/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 */

#include "optsize.h"
#include <QString>
#include <QFile>
#include <QTextStream>
#include <QDateTime>
#include <QCryptographicHash>
#include "defs.h"

// create portfolio views
extern QString
createportfolioviews (QString viewname);

// db schema version 1
static CG_ERR_RESULT
version1 (AppSettings appsettings)
{
  QString SQLCommand;
  CG_ERR_RESULT result = CG_ERR_OK;
  int rc;

  rc = sqlite3_exec(appsettings.db, SQLCommand.toUtf8(), NULL, NULL, NULL);
  if (rc != SQLITE_OK)
  {
    result = CG_ERR_TRANSACTION;
    setGlobalError(result, __FILE__, __LINE__);
    return result;
  }

  SQLCommand.reserve (90000);
  SQLCommand = "BEGIN;";
  SQLCommand.append ('\n');
  // create and populate currencies table
  SQLCommand += "CREATE TABLE CURRENCIES (SYMBOL Text  NOT NULL, CURRENCY_ID Integer Primary Key Autoincrement NOT NULL);";
  SQLCommand.append ('\n');
  SQLCommand += "INSERT INTO CURRENCIES (SYMBOL) VALUES ('USD');";
  SQLCommand += "INSERT INTO CURRENCIES (SYMBOL) VALUES ('EUR');";
  SQLCommand += "INSERT INTO CURRENCIES (SYMBOL) VALUES ('GBP');";
  SQLCommand += "INSERT INTO CURRENCIES (SYMBOL) VALUES ('JPY');";
  SQLCommand += "INSERT INTO CURRENCIES (SYMBOL) VALUES ('CHF');";
  SQLCommand += "INSERT INTO CURRENCIES (SYMBOL) VALUES ('AUD');";
  SQLCommand += "INSERT INTO CURRENCIES (SYMBOL) VALUES ('CAD');";
  SQLCommand += "INSERT INTO CURRENCIES (SYMBOL) VALUES ('NZD');";
  SQLCommand += "INSERT INTO CURRENCIES (SYMBOL) VALUES ('NONE');";
  SQLCommand.append ('\n');
  // create and populate datafeeds_raw table
  SQLCommand += "CREATE TABLE DATAFEEDS_RAW (FEED_ID INTEGER PRIMARY KEY NOT NULL, FEEDNAME CHAR NOT NULL, ACTIVE INTEGER NOT NULL);";
  SQLCommand.append ('\n');
  SQLCommand += "INSERT INTO DATAFEEDS_RAW (FEEDNAME, ACTIVE) VALUES ('YAHOO', 1);";
  SQLCommand += "INSERT INTO DATAFEEDS_RAW (FEEDNAME, ACTIVE) VALUES ('GOOGLE', 1);";
  SQLCommand.append ('\n');

  // create datamodel table
  SQLCommand += "CREATE TABLE DATAMODEL (OPEN REAL NOT NULL,HIGH REAL NOT NULL,LOW REAL NOT NULL,CLOSE REAL NOT NULL,VOLUME INTEGER NOT NULL DEFAULT (0),DATE TEXT NOT NULL,TIME TEXT NOT NULL,ADJCLOSE REAL NOT NULL DEFAULT (-1),DAY INTEGER NOT NULL DEFAULT (1),WEEK INTEGER NOT NULL DEFAULT (1),MONTH INTEGER NOT NULL DEFAULT (1),YEAR INTEGER NOT NULL DEFAULT (1));";
  SQLCommand.append ('\n');

  // create formats raw
  SQLCommand += "CREATE TABLE FORMATS_RAW (FORMAT Text  NOT NULL, FORMAT_ID Integer Primary Key Autoincrement  NOT NULL);";
  SQLCommand.append ('\n');
  SQLCommand += "INSERT INTO FORMATS_RAW (FORMAT) VALUES ('STANDARD CSV');";
  SQLCommand += "INSERT INTO FORMATS_RAW (FORMAT) VALUES ('YAHOO CSV');";
  SQLCommand += "INSERT INTO FORMATS_RAW (FORMAT) VALUES ('GOOGLE CSV');";
  SQLCommand += "INSERT INTO FORMATS_RAW (FORMAT) VALUES ('AMI BROKER');";
  SQLCommand += "INSERT INTO FORMATS_RAW (FORMAT) VALUES ('METASTOCK ASCII 7');";
  SQLCommand += "INSERT INTO FORMATS_RAW (FORMAT) VALUES ('METASTOCK ASCII 8');";
  SQLCommand.append ('\n');
  // create markets table
  SQLCommand += "CREATE TABLE MARKETS (MARKET Text  NOT NULL, MARKET_ID Integer Primary Key Autoincrement  NOT NULL, NAME Text);";
  SQLCommand.append ('\n');
  SQLCommand += "INSERT INTO MARKETS (MARKET) VALUES ('');";
  SQLCommand += "INSERT INTO MARKETS (MARKET) VALUES ('OTHER');";
  SQLCommand.append ('\n');
  // create and populate options table
  SQLCommand += "CREATE TABLE OPTIONS (PAK TEXT NOT NULL DEFAULT '', ";
  SQLCommand += "SHOWSPLASHSCREEN INTEGER NOT NULL DEFAULT 1, ";
  SQLCommand += "CHECKNEWVERSION INTEGER NOT NULL DEFAULT 1, ";
  SQLCommand += "ENABLEPROXY INTEGER NOT NULL DEFAULT 0, ";
  SQLCommand += "PROXYHOST TEXT NOT NULL DEFAULT '', ";
  SQLCommand += "PROXYPORT INTEGER NOT NULL DEFAULT 0, ";
  SQLCommand += "PROXYUSER TEXT NOT NULL DEFAULT '', ";
  SQLCommand += "PROXYPASS TEXT NOT NULL NOT NULL DEFAULT '', ";
  SQLCommand += "NETTIMEOUT INTEGER NOT NULL DEFAULT 20, ";
  SQLCommand += "RECID INTEGER NOT NULL DEFAULT 1);";
  SQLCommand.append ('\n');
  SQLCommand += "INSERT INTO OPTIONS (PAK, ENABLEPROXY) VALUES ('', 0);";
  SQLCommand.append ('\n');
  // create symbols table
  SQLCommand += "CREATE TABLE SYMBOLS (SYMBOL TEXT NOT NULL, DESCRIPTION TEXT,";
  SQLCommand += "MARKET TEXT NOT NULL, SOURCE TEXT NOT NULL,";
  SQLCommand += "TIMEFRAME TEXT NOT NULL, DATEFROM TEXT, DATETO TEXT,";
  SQLCommand += "KEY TEXT NOT NULL, CURRENCY TEXT,";
  SQLCommand += "TFRESOLUTION INTEGER, DNLSTRING TEXT,";
  SQLCommand += "ADJUSTED TEXT NOT NULL DEFAULT ('NO'), BASE TEXT NOT NULL);";
  SQLCommand.append ('\n');
  // create and populate timeframes table
  SQLCommand += "CREATE TABLE TIMEFRAMES (TIMEFRAME TEXT NOT NULL,";
  SQLCommand += "MINUTE_RESOLUTION REAL NOT NULL, TIMEFRAME_ID Integer Primary Key Autoincrement  NOT NULL);";
  SQLCommand += "INSERT INTO TIMEFRAMES (TIMEFRAME, MINUTE_RESOLUTION) VALUES ('MONTH', 43200);";
  SQLCommand += "INSERT INTO TIMEFRAMES (TIMEFRAME, MINUTE_RESOLUTION) VALUES ('WEEK', 7200);";
  SQLCommand += "INSERT INTO TIMEFRAMES (TIMEFRAME, MINUTE_RESOLUTION) VALUES ('DAY', 1440);";
  SQLCommand += "INSERT INTO TIMEFRAMES (TIMEFRAME, MINUTE_RESOLUTION) VALUES ('YEAR', 518400);";
  SQLCommand.append ('\n');
  // create and populate version table
  SQLCommand += "CREATE TABLE VERSION (VERSION Integer  NOT NULL, RESERVED1 Text, RESERVED2 Text, RESERVED3 Text);";
  SQLCommand += "INSERT INTO VERSION (VERSION) VALUES (1);";

  // create views
  SQLCommand += "CREATE VIEW DATAFEEDS AS SELECT * FROM DATAFEEDS_RAW WHERE ACTIVE = 1;";
  SQLCommand.append ('\n');
  SQLCommand += "CREATE VIEW FORMATS AS SELECT * FROM FORMATS_RAW ORDER BY FORMAT ASC;";
  SQLCommand += "CREATE VIEW SYMBOLS_L2 AS ";
  SQLCommand += "SELECT *, SYMBOL||ADJUSTED AS USYMBOL FROM SYMBOLS ORDER BY SYMBOL ASC, ";
  SQLCommand += "TFRESOLUTION ASC, ADJUSTED ASC; ";
  SQLCommand.append ('\n');
  SQLCommand += "CREATE VIEW SYMBOLS_L3 AS ";
  SQLCommand += "SELECT DISTINCT USYMBOL, SYMBOL, DESCRIPTION, MARKET, SOURCE, ";
  SQLCommand += "TIMEFRAME, DATEFROM, DATETO, KEY, CURRENCY, ";
  SQLCommand += "TFRESOLUTION, DNLSTRING, ADJUSTED, BASE ";
  SQLCommand += "FROM SYMBOLS_L2 WHERE TFRESOLUTION = 1440; ";
  SQLCommand.append ('\n');
  SQLCommand += "CREATE VIEW SYMBOLS_ORDERED AS ";
  SQLCommand += "SELECT SYMBOL, DESCRIPTION, MARKET, SOURCE, TIMEFRAME, DATEFROM, ";
  SQLCommand += "DATETO, KEY, CURRENCY, TFRESOLUTION, DNLSTRING, ADJUSTED, BASE ";
  SQLCommand += "FROM SYMBOLS_L3 WHERE TFRESOLUTION = 1440; ";
  SQLCommand.append ('\n');
  SQLCommand += "CREATE VIEW TIMEFRAMES_ORDERED AS SELECT * FROM TIMEFRAMES ";
  SQLCommand += "ORDER BY MINUTE_RESOLUTION ASC; ";
  SQLCommand.append ('\n');
  SQLCommand += "CREATE VIEW NSYMBOLS AS ";
  SQLCommand += "SELECT COUNT (*) AS NSYMBOLS FROM ";
  SQLCommand += "(SELECT DISTINCT (SYMBOL) FROM SYMBOLS_ORDERED);";
  SQLCommand.append ('\n');
  SQLCommand += "COMMIT;";
  SQLCommand.append ('\n');

  // execute sql
  rc = sqlite3_exec(appsettings.db, SQLCommand.toUtf8(), NULL, NULL, NULL);
  if (rc != SQLITE_OK)
  {
    result = CG_ERR_TRANSACTION;
    setGlobalError(result, __FILE__, __LINE__);
  }


  // create demo entry
  SQLCommand = "begin;";
  SQLCommand += "drop table if exists TMP_DDD_NYQ_CSV_DAY;";
  SQLCommand += "create table TMP_DDD_NYQ_CSV_DAY as select * from DATAMODEL;";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (41.50,41.96,40.80,41.41,758635,41.41,201211,2012,2012326,201247,'2012-11-21','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (41.60,42.11,40.33,41.26,1249699,41.26,201211,2012,2012325,201247,'2012-11-20','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (39.03,41.30,39.03,41.28,2354717,41.28,201211,2012,2012324,201247,'2012-11-19','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (38.77,38.77,36.53,38.04,1920268,38.04,201211,2012,2012321,201246,'2012-11-16','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (41.00,41.61,36.90,37.79,2713283,37.79,201211,2012,2012320,201246,'2012-11-15','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (41.82,42.50,41.23,41.57,1523074,41.57,201211,2012,2012319,201246,'2012-11-14','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (41.52,42.58,40.02,41.68,2741389,41.68,201211,2012,2012318,201246,'2012-11-13','00:00.00');";
  SQLCommand.append ('\n');
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (46.19,46.20,41.50,42.17,3463650,42.17,201211,2012,2012317,201246,'2012-11-12','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (45.88,46.92,43.75,46.00,2138259,46.00,201211,2012,2012314,201245,'2012-11-09','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (44.02,46.80,43.85,46.02,1939755,46.02,201211,2012,2012313,201245,'2012-11-08','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (42.40,43.37,41.13,43.34,1318365,43.34,201211,2012,2012312,201245,'2012-11-07','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (43.70,44.25,42.85,43.44,981847,43.44,201211,2012,2012311,201245,'2012-11-06','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (43.72,43.72,42.05,42.76,1277082,42.76,201211,2012,2012310,201245,'2012-11-05','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (46.01,46.23,42.15,42.54,1662945,42.54,201211,2012,2012307,201244,'2012-11-02','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (43.73,45.65,43.35,45.34,1344013,45.34,201211,2012,2012306,201244,'2012-11-01','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (43.66,43.93,42.50,43.50,1572048,43.50,201210,2012,2012305,201244,'2012-10-31','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (40.75,42.92,40.50,42.67,1265438,42.67,201210,2012,2012300,201243,'2012-10-26','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (39.27,42.82,38.75,40.85,4824529,40.85,201210,2012,2012299,201243,'2012-10-25','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (35.95,36.00,34.56,35.92,1143165,35.92,201210,2012,2012298,201243,'2012-10-24','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (36.73,37.48,35.73,36.24,794516,36.24,201210,2012,2012297,201243,'2012-10-23','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (36.72,37.00,36.29,36.98,724475,36.98,201210,2012,2012296,201243,'2012-10-22','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (37.38,37.59,36.18,36.22,996342,36.22,201210,2012,2012293,201242,'2012-10-19','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (38.96,38.97,36.91,37.65,1002006,37.65,201210,2012,2012292,201242,'2012-10-18','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (40.59,40.59,37.82,38.96,1020274,38.96,201210,2012,2012291,201242,'2012-10-17','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (38.25,39.98,37.80,39.92,1464438,39.92,201210,2012,2012290,201242,'2012-10-16','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (37.02,37.98,36.26,37.79,1017974,37.79,201210,2012,2012289,201242,'2012-10-15','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (35.85,36.80,35.53,36.55,1019627,36.55,201210,2012,2012286,201241,'2012-10-12','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (35.38,35.83,35.00,35.23,643585,35.23,201210,2012,2012285,201241,'2012-10-11','00:00.00');";
  SQLCommand.append ('\n');
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (34.00,34.90,33.88,34.65,580100,34.65,201210,2012,2012284,201241,'2012-10-10','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (34.11,35.15,33.51,33.98,892441,33.98,201210,2012,2012283,201241,'2012-10-09','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (35.70,35.75,33.95,34.27,1046706,34.27,201210,2012,2012282,201241,'2012-10-08','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (37.01,37.29,35.81,35.89,1879668,35.89,201210,2012,2012279,201240,'2012-10-05','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (37.36,37.40,36.40,36.63,1573444,36.63,201210,2012,2012278,201240,'2012-10-04','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (34.64,36.48,34.55,36.09,1917770,36.09,201210,2012,2012277,201240,'2012-10-03','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (34.29,34.45,33.57,34.21,1957120,34.21,201210,2012,2012276,201240,'2012-10-02','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (33.78,34.45,33.32,33.86,1621079,33.86,201210,2012,2012275,201240,'2012-10-01','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (33.45,34.01,32.81,32.85,1117807,32.85,201209,2012,2012272,201239,'2012-09-28','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (33.02,34.19,32.80,33.65,1598133,33.65,201209,2012,2012271,201239,'2012-09-27','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (34.18,34.25,32.35,32.53,2458734,32.53,201209,2012,2012270,201239,'2012-09-26','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (35.79,37.39,34.09,34.14,2567972,34.14,201209,2012,2012269,201239,'2012-09-25','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (34.86,35.93,34.07,35.57,1803288,35.57,201209,2012,2012268,201239,'2012-09-24','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (35.50,35.85,34.52,35.07,3292898,35.07,201209,2012,2012265,201238,'2012-09-21','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (36.46,36.46,34.78,35.19,2502584,35.19,201209,2012,2012264,201238,'2012-09-20','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (37.92,38.05,36.25,36.71,1751501,36.71,201209,2012,2012263,201238,'2012-09-19','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (39.14,39.19,37.25,37.89,1379440,37.89,201209,2012,2012262,201238,'2012-09-18','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (39.63,40.00,38.90,39.40,882532,39.40,201209,2012,2012261,201238,'2012-09-17','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (38.90,40.96,38.81,39.49,1438153,39.49,201209,2012,2012258,201237,'2012-09-14','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (38.22,39.49,37.63,38.60,1197986,38.60,201209,2012,2012257,201237,'2012-09-13','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (39.24,39.44,37.12,38.27,1472840,38.27,201209,2012,2012256,201237,'2012-09-12','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (38.92,40.55,38.85,39.16,1173491,39.16,201209,2012,2012255,201237,'2012-09-11','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (40.48,40.48,38.36,39.00,2015164,39.00,201209,2012,2012254,201237,'2012-09-10','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (42.81,43.25,38.33,40.69,2581866,40.69,201209,2012,2012251,201236,'2012-09-07','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (43.51,43.55,42.50,42.72,1299632,42.72,201209,2012,2012250,201236,'2012-09-06','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (43.98,44.37,42.91,43.00,1751864,43.00,201209,2012,2012249,201236,'2012-09-05','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (43.63,44.00,43.42,43.66,1136019,43.66,201209,2012,2012248,201236,'2012-09-04','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (43.68,44.00,42.57,43.71,1362696,43.71,201208,2012,2012244,201235,'2012-08-31','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (44.23,44.80,42.03,42.42,1388099,42.42,201208,2012,2012243,201235,'2012-08-30','00:00.00');";
  SQLCommand.append ('\n');
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (43.35,44.80,43.10,44.30,1358195,44.30,201208,2012,2012242,201235,'2012-08-29','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (41.33,43.20,41.25,43.06,890619,43.06,201208,2012,2012241,201235,'2012-08-28','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (40.88,41.25,40.45,41.19,626771,41.19,201208,2012,2012240,201235,'2012-08-27','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (41.63,41.71,40.05,40.40,1174287,40.40,201208,2012,2012237,201234,'2012-08-24','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (42.19,42.59,41.60,41.92,627391,41.92,201208,2012,2012236,201234,'2012-08-23','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (43.14,43.14,41.80,42.19,717504,42.19,201208,2012,2012235,201234,'2012-08-22','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (42.30,43.90,41.20,42.35,1550209,42.35,201208,2012,2012234,201234,'2012-08-21','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (41.27,41.89,40.87,41.38,1003215,41.38,201208,2012,2012233,201234,'2012-08-20','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (40.77,41.39,40.49,40.82,268441,40.82,201208,2012,2012230,201233,'2012-08-17','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (40.07,41.55,40.00,40.70,263574,40.70,201208,2012,2012229,201233,'2012-08-16','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (39.73,40.06,39.56,40.00,91407,40.00,201208,2012,2012228,201233,'2012-08-15','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (40.50,40.57,39.43,39.77,185155,39.77,201208,2012,2012227,201233,'2012-08-14','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (40.11,41.70,39.55,40.00,121758,40.00,201208,2012,2012226,201233,'2012-08-13','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (39.84,40.39,39.30,40.00,612137,40.00,201208,2012,2012223,201232,'2012-08-10','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (39.52,39.89,39.18,39.75,300288,39.75,201208,2012,2012222,201232,'2012-08-09','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (38.87,40.42,38.59,39.34,347804,39.34,201208,2012,2012221,201232,'2012-08-08','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (38.27,39.19,38.00,38.88,978689,38.88,201208,2012,2012220,201232,'2012-08-07','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (38.63,39.09,37.80,38.05,144413,38.05,201208,2012,2012219,201232,'2012-08-06','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (38.10,38.74,37.56,38.50,250876,38.50,201208,2012,2012216,201231,'2012-08-03','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (36.91,37.97,36.27,37.03,639171,37.03,201208,2012,2012215,201231,'2012-08-02','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (38.37,37.22,37.22,37.22,20056,37.22,201208,2012,2012214,201231,'2012-08-01','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (38.26,38.85,36.92,38.00,1316224,38.00,201207,2012,2012213,201231,'2012-07-31','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (37.46,39.52,37.35,38.48,1536157,38.48,201207,2012,2012212,201231,'2012-07-30','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (34.32,38.24,34.28,37.57,1985625,37.57,201207,2012,2012209,201230,'2012-07-27','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (30.40,34.95,30.37,34.18,1556551,34.18,201207,2012,2012208,201230,'2012-07-26','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (34.95,34.98,33.75,34.29,749538,34.29,201207,2012,2012207,201230,'2012-07-25','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (34.40,35.24,34.10,34.55,692975,34.55,201207,2012,2012206,201230,'2012-07-24','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (34.15,34.80,32.70,34.33,710785,34.33,201207,2012,2012205,201230,'2012-07-23','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (34.68,35.21,34.00,34.92,698308,34.92,201207,2012,2012202,201229,'2012-07-20','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (34.98,35.97,34.59,34.91,973228,34.91,201207,2012,2012201,201229,'2012-07-19','00:00.00');";
  SQLCommand.append ('\n');
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (34.08,36.24,34.08,35.78,1321129,35.78,201207,2012,2012200,201229,'2012-07-18','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (34.72,35.25,33.13,34.20,885838,34.20,201207,2012,2012199,201229,'2012-07-17','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (33.36,35.50,33.19,34.25,1527605,34.25,201207,2012,2012198,201229,'2012-07-16','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (32.56,33.45,32.56,33.02,586692,33.02,201207,2012,2012195,201228,'2012-07-13','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (32.94,32.94,31.30,32.48,1013694,32.48,201207,2012,2012194,201228,'2012-07-12','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (33.94,34.06,31.92,32.99,1025539,32.99,201207,2012,2012193,201228,'2012-07-11','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (35.70,35.88,32.60,33.94,1608623,33.94,201207,2012,2012192,201228,'2012-07-10','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (36.42,36.83,35.24,35.45,911916,35.45,201207,2012,2012191,201228,'2012-07-09','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (36.19,36.42,35.35,35.90,645263,35.90,201207,2012,2012188,201227,'2012-07-06','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (36.31,37.00,35.85,36.17,1151781,36.17,201207,2012,2012187,201227,'2012-07-05','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (36.04,36.50,35.26,35.57,900695,35.57,201207,2012,2012185,201227,'2012-07-03','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (35.00,35.50,34.50,35.30,1182903,35.30,201207,2012,2012184,201227,'2012-07-02','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (34.38,34.73,33.51,34.14,757362,34.14,201206,2012,2012181,201226,'2012-06-29','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (34.26,34.90,32.51,33.26,861581,33.26,201206,2012,2012180,201226,'2012-06-28','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (33.26,34.98,33.26,34.21,1180513,34.21,201206,2012,2012179,201226,'2012-06-27','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (31.92,33.57,31.92,33.01,1230847,33.01,201206,2012,2012178,201226,'2012-06-26','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (31.83,32.20,30.80,31.75,598255,31.75,201206,2012,2012177,201226,'2012-06-25','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (30.67,31.74,30.26,31.67,960118,31.67,201206,2012,2012174,201225,'2012-06-22','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (31.93,32.00,30.25,30.56,757135,30.56,201206,2012,2012173,201225,'2012-06-21','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (31.55,31.85,30.65,31.80,928183,31.80,201206,2012,2012172,201225,'2012-06-20','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (30.90,31.94,30.85,31.39,1254751,31.39,201206,2012,2012171,201225,'2012-06-19','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (30.18,30.86,29.55,30.55,1351690,30.55,201206,2012,2012170,201225,'2012-06-18','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (28.79,30.20,28.58,29.61,1489040,29.61,201206,2012,2012167,201224,'2012-06-15','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (27.80,28.91,27.49,28.78,4140471,28.78,201206,2012,2012166,201224,'2012-06-14','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (30.96,31.20,28.59,29.56,1706680,29.56,201206,2012,2012165,201224,'2012-06-13','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (32.00,32.49,31.50,31.91,691089,31.91,201206,2012,2012164,201224,'2012-06-12','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (32.06,32.50,30.97,31.28,659899,31.28,201206,2012,2012163,201224,'2012-06-11','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (31.12,31.87,30.10,31.19,559821,31.19,201206,2012,2012160,201223,'2012-06-08','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (33.33,33.33,30.90,31.17,782494,31.17,201206,2012,2012159,201223,'2012-06-07','00:00.00');";
  SQLCommand.append ('\n');
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (31.00,32.72,30.96,32.72,1106293,32.72,201206,2012,2012158,201223,'2012-06-06','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (29.75,31.00,29.66,30.95,900048,30.95,201206,2012,2012157,201223,'2012-06-05','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (28.85,29.99,28.85,29.86,500895,29.86,201206,2012,2012156,201223,'2012-06-04','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (29.30,29.74,28.04,28.90,884361,28.90,201206,2012,2012153,201222,'2012-06-01','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (31.06,31.24,29.05,30.40,1181081,30.40,201205,2012,2012152,201222,'2012-05-31','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (31.47,31.74,30.89,31.08,1183587,31.08,201205,2012,2012151,201222,'2012-05-30','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (31.81,31.98,30.86,31.80,1176362,31.80,201205,2012,2012150,201222,'2012-05-29','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (30.44,31.00,30.16,30.63,714939,30.63,201205,2012,2012146,201221,'2012-05-25','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (29.95,31.14,29.20,30.41,1648937,30.41,201205,2012,2012145,201221,'2012-05-24','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (28.08,30.53,27.55,29.89,1340437,29.89,201205,2012,2012144,201221,'2012-05-23','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (27.61,28.76,27.52,28.39,756432,28.39,201205,2012,2012143,201221,'2012-05-22','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (25.87,27.47,25.68,27.38,638235,27.38,201205,2012,2012142,201221,'2012-05-21','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (25.89,26.60,25.56,25.70,715186,25.70,201205,2012,2012139,201220,'2012-05-18','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (26.68,26.84,25.77,25.87,674573,25.87,201205,2012,2012138,201220,'2012-05-17','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (27.56,27.90,26.60,26.68,567951,26.68,201205,2012,2012137,201220,'2012-05-16','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (27.62,28.06,27.20,27.42,471949,27.42,201205,2012,2012136,201220,'2012-05-15','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (27.36,28.19,27.07,27.65,577055,27.65,201205,2012,2012135,201220,'2012-05-14','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (27.21,28.39,26.84,27.45,761854,27.45,201205,2012,2012132,201219,'2012-05-11','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (28.34,28.92,27.52,27.66,469280,27.66,201205,2012,2012131,201219,'2012-05-10','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (28.92,28.92,27.62,28.12,620917,28.12,201205,2012,2012130,201219,'2012-05-09','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (29.01,29.45,27.51,29.26,772590,29.26,201205,2012,2012129,201219,'2012-05-08','00:00.00');";
  SQLCommand.append ('\n');
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (28.02,29.43,28.01,29.24,778484,29.24,201205,2012,2012128,201219,'2012-05-07','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (28.93,28.93,27.93,28.58,699600,28.58,201205,2012,2012125,201218,'2012-05-04','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (29.88,29.99,28.40,29.15,1272025,29.15,201205,2012,2012124,201218,'2012-05-03','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (31.19,31.40,29.80,30.04,1124119,30.04,201205,2012,2012123,201218,'2012-05-02','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (29.49,31.56,29.49,31.13,2104472,31.13,201205,2012,2012122,201218,'2012-05-01','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (29.18,29.84,29.00,29.49,1021853,29.49,201204,2012,2012121,201218,'2012-04-30','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (29.47,29.47,28.75,29.26,811055,29.26,201204,2012,2012118,201217,'2012-04-27','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (28.00,29.17,27.25,29.05,1187649,29.05,201204,2012,2012117,201217,'2012-04-26','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (28.90,28.94,27.66,28.24,929829,28.24,201204,2012,2012116,201217,'2012-04-25','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (27.51,28.75,27.29,28.47,1197763,28.47,201204,2012,2012115,201217,'2012-04-24','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (27.55,27.81,26.55,27.49,688847,27.49,201204,2012,2012114,201217,'2012-04-23','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (27.84,28.52,27.46,27.95,979537,27.95,201204,2012,2012111,201216,'2012-04-20','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (27.66,28.24,26.86,27.28,875576,27.28,201204,2012,2012110,201216,'2012-04-19','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (27.51,27.75,26.55,27.55,989521,27.55,201204,2012,2012109,201216,'2012-04-18','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (26.89,28.39,26.80,27.60,1630033,27.60,201204,2012,2012108,201216,'2012-04-17','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (25.02,27.55,25.00,26.28,2375593,26.28,201204,2012,2012107,201216,'2012-04-16','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (24.40,24.73,24.03,24.42,530818,24.42,201204,2012,2012104,201215,'2012-04-13','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (23.45,24.57,23.10,24.39,968350,24.39,201204,2012,2012103,201215,'2012-04-12','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (22.71,23.70,22.50,23.10,764627,23.10,201204,2012,2012102,201215,'2012-04-11','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (23.54,23.80,22.25,22.43,1238960,22.43,201204,2012,2012101,201215,'2012-04-10','00:00.00');";
  SQLCommand.append ('\n');
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (23.64,24.00,23.45,23.59,783162,23.59,201204,2012,2012100,201215,'2012-04-09','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (24.80,24.90,23.90,24.33,4812396,24.33,201204,2012,2012096,201214,'2012-04-05','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (24.63,24.93,24.26,24.80,1020937,24.80,201204,2012,2012095,201214,'2012-04-04','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (25.23,25.72,24.82,24.91,2796997,24.91,201204,2012,2012094,201214,'2012-04-03','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (24.41,24.90,23.82,24.25,997156,24.25,201204,2012,2012093,201214,'2012-04-02','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (23.77,23.82,23.23,23.54,328892,23.54,201203,2012,2012090,201213,'2012-03-30','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (23.09,23.67,22.82,23.52,364804,23.52,201203,2012,2012089,201213,'2012-03-29','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (23.66,23.66,22.98,23.20,411327,23.20,201203,2012,2012088,201213,'2012-03-28','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (23.96,23.98,23.43,23.56,489724,23.56,201203,2012,2012087,201213,'2012-03-27','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (24.28,24.36,23.71,24.00,579663,24.00,201203,2012,2012086,201213,'2012-03-26','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (24.86,24.86,23.11,23.91,760938,23.91,201203,2012,2012083,201212,'2012-03-23','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (23.10,23.40,22.61,23.11,489588,23.11,201203,2012,2012082,201212,'2012-03-22','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (23.04,23.84,22.86,23.45,507675,23.45,201203,2012,2012081,201212,'2012-03-21','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (23.01,23.14,22.40,22.88,383821,22.88,201203,2012,2012080,201212,'2012-03-20','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (23.06,23.54,22.81,23.18,523730,23.18,201203,2012,2012079,201212,'2012-03-19','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (23.31,23.46,23.04,23.07,552919,23.07,201203,2012,2012076,201211,'2012-03-16','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (22.93,23.44,22.64,23.19,550221,23.19,201203,2012,2012075,201211,'2012-03-15','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (21.96,23.02,21.96,22.82,693516,22.82,201203,2012,2012074,201211,'2012-03-14','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (21.84,21.99,21.67,21.86,967208,21.86,201203,2012,2012073,201211,'2012-03-13','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (22.00,22.23,21.41,21.72,716651,21.72,201203,2012,2012072,201211,'2012-03-12','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (22.33,22.42,21.81,21.90,835302,21.90,201203,2012,2012069,201210,'2012-03-09','00:00.00');";
  SQLCommand.append ('\n');
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (22.16,22.60,21.91,22.10,421487,22.10,201203,2012,2012068,201210,'2012-03-08','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (21.88,22.46,21.82,21.87,764040,21.87,201203,2012,2012067,201210,'2012-03-07','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (21.98,22.08,20.89,21.71,946461,21.71,201203,2012,2012066,201210,'2012-03-06','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (22.50,22.80,22.16,22.20,494137,22.20,201203,2012,2012065,201210,'2012-03-05','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (23.00,23.06,22.00,22.54,691021,22.54,201203,2012,2012062,201209,'2012-03-02','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (22.75,23.51,22.49,22.82,759793,22.82,201203,2012,2012061,201209,'2012-03-01','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (23.71,24.03,22.37,22.40,1253033,22.40,201202,2012,2012060,201209,'2012-02-29','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (24.68,24.85,23.59,23.68,791766,23.68,201202,2012,2012059,201209,'2012-02-28','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (24.49,25.03,23.93,24.52,1112908,24.52,201202,2012,2012058,201209,'2012-02-27','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (24.99,25.00,23.55,24.15,1946719,24.15,201202,2012,2012055,201208,'2012-02-24','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (23.00,25.77,22.90,23.31,3409497,23.31,201202,2012,2012054,201208,'2012-02-23','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (21.04,21.19,20.50,20.93,336742,20.93,201202,2012,2012053,201208,'2012-02-22','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (21.05,21.45,20.92,21.00,381286,21.00,201202,2012,2012052,201208,'2012-02-21','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (21.53,21.75,20.84,20.91,447313,20.91,201202,2012,2012048,201207,'2012-02-17','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (20.38,21.54,20.33,21.54,411199,21.54,201202,2012,2012047,201207,'2012-02-16','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (20.94,21.00,20.30,20.38,302620,20.38,201202,2012,2012046,201207,'2012-02-15','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (20.74,20.87,20.53,20.73,436807,20.73,201202,2012,2012045,201207,'2012-02-14','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (20.63,20.90,20.55,20.80,391624,20.80,201202,2012,2012044,201207,'2012-02-13','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (20.19,20.53,20.11,20.26,260489,20.26,201202,2012,2012041,201206,'2012-02-10','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (20.96,20.96,20.25,20.57,413091,20.57,201202,2012,2012040,201206,'2012-02-09','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (20.79,20.99,20.50,20.79,394399,20.79,201202,2012,2012039,201206,'2012-02-08','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (21.38,21.39,20.10,20.67,587498,20.67,201202,2012,2012038,201206,'2012-02-07','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (21.30,21.69,20.96,21.36,449921,21.36,201202,2012,2012037,201206,'2012-02-06','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (20.59,21.36,20.50,21.13,768738,21.13,201202,2012,2012034,201205,'2012-02-03','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (19.85,20.12,19.75,20.11,474965,20.11,201202,2012,2012033,201205,'2012-02-02','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (19.21,19.87,19.13,19.71,545060,19.71,201202,2012,2012032,201205,'2012-02-01','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (19.50,19.50,19.02,19.12,341222,19.12,201201,2012,2012031,201205,'2012-01-31','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (19.18,19.49,18.93,19.17,455628,19.17,201201,2012,2012030,201205,'2012-01-30','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (19.17,19.44,19.01,19.33,264474,19.33,201201,2012,2012027,201204,'2012-01-27','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (19.23,19.70,19.04,19.14,490091,19.14,201201,2012,2012026,201204,'2012-01-26','00:00.00');";
  SQLCommand.append ('\n');
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (18.91,19.09,18.72,19.02,362408,19.02,201201,2012,2012025,201204,'2012-01-25','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (18.66,18.96,18.61,18.84,441187,18.84,201201,2012,2012024,201204,'2012-01-24','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (18.53,19.30,18.49,18.73,693495,18.73,201201,2012,2012023,201204,'2012-01-23','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (17.37,18.49,17.06,18.40,809215,18.40,201201,2012,2012020,201203,'2012-01-20','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (17.50,17.78,17.13,17.39,325745,17.39,201201,2012,2012019,201203,'2012-01-19','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (17.10,17.52,16.95,17.45,305625,17.45,201201,2012,2012018,201203,'2012-01-18','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (17.27,17.49,17.00,17.08,280887,17.08,201201,2012,2012017,201203,'2012-01-17','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (17.10,17.10,17.10,17.10,0,17.10,201201,2012,2012013,201202,'2012-01-13','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (17.09,17.25,16.80,17.06,521440,17.06,201201,2012,2012012,201202,'2012-01-12','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (16.08,17.17,16.08,17.08,604836,17.08,201201,2012,2012011,201202,'2012-01-11','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (16.12,16.21,15.96,16.04,693749,16.04,201201,2012,2012010,201202,'2012-01-10','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (16.00,16.31,15.76,15.81,375369,15.81,201201,2012,2012009,201202,'2012-01-09','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (16.12,16.50,15.96,16.01,330152,16.01,201201,2012,2012006,201201,'2012-01-06','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (15.42,16.35,15.42,16.09,622725,16.09,201201,2012,2012005,201201,'2012-01-05','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (15.23,15.52,14.97,15.49,268553,15.49,201201,2012,2012004,201201,'2012-01-04','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (14.85,15.64,14.73,15.36,340427,15.36,201201,2012,2012003,201201,'2012-01-03','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (14.40,14.40,14.40,14.40,0,14.40,201112,2011,2011364,201152,'2011-12-30','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (14.60,14.74,14.44,14.49,303450,14.49,201112,2011,2011363,201152,'2011-12-29','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (15.22,15.22,14.51,14.55,249403,14.55,201112,2011,2011362,201152,'2011-12-28','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (14.94,15.41,14.80,15.34,254066,15.34,201112,2011,2011361,201152,'2011-12-27','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (14.95,14.95,14.95,14.95,0,14.95,201112,2011,2011357,201151,'2011-12-23','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (14.85,15.28,14.71,14.99,194062,14.99,201112,2011,2011356,201151,'2011-12-22','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (14.97,14.97,14.45,14.80,261340,14.80,201112,2011,2011355,201151,'2011-12-21','00:00.00');";
  SQLCommand.append ('\n');
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (14.94,15.22,14.84,15.09,595318,15.09,201112,2011,2011354,201151,'2011-12-20','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (14.59,14.89,14.37,14.48,301196,14.48,201112,2011,2011353,201151,'2011-12-19','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (14.65,14.99,14.39,14.53,401617,14.53,201112,2011,2011350,201150,'2011-12-16','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (14.66,14.86,14.43,14.57,300353,14.57,201112,2011,2011349,201150,'2011-12-15','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (15.08,15.08,14.40,14.41,363355,14.41,201112,2011,2011348,201150,'2011-12-14','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (15.98,16.19,15.02,15.26,363864,15.26,201112,2011,2011347,201150,'2011-12-13','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (15.88,15.95,15.65,15.76,352137,15.76,201112,2011,2011346,201150,'2011-12-12','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (15.53,16.33,15.44,16.20,519005,16.20,201112,2011,2011343,201149,'2011-12-09','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (15.32,15.70,15.20,15.45,447566,15.45,201112,2011,2011342,201149,'2011-12-08','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (15.45,15.63,14.84,15.52,331624,15.52,201112,2011,2011341,201149,'2011-12-07','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (15.60,15.73,15.21,15.55,235692,15.55,201112,2011,2011340,201149,'2011-12-06','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (15.70,15.83,15.36,15.57,450465,15.57,201112,2011,2011339,201149,'2011-12-05','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (15.71,15.88,15.37,15.41,349357,15.41,201112,2011,2011336,201148,'2011-12-02','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (15.59,15.61,15.35,15.41,384023,15.41,201112,2011,2011335,201148,'2011-12-01','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (16.07,16.08,15.30,15.61,655081,15.61,201111,2011,2011334,201148,'2011-11-30','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (15.50,15.62,14.84,15.02,268035,15.02,201111,2011,2011333,201148,'2011-11-29','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (14.78,15.94,14.78,15.43,414533,15.43,201111,2011,2011332,201148,'2011-11-28','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (14.64,14.98,14.21,14.23,177751,14.23,201111,2011,2011329,201147,'2011-11-25','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (14.75,14.75,14.75,14.75,0,14.75,201111,2011,2011327,201147,'2011-11-23','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (15.70,16.11,15.22,15.27,483801,15.27,201111,2011,2011326,201147,'2011-11-22','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (16.51,17.00,15.50,15.71,580520,15.71,201111,2011,2011325,201147,'2011-11-21','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (17.39,17.45,16.75,16.83,342822,16.83,201111,2011,2011322,201146,'2011-11-18','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (16.82,17.49,16.55,17.10,770066,17.10,201111,2011,2011321,201146,'2011-11-17','00:00.00');";
  SQLCommand.append ('\n');
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (16.64,17.29,16.34,16.82,396624,16.82,201111,2011,2011320,201146,'2011-11-16','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (16.50,16.79,16.06,16.63,378987,16.63,201111,2011,2011319,201146,'2011-11-15','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (17.37,17.37,16.30,16.58,231311,16.58,201111,2011,2011318,201146,'2011-11-14','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (16.56,17.10,16.56,16.88,327158,16.88,201111,2011,2011315,201145,'2011-11-11','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (15.89,16.50,15.60,16.32,354242,16.32,201111,2011,2011314,201145,'2011-11-10','00:00.00');";
  SQLCommand.append ('\n');
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (16.15,16.38,15.49,15.55,565385,15.55,201111,2011,2011313,201145,'2011-11-09','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (16.73,16.90,16.12,16.79,277336,16.79,201111,2011,2011312,201145,'2011-11-08','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (17.14,17.14,16.26,16.51,499283,16.51,201111,2011,2011311,201145,'2011-11-07','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (16.87,17.60,16.80,17.28,466564,17.28,201111,2011,2011308,201144,'2011-11-04','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (16.34,17.20,16.11,17.12,633042,17.12,201111,2011,2011307,201144,'2011-11-03','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (15.80,16.25,15.45,16.12,549034,16.12,201111,2011,2011306,201144,'2011-11-02','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (15.57,15.92,15.05,15.34,826662,15.34,201111,2011,2011305,201144,'2011-11-01','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (16.23,17.22,16.16,16.27,886836,16.27,201110,2011,2011304,201144,'2011-10-31','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (15.99,16.31,15.45,16.20,955490,16.20,201110,2011,2011301,201143,'2011-10-28','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (19.79,20.00,16.00,19.04,2176672,19.04,201110,2011,2011300,201143,'2011-10-27','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (18.59,19.48,18.22,19.36,892385,19.36,201110,2011,2011299,201143,'2011-10-26','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (18.65,18.70,17.89,17.90,390785,17.90,201110,2011,2011298,201143,'2011-10-25','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (17.64,18.91,17.55,18.86,502173,18.86,201110,2011,2011297,201143,'2011-10-24','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (17.21,17.54,16.91,17.47,313958,17.47,201110,2011,2011294,201142,'2011-10-21','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (16.42,16.95,15.73,16.86,302402,16.86,201110,2011,2011293,201142,'2011-10-20','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (17.06,17.37,16.25,16.31,220932,16.31,201110,2011,2011292,201142,'2011-10-19','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (16.51,17.33,15.90,17.10,262141,17.10,201110,2011,2011291,201142,'2011-10-18','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (16.93,17.15,16.35,16.37,307761,16.37,201110,2011,2011290,201142,'2011-10-17','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (17.27,17.51,16.97,17.21,430152,17.21,201110,2011,2011287,201141,'2011-10-14','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (17.38,17.50,16.35,16.83,427971,16.83,201110,2011,2011286,201141,'2011-10-13','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (17.37,17.77,17.13,17.65,424985,17.65,201110,2011,2011285,201141,'2011-10-12','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (16.49,17.44,16.31,17.09,374799,17.09,201110,2011,2011284,201141,'2011-10-11','00:00.00');";
  SQLCommand.append ('\n');
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (15.91,16.74,15.88,16.73,335474,16.73,201110,2011,2011283,201141,'2011-10-10','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (16.41,16.55,15.42,15.45,487990,15.45,201110,2011,2011280,201140,'2011-10-07','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (15.66,16.23,15.32,16.20,428440,16.20,201110,2011,2011279,201140,'2011-10-06','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (14.93,16.00,14.33,15.74,500740,15.74,201110,2011,2011278,201140,'2011-10-05','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (13.52,15.08,12.78,14.93,632897,14.93,201110,2011,2011277,201140,'2011-10-04','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (13.89,14.26,13.36,13.50,655116,13.50,201110,2011,2011276,201140,'2011-10-03','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (14.23,14.48,13.95,13.99,381297,13.99,201109,2011,2011273,201139,'2011-09-30','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (15.35,15.38,14.00,14.50,416124,14.50,201109,2011,2011272,201139,'2011-09-29','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (16.11,16.31,14.77,14.78,649418,14.78,201109,2011,2011271,201139,'2011-09-28','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (16.32,16.60,15.85,16.16,529225,16.16,201109,2011,2011270,201139,'2011-09-27','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (15.29,15.86,14.61,15.75,495612,15.75,201109,2011,2011269,201139,'2011-09-26','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (14.18,15.07,13.92,14.81,464137,14.81,201109,2011,2011266,201138,'2011-09-23','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (14.73,14.98,13.67,14.22,807774,14.22,201109,2011,2011265,201138,'2011-09-22','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (16.01,16.27,15.10,15.13,360762,15.13,201109,2011,2011264,201138,'2011-09-21','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (16.06,16.97,15.95,15.98,342721,15.98,201109,2011,2011263,201138,'2011-09-20','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (16.32,16.85,15.95,16.57,359374,16.57,201109,2011,2011262,201138,'2011-09-19','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (17.65,17.70,16.37,16.58,613592,16.58,201109,2011,2011259,201137,'2011-09-16','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (17.42,17.68,17.30,17.65,283756,17.65,201109,2011,2011258,201137,'2011-09-15','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (17.17,17.86,16.62,17.20,349687,17.20,201109,2011,2011257,201137,'2011-09-14','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (16.47,17.08,16.37,16.88,358382,16.88,201109,2011,2011256,201137,'2011-09-13','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (15.92,16.41,15.56,16.36,546185,16.36,201109,2011,2011255,201137,'2011-09-12','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (17.03,17.20,16.00,16.20,392274,16.20,201109,2011,2011252,201136,'2011-09-09','00:00.00');";
  SQLCommand.append ('\n');
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (17.50,17.96,17.04,17.17,418481,17.17,201109,2011,2011251,201136,'2011-09-08','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (16.47,18.07,16.35,17.71,779510,17.71,201109,2011,2011250,201136,'2011-09-07','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (15.77,16.03,15.44,15.96,471397,15.96,201109,2011,2011249,201136,'2011-09-06','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (16.57,17.05,16.15,16.25,592810,16.25,201109,2011,2011245,201135,'2011-09-02','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (18.20,18.48,17.22,17.25,364601,17.25,201109,2011,2011244,201135,'2011-09-01','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (18.81,19.09,17.70,18.17,560135,18.17,201108,2011,2011243,201135,'2011-08-31','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (18.04,18.82,17.58,18.59,479704,18.59,201108,2011,2011242,201135,'2011-08-30','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (17.64,18.22,17.46,18.10,264502,18.10,201108,2011,2011241,201135,'2011-08-29','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (16.28,17.21,15.63,17.20,519552,17.20,201108,2011,2011238,201134,'2011-08-26','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (17.38,17.52,16.23,16.27,475541,16.27,201108,2011,2011237,201134,'2011-08-25','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (16.92,17.37,16.58,16.97,457448,16.97,201108,2011,2011236,201134,'2011-08-24','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (15.31,16.97,15.05,16.92,659661,16.92,201108,2011,2011235,201134,'2011-08-23','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (15.82,15.91,14.83,15.18,687579,15.18,201108,2011,2011234,201134,'2011-08-22','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (15.62,16.16,15.07,15.21,649590,15.21,201108,2011,2011231,201133,'2011-08-19','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (16.72,16.72,15.43,15.94,815436,15.94,201108,2011,2011230,201133,'2011-08-18','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (18.11,18.38,17.06,17.40,495548,17.40,201108,2011,2011229,201133,'2011-08-17','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (19.00,19.01,17.80,17.96,628097,17.96,201108,2011,2011228,201133,'2011-08-16','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (18.39,19.48,18.39,19.10,631007,19.10,201108,2011,2011227,201133,'2011-08-15','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (17.61,18.61,17.30,18.00,430430,18.00,201108,2011,2011224,201132,'2011-08-12','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (16.65,18.00,15.96,17.40,674616,17.40,201108,2011,2011223,201132,'2011-08-11','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (16.81,16.82,15.81,15.86,616795,15.86,201108,2011,2011222,201132,'2011-08-10','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (15.62,17.24,15.30,17.21,883387,17.21,201108,2011,2011221,201132,'2011-08-09','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (16.34,17.00,15.58,15.59,1364897,15.59,201108,2011,2011220,201132,'2011-08-08','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (18.76,18.94,17.16,17.23,1076115,17.23,201108,2011,2011217,201131,'2011-08-05','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (19.84,19.98,18.25,18.51,1071062,18.51,201108,2011,2011216,201131,'2011-08-04','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (20.39,20.39,19.12,20.19,681388,20.19,201108,2011,2011215,201131,'2011-08-03','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (21.14,21.14,20.03,20.04,633144,20.04,201108,2011,2011214,201131,'2011-08-02','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (22.00,22.25,20.29,20.92,557132,20.92,201108,2011,2011213,201131,'2011-08-01','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (22.00,22.40,21.28,21.41,528160,21.41,201107,2011,2011210,201130,'2011-07-29','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (21.62,22.89,20.91,22.55,1572172,22.55,201107,2011,2011209,201130,'2011-07-28','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (25.31,25.31,22.01,22.01,1626391,22.01,201107,2011,2011208,201130,'2011-07-27','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (26.14,26.23,25.30,25.46,485315,25.46,201107,2011,2011207,201130,'2011-07-26','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (26.52,26.85,26.09,26.19,391969,26.19,201107,2011,2011206,201130,'2011-07-25','00:00.00');";
  SQLCommand.append ('\n');
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (26.84,27.28,26.70,26.87,439204,26.87,201107,2011,2011203,201129,'2011-07-22','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (25.71,26.97,25.23,26.71,1142276,26.71,201107,2011,2011202,201129,'2011-07-21','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (26.34,26.34,24.37,25.49,704775,25.49,201107,2011,2011201,201129,'2011-07-20','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (23.75,25.91,23.67,25.60,828158,25.60,201107,2011,2011200,201129,'2011-07-19','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (23.54,23.65,23.11,23.47,346729,23.47,201107,2011,2011199,201129,'2011-07-18','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (23.72,23.73,23.28,23.68,357283,23.68,201107,2011,2011196,201128,'2011-07-15','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (23.52,23.97,23.29,23.43,528553,23.43,201107,2011,2011195,201128,'2011-07-14','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (22.69,23.65,22.61,23.49,635979,23.49,201107,2011,2011194,201128,'2011-07-13','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (21.96,22.80,21.95,22.50,393078,22.50,201107,2011,2011193,201128,'2011-07-12','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (22.30,22.58,21.78,22.06,405639,22.06,201107,2011,2011192,201128,'2011-07-11','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (21.88,22.44,21.76,22.34,419082,22.34,201107,2011,2011189,201127,'2011-07-08','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (21.24,22.34,21.15,22.32,518164,22.32,201107,2011,2011188,201127,'2011-07-07','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (21.18,21.18,20.88,21.10,276015,21.10,201107,2011,2011187,201127,'2011-07-06','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (20.25,21.25,20.10,21.18,396000,21.18,201107,2011,2011186,201127,'2011-07-05','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (20.28,20.28,20.28,20.28,0,20.28,201107,2011,2011182,201126,'2011-07-01','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (19.15,19.78,19.10,19.71,313938,19.71,201106,2011,2011181,201126,'2011-06-30','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (19.06,19.20,18.75,19.07,165305,19.07,201106,2011,2011180,201126,'2011-06-29','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (18.25,19.00,18.16,18.96,370113,18.96,201106,2011,2011179,201126,'2011-06-28','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (18.89,18.89,18.05,18.09,476765,18.09,201106,2011,2011178,201126,'2011-06-27','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (19.24,19.40,18.52,18.72,587626,18.72,201106,2011,2011175,201125,'2011-06-24','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (18.29,19.30,17.87,19.24,288672,19.24,201106,2011,2011174,201125,'2011-06-23','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (18.75,19.03,18.65,18.66,204069,18.66,201106,2011,2011173,201125,'2011-06-22','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (18.06,18.89,18.02,18.84,332725,18.84,201106,2011,2011172,201125,'2011-06-21','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (17.68,18.00,17.60,17.94,240773,17.94,201106,2011,2011171,201125,'2011-06-20','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (18.12,18.28,17.54,17.77,598253,17.77,201106,2011,2011168,201124,'2011-06-17','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (17.93,18.31,17.58,17.96,264431,17.96,201106,2011,2011167,201124,'2011-06-16','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (17.87,18.20,17.72,17.93,334511,17.93,201106,2011,2011166,201124,'2011-06-15','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (18.17,18.54,17.91,18.10,419889,18.10,201106,2011,2011165,201124,'2011-06-14','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (17.90,18.50,17.35,17.94,691024,17.94,201106,2011,2011164,201124,'2011-06-13','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (17.75,18.09,17.72,17.91,404729,17.91,201106,2011,2011161,201123,'2011-06-10','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (17.53,18.02,17.30,18.01,342629,18.01,201106,2011,2011160,201123,'2011-06-09','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (18.00,18.09,17.44,17.50,514048,17.50,201106,2011,2011159,201123,'2011-06-08','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (18.11,18.26,17.99,17.99,365581,17.99,201106,2011,2011158,201123,'2011-06-07','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (18.37,18.70,18.04,18.05,329686,18.05,201106,2011,2011157,201123,'2011-06-06','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (18.69,18.89,18.36,18.42,523543,18.42,201106,2011,2011154,201122,'2011-06-03','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (19.01,19.27,18.71,18.96,412732,18.96,201106,2011,2011153,201122,'2011-06-02','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (19.47,20.05,19.00,19.01,535010,19.01,201106,2011,2011152,201122,'2011-06-01','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (19.83,20.04,19.43,19.99,477333,19.99,201105,2011,2011151,201122,'2011-05-31','00:00.00');";
  SQLCommand += "insert into TMP_DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) values (19.69,19.69,19.69,19.69,0,19.69,201105,2011,2011147,201121,'2011-05-27','00:00.00');";
  SQLCommand.append ('\n');
  SQLCommand += "drop table if exists DDD_NYQ_CSV_DAY;";
  SQLCommand.append ('\n');
  SQLCommand += "create table DDD_NYQ_CSV_DAY (OPEN REAL NOT NULL, HIGH REAL  NOT NULL, LOW REAL NOT NULL, CLOSE REAL NOT NULL, VOLUME INTEGER, ADJCLOSE REAL NOT NULL, DATE TEXT NOT NULL, TIME TEXT, MONTH INTEGER, YEAR INTEGER, DAY INTEGER, WEEK INTEGER,  TICK INTEGER PRIMARY KEY AUTOINCREMENT);";
  SQLCommand.append ('\n');
  SQLCommand += "insert into DDD_NYQ_CSV_DAY (OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME) select OPEN, HIGH, LOW, CLOSE, VOLUME, ADJCLOSE, MONTH, YEAR, DAY, WEEK, DATE, TIME from TMP_DDD_NYQ_CSV_DAY GROUP BY DATE, TIME ORDER BY DATE DESC;";
  SQLCommand.append ('\n');
  SQLCommand += "update DDD_NYQ_CSV_DAY set ADJCLOSE = 0 where CLOSE = 0;";
  SQLCommand.append ('\n');
  SQLCommand += "update DDD_NYQ_CSV_DAY set ADJCLOSE = CLOSE where ADJCLOSE < 0;";
  SQLCommand.append ('\n');
  SQLCommand += "delete from SYMBOLS where KEY=\"DDD_NYQ_CSV_DAY\";";
  SQLCommand.append ('\n');
  SQLCommand += "insert into SYMBOLS values ('DDD','3D Systems Corporation','NYQ','CSV','DAY',' ',' ','DDD_NYQ_CSV_DAY','USD',0,'','NO', 'DDD_NYQ_CSV_DAY');";
  SQLCommand.append ('\n');
  SQLCommand += "update SYMBOLS set DATEFROM = (select min(DATE) from DDD_NYQ_CSV_DAY) where KEY=\"DDD_NYQ_CSV_DAY\";";
  SQLCommand.append ('\n');
  SQLCommand += "update SYMBOLS set DATETO = (select max(DATE) from DDD_NYQ_CSV_DAY) where KEY=\"DDD_NYQ_CSV_DAY\";";
  SQLCommand.append ('\n');
  SQLCommand += "update SYMBOLS set TFRESOLUTION = (select MINUTE_RESOLUTION from TIMEFRAMES where SYMBOLS.TIMEFRAME = TIMEFRAMES.TIMEFRAME);";
  SQLCommand.append ('\n');
  SQLCommand += "drop table if exists TMP_DDD_NYQ_CSV_DAY;";
  SQLCommand.append ('\n');
  SQLCommand += "CREATE INDEX \"DDD_NYQ_CSV_DAY_monthidx\" on DDD_NYQ_CSV_DAY (MONTH ASC);";
  SQLCommand.append ('\n');
  SQLCommand += "CREATE INDEX \"DDD_NYQ_CSV_DAY_dateidx\" on DDD_NYQ_CSV_DAY (DATE ASC);";
  SQLCommand.append ('\n');
  SQLCommand += "CREATE INDEX \"DDD_NYQ_CSV_DAY_weekidx\" on DDD_NYQ_CSV_DAY (WEEK ASC);";
  SQLCommand.append ('\n');
  SQLCommand += "CREATE INDEX \"DDD_NYQ_CSV_DAY_yearidx\" on DDD_NYQ_CSV_DAY (YEAR ASC);";
  SQLCommand.append ('\n');
  SQLCommand += "DROP VIEW IF EXISTS DDD_NYQ_CSV_DAY_WEEK;";
  SQLCommand.append ('\n');
  SQLCommand += "DROP VIEW IF EXISTS DDD_NYQ_CSV_DAY_WEEK__CLOSE;";
  SQLCommand.append ('\n');
  SQLCommand += "DROP VIEW IF EXISTS DDD_NYQ_CSV_DAY_WEEK__OPEN;";
  SQLCommand.append ('\n');
  SQLCommand += "DROP VIEW IF EXISTS DDD_NYQ_CSV_DAY_WEEK__HIGH;";
  SQLCommand.append ('\n');
  SQLCommand += "DROP VIEW IF EXISTS DDD_NYQ_CSV_DAY_WEEK__LOW;";
  SQLCommand.append ('\n');
  SQLCommand += "DROP VIEW IF EXISTS DDD_NYQ_CSV_DAY_WEEK__MINDATE;";
  SQLCommand.append ('\n');
  SQLCommand += "DROP VIEW IF EXISTS DDD_NYQ_CSV_DAY_WEEK__MAXDATE;";
  SQLCommand.append ('\n');
  SQLCommand += "DROP VIEW IF EXISTS DDD_NYQ_CSV_DAY_WEEK__VOLUME;";
  SQLCommand.append ('\n');
  SQLCommand += "CREATE VIEW DDD_NYQ_CSV_DAY_WEEK__MAXDATE AS SELECT MAX (DATE) AS DATE, WEEK FROM DDD_NYQ_CSV_DAY GROUP BY WEEK;";
  SQLCommand.append ('\n');
  SQLCommand += "CREATE VIEW DDD_NYQ_CSV_DAY_WEEK__MINDATE AS SELECT MIN (DATE) AS DATE, WEEK FROM DDD_NYQ_CSV_DAY GROUP BY WEEK;";
  SQLCommand.append ('\n');
  SQLCommand += "CREATE VIEW DDD_NYQ_CSV_DAY_WEEK__LOW AS SELECT MIN (LOW) AS LOW, WEEK FROM DDD_NYQ_CSV_DAY GROUP BY WEEK;";
  SQLCommand.append ('\n');
  SQLCommand += "CREATE VIEW DDD_NYQ_CSV_DAY_WEEK__HIGH AS SELECT MAX (HIGH) AS HIGH, WEEK FROM DDD_NYQ_CSV_DAY GROUP BY WEEK;";
  SQLCommand.append ('\n');
  SQLCommand += "CREATE VIEW DDD_NYQ_CSV_DAY_WEEK__OPEN AS SELECT DDD_NYQ_CSV_DAY.OPEN, DDD_NYQ_CSV_DAY.WEEK, DDD_NYQ_CSV_DAY.DATE, DDD_NYQ_CSV_DAY.TIME FROM DDD_NYQ_CSV_DAY, DDD_NYQ_CSV_DAY_WEEK__MINDATE WHERE DDD_NYQ_CSV_DAY.DATE = DDD_NYQ_CSV_DAY_WEEK__MINDATE.DATE AND DDD_NYQ_CSV_DAY.WEEK =  DDD_NYQ_CSV_DAY_WEEK__MINDATE.WEEK;";
  SQLCommand.append ('\n');
  SQLCommand += "CREATE VIEW DDD_NYQ_CSV_DAY_WEEK__CLOSE AS SELECT DDD_NYQ_CSV_DAY.CLOSE, DDD_NYQ_CSV_DAY.CLOSE AS ADJCLOSE, DDD_NYQ_CSV_DAY.WEEK FROM DDD_NYQ_CSV_DAY, DDD_NYQ_CSV_DAY_WEEK__MAXDATE WHERE DDD_NYQ_CSV_DAY.DATE = DDD_NYQ_CSV_DAY_WEEK__MAXDATE.DATE AND DDD_NYQ_CSV_DAY.WEEK =  DDD_NYQ_CSV_DAY_WEEK__MAXDATE.WEEK;";
  SQLCommand.append ('\n');
  SQLCommand += "CREATE VIEW DDD_NYQ_CSV_DAY_WEEK__VOLUME AS SELECT SUM (DDD_NYQ_CSV_DAY.VOLUME ) AS VOLUME, DDD_NYQ_CSV_DAY.WEEK FROM DDD_NYQ_CSV_DAY GROUP BY WEEK;";
  SQLCommand.append ('\n');
  SQLCommand += "CREATE VIEW DDD_NYQ_CSV_DAY_WEEK AS SELECT DDD_NYQ_CSV_DAY_WEEK__HIGH.HIGH AS HIGH, DDD_NYQ_CSV_DAY_WEEK__LOW.LOW AS LOW, DDD_NYQ_CSV_DAY_WEEK__OPEN.OPEN AS OPEN, DDD_NYQ_CSV_DAY_WEEK__CLOSE.CLOSE AS CLOSE, DDD_NYQ_CSV_DAY_WEEK__VOLUME.VOLUME AS VOLUME, DDD_NYQ_CSV_DAY_WEEK__OPEN.DATE AS DATE, DDD_NYQ_CSV_DAY_WEEK__OPEN.TIME AS TIME, DDD_NYQ_CSV_DAY_WEEK__CLOSE.ADJCLOSE AS ADJCLOSE FROM DDD_NYQ_CSV_DAY_WEEK__HIGH, DDD_NYQ_CSV_DAY_WEEK__LOW, DDD_NYQ_CSV_DAY_WEEK__OPEN, DDD_NYQ_CSV_DAY_WEEK__CLOSE, DDD_NYQ_CSV_DAY_WEEK__VOLUME WHERE DDD_NYQ_CSV_DAY_WEEK__HIGH.WEEK = DDD_NYQ_CSV_DAY_WEEK__LOW.WEEK AND DDD_NYQ_CSV_DAY_WEEK__LOW.WEEK = DDD_NYQ_CSV_DAY_WEEK__OPEN.WEEK AND DDD_NYQ_CSV_DAY_WEEK__OPEN.WEEK = DDD_NYQ_CSV_DAY_WEEK__CLOSE.WEEK AND DDD_NYQ_CSV_DAY_WEEK__CLOSE.WEEK = DDD_NYQ_CSV_DAY_WEEK__VOLUME.WEEK;";
  SQLCommand.append ('\n');
  SQLCommand += "delete from SYMBOLS where KEY=\"DDD_NYQ_CSV_DAY_WEEK\";";
  SQLCommand.append ('\n');
  SQLCommand += "INSERT INTO SYMBOLS VALUES ('DDD','3D Systems Corporation','NYQ','CSV','WEEK',' ',' ','DDD_NYQ_CSV_DAY_WEEK','USD',0,'','NO', 'DDD_NYQ_CSV_DAY');";
  SQLCommand.append ('\n');
  SQLCommand += "update SYMBOLS set DATEFROM = (select min(DATE) from DDD_NYQ_CSV_DAY_WEEK) where KEY=\"DDD_NYQ_CSV_DAY_WEEK\";";
  SQLCommand.append ('\n');
  SQLCommand += "update SYMBOLS set DATETO = (select max(DATE) from DDD_NYQ_CSV_DAY_WEEK) where KEY=\"DDD_NYQ_CSV_DAY_WEEK\";";
  SQLCommand.append ('\n');
  SQLCommand += "update SYMBOLS set TFRESOLUTION = (select MINUTE_RESOLUTION from TIMEFRAMES where SYMBOLS.TIMEFRAME = TIMEFRAMES.TIMEFRAME);";
  SQLCommand.append ('\n');
  SQLCommand += "DROP VIEW IF EXISTS DDD_NYQ_CSV_DAY_MONTH;";
  SQLCommand.append ('\n');
  SQLCommand += "DROP VIEW IF EXISTS DDD_NYQ_CSV_DAY_MONTH__CLOSE;";
  SQLCommand.append ('\n');
  SQLCommand += "DROP VIEW IF EXISTS DDD_NYQ_CSV_DAY_MONTH__OPEN;";
  SQLCommand.append ('\n');
  SQLCommand += "DROP VIEW IF EXISTS DDD_NYQ_CSV_DAY_MONTH__HIGH;";
  SQLCommand.append ('\n');
  SQLCommand += "DROP VIEW IF EXISTS DDD_NYQ_CSV_DAY_MONTH__LOW;";
  SQLCommand.append ('\n');
  SQLCommand += "DROP VIEW IF EXISTS DDD_NYQ_CSV_DAY_MONTH__MINDATE;";
  SQLCommand.append ('\n');
  SQLCommand += "DROP VIEW IF EXISTS DDD_NYQ_CSV_DAY_MONTH__MAXDATE;";
  SQLCommand.append ('\n');
  SQLCommand += "DROP VIEW IF EXISTS DDD_NYQ_CSV_DAY_MONTH__VOLUME;";
  SQLCommand.append ('\n');
  SQLCommand += "CREATE VIEW DDD_NYQ_CSV_DAY_MONTH__MAXDATE AS SELECT MAX (DATE) AS DATE, MONTH FROM DDD_NYQ_CSV_DAY GROUP BY MONTH;";
  SQLCommand.append ('\n');
  SQLCommand += "CREATE VIEW DDD_NYQ_CSV_DAY_MONTH__MINDATE AS SELECT MIN (DATE) AS DATE, MONTH FROM DDD_NYQ_CSV_DAY GROUP BY MONTH;";
  SQLCommand.append ('\n');
  SQLCommand += "CREATE VIEW DDD_NYQ_CSV_DAY_MONTH__LOW AS SELECT MIN (LOW) AS LOW, MONTH FROM DDD_NYQ_CSV_DAY GROUP BY MONTH;";
  SQLCommand.append ('\n');
  SQLCommand += "CREATE VIEW DDD_NYQ_CSV_DAY_MONTH__HIGH AS SELECT MAX (HIGH) AS HIGH, MONTH FROM DDD_NYQ_CSV_DAY GROUP BY MONTH;";
  SQLCommand.append ('\n');
  SQLCommand += "CREATE VIEW DDD_NYQ_CSV_DAY_MONTH__OPEN AS SELECT DDD_NYQ_CSV_DAY.OPEN, DDD_NYQ_CSV_DAY.MONTH, DDD_NYQ_CSV_DAY.DATE, DDD_NYQ_CSV_DAY.TIME FROM DDD_NYQ_CSV_DAY, DDD_NYQ_CSV_DAY_MONTH__MINDATE WHERE DDD_NYQ_CSV_DAY.DATE = DDD_NYQ_CSV_DAY_MONTH__MINDATE.DATE AND DDD_NYQ_CSV_DAY.MONTH =  DDD_NYQ_CSV_DAY_MONTH__MINDATE.MONTH;";
  SQLCommand.append ('\n');
  SQLCommand += "CREATE VIEW DDD_NYQ_CSV_DAY_MONTH__CLOSE AS SELECT DDD_NYQ_CSV_DAY.CLOSE, DDD_NYQ_CSV_DAY.CLOSE AS ADJCLOSE, DDD_NYQ_CSV_DAY.MONTH FROM DDD_NYQ_CSV_DAY, DDD_NYQ_CSV_DAY_MONTH__MAXDATE WHERE DDD_NYQ_CSV_DAY.DATE = DDD_NYQ_CSV_DAY_MONTH__MAXDATE.DATE AND DDD_NYQ_CSV_DAY.MONTH =  DDD_NYQ_CSV_DAY_MONTH__MAXDATE.MONTH;";
  SQLCommand.append ('\n');
  SQLCommand += "CREATE VIEW DDD_NYQ_CSV_DAY_MONTH__VOLUME AS SELECT SUM (DDD_NYQ_CSV_DAY.VOLUME ) AS VOLUME, DDD_NYQ_CSV_DAY.MONTH FROM DDD_NYQ_CSV_DAY GROUP BY MONTH;";
  SQLCommand.append ('\n');
  SQLCommand += "CREATE VIEW DDD_NYQ_CSV_DAY_MONTH AS SELECT DDD_NYQ_CSV_DAY_MONTH__HIGH.HIGH AS HIGH, DDD_NYQ_CSV_DAY_MONTH__LOW.LOW AS LOW, DDD_NYQ_CSV_DAY_MONTH__OPEN.OPEN AS OPEN, DDD_NYQ_CSV_DAY_MONTH__CLOSE.CLOSE AS CLOSE, DDD_NYQ_CSV_DAY_MONTH__VOLUME.VOLUME AS VOLUME, DDD_NYQ_CSV_DAY_MONTH__OPEN.DATE AS DATE, DDD_NYQ_CSV_DAY_MONTH__OPEN.TIME AS TIME, DDD_NYQ_CSV_DAY_MONTH__CLOSE.ADJCLOSE AS ADJCLOSE FROM DDD_NYQ_CSV_DAY_MONTH__HIGH, DDD_NYQ_CSV_DAY_MONTH__LOW, DDD_NYQ_CSV_DAY_MONTH__OPEN, DDD_NYQ_CSV_DAY_MONTH__CLOSE, DDD_NYQ_CSV_DAY_MONTH__VOLUME WHERE DDD_NYQ_CSV_DAY_MONTH__HIGH.MONTH = DDD_NYQ_CSV_DAY_MONTH__LOW.MONTH AND DDD_NYQ_CSV_DAY_MONTH__LOW.MONTH = DDD_NYQ_CSV_DAY_MONTH__OPEN.MONTH AND DDD_NYQ_CSV_DAY_MONTH__OPEN.MONTH = DDD_NYQ_CSV_DAY_MONTH__CLOSE.MONTH AND DDD_NYQ_CSV_DAY_MONTH__CLOSE.MONTH = DDD_NYQ_CSV_DAY_MONTH__VOLUME.MONTH;";
  SQLCommand.append ('\n');
  SQLCommand += "delete from SYMBOLS where KEY=\"DDD_NYQ_CSV_DAY_MONTH\";";
  SQLCommand.append ('\n');
  SQLCommand += "INSERT INTO SYMBOLS VALUES ('DDD','3D Systems Corporation','NYQ','CSV','MONTH',' ',' ','DDD_NYQ_CSV_DAY_MONTH','USD',0,'','NO', 'DDD_NYQ_CSV_DAY');";
  SQLCommand.append ('\n');
  SQLCommand += "update SYMBOLS set DATEFROM = (select min(DATE) from DDD_NYQ_CSV_DAY_MONTH) where KEY=\"DDD_NYQ_CSV_DAY_MONTH\";";
  SQLCommand.append ('\n');
  SQLCommand += "update SYMBOLS set DATETO = (select max(DATE) from DDD_NYQ_CSV_DAY_MONTH) where KEY=\"DDD_NYQ_CSV_DAY_MONTH\";";
  SQLCommand.append ('\n');
  SQLCommand += "update SYMBOLS set TFRESOLUTION = (select MINUTE_RESOLUTION from TIMEFRAMES where SYMBOLS.TIMEFRAME = TIMEFRAMES.TIMEFRAME);";
  SQLCommand.append ('\n');
  SQLCommand += "DROP VIEW IF EXISTS DDD_NYQ_CSV_DAY_YEAR;";
  SQLCommand.append ('\n');
  SQLCommand += "DROP VIEW IF EXISTS DDD_NYQ_CSV_DAY_YEAR__CLOSE;";
  SQLCommand.append ('\n');
  SQLCommand += "DROP VIEW IF EXISTS DDD_NYQ_CSV_DAY_YEAR__OPEN;";
  SQLCommand.append ('\n');
  SQLCommand += "DROP VIEW IF EXISTS DDD_NYQ_CSV_DAY_YEAR__HIGH;";
  SQLCommand.append ('\n');
  SQLCommand += "DROP VIEW IF EXISTS DDD_NYQ_CSV_DAY_YEAR__LOW;";
  SQLCommand.append ('\n');
  SQLCommand += "DROP VIEW IF EXISTS DDD_NYQ_CSV_DAY_YEAR__MINDATE;";
  SQLCommand.append ('\n');
  SQLCommand += "DROP VIEW IF EXISTS DDD_NYQ_CSV_DAY_YEAR__MAXDATE;";
  SQLCommand.append ('\n');
  SQLCommand += "DROP VIEW IF EXISTS DDD_NYQ_CSV_DAY_YEAR__VOLUME;";
  SQLCommand.append ('\n');
  SQLCommand += "CREATE VIEW DDD_NYQ_CSV_DAY_YEAR__MAXDATE AS SELECT MAX (DATE) AS DATE, YEAR FROM DDD_NYQ_CSV_DAY GROUP BY YEAR;";
  SQLCommand.append ('\n');
  SQLCommand += "CREATE VIEW DDD_NYQ_CSV_DAY_YEAR__MINDATE AS SELECT MIN (DATE) AS DATE, YEAR FROM DDD_NYQ_CSV_DAY GROUP BY YEAR;";
  SQLCommand.append ('\n');
  SQLCommand += "CREATE VIEW DDD_NYQ_CSV_DAY_YEAR__LOW AS SELECT MIN (LOW) AS LOW, YEAR FROM DDD_NYQ_CSV_DAY GROUP BY YEAR;";
  SQLCommand.append ('\n');
  SQLCommand += "CREATE VIEW DDD_NYQ_CSV_DAY_YEAR__HIGH AS SELECT MAX (HIGH) AS HIGH, YEAR FROM DDD_NYQ_CSV_DAY GROUP BY YEAR;";
  SQLCommand.append ('\n');
  SQLCommand += "CREATE VIEW DDD_NYQ_CSV_DAY_YEAR__OPEN AS SELECT DDD_NYQ_CSV_DAY.OPEN, DDD_NYQ_CSV_DAY.YEAR, DDD_NYQ_CSV_DAY.DATE, DDD_NYQ_CSV_DAY.TIME FROM DDD_NYQ_CSV_DAY, DDD_NYQ_CSV_DAY_YEAR__MINDATE WHERE DDD_NYQ_CSV_DAY.DATE = DDD_NYQ_CSV_DAY_YEAR__MINDATE.DATE AND DDD_NYQ_CSV_DAY.YEAR =  DDD_NYQ_CSV_DAY_YEAR__MINDATE.YEAR;";
  SQLCommand.append ('\n');
  SQLCommand += "CREATE VIEW DDD_NYQ_CSV_DAY_YEAR__CLOSE AS SELECT DDD_NYQ_CSV_DAY.CLOSE, DDD_NYQ_CSV_DAY.CLOSE AS ADJCLOSE, DDD_NYQ_CSV_DAY.YEAR FROM DDD_NYQ_CSV_DAY, DDD_NYQ_CSV_DAY_YEAR__MAXDATE WHERE DDD_NYQ_CSV_DAY.DATE = DDD_NYQ_CSV_DAY_YEAR__MAXDATE.DATE AND DDD_NYQ_CSV_DAY.YEAR =  DDD_NYQ_CSV_DAY_YEAR__MAXDATE.YEAR;";
  SQLCommand.append ('\n');
  SQLCommand += "CREATE VIEW DDD_NYQ_CSV_DAY_YEAR__VOLUME AS SELECT SUM (DDD_NYQ_CSV_DAY.VOLUME ) AS VOLUME, DDD_NYQ_CSV_DAY.YEAR FROM DDD_NYQ_CSV_DAY GROUP BY YEAR;";
  SQLCommand.append ('\n');
  SQLCommand += "CREATE VIEW DDD_NYQ_CSV_DAY_YEAR AS SELECT DDD_NYQ_CSV_DAY_YEAR__HIGH.HIGH AS HIGH, DDD_NYQ_CSV_DAY_YEAR__LOW.LOW AS LOW, DDD_NYQ_CSV_DAY_YEAR__OPEN.OPEN AS OPEN, DDD_NYQ_CSV_DAY_YEAR__CLOSE.CLOSE AS CLOSE, DDD_NYQ_CSV_DAY_YEAR__VOLUME.VOLUME AS VOLUME, DDD_NYQ_CSV_DAY_YEAR__OPEN.DATE AS DATE, DDD_NYQ_CSV_DAY_YEAR__OPEN.TIME AS TIME, DDD_NYQ_CSV_DAY_YEAR__CLOSE.ADJCLOSE AS ADJCLOSE FROM DDD_NYQ_CSV_DAY_YEAR__HIGH, DDD_NYQ_CSV_DAY_YEAR__LOW, DDD_NYQ_CSV_DAY_YEAR__OPEN, DDD_NYQ_CSV_DAY_YEAR__CLOSE, DDD_NYQ_CSV_DAY_YEAR__VOLUME WHERE DDD_NYQ_CSV_DAY_YEAR__HIGH.YEAR = DDD_NYQ_CSV_DAY_YEAR__LOW.YEAR AND DDD_NYQ_CSV_DAY_YEAR__LOW.YEAR = DDD_NYQ_CSV_DAY_YEAR__OPEN.YEAR AND DDD_NYQ_CSV_DAY_YEAR__OPEN.YEAR = DDD_NYQ_CSV_DAY_YEAR__CLOSE.YEAR AND DDD_NYQ_CSV_DAY_YEAR__CLOSE.YEAR = DDD_NYQ_CSV_DAY_YEAR__VOLUME.YEAR;";
  SQLCommand.append ('\n');
  SQLCommand += "delete from SYMBOLS where KEY=\"DDD_NYQ_CSV_DAY_YEAR\";";
  SQLCommand.append ('\n');
  SQLCommand += "INSERT INTO SYMBOLS VALUES ('DDD','3D Systems Corporation','NYQ','CSV','YEAR',' ',' ','DDD_NYQ_CSV_DAY_YEAR','USD',0,'','NO', 'DDD_NYQ_CSV_DAY');";
  SQLCommand.append ('\n');
  SQLCommand += "update SYMBOLS set DATEFROM = (select min(DATE) from DDD_NYQ_CSV_DAY_YEAR) where KEY=\"DDD_NYQ_CSV_DAY_YEAR\";";
  SQLCommand.append ('\n');
  SQLCommand += "update SYMBOLS set DATETO = (select max(DATE) from DDD_NYQ_CSV_DAY_YEAR) where KEY=\"DDD_NYQ_CSV_DAY_YEAR\";";
  SQLCommand.append ('\n');
  SQLCommand += "update SYMBOLS set TFRESOLUTION = (select MINUTE_RESOLUTION from TIMEFRAMES where SYMBOLS.TIMEFRAME = TIMEFRAMES.TIMEFRAME);";
  SQLCommand.append ('\n');
  SQLCommand += "commit;";
  SQLCommand.append ('\n');

  // execute sql
  rc = sqlite3_exec(appsettings.db, SQLCommand.toUtf8(), NULL, NULL, NULL);
  if (rc != SQLITE_OK)
  {
    result = CG_ERR_TRANSACTION;
    setGlobalError(result, __FILE__, __LINE__);
  }


  return result;
}

// db schema version 2
static CG_ERR_RESULT
version2 (AppSettings appsettings)
{
  QString SQLCommand = "";
  CG_ERR_RESULT result = CG_ERR_OK;
  int rc;

  rc = sqlite3_exec(appsettings.db, SQLCommand.toUtf8(), NULL, NULL, NULL);
  if (rc != SQLITE_OK)
  {
    result = CG_ERR_TRANSACTION;
    setGlobalError(result, __FILE__, __LINE__);
    return result;
  }

  SQLCommand = "BEGIN;";
  SQLCommand.append ('\n');
  SQLCommand += "CREATE TABLE BASEDATA (BASE TEXT NOT NULL, ";
  SQLCommand += "BV TEXT NOT NULL DEFAULT 'N/A', MC TEXT NOT NULL DEFAULT 'N/A',";
  SQLCommand += "EBITDA TEXT NOT NULL DEFAULT 'N/A', PE TEXT NOT NULL DEFAULT 'N/A',";
  SQLCommand += "PEG TEXT NOT NULL DEFAULT 'N/A', DY TEXT NOT NULL DEFAULT 'N/A',";
  SQLCommand += "EPSCURRENT TEXT NOT NULL DEFAULT 'N/A',";
  SQLCommand += "EPSNEXT TEXT NOT NULL DEFAULT 'N/A',";
  SQLCommand += "ES TEXT NOT NULL DEFAULT 'N/A',";
  SQLCommand += "PS TEXT NOT NULL DEFAULT 'N/A',";
  SQLCommand += "PBV TEXT NOT NULL DEFAULT 'N/A');";
  SQLCommand.append ('\n');
  SQLCommand += "ALTER TABLE OPTIONS ADD COLUMN LONGBP INTEGER DEFAULT (0);";
  SQLCommand.append ('\n');
  SQLCommand += "UPDATE version SET version=2 WHERE version=1;";
  SQLCommand.append ('\n');
  SQLCommand += "COMMIT;";

  // execute sql
  rc = sqlite3_exec(appsettings.db, SQLCommand.toUtf8(), NULL, NULL, NULL);
  if (rc != SQLITE_OK)
  {
    result = CG_ERR_TRANSACTION;
    setGlobalError(result, __FILE__, __LINE__);
  }

  return result;
}

// db schema version 3
static CG_ERR_RESULT
version3 (AppSettings appsettings)
{
  QString SQLCommand = "";
  CG_ERR_RESULT result = CG_ERR_OK;
  int rc;

  rc = sqlite3_exec(appsettings.db, SQLCommand.toUtf8(), NULL, NULL, NULL);
  if (rc != SQLITE_OK)
  {
    result = CG_ERR_TRANSACTION;
    setGlobalError(result, __FILE__, __LINE__);
    return result;
  }

  SQLCommand = "BEGIN;";
  SQLCommand.append ('\n');
  SQLCommand += "CREATE TABLE TEMPLATES ";
  SQLCommand += "(TEMPLATE Text DEFAULT 'Template', ";
  SQLCommand += "TEMPLATE_ID Integer Primary Key Autoincrement  NOT NULL, ";
  SQLCommand += "TABLENAME TEXT DEFAULT 'NoTableYet'); ";
  SQLCommand.append ('\n');
  SQLCommand += "CREATE TABLE TEMPLATEMODEL ";
  SQLCommand += "(SERIAL INTEGER DEFAULT -1, ";
  SQLCommand += "DYNPARAM INTEGER DEFAULT -1, ";
  SQLCommand += "TYPE INTEGER DEFAULT -1, ";
  SQLCommand += "TITLE TEXT DEFAULT '', ";
  SQLCommand += "PARAMNAME TEXT DEFAULT '', ";
  SQLCommand += "PARAMLABEL TEXT DEFAULT '', ";
  SQLCommand += "PARAMTYPE INTEGER DEFAULT -1, ";
  SQLCommand += "PARAMDEF REAL DEFAULT -999999, ";
  SQLCommand += "PARAMVALUE REAL DEFAULT -999999);";
  SQLCommand.append ('\n');
  SQLCommand += "INSERT INTO TEMPLATES (TEMPLATE, TABLENAME) ";
  SQLCommand += "VALUES ('Golden/Death Cross', 'template_0');";
  SQLCommand.append ('\n');
  SQLCommand += "CREATE TABLE template_0 AS SELECT * FROM templatemodel;";
  SQLCommand.append ('\n');
  SQLCommand += "INSERT INTO template_0 (SERIAL, DYNPARAM, TYPE, TITLE, ";
  SQLCommand += "PARAMNAME, PARAMLABEL, PARAMTYPE, PARAMDEF, PARAMVALUE) ";
  SQLCommand += "VALUES (0, 1, 9, 'SMA', 'Period', 'Period', 0, 50, 50);";
  SQLCommand.append ('\n');
  SQLCommand += "INSERT INTO template_0 (SERIAL, DYNPARAM, TYPE, TITLE, ";
  SQLCommand += "PARAMNAME, PARAMLABEL, PARAMTYPE, PARAMDEF, PARAMVALUE) ";
  SQLCommand += "VALUES (0, 1, 9, 'SMA', 'Color', 'Color', 2, 4278255615, 4278255615);";
  SQLCommand.append ('\n');
  SQLCommand += "INSERT INTO template_0 (SERIAL, DYNPARAM, TYPE, TITLE, ";
  SQLCommand += "PARAMNAME, PARAMLABEL, PARAMTYPE, PARAMDEF, PARAMVALUE) ";
  SQLCommand += "VALUES (1, 1, 9, 'SMA', 'Period', 'Period', 0, 200,    200);";
  SQLCommand.append ('\n');
  SQLCommand += "INSERT INTO template_0 (SERIAL, DYNPARAM, TYPE, TITLE, ";
  SQLCommand += "PARAMNAME, PARAMLABEL, PARAMTYPE, PARAMDEF, PARAMVALUE) ";
  SQLCommand += "VALUES (1, 1, 9, 'SMA', 'Color', 'Color', 2, 4294967040, 4294967040);";
  SQLCommand.append ('\n');
  SQLCommand += "UPDATE version SET version=3 WHERE version=2;";
  SQLCommand.append ('\n');
  SQLCommand += "COMMIT;";

  // execute sql
  rc = sqlite3_exec(appsettings.db, SQLCommand.toUtf8(), NULL, NULL, NULL);
  if (rc != SQLITE_OK)
  {
    result = CG_ERR_TRANSACTION;
    setGlobalError(result, __FILE__, __LINE__);
  }

  return result;
}

// db schema version 4
static CG_ERR_RESULT
version4 (AppSettings appsettings)
{
  QString SQLCommand = "";
  CG_ERR_RESULT result = CG_ERR_OK;
  int rc;

  rc = sqlite3_exec(appsettings.db, SQLCommand.toUtf8(), NULL, NULL, NULL);
  if (rc != SQLITE_OK)
  {
    result = CG_ERR_TRANSACTION;
    setGlobalError(result, __FILE__, __LINE__);
    return result;
  }

  SQLCommand = "BEGIN;";
  SQLCommand.append ('\n');
  SQLCommand += "CREATE TABLE CHART_SETTINGS ";
  SQLCommand += "(KEY TEXT NOT NULL UNIQUE,";
  SQLCommand += "VOLUME INTEGER DEFAULT 0,";
  SQLCommand += "LINEAR INTEGER  DEFAULT 0,";
  SQLCommand += "CHARTSTYLE INTEGER DEFAULT 200,";
  SQLCommand += "TIMEFRAME TEXT DEFAULT 'DAY',";
  SQLCommand += "ONLINEPRICE INTEGER DEFAULT 0,";
  SQLCommand += "LINECOLOR REAL DEFAULT 4278255360,";
  SQLCommand += "BARCOLOR REAL DEFAULT 4278255360,";
  SQLCommand += "FRAMEWIDTH INTEGER DEFAULT 10,";
  SQLCommand += "STARTBAR INTEGER DEFAULT 0,";
  SQLCommand += "EDW REAL DEFAULT 0.0,";
  SQLCommand += "GRID INTEGER DEFAULT 1);";
  SQLCommand.append ('\n');
  SQLCommand += "UPDATE version SET version=4 WHERE version=3;";
  SQLCommand.append ('\n');
  SQLCommand += "COMMIT;";

  // execute sql
  rc = sqlite3_exec(appsettings.db, SQLCommand.toUtf8(), NULL, NULL, NULL);
  if (rc != SQLITE_OK)
  {
    result = CG_ERR_TRANSACTION;
    setGlobalError(result, __FILE__, __LINE__);
  }

  return result;
}

// db schema version 5
static CG_ERR_RESULT
version5 (AppSettings appsettings)
{
  QString SQLCommand = "";
  CG_ERR_RESULT result = CG_ERR_OK;
  int rc;

  rc = sqlite3_exec(appsettings.db, SQLCommand.toUtf8(), NULL, NULL, NULL);
  if (rc != SQLITE_OK)
  {
    result = CG_ERR_TRANSACTION;
    setGlobalError(result, __FILE__, __LINE__);
    return result;
  }

  SQLCommand = "BEGIN;";
  SQLCommand.append ('\n');

  SQLCommand += "ALTER TABLE CHART_SETTINGS ADD COLUMN FORECOLOR REAL ";
  SQLCommand += "DEFAULT (" + QString::number ((qreal) QColor(Qt::white).rgb (), 'f', 0)  + ");";
  SQLCommand.append ('\n');

  SQLCommand += "ALTER TABLE CHART_SETTINGS ADD COLUMN BACKCOLOR REAL ";
  SQLCommand += "DEFAULT (" + QString::number ((qreal)  QColor(Qt::black).rgb (), 'f', 0)  + ");";

  SQLCommand += "UPDATE version SET version=5 WHERE version=4;";
  SQLCommand.append ('\n');
  SQLCommand += "COMMIT;";

  // execute sql
  rc = sqlite3_exec(appsettings.db, SQLCommand.toUtf8(), NULL, NULL, NULL);
  if (rc != SQLITE_OK)
  {
    result = CG_ERR_TRANSACTION;
    setGlobalError(result, __FILE__, __LINE__);
  }

  return result;
}

// db schema version 6
static CG_ERR_RESULT
version6 (AppSettings appsettings)
{
  QString SQLCommand = "", UID;
  QByteArray ba;
  CG_ERR_RESULT result = CG_ERR_OK;
  int rc;

  rc = sqlite3_exec(appsettings.db, SQLCommand.toUtf8(), NULL, NULL, NULL);
  if (rc != SQLITE_OK)
  {
    result = CG_ERR_TRANSACTION;
    setGlobalError(result, __FILE__, __LINE__);
    return result;
  }

  ba = (QString::number(QDateTime::currentMSecsSinceEpoch ())).toLatin1 ();
  UID = QString(QCryptographicHash::hash((ba),
                                         QCryptographicHash::Md5).toHex());

  SQLCommand = "BEGIN;";
  SQLCommand.append ('\n');

  SQLCommand += "ALTER TABLE VERSION ADD COLUMN RUNCOUNTER INTEGER DEFAULT 0;";
  SQLCommand += "UPDATE VERSION SET RUNCOUNTER = 0;";
  SQLCommand.append ('\n');

  SQLCommand += "ALTER TABLE VERSION ADD COLUMN UID TEXT;";
  SQLCommand += "UPDATE VERSION SET UID = '" + UID + "';";
  SQLCommand.append ('\n');


  SQLCommand += "UPDATE version SET version=6 WHERE version=5;";
  SQLCommand.append ('\n');
  SQLCommand += "COMMIT;";

  // execute sql
  rc = sqlite3_exec(appsettings.db, SQLCommand.toUtf8(), NULL, NULL, NULL);
  if (rc != SQLITE_OK)
  {
    result = CG_ERR_TRANSACTION;
    setGlobalError(result, __FILE__, __LINE__);
  }

  return result;

}

// db schema version 7
static QString
version7_template_alter (QString tablename)
{
  QString SQLCommand = "";

  SQLCommand += "ALTER TABLE " + tablename + " ADD COLUMN COLOR REAL DEFAULT 4294967295;";
  SQLCommand.append ('\n');
  SQLCommand += "ALTER TABLE " + tablename + " ADD COLUMN FONTSIZE INTEGER DEFAULT 7;";
  SQLCommand.append ('\n');
  SQLCommand += "ALTER TABLE " + tablename + " ADD COLUMN FONT TEXT DEFAULT 'Tahoma';";
  SQLCommand.append ('\n');
  SQLCommand += "ALTER TABLE " + tablename + " ADD COLUMN FONTWEIGHT INTEGER DEFAULT 50;";
  SQLCommand.append ('\n');
  SQLCommand += "ALTER TABLE " + tablename + " ADD COLUMN TEXT TEXT DEFAULT '';";
  SQLCommand.append ('\n');
  SQLCommand += "ALTER TABLE " + tablename + " ADD COLUMN TRAILERCANDLETEXT TEXT DEFAULT '';";
  SQLCommand.append ('\n');
  SQLCommand += "ALTER TABLE " + tablename + " ADD COLUMN PRICE REAL DEFAULT 0.0;";
  SQLCommand.append ('\n');
  SQLCommand += "ALTER TABLE " + tablename + " ADD COLUMN PAD REAL DEFAULT 0.0;";
  SQLCommand.append ('\n');
  SQLCommand += "ALTER TABLE " + tablename + " ADD COLUMN TXTDIRECTION INTEGER DEFAULT 0;";
  SQLCommand.append ('\n');
  SQLCommand += "ALTER TABLE " + tablename + " ADD COLUMN TRAILERCANDLETEXT2 TEXT DEFAULT '';";
  SQLCommand.append ('\n');
  SQLCommand += "ALTER TABLE " + tablename + " ADD COLUMN PRICE2 REAL DEFAULT 0.0;";
  SQLCommand.append ('\n');
  SQLCommand += "ALTER TABLE " + tablename + " ADD COLUMN PAD2 REAL DEFAULT 0.0;";
  SQLCommand.append ('\n');
  SQLCommand += "ALTER TABLE " + tablename + " ADD COLUMN TXTDIRECTION2 INTEGER DEFAULT 0;";
  SQLCommand.append ('\n');
  SQLCommand += "ALTER TABLE " + tablename + " ADD COLUMN X1 REAL DEFAULT 0.0;";
  SQLCommand.append ('\n');
  SQLCommand += "ALTER TABLE " + tablename + " ADD COLUMN X2 REAL DEFAULT 0.0;";
  SQLCommand.append ('\n');
  SQLCommand += "ALTER TABLE " + tablename + " ADD COLUMN Y1 REAL DEFAULT 0.0;";
  SQLCommand.append ('\n');
  SQLCommand += "ALTER TABLE " + tablename + " ADD COLUMN Y2 REAL DEFAULT 0.0;";
  SQLCommand.append ('\n');

  return SQLCommand;
}

int
version7_sqlcb_sqlite_master (void *classptr, int argc, char **argv, char **column)
{
  QStringList *slist;

  for (qint32 counter = 0; counter < argc; counter ++)
  {
    QString colname = QString::fromUtf8(column[counter]);
    colname = colname.toUpper ();
    if (colname == "NAME")
    {
      slist = (QStringList *) classptr;
      slist->append (QString::fromUtf8 (argv[0]));
    }
  }

  return 0;
}


static CG_ERR_RESULT
version7 (AppSettings appsettings)
{
  QString SQLCommand = "", query;
  QStringList templates;
  CG_ERR_RESULT result = CG_ERR_OK;
  int rc;

  query = "select name from sqlite_master where name like 'template\\_%' escape '\\';";
  rc = sqlite3_exec(appsettings.db, query.toUtf8(),
                    version7_sqlcb_sqlite_master,
                    static_cast <void *> (&templates), NULL);
  if (rc != SQLITE_OK)
  {
    setGlobalError(CG_ERR_DBACCESS, __FILE__, __LINE__);
    return CG_ERR_DBACCESS;
  }

  SQLCommand = "BEGIN;";
  SQLCommand.append ('\n');
  SQLCommand += version7_template_alter ("TEMPLATEMODEL");
  foreach (query, templates)
    SQLCommand += version7_template_alter (query);
  SQLCommand += "UPDATE version SET version=7 WHERE version=6;";
  SQLCommand.append ('\n');
  SQLCommand += "COMMIT;";

  // execute sql
  rc = sqlite3_exec(appsettings.db, SQLCommand.toUtf8(), NULL, NULL, NULL);
  if (rc != SQLITE_OK)
  {
    result = CG_ERR_TRANSACTION;
    setGlobalError(result, __FILE__, __LINE__);
  }

  return result;

}

// db schema version 8
static CG_ERR_RESULT
version8 (AppSettings appsettings)
{
  QString SQLCommand = "";
  CG_ERR_RESULT result = CG_ERR_OK;
  int rc;

  rc = sqlite3_exec(appsettings.db, SQLCommand.toUtf8(), NULL, NULL, NULL);
  if (rc != SQLITE_OK)
  {
    result = CG_ERR_TRANSACTION;
    setGlobalError(result, __FILE__, __LINE__);
    return result;
  }

  SQLCommand = "BEGIN;";
  SQLCommand.append ('\n');
  SQLCommand += "INSERT INTO FORMATS_RAW (FORMAT) VALUES ('MICROSOFT EXCEL');";
  SQLCommand.append ('\n');
  SQLCommand += "ALTER TABLE OPTIONS ADD COLUMN SCROLLSPEED INTEGER DEFAULT 10;";
  SQLCommand.append ('\n');
  SQLCommand += "ALTER TABLE TEMPLATES ADD COLUMN SQLSTATEMENT TEXT;";
  SQLCommand.append ('\n');
  SQLCommand += "UPDATE TEMPLATES SET SQLSTATEMENT = '-- 0|0 -- No template script';";
  SQLCommand.append ('\n');
  SQLCommand += "CREATE TABLE TICKER_SYMBOLS ";
  SQLCommand += "(SYMBOL TEXT NOT NULL UNIQUE,";
  SQLCommand += "FEED TEXT DEFAULT 'IEX');";
  SQLCommand.append ('\n');

  SQLCommand += "INSERT INTO TICKER_SYMBOLS (SYMBOL, FEED) VALUES ";
  SQLCommand += "('AXP', 'YAHOO');";
  SQLCommand.append ('\n');
  SQLCommand += "INSERT INTO TICKER_SYMBOLS (SYMBOL, FEED) VALUES ";
  SQLCommand += "('BA', 'YAHOO');";
  SQLCommand.append ('\n');
  SQLCommand += "INSERT INTO TICKER_SYMBOLS (SYMBOL, FEED) VALUES ";
  SQLCommand += "('CAT', 'YAHOO');";
  SQLCommand.append ('\n');
  SQLCommand += "INSERT INTO TICKER_SYMBOLS (SYMBOL, FEED) VALUES ";
  SQLCommand += "('CSCO', 'YAHOO');";
  SQLCommand.append ('\n');
  SQLCommand += "INSERT INTO TICKER_SYMBOLS (SYMBOL, FEED) VALUES ";
  SQLCommand += "('CVX', 'YAHOO');";
  SQLCommand.append ('\n');
  SQLCommand += "INSERT INTO TICKER_SYMBOLS (SYMBOL, FEED) VALUES ";
  SQLCommand += "('DD', 'YAHOO');";
  SQLCommand.append ('\n');
  SQLCommand += "INSERT INTO TICKER_SYMBOLS (SYMBOL, FEED) VALUES ";
  SQLCommand += "('DIS', 'YAHOO');";
  SQLCommand.append ('\n');
  SQLCommand += "INSERT INTO TICKER_SYMBOLS (SYMBOL, FEED) VALUES ";
  SQLCommand += "('GE', 'YAHOO');";
  SQLCommand.append ('\n');
  SQLCommand += "INSERT INTO TICKER_SYMBOLS (SYMBOL, FEED) VALUES ";
  SQLCommand += "('GS', 'YAHOO');";
  SQLCommand.append ('\n');
  SQLCommand += "INSERT INTO TICKER_SYMBOLS (SYMBOL, FEED) VALUES ";
  SQLCommand += "('HD', 'YAHOO');";
  SQLCommand.append ('\n');
  SQLCommand += "INSERT INTO TICKER_SYMBOLS (SYMBOL, FEED) VALUES ";
  SQLCommand += "('IBM', 'YAHOO');";
  SQLCommand.append ('\n');
  SQLCommand += "INSERT INTO TICKER_SYMBOLS (SYMBOL, FEED) VALUES ";
  SQLCommand += "('INTC', 'YAHOO');";
  SQLCommand.append ('\n');
  SQLCommand += "INSERT INTO TICKER_SYMBOLS (SYMBOL, FEED) VALUES ";
  SQLCommand += "('JNJ', 'YAHOO');";
  SQLCommand.append ('\n');
  SQLCommand += "INSERT INTO TICKER_SYMBOLS (SYMBOL, FEED) VALUES ";
  SQLCommand += "('JPM', 'YAHOO');";
  SQLCommand.append ('\n');
  SQLCommand += "INSERT INTO TICKER_SYMBOLS (SYMBOL, FEED) VALUES ";
  SQLCommand += "('KO', 'YAHOO');";
  SQLCommand.append ('\n');
  SQLCommand += "INSERT INTO TICKER_SYMBOLS (SYMBOL, FEED) VALUES ";
  SQLCommand += "('MCD', 'YAHOO');";
  SQLCommand.append ('\n');
  SQLCommand += "INSERT INTO TICKER_SYMBOLS (SYMBOL, FEED) VALUES ";
  SQLCommand += "('MMM', 'YAHOO');";
  SQLCommand.append ('\n');
  SQLCommand += "INSERT INTO TICKER_SYMBOLS (SYMBOL, FEED) VALUES ";
  SQLCommand += "('MRK', 'YAHOO');";
  SQLCommand.append ('\n');
  SQLCommand += "INSERT INTO TICKER_SYMBOLS (SYMBOL, FEED) VALUES ";
  SQLCommand += "('MSFT', 'YAHOO');";
  SQLCommand.append ('\n');
  SQLCommand += "INSERT INTO TICKER_SYMBOLS (SYMBOL, FEED) VALUES ";
  SQLCommand += "('NKE', 'YAHOO');";
  SQLCommand.append ('\n');
  SQLCommand += "INSERT INTO TICKER_SYMBOLS (SYMBOL, FEED) VALUES ";
  SQLCommand += "('PFE', 'YAHOO');";
  SQLCommand.append ('\n');
  SQLCommand += "INSERT INTO TICKER_SYMBOLS (SYMBOL, FEED) VALUES ";
  SQLCommand += "('PG', 'YAHOO');";
  SQLCommand.append ('\n');
  SQLCommand += "INSERT INTO TICKER_SYMBOLS (SYMBOL, FEED) VALUES ";
  SQLCommand += "('T', 'YAHOO');";
  SQLCommand.append ('\n');
  SQLCommand += "INSERT INTO TICKER_SYMBOLS (SYMBOL, FEED) VALUES ";
  SQLCommand += "('TRV', 'YAHOO');";
  SQLCommand.append ('\n');
  SQLCommand += "INSERT INTO TICKER_SYMBOLS (SYMBOL, FEED) VALUES ";
  SQLCommand += "('UNH', 'YAHOO');";
  SQLCommand.append ('\n');
  SQLCommand += "INSERT INTO TICKER_SYMBOLS (SYMBOL, FEED) VALUES ";
  SQLCommand += "('UTX', 'YAHOO');";
  SQLCommand.append ('\n');
  SQLCommand += "INSERT INTO TICKER_SYMBOLS (SYMBOL, FEED) VALUES ";
  SQLCommand += "('V', 'YAHOO');";
  SQLCommand.append ('\n');
  SQLCommand += "INSERT INTO TICKER_SYMBOLS (SYMBOL, FEED) VALUES ";
  SQLCommand += "('VZ', 'YAHOO');";
  SQLCommand.append ('\n');
  SQLCommand += "INSERT INTO TICKER_SYMBOLS (SYMBOL, FEED) VALUES ";
  SQLCommand += "('WMT', 'YAHOO');";
  SQLCommand.append ('\n');
  SQLCommand += "INSERT INTO TICKER_SYMBOLS (SYMBOL, FEED) VALUES ";
  SQLCommand += "('XOM', 'YAHOO');";
  SQLCommand.append ('\n');

  SQLCommand += "ALTER TABLE OPTIONS ADD COLUMN ";
  SQLCommand += "VOLUME INTEGER DEFAULT 0;";
  SQLCommand.append ('\n');

  SQLCommand += "ALTER TABLE OPTIONS ADD COLUMN ";
  SQLCommand += "LINEAR INTEGER  DEFAULT 0;";
  SQLCommand.append ('\n');

  SQLCommand += "ALTER TABLE OPTIONS ADD COLUMN ";
  SQLCommand += "CHARTSTYLE INTEGER DEFAULT 200;";
  SQLCommand.append ('\n');

  SQLCommand += "ALTER TABLE OPTIONS ADD COLUMN ";
  SQLCommand += "ONLINEPRICE INTEGER DEFAULT 0;";
  SQLCommand.append ('\n');

  SQLCommand += "ALTER TABLE OPTIONS ADD COLUMN ";
  SQLCommand += "LINECOLOR INTEGER DEFAULT 4278255360;";
  SQLCommand.append ('\n');

  SQLCommand += "ALTER TABLE OPTIONS ADD COLUMN ";
  SQLCommand += "BARCOLOR INTEGER DEFAULT 4278255360;";
  SQLCommand.append ('\n');

  SQLCommand += "ALTER TABLE OPTIONS ADD COLUMN FORECOLOR INTEGER ";
  SQLCommand += "DEFAULT 4294967295;";
  SQLCommand.append ('\n');

  SQLCommand += "ALTER TABLE OPTIONS ADD COLUMN BACKCOLOR INTEGER ";
  SQLCommand += "DEFAULT 4278190080;";

  SQLCommand += "ALTER TABLE OPTIONS ADD COLUMN ";
  SQLCommand += "GRID INTEGER DEFAULT 1;";
  SQLCommand.append ('\n');

  SQLCommand += "UPDATE version SET version=8 WHERE version=7;";
  SQLCommand.append ('\n');
  SQLCommand += "COMMIT;";

  // execute sql
  rc = sqlite3_exec(appsettings.db, SQLCommand.toUtf8(), NULL, NULL, NULL);
  if (rc != SQLITE_OK)
  {
    result = CG_ERR_TRANSACTION;
    setGlobalError(result, __FILE__, __LINE__);
  }

  return result;
}

// db schema version 9
static CG_ERR_RESULT
version9 (AppSettings appsettings)
{
  QString SQLCommand = "";
  CG_ERR_RESULT result = CG_ERR_OK;
  int rc;

  rc = sqlite3_exec(appsettings.db, SQLCommand.toUtf8(), NULL, NULL, NULL);
  if (rc != SQLITE_OK)
  {
    result = CG_ERR_TRANSACTION;
    setGlobalError(result, __FILE__, __LINE__);
    return result;
  }

  SQLCommand = "BEGIN;";
  SQLCommand.append ('\n');
  SQLCommand += "ALTER TABLE datafeeds_raw ADD COLUMN REALTIME INTEGER DEFAULT 0;";
  SQLCommand.append ('\n');
  SQLCommand += "ALTER TABLE datafeeds_raw ADD COLUMN SYMLIST CHAR DEFAULT 'NONE';";
  SQLCommand.append ('\n');
  SQLCommand += "ALTER TABLE datafeeds_raw ADD COLUMN SYMLISTURL CHAR DEFAULT 'NONE';";
  SQLCommand.append ('\n');
  SQLCommand += "UPDATE datafeeds_raw SET REALTIME = 1;";
  SQLCommand.append ('\n');
  SQLCommand += "INSERT INTO datafeeds_raw (FEEDNAME, ACTIVE, SYMLIST, REALTIME, SYMLISTURL) VALUES ('QUANDL (INDEXES)', 1, 'symlist_quandl_indexes', 0, 'https://www.dropbox.com/s/xp0yoxs3wd1a8ib/indexlist.csv');";
  SQLCommand.append ('\n');
  SQLCommand += "CREATE TABLE symlistmodel (SYMBOL CHAR NOT NULL, DESCRIPTION CHAR NOT NULL, MARKET CHAR NOT NULL, URL1 CHAR NOT NULL, URL2 CHAR NOT NULL);";
  SQLCommand.append ('\n');
  SQLCommand += "CREATE TABLE symlist_quandl_indexes AS SELECT * FROM symlistmodel;";
  SQLCommand.append ('\n');
  SQLCommand += "INSERT INTO symlist_quandl_indexes (SYMBOL, DESCRIPTION, MARKET, URL1, URL2) VALUES ('CAC40','CAC-40 Index','Paris','https://www.dropbox.com/s/e5e6qerefa2790h/cac40','http://chartgeany.com/downloads/indexes/cac40');";
  SQLCommand.append ('\n');
  SQLCommand += "INSERT INTO symlist_quandl_indexes (SYMBOL, DESCRIPTION, MARKET, URL1, URL2) VALUES ('NIKKEI225','Nikkei 225 Index','Tokyo','https://www.dropbox.com/s/mb65lias6gxrjzz/nikkei225','http://chartgeany.com/downloads/indexes/nikkei225');";
  SQLCommand.append ('\n');
  SQLCommand += "INSERT INTO symlist_quandl_indexes (SYMBOL, DESCRIPTION, MARKET, URL1, URL2) VALUES ('DAX','DAX Index','XETRA','https://www.dropbox.com/s/ua1osvwpd1pt4cb/dax','http://chartgeany.com/downloads/indexes/dax');";
  SQLCommand.append ('\n');
  SQLCommand += "INSERT INTO symlist_quandl_indexes (SYMBOL, DESCRIPTION, MARKET, URL1, URL2) VALUES ('FTSE100','FTSE 100 Index','London','https://www.dropbox.com/s/qv6pfxlgv12b66n/ftse100','http://chartgeany.com/downloads/indexes/ftse100');";
  SQLCommand.append ('\n');
  SQLCommand += "INSERT INTO symlist_quandl_indexes (SYMBOL, DESCRIPTION, MARKET, URL1, URL2) VALUES ('SP500','S & P 500 Index','New York','https://www.dropbox.com/s/r6dtljy8hhcvrb5/sp500','http://chartgeany.com/downloads/indexes/sp500');";
  SQLCommand.append ('\n');
  SQLCommand += "INSERT INTO symlist_quandl_indexes (SYMBOL, DESCRIPTION, MARKET, URL1, URL2) VALUES ('NASDAQ','NASDAQ Composite Index','New York','https://www.dropbox.com/s/yuy2la1t8tgqa2f/nasdaq','http://chartgeany.com/downloads/indexes/nasdaq');";
  SQLCommand.append ('\n');
  SQLCommand += "INSERT INTO symlist_quandl_indexes (SYMBOL, DESCRIPTION, MARKET, URL1, URL2) VALUES ('RUSSELL1000','Russell 1000 Index','Chicago','https://www.dropbox.com/s/f4fpiksgbg7bc5t/russell1000','http://chartgeany.com/downloads/indexes/russell1000');";
  SQLCommand.append ('\n');
  SQLCommand += "INSERT INTO symlist_quandl_indexes (SYMBOL, DESCRIPTION, MARKET, URL1, URL2) VALUES ('DJIA','Dow Jones Industrial Average','New York','https://www.dropbox.com/s/lxoa0y075rbvgu3/djia','http://chartgeany.com/downloads/indexes/djia');";
  SQLCommand.append ('\n');
  SQLCommand += "INSERT INTO symlist_quandl_indexes (SYMBOL, DESCRIPTION, MARKET, URL1, URL2) VALUES ('HSI','Hang Seng Index','Hong Kong','https://www.dropbox.com/s/smjmkpxmk62yd7c/hangseng','http://chartgeany.com/downloads/indexes/hangseng');";
  SQLCommand.append ('\n');
  SQLCommand += "INSERT INTO symlist_quandl_indexes (SYMBOL, DESCRIPTION, MARKET, URL1, URL2) VALUES ('MIB','FTSE MIB Index','Milan','https://www.dropbox.com/s/9esvbrwceeiytdp/mib','http://chartgeany.com/downloads/indexes/mib');";
  SQLCommand.append ('\n');
  SQLCommand += "INSERT INTO symlist_quandl_indexes (SYMBOL, DESCRIPTION, MARKET, URL1, URL2) VALUES ('BSE30','S & P BSE Sensex Index','Bombay','https://www.dropbox.com/s/mkqeuaxkofnyjt8/bse30','http://chartgeany.com/downloads/indexes/bse30');";
  SQLCommand.append ('\n');
  SQLCommand += "INSERT INTO symlist_quandl_indexes (SYMBOL, DESCRIPTION, MARKET, URL1, URL2) VALUES ('BOVESPA','Bovespa Index','Sao Paolo','https://www.dropbox.com/s/z0zwjppk7iivex3/bovespa','http://chartgeany.com/downloads/indexes/bovespa');";
  SQLCommand.append ('\n');
  SQLCommand += "UPDATE version SET version=9 WHERE version=8;";
  SQLCommand.append ('\n');
  SQLCommand += "COMMIT;";
  SQLCommand.append ('\n');

  // execute sql
  rc = sqlite3_exec(appsettings.db, SQLCommand.toUtf8(), NULL, NULL, NULL);
  if (rc != SQLITE_OK)
  {
    result = CG_ERR_TRANSACTION;
    setGlobalError(result, __FILE__, __LINE__);
  }

  return result;
}

// db schema version 10
static CG_ERR_RESULT
version10 (AppSettings appsettings)
{
  QString SQLCommand = "";
  CG_ERR_RESULT result = CG_ERR_OK;
  int rc;

  rc = sqlite3_exec(appsettings.db, SQLCommand.toUtf8(), NULL, NULL, NULL);
  if (rc != SQLITE_OK)
  {
    result = CG_ERR_TRANSACTION;
    setGlobalError(result, __FILE__, __LINE__);
    return result;
  }

  SQLCommand = "BEGIN;";
  SQLCommand += "ALTER TABLE symbols ADD COLUMN FORMAT CHAR DEFAULT '';";
  SQLCommand += "UPDATE SYMBOLS SET FORMAT = SOURCE WHERE ";
  SQLCommand += "SOURCE = 'YAHOO' OR SOURCE = 'GOOGLE' OR SOURCE = 'QUANDL (INDEXES)' OR SOURCE = 'XLS';";
  SQLCommand.append ('\n');
  SQLCommand += "DROP VIEW SYMBOLS_L3;";
  SQLCommand += "CREATE VIEW SYMBOLS_L3 AS ";
  SQLCommand += "SELECT DISTINCT USYMBOL, SYMBOL, DESCRIPTION, MARKET, SOURCE, ";
  SQLCommand += "TIMEFRAME, DATEFROM, DATETO, KEY, CURRENCY, ";
  SQLCommand += "TFRESOLUTION, DNLSTRING, ADJUSTED, BASE, FORMAT ";
  SQLCommand += "FROM SYMBOLS_L2 WHERE TFRESOLUTION = 1440; ";
  SQLCommand.append ('\n');
  SQLCommand += "DROP VIEW SYMBOLS_ORDERED;";
  SQLCommand += "CREATE VIEW SYMBOLS_ORDERED AS ";
  SQLCommand += "SELECT SYMBOL, DESCRIPTION, MARKET, SOURCE, TIMEFRAME, DATEFROM, ";
  SQLCommand += "DATETO, KEY, CURRENCY, TFRESOLUTION, DNLSTRING, ADJUSTED, BASE, ";
  SQLCommand += "FORMAT FROM SYMBOLS_L3 WHERE TFRESOLUTION = 1440; ";
  SQLCommand.append ('\n');
  SQLCommand += "UPDATE version SET version=10 WHERE version=9;";
  SQLCommand.append ('\n');
  SQLCommand += "COMMIT;";
  SQLCommand.append ('\n');

  // execute sql
  rc = sqlite3_exec(appsettings.db, SQLCommand.toUtf8(), NULL, NULL, NULL);
  if (rc != SQLITE_OK)
  {
    result = CG_ERR_TRANSACTION;
    setGlobalError(result, __FILE__, __LINE__);
  }

  return result;
}

// db schema version 11
static CG_ERR_RESULT
version11 (AppSettings appsettings)
{
  QString SQLCommand = "";
  CG_ERR_RESULT result = CG_ERR_OK;
  int rc;

  rc = sqlite3_exec(appsettings.db, SQLCommand.toUtf8(), NULL, NULL, NULL);
  if (rc != SQLITE_OK)
  {
    result = CG_ERR_TRANSACTION;
    setGlobalError(result, __FILE__, __LINE__);
    return result;
  }

  SQLCommand = "BEGIN;";
  SQLCommand += "UPDATE basedata SET BASE = upper (BASE);";
  SQLCommand += "UPDATE symbols SET BASE = upper (BASE);";
  SQLCommand += "UPDATE symbols SET KEY = upper (KEY);";
  SQLCommand += "UPDATE version SET version=11 WHERE version=10;";
  SQLCommand.append ('\n');
  SQLCommand += "COMMIT;";
  SQLCommand.append ('\n');

  // execute sql
  rc = sqlite3_exec(appsettings.db, SQLCommand.toUtf8(), NULL, NULL, NULL);
  if (rc != SQLITE_OK)
  {
    result = CG_ERR_TRANSACTION;
    setGlobalError(result, __FILE__, __LINE__);
  }

  return result;
}

// db schema version 12
static CG_ERR_RESULT
version12 (AppSettings appsettings)
{
  QString SQLCommand = "";
  CG_ERR_RESULT result = CG_ERR_OK;
  int rc;

  rc = sqlite3_exec(appsettings.db, SQLCommand.toUtf8(), NULL, NULL, NULL);
  if (rc != SQLITE_OK)
  {
    result = CG_ERR_TRANSACTION;
    setGlobalError(result, __FILE__, __LINE__);
    return result;
  }

  SQLCommand = "BEGIN;";
  SQLCommand += "ALTER TABLE OPTIONS ADD COLUMN AUTOUPDATE INTEGER DEFAULT 1;";
  SQLCommand += "ALTER TABLE SYMBOLS ADD COLUMN LASTUPDATE TIMESTAMP DEFAULT 0;";
  SQLCommand.append ('\n');
  SQLCommand += "CREATE TRIGGER IF NOT EXISTS ISETLASTUPDATE AFTER INSERT ON SYMBOLS ";
  SQLCommand += "BEGIN UPDATE SYMBOLS SET LASTUPDATE = strftime('%s', 'now') ";
  SQLCommand += "WHERE KEY = NEW.KEY; END; ";
  SQLCommand.append ('\n');
  SQLCommand += "DROP VIEW SYMBOLS_L3;";
  SQLCommand += "CREATE VIEW SYMBOLS_L3 AS ";
  SQLCommand += "SELECT DISTINCT USYMBOL, SYMBOL, DESCRIPTION, MARKET, SOURCE, ";
  SQLCommand += "TIMEFRAME, DATEFROM, DATETO, KEY, CURRENCY, LASTUPDATE, ";
  SQLCommand += "TFRESOLUTION, DNLSTRING, ADJUSTED, BASE, FORMAT ";
  SQLCommand += "FROM SYMBOLS_L2 WHERE TFRESOLUTION = 1440; ";
  SQLCommand.append ('\n');
  SQLCommand += "DROP VIEW SYMBOLS_ORDERED;";
  SQLCommand += "CREATE VIEW SYMBOLS_ORDERED AS ";
  SQLCommand += "SELECT SYMBOL, DESCRIPTION, MARKET, SOURCE, TIMEFRAME, DATEFROM, ";
  SQLCommand += "DATETO, KEY, CURRENCY, TFRESOLUTION, DNLSTRING, ADJUSTED, BASE, ";
  SQLCommand += "FORMAT, LASTUPDATE FROM SYMBOLS_L3 WHERE TFRESOLUTION = 1440; ";
  SQLCommand.append ('\n');
  SQLCommand += "UPDATE version SET version=12 WHERE version=11;";
  SQLCommand.append ('\n');
  SQLCommand += "COMMIT;";
  SQLCommand.append ('\n');

  // execute sql
  rc = sqlite3_exec(appsettings.db, SQLCommand.toUtf8(), NULL, NULL, NULL);
  if (rc != SQLITE_OK)
  {
    result = CG_ERR_TRANSACTION;
    setGlobalError(result, __FILE__, __LINE__);
  }

  return result;
}

// db schema version 13
static CG_ERR_RESULT
version13 (AppSettings appsettings)
{
  QString SQLCommand = "";
  CG_ERR_RESULT result = CG_ERR_OK;
  int rc;

  rc = sqlite3_exec(appsettings.db, SQLCommand.toUtf8(), NULL, NULL, NULL);
  if (rc != SQLITE_OK)
  {
    result = CG_ERR_TRANSACTION;
    setGlobalError(result, __FILE__, __LINE__);
    return result;
  }

  SQLCommand = "BEGIN;";
  SQLCommand += "UPDATE SYMBOLS SET FORMAT = 'YAHOO CSV' WHERE FORMAT = 'YAHOO';";
  SQLCommand += "UPDATE SYMBOLS SET FORMAT = 'GOOGLE CSV' WHERE FORMAT = 'GOOGLE';";
  SQLCommand += "UPDATE SYMBOLS SET DNLSTRING = ";
  SQLCommand += "(SELECT DNLSTRING FROM SYMBOLS_ORDERED WHERE ";
  SQLCommand += " SYMBOLS_ORDERED.ADJUSTED = 'NO' AND ";
  SQLCommand += " SYMBOLS_ORDERED.BASE = SYMBOLS.BASE AND ";
  SQLCommand += " SYMBOLS_ORDERED.BASE = SYMBOLS_ORDERED.KEY); ";
  SQLCommand.append ('\n');
  SQLCommand += "UPDATE version SET version=13 WHERE version=12;";
  SQLCommand.append ('\n');
  SQLCommand += "COMMIT;";
  SQLCommand.append ('\n');

  // execute sql
  rc = sqlite3_exec(appsettings.db, SQLCommand.toUtf8(), NULL, NULL, NULL);
  if (rc != SQLITE_OK)
  {
    result = CG_ERR_TRANSACTION;
    setGlobalError(result, __FILE__, __LINE__);
  }

  return result;
}


// db schema version 14
static CG_ERR_RESULT
version14 (AppSettings appsettings)
{
  QString SQLCommand = "";
  CG_ERR_RESULT result = CG_ERR_OK;
  int rc;

  rc = sqlite3_exec(appsettings.db, SQLCommand.toUtf8(), NULL, NULL, NULL);
  if (rc != SQLITE_OK)
  {
    result = CG_ERR_TRANSACTION;
    setGlobalError(result, __FILE__, __LINE__);
    return result;
  }

  SQLCommand = "BEGIN;";
  SQLCommand += "CREATE TABLE forex_forex_netfonds_day AS SELECT OPEN, HIGH, LOW, CLOSE, VOLUME, DATE, TIME FROM datamodel;";
  SQLCommand.append ('\n');
  SQLCommand += "ALTER TABLE  forex_forex_netfonds_day ADD COLUMN PAIR TEXT NOT NULL DEFAULT '';";
  SQLCommand.append ('\n');
  SQLCommand += "CREATE INDEX  'forex_forex_netfonds_day_pairidx' on forex_forex_netfonds_day (pair ASC);";
  SQLCommand.append ('\n');
  SQLCommand += "CREATE VIEW symlist_netfonds_forex AS SELECT pair AS SYMBOL, pair AS DESCRIPTION, 'FOREX' as MARKET, ";
  SQLCommand += "'http://chartgeany.com/downloads/indexes/forexdata.txt' AS URL1, ";
  SQLCommand += "('SELECT * FROM '||  pair || '_forex_netfonds_day;')  AS URL2 FROM forex_forex_netfonds_day ";
  SQLCommand += "GROUP BY PAIR;";
  SQLCommand.append ('\n');
  SQLCommand += "INSERT INTO datafeeds_raw (FEEDNAME, ACTIVE, SYMLIST, REALTIME, SYMLISTURL) VALUES ('FOREX', 0, 'symlist_netfonds_forex', 0, '');";
  SQLCommand += "INSERT INTO FORMATS_RAW (FORMAT) VALUES ('NETFONDS');";
  SQLCommand.append ('\n');
  SQLCommand += "UPDATE version SET version=14 WHERE version=13;";
  SQLCommand.append ('\n');
  SQLCommand += "COMMIT;";
  SQLCommand.append ('\n');

  // execute sql
  rc = sqlite3_exec(appsettings.db, SQLCommand.toUtf8(), NULL, NULL, NULL);
  if (rc != SQLITE_OK)
  {
    result = CG_ERR_TRANSACTION;
    setGlobalError(result, __FILE__, __LINE__);
  }

  return result;
}

// db schema version 15
static CG_ERR_RESULT
version15 (AppSettings appsettings)
{
  QString SQLCommand = "";
  CG_ERR_RESULT result = CG_ERR_OK;
  int rc;

  rc = sqlite3_exec(appsettings.db, SQLCommand.toUtf8(), NULL, NULL, NULL);
  if (rc != SQLITE_OK)
  {
    result = CG_ERR_TRANSACTION;
    setGlobalError(result, __FILE__, __LINE__);
    return result;
  }

  SQLCommand = "BEGIN;";
  SQLCommand += "DROP VIEW symlist_netfonds_forex;";
  SQLCommand += "UPDATE version SET version=15 WHERE version=14;";
  SQLCommand.append ('\n');
  SQLCommand += "DROP TABLE forex_forex_netfonds_day;";
  SQLCommand.append ('\n');
  SQLCommand += "CREATE TABLE forex_forex_netfonds_day AS SELECT * FROM datamodel;";
  SQLCommand.append ('\n');
  SQLCommand += "ALTER TABLE  forex_forex_netfonds_day ADD COLUMN PAIR TEXT NOT NULL DEFAULT '';";
  SQLCommand.append ('\n');
  SQLCommand += "CREATE INDEX  'forex_forex_netfonds_day_pairidx' on forex_forex_netfonds_day (pair ASC);";
  SQLCommand.append ('\n');
  SQLCommand += "UPDATE formats_raw SET format = 'NETFONDS FOREX CSV' WHERE format = 'NETFONDS';";
  SQLCommand.append ('\n');
  SQLCommand += "UPDATE datafeeds_raw SET ACTIVE = 1 WHERE FEEDNAME = 'FOREX';";
  SQLCommand.append ('\n');
  SQLCommand += "ALTER TABLE datamodel ADD COLUMN SYMBOL TEXT NOT NULL DEFAULT '';";
  SQLCommand.append ('\n');
  SQLCommand += "CREATE VIEW symlist_netfonds_forex AS ";
  SQLCommand += "SELECT DISTINCT pair AS SYMBOL , ";
  SQLCommand += "pair AS DESCRIPTION, 'FOREX' AS MARKET, '' AS URL1, '' AS URL2 ";
  SQLCommand += "FROM forex_forex_netfonds_day ORDER BY pair;";
  SQLCommand.append ('\n');
  SQLCommand += "INSERT INTO CURRENCIES (SYMBOL) VALUES ('GBp');";
  SQLCommand += "CREATE UNIQUE INDEX currencies_symbolidx ON CURRENCIES (SYMBOL);";
  SQLCommand.append ('\n');
  SQLCommand += "ALTER TABLE VERSION ADD COLUMN NETFONDSFOREXUPDATE TIMESTAMP DEFAULT 0;";
  SQLCommand += "COMMIT;";
  SQLCommand.append ('\n');

  // execute sql
  rc = sqlite3_exec(appsettings.db, SQLCommand.toUtf8(), NULL, NULL, NULL);
  if (rc != SQLITE_OK)
  {
    result = CG_ERR_TRANSACTION;
    setGlobalError(result, __FILE__, __LINE__);
  }

  return result;
}

// db schema version 16
static CG_ERR_RESULT
version16 (AppSettings appsettings)
{
  QString SQLCommand = "";
  CG_ERR_RESULT result = CG_ERR_OK;
  int rc;

  rc = sqlite3_exec(appsettings.db, SQLCommand.toUtf8(), NULL, NULL, NULL);
  if (rc != SQLITE_OK)
  {
    result = CG_ERR_TRANSACTION;
    setGlobalError(result, __FILE__, __LINE__);
    return result;
  }

  SQLCommand  = "BEGIN;";
  SQLCommand += "UPDATE version SET version=16 WHERE version=15;";
  SQLCommand.append ('\n');
  SQLCommand += "UPDATE datafeeds_raw SET feedname='QUANDL (INDICES)' WHERE feedname='QUANDL (INDEXES)';";
  SQLCommand += "COMMIT;";
  SQLCommand.append ('\n');

  // execute sql
  rc = sqlite3_exec(appsettings.db, SQLCommand.toUtf8(), NULL, NULL, NULL);
  if (rc != SQLITE_OK)
  {
    result = CG_ERR_TRANSACTION;
    setGlobalError(result, __FILE__, __LINE__);
  }

  return result;
}

// db schema version 17
static CG_ERR_RESULT
version17 (AppSettings appsettings)
{
  QString SQLCommand = "";
  CG_ERR_RESULT result = CG_ERR_OK;
  int rc;

  rc = sqlite3_exec(appsettings.db, SQLCommand.toUtf8(), NULL, NULL, NULL);
  if (rc != SQLITE_OK)
  {
    result = CG_ERR_TRANSACTION;
    setGlobalError(result, __FILE__, __LINE__);
    return result;
  }

  SQLCommand  = "BEGIN;";

  SQLCommand += "UPDATE version SET version=17 WHERE version=16;";
  SQLCommand.append ('\n');
  SQLCommand += "CREATE TABLE prices ";
  SQLCommand += "(SYMBOL    TEXT NOT NULL,";
  SQLCommand += " PRICE     REAL NOT NULL DEFAULT 0,";
  SQLCommand += " VOLUME    TEXT NOT NULL DEFAULT '',";
  SQLCommand += " DATE      TEXT NOT NULL DEFAULT '',";
  SQLCommand += " TIME      TEXT NOT NULL DEFAULT '',";
  SQLCommand += " CHANGE    TEXT NOT NULL DEFAULT '',";
  SQLCommand += " PRCCHANGE TEXT NOT NULL DEFAULT '',";
  SQLCommand += " FEED      TEXT NOT NULL DEFAULT 'NONE',";
  SQLCommand += " TIMESTAMP DATE DEFAULT (datetime('now','localtime')));";
  SQLCommand += "CREATE INDEX prices_symbol_idx ON prices (SYMBOL);";
  SQLCommand.append ('\n');
  SQLCommand += "CREATE TABLE transactions ";
  SQLCommand += "(TR_ID       INTEGER PRIMARY KEY AUTOINCREMENT,";
  SQLCommand += " PF_ID       INTEGER NOT NULL,";
  SQLCommand += " TRTYPE      TEXT NOT NULL,";
  SQLCommand += " SYMBOL      TEXT NOT NULL DEFAULT '', TR_DATE     TEXT NOT NULL,";
  SQLCommand += " QUANTITY    REAL NOT NULL, PRICE      REAL NOT NULL DEFAULT 0,";
  SQLCommand += " COMMISSION  REAL NOT NULL DEFAULT 0, NOTES TEXT DEFAULT '',";
  SQLCommand += " COMMTYPE    TEXT NOT NULL DEFAULT 'FIXED');";
  SQLCommand += "CREATE INDEX transactions_pf_id_idx ON transactions (PF_ID);";
  SQLCommand.append ('\n');

  SQLCommand += "CREATE TABLE portfolios ";
  SQLCommand += "(PF_ID     INTEGER PRIMARY KEY AUTOINCREMENT,";
  SQLCommand += " TITLE     TEXT NOT NULL, DESCRIPTION  TEXT NOT NULL,";
  SQLCommand += " CURRENCY  TEXT NOT NULL, DATAVIEW     TEXT DEFAULT '',";
  SQLCommand += " DATAFEED  TEXT NOT NULL, CDATE        DATETIME DEFAULT CURRENT_DATE);";
  SQLCommand += "CREATE UNIQUE INDEX portfolios_title_idx ON portfolios (TITLE);";
  SQLCommand.append ('\n');

  SQLCommand += "CREATE TABLE transactiontypes ";
  SQLCommand += "(TR_CODE     INTEGER PRIMARY KEY AUTOINCREMENT,";
  SQLCommand += " DESCRIPTION TEXT NOT NULL);";
  SQLCommand.append ('\n');

  SQLCommand += "INSERT INTO transactiontypes (DESCRIPTION) VALUES ('BUY');";
  SQLCommand += "INSERT INTO transactiontypes (DESCRIPTION) VALUES ('SELL');";
  SQLCommand += "INSERT INTO transactiontypes (DESCRIPTION) VALUES ('CASH IN');";
  SQLCommand += "INSERT INTO transactiontypes (DESCRIPTION) VALUES ('CASH OUT');";
  SQLCommand += "INSERT INTO transactiontypes (DESCRIPTION) VALUES ('DIVIDEND');";
  // SQLCommand += "INSERT INTO transactiontypes (DESCRIPTION) VALUES ('DIVIDEND PER SHARE');";
  SQLCommand.append ('\n');

  SQLCommand += "CREATE TABLE commissiontypes ";
  SQLCommand += "(COMM_CODE   INTEGER PRIMARY KEY AUTOINCREMENT,";
  SQLCommand += " DESCRIPTION TEXT NOT NULL);";
  SQLCommand.append ('\n');

  SQLCommand += "INSERT INTO commissiontypes (DESCRIPTION) VALUES ('FIXED');";
  SQLCommand += "INSERT INTO commissiontypes (DESCRIPTION) VALUES ('PER SHARE');";
  SQLCommand += "INSERT INTO commissiontypes (DESCRIPTION) VALUES ('PERCENT');";
  SQLCommand.append ('\n');

  SQLCommand += "CREATE VIEW commissionspaid AS \
                   SELECT \
                     TR_ID, \
                     (CASE \
                        WHEN commtype = 'FIXED' \
                          THEN commission \
                        WHEN commtype = 'PER SHARE' \
                          THEN (quantity * commission) \
                        WHEN commtype = 'PERCENT' \
                          THEN ((quantity * price * commission) / 100)  \
                        ELSE 0 \
                      END) AS COMMPAID FROM transactions;";
  SQLCommand.append ('\n');
  SQLCommand += "INSERT INTO portfolios (TITLE, DESCRIPTION, DATAFEED, CURRENCY)\
                 VALUES ('Portfolio Example', 'Chart Geany Portfolio Example',\
                 'YAHOO', 'USD');";
  int pf_id = 1;
  SQLCommand += "CREATE VIEW pftrans_" % QString::number(pf_id) % " AS " %
                "SELECT transactions.*, \
              (CASE \
                WHEN transactions.trtype = 'CASH IN' \
                  THEN transactions.quantity - commissionspaid.commpaid \
                WHEN transactions.trtype = 'CASH OUT' \
                  THEN (transactions.quantity + commissionspaid.commpaid) * -1 \
                WHEN transactions.trtype = 'BUY' \
                  THEN ((transactions.quantity * transactions.price) + commissionspaid.commpaid) * -1 \
                WHEN transactions.trtype = 'SELL' \
                  THEN (transactions.quantity * transactions.price) - commissionspaid.commpaid \
                WHEN transactions.trtype = 'DIVIDEND' \
                  THEN (transactions.quantity - commissionspaid.commpaid) \
                ELSE 0 \
              END) AS AMOUNT, \
              portfolios.datafeed AS DATAFEED \
              FROM transactions, commissionspaid, portfolios \
              WHERE transactions.pf_id = " % QString::number(pf_id) %
                " AND transactions.tr_id = commissionspaid.tr_id \
                AND portfolios.pf_id = transactions.pf_id; " %
                "UPDATE portfolios SET dataview = 'pftrans_" % QString::number(pf_id) %
                "full' WHERE pf_id = " % QString::number(pf_id) % ";";
  SQLCommand += createportfolioviews ("pftrans_1");
  SQLCommand +=
    "INSERT INTO transactions (PF_ID, TRTYPE, SYMBOL, TR_DATE, QUANTITY, NOTES, PRICE, COMMISSION,  COMMTYPE)\
                          VALUES (1, 'CASH IN', '', '2015-09-01', 30000, '', 0, 0, 'FIXED');\
     INSERT INTO transactions (PF_ID, TRTYPE, SYMBOL, TR_DATE, QUANTITY, NOTES, PRICE, COMMISSION,  COMMTYPE)\
                          VALUES (1, 'BUY', 'NOK', '2015-09-02', 1000, '', 6.19, 0.07, 'PER SHARE');\
     INSERT INTO transactions (PF_ID, TRTYPE, SYMBOL, TR_DATE, QUANTITY, NOTES, PRICE, COMMISSION,  COMMTYPE)\
                          VALUES (1, 'BUY', 'GE', '2015-09-15', 200, '', 25.10, 0.07, 'PER SHARE');\
     INSERT INTO transactions (PF_ID, TRTYPE, SYMBOL, TR_DATE, QUANTITY, NOTES, PRICE, COMMISSION,  COMMTYPE)\
                          VALUES (1, 'BUY', 'BAC', '2015-09-30', 200, '', 15.53, 0.07, 'PER SHARE');\
     INSERT INTO transactions (PF_ID, TRTYPE, SYMBOL, TR_DATE, QUANTITY, NOTES, PRICE, COMMISSION,  COMMTYPE)\
                          VALUES (1, 'BUY', 'SLV', '2015-10-07', 300, '', 15.25, 0.03, 'PERCENT');\
     INSERT INTO transactions (PF_ID, TRTYPE, SYMBOL, TR_DATE, QUANTITY, NOTES, PRICE, COMMISSION,  COMMTYPE)\
                          VALUES (1, 'SELL', 'GE', '2015-10-27', 100, '', 29.40, 0.07, 'PER SHARE');\
     INSERT INTO transactions (PF_ID, TRTYPE, SYMBOL, TR_DATE, QUANTITY, NOTES, PRICE, COMMISSION,  COMMTYPE)\
                          VALUES (1, 'CASH OUT', '', '2015-11-01', 1710.19, '', 0, 0, 'FIXED');";
  SQLCommand += "COMMIT;";
  SQLCommand.append ('\n');

  // execute sql
  rc = sqlite3_exec(appsettings.db, SQLCommand.toUtf8(), NULL, NULL, NULL);
  if (rc != SQLITE_OK)
  {
    result = CG_ERR_TRANSACTION;
    setGlobalError(result, __FILE__, __LINE__);
  }

  return result;
}

// db schema version 18
static CG_ERR_RESULT
version18 (AppSettings appsettings)
{
  QString SQLCommand = "";
  CG_ERR_RESULT result = CG_ERR_OK;
  int rc;

  rc = sqlite3_exec(appsettings.db, SQLCommand.toUtf8(), NULL, NULL, NULL);
  if (rc != SQLITE_OK)
  {
    result = CG_ERR_TRANSACTION;
    setGlobalError(result, __FILE__, __LINE__);
    return result;
  }

  SQLCommand  = "BEGIN;";
  SQLCommand += "UPDATE version SET version=18 WHERE version=17;";
  SQLCommand.append ('\n');

  SQLCommand += "CREATE TABLE modules ";
  SQLCommand += "(ID    TEXT NOT NULL PRIMARY KEY,";
  SQLCommand += " NAME TEXT NOT NULL,";
  SQLCommand += " SOURCE TEXT NOT NULL, ";
  SQLCommand += " PLATFORM TEXT NOT NULL, ";
  SQLCommand += " BINARY TEXT NOT NULL, ";
  SQLCommand += " AUTHOR TEXT NOT NULL DEFAULT '', ";
  SQLCommand += " PAK TEXT NOT NULL DEFAULT '', ";
  SQLCommand += " TYPE TEXT NOT NULL, ";
  SQLCommand += " VERSION TEXT NOT NULL DEFAULT '');";
  SQLCommand.append ('\n');

  SQLCommand += "COMMIT;";
  SQLCommand.append ('\n');

  // execute sql
  rc = sqlite3_exec(appsettings.db, SQLCommand.toUtf8(), NULL, NULL, NULL);
  if (rc != SQLITE_OK)
  {
    result = CG_ERR_TRANSACTION;
    setGlobalError(result, __FILE__, __LINE__);
  }

  return result;
}

// db schema version 19
static CG_ERR_RESULT
version19 (AppSettings appsettings)
{
  QString SQLCommand = "";
  CG_ERR_RESULT result = CG_ERR_OK;
  int rc;

  rc = sqlite3_exec(appsettings.db, SQLCommand.toUtf8(), NULL, NULL, NULL);
  if (rc != SQLITE_OK)
  {
    result = CG_ERR_TRANSACTION;
    setGlobalError(result, __FILE__, __LINE__);
    return result;
  }

  SQLCommand  = "BEGIN;";
  SQLCommand += "UPDATE version SET version=19 WHERE version=18;";
  SQLCommand.append ('\n');
  SQLCommand += "ALTER TABLE options ADD COLUMN DEVMODE INTEGER NOT NULL DEFAULT 0;";
  SQLCommand += "ALTER TABLE modules ADD COLUMN STATUS TEXT NOT NULL DEFAULT 'ENABLED';";
  SQLCommand.append ('\n');
  SQLCommand += "CREATE TABLE toolchains ";
  SQLCommand += "(PLATFORM TEXT NOT NULL DEFAULT '' UNIQUE,";
  SQLCommand += " COMPILER TEXT NOT NULL DEFAULT '',";
  SQLCommand += " COMPILERDBG TEXT NOT NULL DEFAULT '',";
  SQLCommand += " COMPILERREL TEXT NOT NULL DEFAULT '',";
  SQLCommand += " LINKER TEXT NOT NULL DEFAULT '',";
  SQLCommand += " LINKERDBG TEXT NOT NULL DEFAULT '',";
  SQLCommand += " LINKERREL TEXT NOT NULL DEFAULT '');";
  SQLCommand.append ('\n');

// linux-gcc
  SQLCommand += "INSERT INTO toolchains (PLATFORM,\
                                         COMPILER,\
                                         COMPILERDBG,\
                                         COMPILERREL,\
                                         LINKER,\
                                         LINKERDBG,\
                                         LINKERREL) VALUES \
('linux32-gcc', '/usr/bin/gcc', \
'-pedantic-errors -fno-asm -fno-inline -fvisibility=hidden \
 -fno-builtin-malloc -fno-stack-protector \
 -std=c99 -nostdinc -ffreestanding -Wall -Wextra -fPIC -Werror -pedantic \
 -fno-diagnostics-show-option  \
 -D_CGSCRIPT_MODULE -m32 -g0 -fno-omit-frame-pointer -DDEBUG_BUILD ',\
'-pedantic-errors -fno-asm -fno-inline -fvisibility=hidden \
 -fno-builtin-malloc -fno-stack-protector \
 -std=c99 -nostdinc -ffreestanding -Wall -Wextra -fPIC -Werror -pedantic \
 -fno-diagnostics-show-option  \
 -D_CGSCRIPT_MODULE -m32 -O -fomit-frame-pointer -s ', \
'/usr/bin/gcc','-m32 -nostdlib -nodefaultlibs -shared ',\
'-m32 -nostdlib -nodefaultlibs -shared ');";
  SQLCommand.append ('\n');
  SQLCommand += "INSERT INTO toolchains (PLATFORM,\
                                         COMPILER,\
                                         COMPILERDBG,\
                                         COMPILERREL,\
                                         LINKER,\
                                         LINKERDBG,\
                                         LINKERREL) VALUES \
('linux64-gcc', '/usr/bin/gcc', \
'-pedantic-errors -fno-asm -fno-inline -fvisibility=hidden \
 -fno-builtin-malloc -fno-stack-protector \
 -std=c99 -nostdinc -ffreestanding -Wall -Wextra -fPIC -Werror -pedantic \
 -fno-diagnostics-show-option   \
 -D_CGSCRIPT_MODULE -m64 -g0 -fno-omit-frame-pointer -DDEBUG_BUILD ',\
'-pedantic-errors -fno-asm -fno-inline -fvisibility=hidden \
 -fno-builtin-malloc -fno-stack-protector \
 -std=c99 -nostdinc -ffreestanding -Wall -Wextra -fPIC -Werror -pedantic \
 -fno-diagnostics-show-option   \
 -D_CGSCRIPT_MODULE -m64 -O -fomit-frame-pointer -s ', \
'/usr/bin/gcc','-m64 -nostdlib -nodefaultlibs -shared ',\
'-m64 -nostdlib -nodefaultlibs -shared ');";

// linux-cc
  SQLCommand += "INSERT INTO toolchains (PLATFORM,\
                                         COMPILER,\
                                         COMPILERDBG,\
                                         COMPILERREL,\
                                         LINKER,\
                                         LINKERDBG,\
                                         LINKERREL) VALUES \
('linux32-cc', '/usr/bin/cc', \
'-pedantic-errors -fno-asm -fno-inline -fvisibility=hidden \
 -fno-builtin-malloc -fno-stack-protector \
 -std=c99 -nostdinc -ffreestanding -Wall -Wextra -fPIC -Werror -pedantic \
 -fno-diagnostics-show-option  \
 -D_CGSCRIPT_MODULE -m32 -g0 -fno-omit-frame-pointer -DDEBUG_BUILD ',\
'-pedantic-errors -fno-asm -fno-inline -fvisibility=hidden \
 -fno-builtin-malloc -fno-stack-protector \
 -std=c99 -nostdinc -ffreestanding -Wall -Wextra -fPIC -Werror -pedantic \
 -fno-diagnostics-show-option  \
 -D_CGSCRIPT_MODULE -m32 -O -fomit-frame-pointer -s ', \
'/usr/bin/cc','-m32 -nostdlib -nodefaultlibs -shared ',\
'-m32 -nostdlib -nodefaultlibs -shared ');";
  SQLCommand.append ('\n');
  SQLCommand += "INSERT INTO toolchains (PLATFORM,\
                                         COMPILER,\
                                         COMPILERDBG,\
                                         COMPILERREL,\
                                         LINKER,\
                                         LINKERDBG,\
                                         LINKERREL) VALUES \
('linux64-cc', '/usr/bin/cc', \
'-pedantic-errors -fno-asm -fno-inline -fvisibility=hidden \
 -fno-builtin-malloc -fno-stack-protector \
 -std=c99 -nostdinc -ffreestanding -Wall -Wextra -fPIC -Werror -pedantic \
 -fno-diagnostics-show-option   \
 -D_CGSCRIPT_MODULE -m64 -g0 -fno-omit-frame-pointer -DDEBUG_BUILD ',\
'-pedantic-errors -fno-asm -fno-inline -fvisibility=hidden \
 -fno-builtin-malloc -fno-stack-protector \
 -std=c99 -nostdinc -ffreestanding -Wall -Wextra -fPIC -Werror -pedantic \
 -fno-diagnostics-show-option   \
 -D_CGSCRIPT_MODULE -m64 -O -fomit-frame-pointer -s ', \
'/usr/bin/cc','-m64 -nostdlib -nodefaultlibs -shared ',\
'-m64 -nostdlib -nodefaultlibs -shared ');";

// linux-pcc
  SQLCommand.append ('\n');
  SQLCommand += "INSERT INTO toolchains (PLATFORM,\
                                         COMPILER,\
                                         COMPILERDBG,\
                                         COMPILERREL,\
                                         LINKER,\
                                         LINKERDBG,\
                                         LINKERREL) VALUES \
('linux32-pcc', \
 '/usr/bin/pcc ', \
 '-fPIC -nostdinc -g', \
 '-fPIC -nostdinc -O', \
 '/usr/bin/pcc ', \
 '-nostdlib -shared ', \
 '-nostdlib -shared ');";
  SQLCommand.append ('\n');
  SQLCommand += "INSERT INTO toolchains (PLATFORM,\
                                         COMPILER,\
                                         COMPILERDBG,\
                                         COMPILERREL,\
                                         LINKER,\
                                         LINKERDBG,\
                                         LINKERREL) VALUES \
 ('linux64-pcc', \
  '/usr/bin/pcc ', \
  '-fPIC -nostdinc -g', \
  '-fPIC -nostdinc -O', \
  '/usr/bin/pcc ', \
  '-nostdlib -shared ', \
  '-nostdlib -shared ');";

// linux-clang
  SQLCommand += "INSERT INTO toolchains (PLATFORM,\
                                         COMPILER,\
                                         COMPILERDBG,\
                                         COMPILERREL,\
                                         LINKER,\
                                         LINKERDBG,\
                                         LINKERREL) VALUES \
('linux32-clang', '/usr/bin/clang ', \
'-pedantic-errors -fno-asm -fno-inline -fvisibility=hidden \
 -fno-builtin-malloc -fno-stack-protector \
 -std=c99 -nostdinc -ffreestanding -Wall -Wextra -fPIC -Werror -pedantic \
 -fno-diagnostics-show-option  \
 -D_CGSCRIPT_MODULE -m32 -g0 -fno-omit-frame-pointer -DDEBUG_BUILD ',\
'-pedantic-errors -fno-asm -fno-inline -fvisibility=hidden \
 -fno-builtin-malloc -fno-stack-protector \
 -std=c99 -nostdinc -ffreestanding -Wall -Wextra -fPIC -Werror -pedantic \
 -fno-diagnostics-show-option  \
 -D_CGSCRIPT_MODULE -m32 -O -fomit-frame-pointer -s ', \
'/usr/bin/clang ','-m32 -Wl,-nostdlib,-z,nodefaultlib -shared ',\
'-m32 -Wl,-nostdlib,-z,nodefaultlib -shared ');";
  SQLCommand.append ('\n');
  SQLCommand += "INSERT INTO toolchains (PLATFORM,\
                                         COMPILER,\
                                         COMPILERDBG,\
                                         COMPILERREL,\
                                         LINKER,\
                                         LINKERDBG,\
                                         LINKERREL) VALUES \
('linux64-clang', '/usr/bin/clang ', \
'-pedantic-errors -fno-asm -fno-inline -fvisibility=hidden \
 -fno-builtin-malloc -fno-stack-protector \
 -std=c99 -nostdinc -ffreestanding -Wall -Wextra -fPIC -Werror -pedantic \
 -fno-diagnostics-show-option  \
 -D_CGSCRIPT_MODULE -m64 -g0 -fno-omit-frame-pointer -DDEBUG_BUILD ',\
'-pedantic-errors -fno-asm -fno-inline -fvisibility=hidden \
 -fno-builtin-malloc -fno-stack-protector \
 -std=c99 -nostdinc -ffreestanding -Wall -Wextra -fPIC -Werror -pedantic \
 -fno-diagnostics-show-option  \
 -D_CGSCRIPT_MODULE -m64 -O -fomit-frame-pointer -s ', \
'/usr/bin/clang ','-m64 -Wl,-nostdlib,-z,nodefaultlib -shared ',\
'-m64 -Wl,-nostdlib,-z,nodefaultlib -shared ');";

// win-clang
  SQLCommand += "INSERT INTO toolchains (PLATFORM,\
                                         COMPILER,\
                                         COMPILERDBG,\
                                         COMPILERREL,\
                                         LINKER,\
                                         LINKERDBG,\
                                         LINKERREL) VALUES \
('win32-clang', '/clang/bin/clang.exe ', \
'-pedantic-errors -fno-asm -fno-inline -fvisibility=hidden \
 -fno-builtin-malloc -fno-stack-protector \
 -std=c99 -nostdinc -ffreestanding -Wall -Wextra -Werror -pedantic \
 -fno-diagnostics-show-option  \
 -D_CGSCRIPT_MODULE -m32 -g0 -fno-omit-frame-pointer -DDEBUG_BUILD ',\
'-pedantic-errors -fno-asm -fno-inline -fvisibility=hidden \
 -fno-builtin-malloc -fno-stack-protector \
 -std=c99 -nostdinc -ffreestanding -Wall -Wextra -Werror -pedantic \
 -fno-diagnostics-show-option  \
 -D_CGSCRIPT_MODULE -m32 -O -fomit-frame-pointer ', \
'clang ','-shared ',\
'-shared ');";
  SQLCommand.append ('\n');
  SQLCommand += "INSERT INTO toolchains (PLATFORM,\
                                         COMPILER,\
                                         COMPILERDBG,\
                                         COMPILERREL,\
                                         LINKER,\
                                         LINKERDBG,\
                                         LINKERREL) VALUES \
('win64-clang', '/clang/bin/clang.exe ', \
'-pedantic-errors -fno-asm -fno-inline -fvisibility=hidden \
 -fno-builtin-malloc -fno-stack-protector \
 -std=c99 -nostdinc -ffreestanding -Wall -Wextra -Werror -pedantic \
 -fno-diagnostics-show-option  \
 -D_CGSCRIPT_MODULE -m64 -g0 -fno-omit-frame-pointer -DDEBUG_BUILD ',\
'-pedantic-errors -fno-asm -fno-inline -fvisibility=hidden \
 -fno-builtin-malloc -fno-stack-protector \
 -std=c99 -nostdinc -ffreestanding -Wall -Wextra -Werror -pedantic \
 -fno-diagnostics-show-option  \
 -D_CGSCRIPT_MODULE -m64 -O -fomit-frame-pointer ', \
'clang ','-shared ',\
'-shared ');";

// win-gcc
  SQLCommand += "INSERT INTO toolchains (PLATFORM,\
                                           COMPILER,\
                                           COMPILERDBG,\
                                           COMPILERREL,\
                                           LINKER,\
                                           LINKERDBG,\
                                           LINKERREL) VALUES \
  ('win32-gcc', '/gcc/bin/gcc.exe ', \
  '-pedantic-errors -fno-asm -fno-inline -fvisibility=hidden \
   -fno-builtin-malloc -fno-stack-protector \
   -std=c99 -nostdinc -ffreestanding -Wall -Wextra -Werror -pedantic \
   -fno-diagnostics-show-option  \
   -D_CGSCRIPT_MODULE -m32 -g0 -fno-omit-frame-pointer -DDEBUG_BUILD ',\
  '-pedantic-errors -fno-asm -fno-inline -fvisibility=hidden \
   -fno-builtin-malloc -fno-stack-protector \
   -std=c99 -nostdinc -ffreestanding -Wall -Wextra -Werror -pedantic \
   -fno-diagnostics-show-option  \
   -D_CGSCRIPT_MODULE -m32 -O -fomit-frame-pointer ', \
  '/gcc/bin/gcc.exe ','-fno-use-linker-plugin -fno-lto -shared ',\
  '-fno-use-linker-plugin -fno-lto -shared ');";
  SQLCommand.append ('\n');

// win-pcc
  SQLCommand += "INSERT INTO toolchains (PLATFORM,\
                                           COMPILER,\
                                           COMPILERDBG,\
                                           COMPILERREL,\
                                           LINKER,\
                                           LINKERDBG,\
                                           LINKERREL) VALUES \
  ('win32-pcc', '/pcc/bin/pcc.exe ', \
  '-fno-asm -fno-inline -fvisibility=hidden \
   -fno-builtin-malloc -fno-stack-protector \
   -std=c99 -nostdinc -ffreestanding -Wall -Wextra -Werror -pedantic \
   -Wa,-f,win32 -x c -nodefaultlibs -nostartfiles -nostdlib \
   -fno-diagnostics-show-option  \
   -D_CGSCRIPT_MODULE -m32 -g0 -fno-omit-frame-pointer -DDEBUG_BUILD -c ',\
  '-fno-asm -fno-inline -fvisibility=hidden \
   -fno-builtin-malloc -fno-stack-protector \
   -std=c99 -nostdinc -ffreestanding -Wall -Wextra -Werror -pedantic \
   -Wa,-f,win32 -x c -nodefaultlibs -nostartfiles -nostdlib \
   -fno-diagnostics-show-option  \
   -D_CGSCRIPT_MODULE -m32 -O -fomit-frame-pointer -c ', \
  '/pcc/bin/pcc.exe ','-Bwin32 -shared ',\
  '-Bwin32 -shared ');";
  SQLCommand.append ('\n');

  SQLCommand += "INSERT INTO toolchains (PLATFORM,\
                                           COMPILER,\
                                           COMPILERDBG,\
                                           COMPILERREL,\
                                           LINKER,\
                                           LINKERDBG,\
                                           LINKERREL) VALUES \
  ('win64-gcc', '/gcc/bin/gcc.exe', \
  '-pedantic-errors -fno-asm -fno-inline -fvisibility=hidden \
   -fno-builtin-malloc -fno-stack-protector \
   -std=c99 -nostdinc -ffreestanding -Wall -Wextra -Werror -pedantic \
   -fno-diagnostics-show-option  \
   -D_CGSCRIPT_MODULE -m64 -g0 -fno-omit-frame-pointer -DDEBUG_BUILD ',\
  '-pedantic-errors -fno-asm -fno-inline -fvisibility=hidden \
   -fno-builtin-malloc -fno-stack-protector \
   -std=c99 -nostdinc -ffreestanding -Wall -Wextra -Werror -pedantic \
   -fno-diagnostics-show-option  \
   -D_CGSCRIPT_MODULE -m64 -O -fomit-frame-pointer ', \
  '/gcc/bin/gcc.exe ','-fno-use-linker-plugin -fno-lto -shared ',\
  '-fno-use-linker-plugin -fno-lto -shared ');";

// darwin-gcc
  SQLCommand += "INSERT INTO toolchains (PLATFORM,\
                                         COMPILER,\
                                         COMPILERDBG,\
                                         COMPILERREL,\
                                         LINKER,\
                                         LINKERDBG,\
                                         LINKERREL) VALUES \
('darwin32-gcc', '/usr/local/bin/gcc-4.8', \
'-fno-asm -fno-inline -fvisibility=hidden \
 -fno-builtin-malloc  \
 -std=c99 -nostdinc -ffreestanding -Wall -Wextra -fPIC -Werror -pedantic \
 -fno-diagnostics-show-option   \
 -D_CGSCRIPT_MODULE -m32 -g0 -fno-omit-frame-pointer -DDEBUG_BUILD ',\
'-fno-asm -fno-inline -fvisibility=hidden \
 -fno-builtin-malloc  \
 -std=c99 -nostdinc -ffreestanding -Wall -Wextra -fPIC -Werror -pedantic \
 -fno-diagnostics-show-option   \
 -D_CGSCRIPT_MODULE -m32 -O -fomit-frame-pointer -s ', \
'/usr/bin/gcc','-m32 -nostdlib -nodefaultlibs -dynamiclib -undefined suppress -flat_namespace ',\
'-m32 -nostdlib -nodefaultlibs -dynamiclib -undefined suppress -flat_namespace ');";
  SQLCommand.append ('\n');
  SQLCommand += "INSERT INTO toolchains (PLATFORM,\
                                         COMPILER,\
                                         COMPILERDBG,\
                                         COMPILERREL,\
                                         LINKER,\
                                         LINKERDBG,\
                                         LINKERREL) VALUES \
('darwin64-gcc', '/usr/local/bin/gcc-4.8', \
'-fno-asm -fno-inline -fvisibility=hidden \
 -fno-builtin-malloc  \
 -std=c99 -nostdinc -ffreestanding -Wall -Wextra -fPIC -Werror -pedantic \
 -fno-diagnostics-show-option   \
 -D_CGSCRIPT_MODULE -m64 -g0 -fno-omit-frame-pointer -DDEBUG_BUILD ',\
'-fno-asm -fno-inline -fvisibility=hidden \
 -fno-builtin-malloc  \
 -std=c99 -nostdinc -ffreestanding -Wall -Wextra -fPIC -Werror -pedantic \
 -fno-diagnostics-show-option   \
 -D_CGSCRIPT_MODULE -m64 -O -fomit-frame-pointer -s ', \
'/usr/bin/gcc','-m64 -nostdlib -nodefaultlibs -dynamiclib -undefined suppress -flat_namespace ',\
'-m64 -nostdlib -nodefaultlibs -dynamiclib -undefined suppress -flat_namespace ');";

// darwin-clang
  SQLCommand += "INSERT INTO toolchains (PLATFORM,\
                                         COMPILER,\
                                         COMPILERDBG,\
                                         COMPILERREL,\
                                         LINKER,\
                                         LINKERDBG,\
                                         LINKERREL) VALUES \
('darwin32-clang', '/usr/bin/clang ', \
'-fno-asm -fno-inline -fvisibility=hidden \
 -fno-builtin  \
 -std=c99 -nostdinc -ffreestanding -Wall -Wextra -fPIC -Werror -pedantic \
 -fno-diagnostics-show-option  \
 -D_CGSCRIPT_MODULE -arch x86 -g0 -fno-omit-frame-pointer -DDEBUG_BUILD ',\
'-fno-asm -fno-inline -fvisibility=hidden \
 -fno-builtin  \
 -std=c99 -nostdinc -ffreestanding -Wall -Wextra -fPIC -Werror -pedantic \
 -fno-diagnostics-show-option  \
 -D_CGSCRIPT_MODULE -arch x86 -O -fomit-frame-pointer  ', \
'/usr/bin/clang ','-arch x86 -nostdlib -dynamiclib -undefined suppress -flat_namespace ',\
'-arch x86 -nostdlib -dynamiclib -undefined suppress -flat_namespace ');";
  SQLCommand.append ('\n');
  SQLCommand += "INSERT INTO toolchains (PLATFORM,\
                                         COMPILER,\
                                         COMPILERDBG,\
                                         COMPILERREL,\
                                         LINKER,\
                                         LINKERDBG,\
                                         LINKERREL) VALUES \
('darwin64-clang', '/usr/bin/clang ', \
'-fno-asm -fno-inline -fvisibility=hidden \
 -fno-builtin  \
 -std=c99 -nostdinc -ffreestanding -Wall -Wextra -fPIC -Werror -pedantic \
 -fno-diagnostics-show-option  \
 -D_CGSCRIPT_MODULE -arch x86_64 -g0 -fno-omit-frame-pointer -DDEBUG_BUILD ',\
'-fno-asm -fno-inline -fvisibility=hidden \
 -fno-builtin  \
 -std=c99 -nostdinc -ffreestanding -Wall -Wextra -fPIC -Werror -pedantic \
 -fno-diagnostics-show-option   \
 -D_CGSCRIPT_MODULE -arch x86_64 -O -fomit-frame-pointer  ', \
'/usr/bin/clang ','-arch x86_64 -nostdlib -dynamiclib -undefined suppress -flat_namespace ',\
'-arch x86_64 -nostdlib -dynamiclib -undefined suppress -flat_namespace ');";

// darwin-cc
  SQLCommand += "INSERT INTO toolchains (PLATFORM,\
                                         COMPILER,\
                                         COMPILERDBG,\
                                         COMPILERREL,\
                                         LINKER,\
                                         LINKERDBG,\
                                         LINKERREL) VALUES \
('darwin32-cc', '/usr/bin/cc ', \
'-fno-asm -fno-inline -fvisibility=hidden \
 -fno-builtin  \
 -std=c99 -nostdinc -ffreestanding -Wall -Wextra -fPIC -Werror -pedantic \
 -fno-diagnostics-show-option  \
 -D_CGSCRIPT_MODULE -arch i386 -g0 -fno-omit-frame-pointer -DDEBUG_BUILD ',\
'-fno-asm -fno-inline -fvisibility=hidden \
 -fno-builtin  \
 -std=c99 -nostdinc -ffreestanding -Wall -Wextra -fPIC -Werror -pedantic \
 -fno-diagnostics-show-option  \
 -D_CGSCRIPT_MODULE -arch i386 -O -fomit-frame-pointer  ', \
'/usr/bin/cc ','-arch i386 -nostdlib -dynamiclib -undefined suppress -flat_namespace ',\
'-arch i386 -nostdlib -dynamiclib -undefined suppress -flat_namespace ');";
  SQLCommand.append ('\n');
  SQLCommand += "INSERT INTO toolchains (PLATFORM,\
                                         COMPILER,\
                                         COMPILERDBG,\
                                         COMPILERREL,\
                                         LINKER,\
                                         LINKERDBG,\
                                         LINKERREL) VALUES \
('darwin64-cc', '/usr/bin/cc ', \
'-fno-asm -fno-inline -fvisibility=hidden \
 -fno-builtin  \
 -std=c99 -nostdinc -ffreestanding -Wall -Wextra -fPIC -Werror -pedantic \
 -fno-diagnostics-show-option  \
 -D_CGSCRIPT_MODULE -arch x86_64 -g0 -fno-omit-frame-pointer -DDEBUG_BUILD ',\
'-fno-asm -fno-inline -fvisibility=hidden \
 -fno-builtin  \
 -std=c99 -nostdinc -ffreestanding -Wall -Wextra -fPIC -Werror -pedantic \
 -fno-diagnostics-show-option   \
 -D_CGSCRIPT_MODULE -arch x86_64 -O -fomit-frame-pointer  ', \
'/usr/bin/cc ','-arch x86_64 -nostdlib -dynamiclib -undefined suppress -flat_namespace ',\
'-arch x86_64 -nostdlib -dynamiclib -undefined suppress -flat_namespace ');";

 // insert modules
 QFile ModuleSource;
 QString modsource;

 // BetterMACD
 SQLCommand.append ('\n');
 SQLCommand += "INSERT INTO modules (ID, NAME, SOURCE, AUTHOR, TYPE, VERSION, PLATFORM, BINARY) VALUES \
 ('bc4949174c2cacc5e49cd46511efe2f0', 'BetterMACD', \
  '";
 SQLCommand.append ('\n');

 ModuleSource.setFileName (QString::fromUtf8 (":/source/cgscript/github/BetterMACD.cgs"));
 ModuleSource.open(QIODevice::ReadOnly|QIODevice::Text);
 QTextStream ReadBetterMACD (&ModuleSource);
 modsource = ReadBetterMACD.readAll();
 ModuleSource.close ();
 modsource.replace ("'", "");
 SQLCommand.append (modsource);
 SQLCommand.append ('\n');

 SQLCommand += "', \
  'ChartGeany.com', 'SUBCHART', '1.0.0', 'linux32-gcc', '');";

 // SuperTrend
 SQLCommand.append ('\n');
 SQLCommand += "INSERT INTO modules (ID, NAME, SOURCE, AUTHOR, TYPE, VERSION, PLATFORM, BINARY) VALUES \
 ('31448d6efd92623be95583c7b79effa9', 'SuperTrend', \
  '";
 SQLCommand.append ('\n');

 ModuleSource.setFileName (QString::fromUtf8 (":/source/cgscript/github/SuperTrend.cgs"));
 ModuleSource.open(QIODevice::ReadOnly|QIODevice::Text);
 QTextStream ReadSuperTrend (&ModuleSource);
 modsource = ReadSuperTrend.readAll();
 ModuleSource.close ();
 modsource.replace ("'", "");
 SQLCommand.append (modsource);
 SQLCommand.append ('\n');

 SQLCommand += "', \
  'ChartGeany.com', 'CURVE', '1.0.0', 'linux32-gcc', '');";
  SQLCommand.append ('\n');

// BigOHLC
 SQLCommand.append ('\n');
 SQLCommand += "INSERT INTO modules (ID, NAME, SOURCE, AUTHOR, TYPE, VERSION, PLATFORM, BINARY) VALUES \
 ('201f2ae13cfc31621f889fafdf45afd7', 'BigOHLC', \
  '";

 ModuleSource.setFileName (QString::fromUtf8 (":/source/cgscript/github/BigOHLC.cgs"));
 ModuleSource.open(QIODevice::ReadOnly|QIODevice::Text);
 QTextStream ReadBigOHLC (&ModuleSource);
 modsource = ReadBigOHLC.readAll();
 ModuleSource.close ();
 modsource.replace ("'", "");
 SQLCommand.append (modsource);
 SQLCommand.append ('\n');

 SQLCommand += "', \
  'ChartGeany.com', 'CONTAINER', '1.0.0', 'linux32-gcc', '');";
  SQLCommand += "COMMIT;";
  SQLCommand.append ('\n');

  // execute sql
  rc = sqlite3_exec(appsettings.db, SQLCommand.toUtf8(), NULL, NULL, NULL);
  if (rc != SQLITE_OK)
  {
    result = CG_ERR_TRANSACTION;
    setGlobalError(result, __FILE__, __LINE__);
  }

  return result;
}

// db schema version 20
static CG_ERR_RESULT
version20 (AppSettings appsettings)
{
  QString SQLCommand = "";
  CG_ERR_RESULT result = CG_ERR_OK;
  int rc;

  rc = sqlite3_exec(appsettings.db, SQLCommand.toUtf8(), NULL, NULL, NULL);
  if (rc != SQLITE_OK)
  {
    result = CG_ERR_TRANSACTION;
    setGlobalError(result, __FILE__, __LINE__);
    return result;
  }

  SQLCommand  = "BEGIN;";
  SQLCommand += "UPDATE version SET version=20 WHERE version=19;";
  SQLCommand.append ('\n');

  SQLCommand += "INSERT INTO datafeeds_raw (FEEDNAME, ACTIVE, SYMLIST, REALTIME, SYMLISTURL) VALUES ('IEX', 1, 'symlist_iex', 1, 'NONE');";
  SQLCommand.append ('\n');
  SQLCommand += "CREATE TABLE symlist_iex AS SELECT * FROM symlistmodel;";
  SQLCommand.append ('\n');

  SQLCommand += "ALTER TABLE VERSION ADD COLUMN IEXUPDATE TIMESTAMP DEFAULT 0;";
  SQLCommand.append ('\n');

  SQLCommand += "UPDATE datafeeds_raw SET active = 0 WHERE feed_id IN (2, 3);";

  SQLCommand += "COMMIT;";
  SQLCommand.append ('\n');

  // execute sql
  rc = sqlite3_exec(appsettings.db, SQLCommand.toUtf8(), NULL, NULL, NULL);
  if (rc != SQLITE_OK)
  {
    result = CG_ERR_TRANSACTION;
    setGlobalError(result, __FILE__, __LINE__);
  }

  return result;
}

// db schema version 21
static CG_ERR_RESULT
version21 (AppSettings appsettings)
{
  QString SQLCommand = "";
  CG_ERR_RESULT result = CG_ERR_OK;
  int rc;

  rc = sqlite3_exec(appsettings.db, SQLCommand.toUtf8(), NULL, NULL, NULL);
  if (rc != SQLITE_OK)
  {
    result = CG_ERR_TRANSACTION;
    setGlobalError(result, __FILE__, __LINE__);
    return result;
  }

  SQLCommand  = "BEGIN;";
  SQLCommand += "UPDATE version SET version=21 WHERE version=20;";
  SQLCommand.append ('\n');

  SQLCommand += "INSERT INTO datafeeds_raw (FEEDNAME, ACTIVE, SYMLIST, REALTIME, SYMLISTURL) VALUES ('ALPHAVANTAGE', 1, 'NONE', 1, 'NONE');";
  SQLCommand.append ('\n');

  SQLCommand += "ALTER TABLE VERSION ADD COLUMN ALPHAVANTAGE TIMESTAMP DEFAULT 0;";
  SQLCommand.append ('\n');

  // SQLCommand += "UPDATE datafeeds_raw SET active = 0 WHERE feed_id = 1;";
  // SQLCommand.append ('\n');

  SQLCommand += "ALTER TABLE OPTIONS ADD COLUMN AVAPIKEY TEXT NOT NULL DEFAULT '';";

  SQLCommand += "COMMIT;";
  SQLCommand.append ('\n');

  // execute sql
  rc = sqlite3_exec(appsettings.db, SQLCommand.toUtf8(), NULL, NULL, NULL);
  if (rc != SQLITE_OK)
  {
    result = CG_ERR_TRANSACTION;
    setGlobalError(result, __FILE__, __LINE__);
  }

  return result;
}

// db schema version 22
static CG_ERR_RESULT
version22 (AppSettings appsettings)
{
  QString SQLCommand = "";
  CG_ERR_RESULT result = CG_ERR_OK;
  int rc;

  rc = sqlite3_exec(appsettings.db, SQLCommand.toUtf8(), NULL, NULL, NULL);
  if (rc != SQLITE_OK)
  {
    result = CG_ERR_TRANSACTION;
    setGlobalError(result, __FILE__, __LINE__);
    return result;
  }

  SQLCommand  = "BEGIN;";
  SQLCommand += "UPDATE version SET version=22 WHERE version=21;";
  SQLCommand.append ('\n');

  SQLCommand += "UPDATE datafeeds_raw SET ACTIVE = 0 WHERE FEEDNAME = 'FOREX';";

  SQLCommand += "COMMIT;";
  SQLCommand.append ('\n');

  // execute sql
  rc = sqlite3_exec(appsettings.db, SQLCommand.toUtf8(), NULL, NULL, NULL);
  if (rc != SQLITE_OK)
  {
    result = CG_ERR_TRANSACTION;
    setGlobalError(result, __FILE__, __LINE__);
  }

  return result;
}

// db schema version 23
static CG_ERR_RESULT
version23 (AppSettings appsettings)
{
  QString SQLCommand = "";
  CG_ERR_RESULT result = CG_ERR_OK;
  int rc;

  rc = sqlite3_exec(appsettings.db, SQLCommand.toUtf8(), NULL, NULL, NULL);
  if (rc != SQLITE_OK)
  {
    result = CG_ERR_TRANSACTION;
    setGlobalError(result, __FILE__, __LINE__);
    return result;
  }

  SQLCommand  = "BEGIN;";
  SQLCommand += "UPDATE version SET version=23 WHERE version=22;";
  SQLCommand.append ('\n');
  SQLCommand += "ALTER TABLE OPTIONS ADD COLUMN IEXAPIKEY TEXT NOT NULL DEFAULT '';";

  SQLCommand += "COMMIT;";
  SQLCommand.append ('\n');

  // execute sql
  rc = sqlite3_exec(appsettings.db, SQLCommand.toUtf8(), NULL, NULL, NULL);
  if (rc != SQLITE_OK)
  {
    result = CG_ERR_TRANSACTION;
    setGlobalError(result, __FILE__, __LINE__);
  }

  return result;
}

// db schema version 24
static CG_ERR_RESULT
version24 (AppSettings appsettings)
{
  QString SQLCommand = "";
  CG_ERR_RESULT result = CG_ERR_OK;
  int rc;

  rc = sqlite3_exec(appsettings.db, SQLCommand.toUtf8(), NULL, NULL, NULL);
  if (rc != SQLITE_OK)
  {
    result = CG_ERR_TRANSACTION;
    setGlobalError(result, __FILE__, __LINE__);
    return result;
  }

  SQLCommand = "BEGIN;";
  SQLCommand.append ('\n');
  SQLCommand += "UPDATE version SET version=24 WHERE version=23;";
  SQLCommand.append ('\n');
  SQLCommand += "COMMIT;";
  SQLCommand.append ('\n');

  SQLCommand +=
  "ALTER TABLE SYMBOLS ADD COLUMN KEY2 TEXT NOT NULL DEFAULT '';\
   BEGIN; UPDATE SYMBOLS SET KEY2 = REPLACE (KEY, '_DAY_ADJUSTED_', '_ADJUSTED_'); COMMIT;\
   BEGIN; UPDATE SYMBOLS SET KEY2 = REPLACE (KEY2, '_DAY_ADJUSTED', '_ADJUSTED_DAY'); COMMIT;\
   BEGIN; UPDATE SYMBOLS SET KEY2 = REPLACE (KEY2, '_DAY_WEEK', '_WEEK'); COMMIT;\
   BEGIN; UPDATE SYMBOLS SET KEY2 = REPLACE (KEY2, '_DAY_MONTH', '_MONTH'); COMMIT;\
   BEGIN; UPDATE SYMBOLS SET KEY2 = REPLACE (KEY2, '_DAY_YEAR', '_YEAR'); COMMIT;\
   CREATE UNIQUE INDEX key2_idx ON SYMBOLS (KEY2);\
   CREATE TRIGGER ISETKEY2 AFTER INSERT ON SYMBOLS\
   BEGIN\
     UPDATE SYMBOLS SET KEY2 = REPLACE (KEY, '_DAY_ADJUSTED_', '_ADJUSTED_') WHERE KEY=NEW.KEY;\
     UPDATE SYMBOLS SET KEY2 = REPLACE (KEY2, '_DAY_ADJUSTED', '_ADJUSTED_DAY') WHERE KEY=NEW.KEY;\
     UPDATE SYMBOLS SET KEY2 = REPLACE (KEY2, '_DAY_WEEK', '_WEEK') WHERE KEY=NEW.KEY;\
     UPDATE SYMBOLS SET KEY2 = REPLACE (KEY2, '_DAY_MONTH', '_MONTH') WHERE KEY=NEW.KEY;\
     UPDATE SYMBOLS SET KEY2 = REPLACE (KEY2, '_DAY_YEAR', '_YEAR') WHERE KEY=NEW.KEY;\
   END;\
   CREATE TRIGGER USETKEY2 AFTER UPDATE ON SYMBOLS\
   BEGIN\
     UPDATE SYMBOLS SET KEY2 = REPLACE (KEY, '_DAY_ADJUSTED_', '_ADJUSTED_') WHERE KEY=NEW.KEY;\
     UPDATE SYMBOLS SET KEY2 = REPLACE (KEY2, '_DAY_ADJUSTED', '_ADJUSTED_DAY') WHERE KEY=NEW.KEY;\
     UPDATE SYMBOLS SET KEY2 = REPLACE (KEY2, '_DAY_WEEK', '_WEEK') WHERE KEY=NEW.KEY;\
     UPDATE SYMBOLS SET KEY2 = REPLACE (KEY2, '_DAY_MONTH', '_MONTH') WHERE KEY=NEW.KEY;\
     UPDATE SYMBOLS SET KEY2 = REPLACE (KEY2, '_DAY_YEAR', '_YEAR') WHERE KEY=NEW.KEY;\
   END;";

  // execute sql
  rc = sqlite3_exec(appsettings.db, SQLCommand.toUtf8(), NULL, NULL, NULL);
  if (rc != SQLITE_OK)
  {
    result = CG_ERR_TRANSACTION;
    setGlobalError(result, __FILE__, __LINE__);
  }

  return result;
}

// db schema version 25
static CG_ERR_RESULT
version25 (AppSettings appsettings)
{
  QString SQLCommand = "";
  CG_ERR_RESULT result = CG_ERR_OK;
  int rc;

  rc = sqlite3_exec(appsettings.db, SQLCommand.toUtf8(), NULL, NULL, NULL);
  if (rc != SQLITE_OK)
  {
    result = CG_ERR_TRANSACTION;
    setGlobalError(result, __FILE__, __LINE__);
    return result;
  }

  QString PLATFORM, BITS,
          CC = "", CFLAGS = "", CFLAGSREL = "", CFLAGSDBG = "",
          LD = "", LFLAGS = "", LFLAGSDBG = "";

  SQLCommand = "BEGIN;";
  SQLCommand.append ('\n');
  SQLCommand += "UPDATE version SET version=25 WHERE version=24;";
  SQLCommand.append ('\n');
  SQLCommand += "DELETE FROM toolchains;";
  SQLCommand.append ('\n');
  SQLCommand += "CREATE TABLE tempmodules AS SELECT * FROM modules LIMIT 1;";
  SQLCommand.append ('\n');
  SQLCommand += "DELETE FROM tempmodules;";
  SQLCommand.append ('\n');

  // linux32-cgs
  PLATFORM = "linux32-cgs";
  SQLCommand += "INSERT INTO toolchains (PLATFORM,\
                                         COMPILER,\
                                         COMPILERDBG,\
                                         COMPILERREL,\
                                         LINKER,\
                                         LINKERDBG,\
                                         LINKERREL) VALUES \
  ('" + PLATFORM + "', '', '', '', '', '', '');";

  // linux64-cgs
  PLATFORM = "linux64-cgs";
  SQLCommand += "INSERT INTO toolchains (PLATFORM,\
                                         COMPILER,\
                                         COMPILERDBG,\
                                         COMPILERREL,\
                                         LINKER,\
                                         LINKERDBG,\
                                         LINKERREL) VALUES \
  ('" + PLATFORM + "', '', '', '', '', '', '');";

  // win32-cgs
  PLATFORM = "win32-cgs";
  SQLCommand += "INSERT INTO toolchains (PLATFORM,\
                                         COMPILER,\
                                         COMPILERDBG,\
                                         COMPILERREL,\
                                         LINKER,\
                                         LINKERDBG,\
                                         LINKERREL) VALUES \
  ('" + PLATFORM + "', '', '', '', '', '', '');";

  // win64-cgs
  PLATFORM = "win64-cgs";
  SQLCommand += "INSERT INTO toolchains (PLATFORM,\
                                         COMPILER,\
                                         COMPILERDBG,\
                                         COMPILERREL,\
                                         LINKER,\
                                         LINKERDBG,\
                                         LINKERREL) VALUES \
  ('" + PLATFORM + "', '', '', '', '', '', '');";

  // linux32-cc
  CC = "cc";
  BITS = "32";
  PLATFORM = "linux" + BITS + "-" + CC;
  CFLAGS = "-m" + BITS + " \
    -Wall -Wextra -Werror -nostdinc -fstack-protector \
    -fno-asm -fno-inline -fvisibility=hidden -fno-builtin-malloc \
    -std=c99 -pedantic -pedantic-errors -ffreestanding -fPIC \
    -fno-diagnostics-show-option  -D_CGSCRIPT_MODULE ";
  CFLAGSREL = " -fomit-frame-pointer -O2 " + CFLAGS;
  CFLAGSDBG = " -DDEBUG_BUILD -g -fno-omit-frame-pointer -O0 " + CFLAGS;
  LD = CC;
  LFLAGS = " -nostdlib -nodefaultlibs -shared ";
  SQLCommand += "INSERT INTO toolchains (PLATFORM,\
                                         COMPILER,\
                                         COMPILERDBG,\
                                         COMPILERREL,\
                                         LINKER,\
                                         LINKERDBG,\
                                         LINKERREL) VALUES \
  ('" + PLATFORM + "', \
   '" + CC + "', '" + CFLAGSDBG + "', '" + CFLAGSREL + "', '" +
   LD + "', '" + LFLAGS +"', '"+ LFLAGS +"');";

  // linux64-cc
  CC = "cc";
  BITS = "64";
  PLATFORM = "linux" + BITS + "-" + CC;
  CFLAGS = "-m" + BITS + " \
    -Wall -Wextra -Werror -nostdinc -fstack-protector \
    -fno-asm -fno-inline -fvisibility=hidden -fno-builtin-malloc \
    -std=c99 -pedantic -pedantic-errors -ffreestanding -fPIC \
    -fno-diagnostics-show-option  -D_CGSCRIPT_MODULE ";
  CFLAGSREL = " -fomit-frame-pointer -O2 " + CFLAGS;
  CFLAGSDBG = " -DDEBUG_BUILD -g -fno-omit-frame-pointer -O0 " + CFLAGS;
  LD = CC;
  LFLAGS = " -nostdlib -nodefaultlibs -shared ";
  SQLCommand += "INSERT INTO toolchains (PLATFORM,\
                                         COMPILER,\
                                         COMPILERDBG,\
                                         COMPILERREL,\
                                         LINKER,\
                                         LINKERDBG,\
                                         LINKERREL) VALUES \
  ('" + PLATFORM + "', \
   '" + CC + "', '" + CFLAGSDBG + "', '" + CFLAGSREL + "', '" +
   LD + "', '" + LFLAGS +"', '"+ LFLAGS +"');";

// darwin32-cc
  CC = "cc";
  BITS = "32";
  PLATFORM = "darwin" + BITS + "-" + CC;
  CFLAGS = " \
    -Wall -Wextra -Werror -nostdinc -fstack-protector -fno-builtin \
    -fno-asm -fno-inline -fvisibility=hidden -arch i386 -fexceptions \
    -std=c99 -pedantic -pedantic-errors -ffreestanding -fPIC \
    -fno-diagnostics-show-option  -D_CGSCRIPT_MODULE ";
  CFLAGSREL = " -fomit-frame-pointer -O2 " + CFLAGS;
  CFLAGSDBG = " -DDEBUG_BUILD -g -fno-omit-frame-pointer -O0 " + CFLAGS;
  LD = CC;
  LFLAGS = " -nostdlib -dynamiclib -undefined suppress -flat_namespace ";
  SQLCommand += "INSERT INTO toolchains (PLATFORM,\
                                         COMPILER,\
                                         COMPILERDBG,\
                                         COMPILERREL,\
                                         LINKER,\
                                         LINKERDBG,\
                                         LINKERREL) VALUES \
  ('" + PLATFORM + "', \
   '" + CC + "', '" + CFLAGSDBG + "', '" + CFLAGSREL + "', '" +
   LD + "', '" + LFLAGS +"', '"+ LFLAGS +"');";

  // darwin64-cc
  CC = "cc";
  BITS = "64";
  PLATFORM = "darwin" + BITS + "-" + CC;
  CFLAGS = " \
    -Wall -Wextra -Werror -nostdinc -fstack-protector -fno-builtin \
    -fno-asm -fno-inline -fvisibility=hidden -arch x86_64 -fexceptions \
    -std=c99 -pedantic -pedantic-errors -ffreestanding -fPIC \
    -fno-diagnostics-show-option  -D_CGSCRIPT_MODULE ";
  CFLAGSREL = " -fomit-frame-pointer -O2 " + CFLAGS;
  CFLAGSDBG = " -DDEBUG_BUILD -g -fno-omit-frame-pointer -O0 " + CFLAGS;
  LD = CC;
  LFLAGS = " -nostdlib -dynamiclib -undefined suppress -flat_namespace ";
  SQLCommand += "INSERT INTO toolchains (PLATFORM,\
                                         COMPILER,\
                                         COMPILERDBG,\
                                         COMPILERREL,\
                                         LINKER,\
                                         LINKERDBG,\
                                         LINKERREL) VALUES \
  ('" + PLATFORM + "', \
   '" + CC + "', '" + CFLAGSDBG + "', '" + CFLAGSREL + "', '" +
   LD + "', '" + LFLAGS +"', '"+ LFLAGS +"');";


  // linux32-clang
  CC = "clang";
  BITS = "32";
  PLATFORM = "linux" + BITS + "-" + CC;
  CFLAGS = "-m" + BITS + " \
    -Wall -Wextra -Werror -nostdinc -fstack-protector \
    -fno-asm -fno-inline -fvisibility=hidden -fno-builtin-malloc \
    -std=c99 -pedantic -pedantic-errors -ffreestanding -fPIC \
    -fno-diagnostics-show-option  -D_CGSCRIPT_MODULE ";
  CFLAGSREL = " -fomit-frame-pointer -O2 " + CFLAGS;
  CFLAGSDBG = " -DDEBUG_BUILD -g -fno-omit-frame-pointer -O0 " + CFLAGS;
  LD = CC;
  LFLAGS = " -nostdlib -nodefaultlibs -shared ";
  SQLCommand += "INSERT INTO toolchains (PLATFORM,\
                                         COMPILER,\
                                         COMPILERDBG,\
                                         COMPILERREL,\
                                         LINKER,\
                                         LINKERDBG,\
                                         LINKERREL) VALUES \
  ('" + PLATFORM + "', \
   '" + CC + "', '" + CFLAGSDBG + "', '" + CFLAGSREL + "', '" +
   LD + "', '" + LFLAGS +"', '"+ LFLAGS +"');";

  // linux64-clang
  CC = "clang";
  BITS = "64";
  PLATFORM = "linux" + BITS + "-" + CC;
  CFLAGS = "-m" + BITS + " \
    -Wall -Wextra -Werror -nostdinc -fstack-protector \
    -fno-asm -fno-inline -fvisibility=hidden -fno-builtin-malloc \
    -std=c99 -pedantic -pedantic-errors -ffreestanding -fPIC \
    -fno-diagnostics-show-option  -D_CGSCRIPT_MODULE ";
  CFLAGSREL = " -fomit-frame-pointer -O2 " + CFLAGS;
  CFLAGSDBG = " -DDEBUG_BUILD -g -fno-omit-frame-pointer -O0 " + CFLAGS;
  LD = CC;
  LFLAGS = " -nostdlib -nodefaultlibs -shared ";
  SQLCommand += "INSERT INTO toolchains (PLATFORM,\
                                         COMPILER,\
                                         COMPILERDBG,\
                                         COMPILERREL,\
                                         LINKER,\
                                         LINKERDBG,\
                                         LINKERREL) VALUES \
  ('" + PLATFORM + "', \
   '" + CC + "', '" + CFLAGSDBG + "', '" + CFLAGSREL + "', '" +
   LD + "', '" + LFLAGS +"', '"+ LFLAGS +"');";

  SQLCommand += "COMMIT;";

  // execute sql
  rc = sqlite3_exec(appsettings.db, SQLCommand.toUtf8(), NULL, NULL, NULL);
  if (rc != SQLITE_OK)
  {
    result = CG_ERR_TRANSACTION;
    setGlobalError(result, __FILE__, __LINE__);
  }

  return result;
}

// database manager
CG_ERR_RESULT
dbman (int dbversion, AppSettings appsettings)
{
  CG_ERR_RESULT result = CG_ERR_DBACCESS;

  switch (dbversion)
  {
  case 1:
    result = version1 (appsettings);
    if (result != CG_ERR_OK)
      return result;
    // fall through
  case 2:
    result = version2 (appsettings);
    if (result != CG_ERR_OK)
      return result;
    // fall through
  case 3:
    result = version3 (appsettings);
    if (result != CG_ERR_OK)
      return result;
    // fall through
  case 4:
    result = version4 (appsettings);
    if (result != CG_ERR_OK)
      return result;
    // fall through
  case 5:
    result = version5 (appsettings);
    if (result != CG_ERR_OK)
      return result;
    // fall through
  case 6:
    result = version6 (appsettings);
    if (result != CG_ERR_OK)
      return result;
    // fall through
  case 7:
    result = version7 (appsettings);
    if (result != CG_ERR_OK)
      return result;
    // fall through
  case 8:
    result = version8 (appsettings);
    if (result != CG_ERR_OK)
      return result;
    // fall through
  case 9:
    result = version9 (appsettings);
    if (result != CG_ERR_OK)
      return result;
    // fall through
  case 10:
    result = version10 (appsettings);
    if (result != CG_ERR_OK)
      return result;
    // fall through
  case 11:
    result = version11 (appsettings);
    if (result != CG_ERR_OK)
      return result;
    // fall through
  case 12:
    result = version12 (appsettings);
    if (result != CG_ERR_OK)
      return result;
    // fall through
  case 13:
    result = version13 (appsettings);
    if (result != CG_ERR_OK)
      return result;
    // fall through
  case 14:
    result = version14 (appsettings);
    if (result != CG_ERR_OK)
      return result;
    // fall through
  case 15:
    result = version15 (appsettings);
    if (result != CG_ERR_OK)
      return result;
    // fall through
  case 16:
    result = version16 (appsettings);
    if (result != CG_ERR_OK)
      return result;
    // fall through
  case 17:
    result = version17 (appsettings);
    if (result != CG_ERR_OK)
      return result;
    // fall through
  case 18:
    result = version18 (appsettings);
    if (result != CG_ERR_OK)
      return result;
    // fall through
  case 19:
    result = version19 (appsettings);
    if (result != CG_ERR_OK)
      return result;
    // fall through
  case 20:
    result = version20 (appsettings);
    if (result != CG_ERR_OK)
      return result;
    // fall through
  case 21:
    result = version21 (appsettings);
    if (result != CG_ERR_OK)
      return result;
    // fall through
  case 22:
    result = version22 (appsettings);
    if (result != CG_ERR_OK)
      return result;
    // fall through
  case 23:
    result = version23 (appsettings);
    if (result != CG_ERR_OK)
      return result;
    // fall through
  case 24:
    result = version24 (appsettings);
    if (result != CG_ERR_OK)
      return result;
    // fall through
  case 25:
    result = version25 (appsettings);
    if (result != CG_ERR_OK)
      return result;
    // fall through

  default:
    return CG_ERR_OK;
  }

  return CG_ERR_OK;
}

