/*
 * newpref.c - write a template of userprefs.h
 * 
 * include LICENSE
 */

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <errno.h>

#include <mkcf.h>
#include <msglog.h>
#include <strmem.h>
#include <strcatdup.h>


char *text_file = 
"#ifndef USERPREFS_H\n"
"#define USERPREFS_H\n"
"\n"
"/*\n"
" * %s - User preferences and configuration functions\n"
" * \n"
" * include LICENSE\n"
" */\n"
"\n"
"/*\n"
" * WARNING : This file use the same name for each project\n"
" *           but its contents is project dependant\n"
" * There are 3 parts in configuration system :\n"
" *   - the C code of configuration functions in userprefs.c file independant of\n"
" *     the project.\n"
" *   - the private C code included between #ifdef %s #endif\n"
" *     in the  userprefs.h file that is application dependant.\n"
" *   - the public code exported to other files of the application before and after the\n"
" *     #ifdef %s #endif in the userprefs.h file.\n"
" *     defmarker is THIS_IS_USERPREFS_FILE by default.\n"
" */\n"
"\n"
"/*\n"
" * To add a new variable:\n"
" *      1 - add the variable at the end of struct _UserPrefs .\n"
" *          Do not forget to put a comment.\n"
" *      2 - If you need a default value different of 0,\n"
" *          do an assignation for this variable in\n"
" *          the function up_init_defaults(UserPrefs *up).\n"
" *          If defaults are needed for object instances, they can be\n"
" *          set in the .*_construct function.\n"
" *      3 - run mkcf : mkcf userprefs.h\n"
" *          it will do the hard job for you.\n"
" */\n"
"\n"
"#include <fdbuf.h>\n"
"#include <dliststr.h>\n"
"#include <arraystr.h>\n"
"\n"
"typedef struct _UserPrefs UserPrefs;\n"
"typedef struct _%s %s;\n"
"typedef void *(*VarAddr_FP)( ); /* do not check arguments */\n"
"\n"
"/* Description Table */\n"
"struct _%s {\n"
"   char *extTok;              /* ptr on file name token : TOKEN  */\n"
"   VarAddr_FP varfunc;        /* function returning the address of variable */\n"
"   int  vartype;              /* variable type                   */\n"
"   char *pcomment;            /* a comment for the variable      */\n"
"} ;\n"
"\n"
"    \n"
"struct _UserPrefs {\n"
"   AppClass parent;\n"
"   int newFile;             /* a new rcfile was created */\n"
"   char *prog;              /* pointer to program name                 */\n"
"   char *rcDir;             /* ressource directory $HOME/.prog         */\n"
"   char *rcFile;            /* preferences file name                    */\n"
"   %s *pdesc;  /* pointer to the config description table  */\n"
"   FDBuf *linebuf;          /* dynamic buffer for read the file         */\n"
"   DList *incVars;          /* list of included variables from rcfile   */\n"
"   int curnum;              /* current element index                    */\n"
"   int curel;               /* current element index                    */\n"
"//   AppClass *curptr;        /* current pointer to objet                 */\n"
"\n"
"/* mkcf User Variables prefix up */\n"
"   int version;             /* userprefs version managed by mkcf */\n"
"   int prog_debug;          /* global debug flag  */\n"
"   int verbose;             /* level of verbosity */\n"
"};\n"
"\n"
"\n"
"/*\n"
" * The following part is included in userprefs.c\n"
" */\n"
"#ifdef %s\n"
"\n"
"static int mkcfVersion = 1;\n"
"\n"
"%s confDesc[] = {  /* UserPrefs - by mkcf */\n"
"    { \"\", 0 , TCMT,\n"
"        \"User Preferences\" },\n"
"    {  0, 0, 0, 0, },\n"
"};\n"
"\n"
"\n"
"void up_dyn_destroy(UserPrefs *up)\n"
"{\n"
"}\n"
"\n"
"\n"
"/* mkcf end of stuff generated by mkcf */\n"
"\n"
"\n"
"void up_init_defaults(UserPrefs *up)\n"
"{\n"
"}\n"
"\n"
"#endif /* %s */\n"
"\n"
"extern int prog_debug;\n"
"\n"
"/*\n"
" * prototypes\n"
" */\n"
"UserPrefs *up_new( char *prog, char *rcFile, %s *pdesc );\n"
"void up_construct( UserPrefs *up, char *prog, char *rcFile, %s *pdesc );\n"
"void up_destroy(void *up);\n"
"\n"
"void up_init_defaults(UserPrefs *up);\n"
"int up_rc_read_file(UserPrefs *up );\n"
"int up_rc_rewrite( UserPrefs *up );\n"
"\n"
"#endif /* USERPREFS_H */\n"
"\n"
;

/*
 * write a template of userprefs.h
 */
void mkcf_write_empty_file (UserData *ud)
{
   char *filename;
   FILE *fd;
   struct stat stbuf;
   char buf[BUFSIZ];
   int ret = -1;

   if ( ! ud->rcfile ) {
       ud->rcfile = app_strdup("userprefs.h");
   }
   filename = ud->rcfile;
   char *bak = app_strcatdup( filename, ".bak", NULL) ;
   char *out = app_strcatdup( filename, "_tmp", NULL) ;
   
   if ( stat(bak, &stbuf) < 0 &&  (ret = stat(filename, &stbuf)) == 0){
      rename( filename, bak );
   }
	
   fd = fopen( out, "w" );
   if ( ! fd ) {
      msg_fatal(_("Can't open file '%s': %s"), filename,  strerror (errno));
   }
   fprintf(fd, text_file, ud->rcfile,
	  ud->defmarker, ud->defmarker,
	  ud->defdesc, ud->defdesc, ud->defdesc, ud->defdesc,
	  ud->defmarker,
	  ud->defdesc,
	  ud->defmarker,
	  ud->defdesc, ud->defdesc );
   fclose(fd);
   
   if ( ret == 0 && stbuf.st_mode & S_IFLNK ) {
      /* modify the source */
      int sz = readlink(filename, buf, sizeof(buf));
      buf[sz] = 0;
      filename = buf;
   }
   rename( out, filename);
   app_free(out);
   app_free(bak);
}
