/* MF_About.cxx */


#include <string.h>

#include "MF_About.H"
#include "MF_MainWindow.H"

extern MF_MainWindow * _MAINW_;


void ok_cb(Fl_Widget * w)
{
  _MAINW_->clearAbout();
}

MF_AboutText::MF_AboutText(int x, int y, int w, int h)
  : Fl_Widget(x, y, w, h)
{
  int btx, bty, btw, bth;

  btw = 50;
  bth = 25;
  btx = x + w/2 - btw/2;
  bty = y + h - bth - 5;

  bt_ = new Fl_Button(btx, bty, btw, bth, "OK");
  bt_->callback(ok_cb);
  bt_->shortcut(FL_Enter);
}

void MF_AboutText::draw(void)
{
  int posx, posx2, posy, lgw, lgh;
  char *txt;

  fl_color(FL_BLACK);
  fl_font(FL_HELVETICA_BOLD, 14);


  txt = strdup("LALNVIEW : A graphical viewer for pairwise alignments");
  lgw = lgh = 0;
  fl_measure(txt, lgw, lgh);
  posx = x() + w()/2 - lgw/2;
  posy = 30;
  fl_draw(txt, posx, posy);
  free(txt);

  fl_font(FL_HELVETICA, 12);
  txt = strdup("Version : lalnview 3.0");
  lgw = lgh = 0;
  fl_measure(txt, lgw, lgh);
  posx = x() + w()/2 - lgw/2;
  posy += 30;
  fl_draw(txt, posx, posy);
  free(txt);

  posx = x()+20;
  posy += 40;
  fl_draw("Lalnview is licensed under the GNU General Public License (http://www.gnu.org)", posx, posy);

  posx = x()+40;
  posy+=50;

  fl_draw("Laurent Duret", posx, posy);
  posy += fl_height();
  fl_draw("Laboratoire de Biometrie et Biologie Evolutive", posx, posy);
  posy += fl_height();
  fl_draw("CNRS / Universite Lyon I", posx, posy);
  posy += fl_height();
  //  fl_draw("e-mail : duret@biomserv.univ-lyon1.fr", posx, posy);
  fl_draw("e-mail : ", posx, posy);
  lgw = lgh = 0;
  fl_measure("e-mail : ", lgw, lgh);
  posx2 = posx + lgw + 2;
  fl_color(FL_BLUE);
  fl_draw("duret@biomserv.univ-lyon1.fr", posx2, posy);
  fl_color(FL_BLACK);


  posy += 50;
  fl_draw("Jean-Francois Gout", posx, posy);
  posy += fl_height();
  fl_draw("e-mail : ", posx, posy);
  fl_color(FL_BLUE);
  fl_draw("gout@biomserv.univ-lyon1.fr", posx2, posy);
  fl_color(FL_BLACK);

  posy = y() + h() - 80;
  fl_draw("lalnview uses the FLTK project (http://www.fltk.org) for its user interface", posx, posy);
  posy = y() + h() -60;
  fl_draw("lalnview uses the PDFlib lite library (http://www.pdflib.org) for PDF output", posx, posy);

  posy += 15;
  fl_line( x(), posy, x()+w(), posy);

  int ret =  bt_->take_focus();
}



MF_About::MF_About(int x, int y, int w, int h)
  : Fl_Window(x, y, w, h, "About lalnview")
{
  tin_ = new MF_AboutText(0, 0, w, h);
  this->add(tin_);
}

