/* MF_BestSeries.cxx */


#include "MF_BestSeries.H"
#include "MF_MainWindow.H"
#include "dijkstra.H"
#include "globals.h"

extern MF_MainWindow * _MAINW_;


/* void chk_cb(Fl_Widget *w)
   The callback method for the Fl_Check_Button 'chk_'.
*/
void chk_cb(Fl_Widget *w)
{
  if( NBBLOC<1 )
    return;

  Fl_Check_Button * c = (Fl_Check_Button *)w;
  //  printf("Bouton : '%d'\n", c->value());
  if(c->value())
      dijkstra();
  _MAINW_->fullUpdatePanel();
}


/* void input_cb(Fl_Widget *w)
   The callback method for the input field 'input_'.
*/
void input_cb(Fl_Widget *w)
{
  if( NBBLOC<1 )
    return;

  if(_MAINW_->getBestSeries()->isChecked())
    dijkstra();
  _MAINW_->fullUpdatePanel();

}


MF_BestSeries::MF_BestSeries(int x, int y, int w, int h)
  : Fl_Widget(x, y, w, h)
{
  int posx, posy;

  this->txt_ = strdup("Display the best series of segments");
  fl_font(FL_COURIER, 12);
  this->chk_ = new Fl_Check_Button(x+5, y+3, 20, h-5, "");
  //_MAINW_->add(chk_);
  parent()->add(chk_);
  chk_->callback(chk_cb);

  posx = posy = 0;
  fl_measure(txt_, posx, posy);
  posx_ = posx + 5;

  this->w( posx_ );

  input_ = new Fl_Int_Input(x+posx+2, chk_->y()+5, 0, 0);
  //_MAINW_->add(input_);
  //parent()->add(input_);
  input_->value("0");
  input_->callback(input_cb);
  input_->when(FL_WHEN_ENTER_KEY | FL_WHEN_RELEASE);
}


void MF_BestSeries::draw(void)
{
  fl_font(FL_HELVETICA, 12);
  fl_color(FL_BLACK);

  fl_draw(txt_, (chk_->x()+chk_->w()+2), chk_->y()+(chk_->h()/2)+3 );

  fl_rect(x(), y(), w(), h());
  //  fl_rectf(x()+posx_, y(), 20, 20, FL_RED);
}

int MF_BestSeries::isChecked(void)
{
  return ( chk_->value() );
}

int MF_BestSeries::getMarg(void)
{
  return( atoi(input_->value()) );
}
