/* MF_Echelle.cxx */

#include <FL/Enumerations.H>

#include "MF_Echelle.H"
#include "MF_MainWindow.H"


extern MF_MainWindow * _MAINW_;


FL_EXPORT MF_Echelle::MF_Echelle(int x, int y, int w, int h, int larg, int taille_inter, int taille1)
  :  Fl_Widget(x,y,w,h+40){
  this->taille_inter_ = taille_inter;
  this->taille1_ = taille1;
  this->larg_=larg;
  this->sizeText_= 5;
  this->sizeTitre_ = 20;
  
  leftBeg_ = (int)( w/2 - (taille1 + taille_inter*NBCOL)/2) + taille1;
}

void MF_Echelle::handle_push(void)
{
  int choix;
  char buf[512];
  int x, y;
  uchar r,g,b;
  r = 0xFF;
  g = 0xFF;
  b = 0xFF;

  x = Fl::event_x();
  y = Fl::event_y();

  int numCol = (int)( (w()/2 - (taille1_ + taille_inter_*NBCOL)/2) + taille1_ );
  int x2 = x - numCol;

  if(x2<0 || x2>NBCOL*taille_inter_)
    return;

  x2 /= taille_inter_;

  if(y < this->y()+sizeTitre_)
    return;

  if(x<this->x()+this->taille1_)
    return;

  numCol = NBCOL-x2-1;

  sprintf(buf,"%s", "Choix couleur");
  choix = fl_color_chooser(buf, r, g, b);

  //printf("Couleur choisie : \nHexa : %x - %x - %x\nDeci : %d %d %d\n",r,g,b,r,g,b);

  if(choix){
    fl_color(r,g,b);
    //    fl_rectf(200,200,10,20, fl_color());
    color_lg[numCol].col = fl_color();
    this->redraw();
    _MAINW_->redraw();
  }
}


FL_EXPORT int MF_Echelle::handle(int e)
{
  if(e){
    switch(e){
    case FL_PUSH :
      handle_push();
      return 1;
      break;
    default :
      break;
    }  
  }
  return (0);
}

void MF_Echelle::draw(void)
{  
  int i, leftMarg;
  char buf[10];
  int sizeBloc = this->taille_inter_;
  int base = this->x();


  _MAINW_->make_current();
  fl_rectf(x(), y(), w(), h(), FL_WHITE);

  fl_color(0,0,0);
  fl_font(FL_COURIER,12);
  fl_draw("SIMILARITY SCALE\0", base+w()/2-(int)fl_width("Similarity scale\0")/2, y()+14);

  leftMarg = (int)( w()/2 - (taille1_ + taille_inter_*NBCOL)/2);
  base = leftMarg;

  fl_font(FL_COURIER,10);
  fl_draw("Nothing detected\0", base+this->taille1_/2-(int)fl_width("Nothing detected\0")/2, y()+sizeTitre_+larg_+10 );
  //  fl_rectf(base+1, y()+sizeTitre_, this->taille1_, this->larg_, FL_WHITE);
  fl_color(0,0,0);
	
  base += this->taille1_;
  leftBeg_ = base;
  
  for(i=NBCOL-1 ; i>=0 ; i--){
    //printf("%f - %f -> %f\n", color_lg[i].sco, color_lg[i].x1, color_lg[i].x2);
    fl_rectf(base, y()+sizeTitre_, sizeBloc, this->larg_, color_lg[i].col);
    sprintf(buf,"%3.0f %c\0",color_lg[i].sco, '%');
    fl_color(0,0,0);
    fl_font(FL_COURIER,10);
    fl_draw(buf , base+this->taille_inter_/2-(int)fl_width(buf)/2, y()+sizeTitre_+larg_+10);
    base+=sizeBloc;
  }
  base = leftMarg;  
  fl_rect(base,y()+sizeTitre_, taille1_+taille_inter_*NBCOL, larg_);
  
}

void MF_Echelle::myResize(int xx, int yy, int ww, int hh)
{
  this->resize(xx, yy, ww, hh);
  this->draw();
}



/**************************************************************************************************/
/*                                      PDF EXPORT                                               */
/**************************************************************************************************/


void MF_Echelle::drawPDF(PDF *p, int decx, int decy)
{
  int i, leftMarg;
  char buf[10];
  int sizeBloc = this->taille_inter_;
  int base = this->x();
  double larg = (double)(this->larg_/1.5);


  PDF_setcolor(p, "fillstroke", "rgb", (double)0.0, (double)0.0, (double)0.0, (double)0.0 );
  int font =  PDF_load_font(p, "Helvetica", 0, "host", "");
  double fontSize = (double)10.0;
  PDF_setfont(p, font, fontSize);
  char *st = (char *)"SIMILARITY SCALE\0";
  PDF_set_text_pos(p, base+w()/2-(int)PDF_stringwidth(p, st, font, fontSize)+decx, y()+decy);
  PDF_show(p, st);

  leftMarg = (int)( w()/2 - (taille1_ + taille_inter_*NBCOL)/2);
  base = leftMarg;

  fontSize = 8.0;
  PDF_setfont(p, font, fontSize);
  PDF_set_text_pos(p,  base+this->taille1_/2-(int)PDF_stringwidth(p, "Nothing detected\0", font, fontSize)/2+decx, y()+sizeTitre_+larg+decy );
  PDF_show(p, "Nothing detected\0");
	
  base += this->taille1_;
  leftBeg_ = base;

  PDF_setlinewidth( p, (double)0.5 );  

  uchar red, green, blue;
  double dred, dgreen, dblue;

  for(i=NBCOL-1 ; i>=0 ; i--){
    //printf("%f - %f -> %f\n", color_lg[i].sco, color_lg[i].x1, color_lg[i].x2);
    Fl::get_color(color_lg[i].col, red, green, blue);

    dred = (double)(red/(double)255);
    dgreen = (double)(green/(double)255);
    dblue = (double)(blue/(double)255);

    PDF_setcolor( p, "fill", "rgb", dred, dgreen, dblue, (double)0.0 );
    PDF_rect(p, base+decx, y()+sizeTitre_+decy, sizeBloc, larg);
    PDF_fill(p);

    //fl_rectf(base, y()+sizeTitre_, sizeBloc, this->larg_, color_lg[i].col);
    sprintf(buf,"%3.0f %c\0",color_lg[i].sco, '%');
    fl_color(0,0,0);
    fl_font(FL_COURIER,10);

    PDF_setcolor(p, "fillstroke", "rgb", (double)0.0, (double)0.0, (double)0.0, (double)0.0 );
    PDF_set_text_pos(p,  base+this->taille_inter_/2-(int)PDF_stringwidth(p, buf, font, fontSize)/2+decx, y()+sizeTitre_+larg+decy);
    PDF_show(p, buf);
    //fl_draw(buf , base+this->taille_inter_/2-(int)fl_width(buf)/2, y()+sizeTitre_+larg_+10);
    base+=sizeBloc;
  }
  base = leftMarg;  

  PDF_setcolor(p, "stroke", "rgb", (double)0.0, (double)0.0, (double)0.0, (double)0.0 );
  PDF_rect(p, base+decx, y()+sizeTitre_+decy, taille1_+taille_inter_*NBCOL, larg);
  PDF_stroke(p);
  //fl_rect(base,y()+sizeTitre_, taille1_+taille_inter_*NBCOL, larg_);
  
}

