/* MF_FeatDisplay.cxx */

/*
  The MF_FeatDisplay class' goal is to display the text associated with the features 
  on wich the user clicked.
  The action is performed by a 'Fl_Text_Display' widget wich is updated using the private field 
  'buf_'.
*/

#include "MF_FeatDisplay.H"
#include "MF_MainWindow.H"

extern MF_MainWindow * _MAINW_;


MF_FeatDisplay::MF_FeatDisplay(int x, int y, int w, int h)
  : Fl_Text_Editor(x,y,w,h){
  this->buf_ = new Fl_Text_Buffer();
}


/* Displays in full text 'nb' features by reading them in 'tab' array. */
void MF_FeatDisplay::afficheFeat(int *tab, int nb)
{
  int i;
  char * txt;
  //  int len = nb * (30+18+MAXLAB+1); <-- A retablir apres debug

  int len = nb * (32+18+MAXLAB+1) + 1;
  txt = (char *)malloc(len*sizeof(char));
  txt[0]='\0';

  struct FEATURE f;
  for(i=0 ; i<nb ; i++){
    f = tab_feat[tab[i]];
    if(i==0)
      sprintf(txt,"%d.%-8s %8d .. %-8d %s", f.nseq, f.col, f.deb, f.fin, f.lab);
    else
      sprintf(txt,"%s\n%d.%-8s %8d .. %-8d %s", txt, f.nseq, f.col, f.deb, f.fin, f.lab);
  }

  buf_->text(txt);
  free(txt);   

  textfont(FL_COURIER);
  textsize(13);
  
  this->buffer(buf_);
}

void MF_FeatDisplay::raz(void)
{
  buf_->text("\0");
  this->buffer(buf_);
}
