#ifndef _MF_MAINWINDOW_H_
#define _MF_MAINWINDOW_H_


#include <FL/Fl_Window.H>
#include <FL/Fl_Menu_Bar.H>
#include <FL/Fl_Scroll.H>


#include "MF_MyScroll.H"
#include "MF_Echelle.H"
#include "MF_Name.H"
#include "MF_About.H"
#include "MF_Zoomer.H"
#include "MF_ScoMinChooser.H"
#include "MF_ParcBloc.H"
#include "MF_Stats.H"
#include "MF_FeatDisplay.H"
#include "MF_BestSeries.H"


class MF_MainWindow : public Fl_Window {
public :
  MF_MainWindow(int x, int y, int w, int h, const char * lbl);
  void addMenu(void);
  void about(void);
  void clearAbout(void);

  void actuName(void);
  void updatePanel(void);
  void fullUpdatePanel(void);

  void activerParcBloc(void);
  void desactiverParcBloc(void);

  void bestFirst(int);
  int bestFirst(void);

  int bestSeries(void);

  void setMins(void);

  void listMenuItems(void);

  Fl_Menu_Bar * getMenuBar(void);
  const Fl_Menu_Item * getMenuItems(void);
  MF_MyScroll * getScroll(void);
  MF_Name * getName(void);
  MF_Zoomer * getZoomer(void);
  MF_ParcBloc * getParcBloc(void);
  MF_Stats * getStats(void);
  MF_FeatDisplay * getFeatDisp(void);
  MF_BestSeries * getBestSeries(void);
  MF_Echelle * getScale(void);
  MF_ScoMinChooser * getScoMinC(void);

private :
  Fl_Menu_Bar * menu_;
  MF_About * about_;

  MF_Echelle * scale_;
  MF_Name * name_;
  MF_MyScroll * myScroll_;

  MF_ScoMinChooser * scoMinC_;
  MF_ScoMinChooser * identityMinC_;
  MF_ScoMinChooser * lenghtMinC_;

  MF_ParcBloc * parcBloc_;
  MF_Zoomer * zoomer_;
  MF_Stats * stats_;

  MF_FeatDisplay * featDisp_;
  MF_BestSeries * bestSeries_;
  Fl_Scroll * btGrp_;
  Fl_Group * grpName_;

  int bestFirst_;
};


#endif
