/* MF_MyScroll.H */

#ifndef _MF_MYSCROLLH_
#define _MF_MYSCROLLH_

#include <FL/Fl_Group.H>


#include "MF_Sequence.H"
#include "MF_MyScrollbar.H"
#include "bmp.H"


class MF_MyScroll : public Fl_Group {
public :
  MF_MyScroll(int x, int y, int w , int h);
  void draw(void);
  void fillSeg(SEG s);
  void drawSegLines(SEG s);

  void myResize(int x, int y, int w, int h);
  void loadSequences(void);
  void initSegIdentity(void);

  void reAlign(void);
  void reCalibrate(int pos);
  void zoomWhole(void);
  int getFullSize(void);
  double shift(void);

  void fullUpdate(void);
  void setLasts(int lastSeqClicked, int lastBlocClicked);
  int getLastSegment(void);
  int getLastSeq(void);
  int getLastBloc(void);

  void captToBmp(char *file);
  void exportPDF(char *fileName, int all);
  void drawPDF(PDF *p, int _DECX_, int _DECY_, int all);
  void fillSegPDF(PDF *p, SEG s, int _DECX_, int _DECY_, double red, double green, double blue, int all);
  void drawSegLinesPDF(SEG s, PDF *p, int decx, int decy, int all);

  MF_MyScrollbar * getScrollbar(void);
  MF_Sequence * getSequence(int numSeq);
private :
  MF_Sequence * seq_[2];
  MF_MyScrollbar * scrolb_;
  int scrolbH_;
  int seqLarg_;

  int lastSeqClicked_;
  int lastBlocClicked_;
};


#endif
