/* MF_MyScroll.cxx */

#include "pdflib.h"


#include "lalnview_utils.H"
#include "MF_MyScroll.H"
#include "MF_MainWindow.H"
#include "MF_FeatDisplay.H"
#include "MF_Values.H"



extern MF_MainWindow * _MAINW_;


MF_MyScroll::MF_MyScroll(int x, int y, int w, int h)
  : Fl_Group(x, y, w, h)
{
  lastSeqClicked_ = -1;
  lastBlocClicked_ = -1;
  seq_[0] = seq_[1] = NULL;

  scrolbH_ = 15;
  scrolb_ = new MF_MyScrollbar(x, y+h-scrolbH_, w, scrolbH_);
  scrolb_->type(FL_HORIZONTAL);
  this->add(scrolb_);
  this->resizable(NULL);
}


void MF_MyScroll::loadSequences(void)
{
  int seqMarg = 10;
  int i, imax, lg;
  double rapport = MF_Values::rapport();
  seqLarg_ = 11;

  lastSeqClicked_ = -1;
  lastBlocClicked_ = -1;

  float scoMin = segm[0].sco;
  for(i=0 ; i<NBSEG ; i++){
    if(segm[i].sco>scoMin)
      scoMin = segm[i].sco;
    segm[i].id = i;
    segm[i].myList = 0;
  }
  /* The default scoMin_ (Similarity score threshold) is 120 but if no segm has a score higer than 120, the scoMin_ is 
   set to the score of the best segment. */
  if(scoMin<MF_Values::scoMin())
    MF_Values::scoMin(scoMin);

  trier();
  initSegIdentity();

  seq_[0] = new MF_Sequence( 0 ,  x() , y() , this->w(), this->h()/2-scrolbH_/2 , seqMarg, seqLarg_);
  this->add(seq_[0]);
  seq_[1] = new MF_Sequence( 1 ,  x() , seq_[0]->y()+seq_[0]->h(), this->w(), this->h()/2-scrolbH_/2-2 , seqMarg, seqLarg_);
  this->add(seq_[1]);

  _MAINW_->getName()->yText( seq_[0]->seqY() , seq_[1]->seqY() );

  imax = 0;
  if( seq[0].lg<seq[1].lg )
    imax = 1;

  lg = (int)( seq[imax].lg / rapport) + seqMarg;

  scrolb_->slider_size( (float)( ((float)scrolb_->w()) / ((float)lg) ) );
  scrolb_->step(rapport/50);
  scrolb_->range(0 , (lg-scrolb_->w()) + 15);
  scrolb_->callback(scrolb_cb);
  scrolb_->dessine();
  scrolb_->redraw();

  draw();
  _MAINW_->actuName();
}

void MF_MyScroll::reCalibrate(int pos)
{
  double rapport = MF_Values::rapport();

  int fullSize = getFullSize();

  scrolb_->slider_size( (float)( ((float)scrolb_->w()) / ((float)fullSize) ) );
  scrolb_->range(0 , (fullSize-scrolb_->w()) + 15);

  if(pos>-1){
    Fl_Slider * slid = (Fl_Slider *)scrolb_;
    slid->value((double)pos);
  }
  scrolb_->redraw();
}

void MF_MyScroll::zoomWhole(void)
{
  if(NBBLOC<1 || NBSEQ<0)
    return;

  int fullSize = getFullSize();
  //  int r = (int)(fullSize/w());
  int r, l, tot;

  if(lastBlocClicked_<0){
    if(seq[0].lg>seq[1].lg)
      tot = seq[0].lg;
    else
      tot = seq[1].lg;
  } else {
    SEG curSeg = segm[seq[0].bloc[lastBlocClicked_].seg];

    /*************************************/
    /* Looking for the biggest left part. */
    if( curSeg.beg0>curSeg.beg1 )
      l = curSeg.beg0;
    else
      l = curSeg.beg1;
    /*************************************/

    /***********************************************************/
    /* Looking for the biggest right part. */
    if( (seq[0].lg-curSeg.beg0)>(seq[1].lg-curSeg.beg1) )
      r = seq[0].lg-curSeg.beg0;
    else
      r = seq[1].lg -curSeg.beg1;
    /***********************************************************/

    tot = l+r;
  }

  double rp = (double)((double)tot/(double)(w()-25));

  MF_Values::rapport(rp);

  reCalibrate(0);
  reAlign();
  Fl_Slider * slid = ((Fl_Slider *)scrolb_);
  slid->value((double)0); 
  redraw();
}

void MF_MyScroll::myResize(int xx, int yy, int ww, int hh)
{

  this->resize( xx , y() , ww , h() );
  scrolb_->resize(xx, yy+hh-scrolbH_, ww, scrolbH_);
  scrolb_->dessine();
}

double MF_MyScroll::shift(void)
{
  return scrolb_->value();
}


void MF_MyScroll::draw(void)
{
  int i;
  SEG s;

  MF_FeatDisplay * st = _MAINW_->getFeatDisp();
  st->resize( _MAINW_->getScoMinC()->x()+_MAINW_->getScoMinC()->w()+10 , st->y(), st->w() , st->h() );


  if(NBBLOC<1 || NBSEQ<1){
    scrolb_->dessine();
    return;
  }

  uchar r, g, b;
  /* r,g,b : colors used to fill the segments between the sequences. */
  r = 0xFF;
  g = 0xF0;
  b = 0x90;


  fl_rectf(x(), y(), w(), h()-scrolbH_, FL_WHITE);

  double scoMin = MF_Values::scoMin();
  double identityMin = MF_Values::identityMin();
  int lenghtMin = MF_Values::lenghtMin();

  /* if the option of displaying only the best series of segments id checked bck will be non-zero */
  int bck = _MAINW_->getBestSeries()->isChecked();
  int onlyRed = 0;
  int onlyGreen = 0;

  /* Fisrt loop fills the segment with yellow color */
  for(i=0 ; i<NBSEG ; i++){
    s = segm[i];
    if( isDrawable(s, scoMin, identityMin, lenghtMin, bck, onlyGreen, onlyRed) ){
      fl_color(r,g,b);
      fillSeg(s);
    }
  }

  /* We now fill the current segment with a darker color */
  if( lastSeqClicked_>-1 && lastBlocClicked_>-1 ){
    s = segm[seq[lastSeqClicked_].bloc[lastBlocClicked_].seg];
    fl_color(0xEF, 0xDF, 0x50);
    //    if( s.sco>=scoMin && s.lgaln >= lenghtMin && s.identity >= identityMin && ( !bck || s.bestSeries) ){
    if( isDrawable(s, scoMin, identityMin, lenghtMin, bck, onlyGreen, onlyRed) ){
      fillSeg(s);
    }
  }


  /* Second loop draws the lines that delimitate the segments */
  for(i=0 ; i<NBSEG ; i++){
    s = segm[i];
    //if(s.sco >= scoMin  && s.lgaln >= lenghtMin && s.identity >= identityMin && ( !bck || s.bestSeries) ){
    if( isDrawable(s, scoMin, identityMin, lenghtMin, bck, onlyGreen, onlyRed) ){
      drawSegLines(s);
    }
  }
  /* !!!!  The second loop (drawing the lines) must be done after the first one, otherwise the lines 
     would be invisible. !!!! */

  seq_[0]->draw();
  seq_[1]->draw();
  scrolb_->dessine();
  _MAINW_->actuName();
  return;
}

void MF_MyScroll::fillSeg(SEG s)
{
  int px, py, px1, py1, px2, py2, px3, py3;
  int beg[2], end[2];
  double rapport = MF_Values::rapport();

  double shift[2];
  shift[0] = scrolb_->value() - seq_[0]->leftMarg() - seq_[0]->x();
  shift[1] = scrolb_->value() - seq_[1]->leftMarg() - seq_[1]->x();

  int firstBase[2];
  firstBase[0] = (int)(shift[0]*rapport);
  firstBase[1] = (int)(shift[1]*rapport);


  beg[0] = (int)((s.beg0 - firstBase[0])/rapport);
  beg[1] = (int)((s.beg1 - firstBase[1])/rapport);

  end[0] = (int)((s.end0 - firstBase[0])/rapport);
  end[1] = (int)((s.end1 - firstBase[1])/rapport);

  px = beg[0];
  py =  seq_[0]->seqY()+seqLarg_;
  px1 = beg[1];
  py1 = seq_[1]->seqY();
  px2 = end[1];
  py2 = seq_[1]->seqY();
  px3 = end[0];
  py3 = seq_[0]->seqY()+seqLarg_;

  fl_polygon(px, py, px1, py1, px2, py2, px3, py3);  
}



/* void MF_Bin::drawSegLines(SEG s)
   Draws the lines (between the two sequences) wich delimitates the segment s.
*/
void MF_MyScroll::drawSegLines(SEG s)
{
  int beg[2], end[2];
  double rapport = MF_Values::rapport();

  double shift[2];
  shift[0] = scrolb_->value() - seq_[0]->leftMarg() - seq_[0]->x();
  shift[1] = scrolb_->value() - seq_[1]->leftMarg() - seq_[1]->x();

  int firstBase[2];
  firstBase[0] = (int)(shift[0]*rapport);
  firstBase[1] = (int)(shift[1]*rapport);


  beg[0] = (int)((s.beg0 - firstBase[0])/rapport);
  beg[1] = (int)((s.beg1 - firstBase[1])/rapport);

  end[0] = (int)((s.end0 - firstBase[0])/rapport);
  end[1] = (int)((s.end1 - firstBase[1])/rapport);


  fl_color(FL_BLACK);
  fl_line(beg[0], seq_[0]->seqY()+seqLarg_ , beg[1], seq_[1]->seqY());
  fl_line(end[0], seq_[0]->seqY()+seqLarg_ , end[1], seq_[1]->seqY());
}


void MF_MyScroll::reAlign(void)
{
  if(lastSeqClicked_<0 || lastBlocClicked_<0)
    return;

  double rapport = MF_Values::rapport();

  BLOC b[2];
  b[0] = seq[0].bloc[lastBlocClicked_];
  b[1] = seq[1].bloc[lastBlocClicked_];

  double shift[2];
  shift[0] = scrolb_->value() - seq_[0]->leftMarg() - seq_[0]->x();
  shift[1] = scrolb_->value() - seq_[1]->leftMarg() - seq_[1]->x();

  int firstBase[2];
  firstBase[0] = (int)(shift[0]*rapport);
  firstBase[1] = (int)(shift[1]*rapport);

  int posX[2];
  posX[0] = (int)( (b[0].beg - firstBase[0])/rapport );
  posX[1] = (int)( (b[1].beg - firstBase[1])/rapport );

  if(posX[0]==posX[1])
    return;

  int r, l;
  if( posX[0]>posX[1] ){
    r = 0;
    l = 1;
  } else {
    r = 1;
    l = 0;
  }
  int dec = posX[r]-posX[l];
  int pos = scrolb_->value();

  int leftMarg[2];
  leftMarg[r] = seq_[r]->leftMarg();
  leftMarg[l] = seq_[l]->leftMarg();

  if( leftMarg[r] > dec){
    leftMarg[r] -= dec;
    if( lastSeqClicked_ == r )
      pos -= dec;
  } else {
    leftMarg[l] += dec;
    if( lastSeqClicked_ == l )
      pos += dec;
  }

  while( leftMarg[r]>20 && leftMarg[l]>20 ){
    leftMarg[r] -= 20;
    leftMarg[l] -= 20;
    pos -= 20;
  }

  seq_[r]->leftMarg(leftMarg[r]);
  seq_[l]->leftMarg(leftMarg[l]);


  int fullSize = getFullSize();

  scrolb_->slider_size( (float)( ((float)scrolb_->w()) / ((float)fullSize) ) );
  scrolb_->range(0 , (fullSize-scrolb_->w()) + 15);

  Fl_Slider * slid = (Fl_Slider *)scrolb_;
  slid->value((double)pos);

  //  scrolb_->value(pos);
  seq_[r]->redraw();
  seq_[l]->redraw();
}


void MF_MyScroll::initSegIdentity(void)
{
  int i, lastSeg, lgaln;
  float ident, gapf;
  float _defaultSeuil_ = 120.0;
  float scoMax = 0.0;
  BLOC b;

  lastSeg = -1;

  for(i=0 ; i<NBBLOC ; i++){
    b = seq[1].bloc[i];
    if(lastSeg != b.seg){
      if(segm[b.seg].sco>scoMax)
	scoMax = segm[b.seg].sco;
      get_aln(b.seg, &ident, &gapf, &lgaln, i);
      segm[b.seg].identity = ident;
      segm[b.seg].gapf = gapf;
      segm[b.seg].lgaln = lgaln;
      lastSeg = b.seg;
    }
  }
  if(scoMax>_defaultSeuil_)
    scoMax = _defaultSeuil_;

  MF_Values::scoMin(scoMax);
}

void MF_MyScroll::setLasts(int lastSeqClicked, int lastBlocClicked)
{
  lastSeqClicked_ = lastSeqClicked;
  lastBlocClicked_ = lastBlocClicked;
}

MF_MyScrollbar * MF_MyScroll::getScrollbar(void){ return scrolb_; }


int MF_MyScroll::getFullSize(void)
{
  double rapport = MF_Values::rapport();

  int lg[2];
  lg[0] = (int)(seq[0].lg/rapport) + seq_[0]->leftMarg();
  lg[1] = (int)(seq[1].lg/rapport) + seq_[1]->leftMarg();;

  int imax;
  if( lg[0]>lg[1] )
    imax = 0;
  else
    imax = 1;

  return(lg[imax]);
}


void MF_MyScroll::fullUpdate(void)
{
  seq_[0]->loadTab();
  seq_[1]->loadTab();
  /*
  seq_[0]->draw();
  seq_[1]->draw();
  */  
  redraw();
}

/* int MF_MyScroll::getLastSegment(void)
   Return the last segment clicked by the user, -1 if no segment was ever clicked.
   The returned integer correspond to the index of the segment in the 'segm' array 
   declared as a global variable (see file def_globals.h for definitions).
*/
int MF_MyScroll::getLastSegment(void)
{
  int segNum = -1;
  int lastBloc = this->getLastBloc();
  int lastSeq = this->getLastSeq();

  if(lastBloc>-1 && lastBloc<NBBLOC){
    segNum = seq[lastSeq].bloc[lastBloc].seg;
    if(segNum>-1 && segNum<NBSEG)
      return segNum;
  }
  return -1;
}


/* void MF_MyScroll::captToBmp(char *file)
  Creates a capture of the current window in bitmap format.
 */
void MF_MyScroll::captToBmp(char *file)
{
  this->take_focus();
  _MAINW_->fullUpdatePanel();
  this->take_focus();
  _MAINW_->take_focus();
  _MAINW_->make_current();

  _MAINW_->redraw();
  this->draw();

  int ww = _MAINW_->getName()->w() + w();
  int hh = _MAINW_->getScale()->h() + h();

  uchar *mat = (uchar *)malloc(ww*hh*4*sizeof(uchar));

  fl_read_image(mat, _MAINW_->getName()->x(), _MAINW_->getName()->y(), ww, hh);

  saveBMP(mat, ww, hh, file);

}


int MF_MyScroll::getLastSeq(void){ return lastSeqClicked_; }
int MF_MyScroll::getLastBloc(void){ return lastBlocClicked_; }
MF_Sequence * MF_MyScroll::getSequence(int num){ return seq_[num]; }


/****************************************************************************************/
/****************************************************************************************/
/****************************************************************************************/

/****************************************************************************************/
/*					PDF FUNCTIONS					*/
/****************************************************************************************/


void MF_MyScroll::exportPDF(char *fileName, int all)
{
  
  PDF *p; 
  int font; 
  int decy = 20;
  int decx = 80;
  double fontSize = (double)10.0;
  int maxName, lgS, lgSMax;
  double sr = MF_Values::rapport();

  //printf("Taille : %d\n", getFullSize());

  int lg = strlen(seq[0].name);
  if(lg < strlen(seq[1].name) )
    maxName = 1;
  else
    maxName = 0;

  lgSMax = 10000;
  lgS = getFullSize();
  int a4h = 842;
  int a4w = 595;

  lgSMax = a4h;

  // The PDF output must nit be larger than a given width (lgSMax) to avoid crash when reading the pdf created.
  if( all==1 && lgS > lgSMax ){
    MF_Values::rapport(sr*((double)((double)lgS/(double)lgSMax)));
    reAlign();
    //printf("Changement rapport de %.2f a %.2f\n", sr, MF_Values::rapport());
  }

  //MF_Values::rapport(sr*((double)((double)lgS/(double)lgSMax)));

  //printf("FullSize : %d\n", getFullSize());
 
  if ((p = PDF_new()) == (PDF *) 0) { 
    fl_alert("Couldn't create PDFlib object (out of memory)!\n"); 
    return; 
  } 

  PDF_TRY(p) { 
    if (PDF_begin_document(p, fileName, 0, "compatibility=1.3") == -1) { 
      printf("Error: %s\n", PDF_get_errmsg(p)); 
      return; 
    }

    PDF_set_parameter(p, "topdown", "true");

    PDF_set_info(p, "Creator", "lalnview"); 
    PDF_set_info(p, "Author", "Lalnview"); 
    PDF_set_info(p, "Title", "Export from lalnview"); 

    if(all==1)
      PDF_begin_page_ext(p, lgSMax+decx, 400, ""); 
    else
      PDF_begin_page_ext(p, w()+decx+10, 400, ""); 


    font = PDF_load_font(p, "Helvetica", 0, "host", "");
    PDF_setfont(p, font, fontSize);
    decx = (int)PDF_stringwidth(p, seq[maxName].name, font, fontSize) + 8;

    // Drawing successively the scale, the to sequences (with their features) and then the segments.
    _MAINW_->getScale()->drawPDF(p, decx, decy);
    seq_[0]->drawPDF(p, decx, decy, all);
    seq_[1]->drawPDF(p, decx, decy, all);
    this->drawPDF(p, decx, decy, all);


    /****************************************************************************************************/
    /* Clean an area on the left side to draw sequence name */
    PDF_setcolor(p, "fill", "rgb", (double)1.0,  (double)1.0,  (double)1.0, (double)0.0);
    PDF_rect(p, 0, 400, decx-2, 400);
    PDF_fill(p);

    PDF_setcolor(p, "fillstroke", "rgb", (double)0.0,  (double)0.0,  (double)0.0, (double)0.0);
    font = PDF_load_font(p, "Helvetica", 0, "host", "");
    PDF_setfont(p, font, fontSize);

    PDF_set_text_pos(p, 4, seq_[0]->seqY()+decy);
    PDF_show(p, seq[0].name);
    PDF_set_text_pos(p, 4, seq_[1]->seqY()+decy);
    PDF_show(p, seq[1].name);
    /****************************************************************************************************/

    PDF_end_page_ext(p, "");
    PDF_end_document(p, "");

    if(all==1){
      MF_Values::rapport(sr);
      reAlign();
    }
  }

  PDF_CATCH(p) {
    printf("PDFlib exception occurred.\n");
    printf("[%d] %s: %s\n", PDF_get_errnum(p), PDF_get_apiname(p), PDF_get_errmsg(p)); PDF_delete(p);
    return; 
  }
  
  PDF_delete(p);
}


void MF_MyScroll::drawPDF(PDF *p, int _DECX_, int _DECY_, int all)
{
  int i;
  SEG s;

  if(NBBLOC<1 || NBSEQ<1){
    return;
  }

  uchar r, g, b;
  /* r,g,b : colors used to fill the segments between the sequences. */
  r = 0xFF;
  g = 0xF0;
  b = 0x90;

  // Converting uchar to double because PDFlib requires double values between 0 and 1 for colors.
  double red, green, blue;
  red = (double)(r/(double)255);
  green = (double)(g/(double)255);
  blue = (double)(b/(double)255);

  double scoMin = MF_Values::scoMin();
  double identityMin = MF_Values::identityMin();
  int lenghtMin = MF_Values::lenghtMin();

  /* if the option of displaying only the best series of segments id checked bck will be non-zero */
  int bck = _MAINW_->getBestSeries()->isChecked();
  int onlyRed = 0;
  int onlyGreen = 0;

  /* Fisrt loop fills the segment with yellow color */
  for(i=0 ; i<NBSEG ; i++){
    s = segm[i];
    if( isDrawable(s, scoMin, identityMin, lenghtMin, bck, onlyGreen, onlyRed) ){
      fillSegPDF(p, s, _DECX_, _DECY_, red, green, blue, all);
    }
  }

  /* We now fill the current segment with a darker color */
  if( lastSeqClicked_>-1 && lastBlocClicked_>-1 ){
    s = segm[seq[lastSeqClicked_].bloc[lastBlocClicked_].seg];
    if( isDrawable(s, scoMin, identityMin, lenghtMin, bck, onlyGreen, onlyRed) ){
      r = 0xEF;
      g = 0xDF;
      b = 0x50;

      red = (double)(r/(double)255);
      green = (double)(g/(double)255);
      blue = (double)(b/(double)255);
      fillSegPDF(p, s, _DECX_, _DECY_, red, green, blue, all);
    }
  }

  /* Second loop draws the lines that delimitate the segments */
  for(i=0 ; i<NBSEG ; i++){
    s = segm[i];
    if( isDrawable(s, scoMin, identityMin, lenghtMin, bck, onlyGreen, onlyRed) ){
      drawSegLinesPDF(s, p, _DECX_, _DECY_, all);
    }
  }
  /* !!!!  The second loop (drawing the lines) must be done after the first one, otherwise the lines 
     would be invisible. !!!! */

}

/* void MF_MyScroll::fillSegPDF(PDF *p, SEG s, int decx, int decy, double red, double green, double blue, int all)
   Draws a qudrilateral representing the segment between the two sequences and fills it with the given colors.
*/
void MF_MyScroll::fillSegPDF(PDF *p, SEG s, int decx, int decy, double red, double green, double blue, int all)
{
  int beg[2], end[2];
  double rapport = MF_Values::rapport();

  double shift[2];
  shift[0] = scrolb_->value() - seq_[0]->leftMarg() ;
  shift[1] = scrolb_->value() - seq_[1]->leftMarg() ;

  if(all==1){
    shift[0] = 0 - seq_[0]->leftMarg();
    shift[1] = 0 - seq_[1]->leftMarg();
  }

  int firstBase[2];
  firstBase[0] = (int)(shift[0]*rapport);
  firstBase[1] = (int)(shift[1]*rapport);

  beg[0] = (int)((s.beg0 - firstBase[0])/rapport);
  beg[1] = (int)((s.beg1 - firstBase[1])/rapport);

  end[0] = (int)((s.end0 - firstBase[0])/rapport);
  end[1] = (int)((s.end1 - firstBase[1])/rapport);

  PDF_setcolor( p, "fill", "rgb", red, green, blue, (double)0.0 );
  PDF_moveto(p, beg[0]+decx, seq_[0]->seqY()+decy);
  PDF_lineto(p, beg[1]+decx, seq_[1]->seqY()-seqLarg_+decy);
  PDF_lineto(p, end[1]+decx, seq_[1]->seqY()-seqLarg_+decy);
  PDF_lineto(p, end[0]+decx, seq_[0]->seqY()+decy);
  PDF_fill(p);
}



/* void MF_Bin::drawSegLines(SEG s)
   Draws the lines (between the two sequences) which delimitates the segment s.
*/
void MF_MyScroll::drawSegLinesPDF(SEG s, PDF *p, int decx, int decy, int all)
{
  double dred, dgreen, dblue;
  int beg[2], end[2];
  double rapport = MF_Values::rapport();

  double shift[2];
  shift[0] = scrolb_->value() - seq_[0]->leftMarg() ;
  shift[1] = scrolb_->value() - seq_[1]->leftMarg() ;

  // all==1 if the entire alignment must be drawn. In that case, the scrolling value does not matter, only the leftMarg must 
  // be taken in account.
  if(all==1){
    shift[0] = 0 - seq_[0]->leftMarg();
    shift[1] = 0 - seq_[1]->leftMarg();
  }

  int firstBase[2];
  firstBase[0] = (int)(shift[0]*rapport);
  firstBase[1] = (int)(shift[1]*rapport);

  beg[0] = (int)((s.beg0 - firstBase[0])/rapport);
  beg[1] = (int)((s.beg1 - firstBase[1])/rapport);

  end[0] = (int)((s.end0 - firstBase[0])/rapport);
  end[1] = (int)((s.end1 - firstBase[1])/rapport);

  dred = dgreen = dblue = (double)0.0;
  PDF_setcolor(p, "stroke", "rgb", dred, dgreen, dblue, 0);
  PDF_setlinewidth( p, (double)0.001 );

  PDF_moveto(p, beg[0]+decx, seq_[0]->seqY()+decy);
  PDF_lineto(p,  beg[1]+decx, seq_[1]->seqY()-seqLarg_+decy);
  PDF_stroke(p);

  PDF_moveto(p, end[0]+decx, seq_[0]->seqY()+decy);
  PDF_lineto(p,  end[1]+decx, seq_[1]->seqY()-seqLarg_+decy);
  PDF_stroke(p);

}
