/* MF_Name.cxx */

#include "MF_Name.H"
#include "globals.h"

MF_Name::MF_Name(int x, int y, int w, int h, int y0, int y1, int fsize)
  : Fl_Widget(x,y,w,h)
{
  yText_[0] = y0;
  yText_[1] = y1;

  fsize_ = fsize;
}

void MF_Name::draw(void)
{
  if(NBSEQ<1)
    return;

  fl_rectf(x(), y(), w(), h(), FL_WHITE);
  fl_color(FL_BLACK);
  fl_font(FL_COURIER, fsize_);
  fl_draw(seq[0].name, x()+5, yText_[0] + fsize_ - 2);
  fl_draw(seq[1].name, x()+5, yText_[1] + fsize_ - 2);
}


void MF_Name::yText(int y0, int y1)
{
  yText_[0] = y0;
  yText_[1] = y1;
}


int MF_Name::getX(void){ return this->x(); }
int MF_Name::getW(void){ return this->w(); }
void MF_Name::myW(int w)
{ 
  this->w(w);
}

