/* MF_ParcBloc.cxx */

#include "MF_ParcBloc.H"
#include "MF_MainWindow.H"

extern MF_MainWindow * _MAINW_;


void MF_NextBloc_cb(Fl_Widget *w)
{
  int lb, ls;
  MF_MyScroll * ms = _MAINW_->getScroll();

  lb = ms->getLastBloc();
  ls = ms->getLastSeq();

  if( ls<0 || ls>1 || lb<0)
    return;

  MF_Next * b = (MF_Next *)w;
  MF_Sequence * seq = ms->getSequence(ls);
 
  if(b->sens()>0){
    seq->showNextBloc();
  } else {
    seq->showPrevBloc();
  }
}


MF_ParcBloc::MF_ParcBloc(int x, int y, int w, int h)
  : Fl_Widget(x,y,w,h)
{
  curBloc_ = -1;
  nbBloc_ = -1;

  fsize_ = 12;
  decY_ = fsize_*2;;


  btPrevX_ = x+8;
  btPrevY_ =  y + decY_;
  btPrevW_ = (w-16)/2;
  btPrevH_ = (int)(h-decY_- (0.2*decY_));

  btNextX_ = btPrevX_ + btPrevW_;
  btNextY_ = btPrevY_;
  btNextW_ = btPrevW_;
  btNextH_ = btPrevH_;

  btPrev_ = new MF_Next(-1, btPrevX_, btPrevY_, btPrevW_, btPrevH_, "@<-");
  btNext_ = new MF_Next(1, btNextX_, btNextY_, btNextW_, btNextH_, "@->");

  //_MAINW_->add(btPrev_);
  //_MAINW_->add(btNext_);
  parent()->add(btPrev_);
  parent()->add(btNext_);

  btPrev_->callback(MF_NextBloc_cb);
  btNext_->callback(MF_NextBloc_cb);

  desactiver();
}

void MF_ParcBloc::draw(void)
{

  if(nbBloc_<0 || curBloc_<0)
    return;

  sprintf(txt_, "Bloc %d / %d\0", curBloc_, nbBloc_);

  fl_rectf(x(), y()+(int)(0.7*fsize_), w(), fsize_, FL_BACKGROUND_COLOR);

  fl_color(FL_BLACK);
  fl_rect(x(), y(), w(), h());

  fl_font(FL_COURIER, fsize_);
  fl_draw(txt_, x(), y()+(int)(0.7*fsize_), w(), fsize_, FL_ALIGN_CENTER);
}

void MF_ParcBloc::desactiver()
{
  btPrev_->deactivate();
  btNext_->deactivate();
}

void MF_ParcBloc::activer()
{
  btPrev_->activate();
  btNext_->activate();
}

void MF_ParcBloc::setCurrentBloc(int curBloc, int nbBloc)
{
  curBloc_ = curBloc;
  nbBloc_ = nbBloc;
  redraw();
}
