/* MF_ScoMinChooser.cxx */

/*
  MF_ScoMinChooser provides a class that can be used to create easily boxes such as the 
  "Similarity Score Threshold" or the "Minimum lenght" boxes.
  Each box is composed an input field and a text.
*/

#include "MF_ScoMinChooser.H"
#include "MF_MainWindow.H"
#include "MF_Values.H"


extern MF_MainWindow * _MAINW_;

/* Callback method for the "Similarity Score Threshold" box. */
void MF_ScoMinChooser_score_cb(Fl_Widget *w)
{

  Fl_Float_Input * flip = (Fl_Float_Input *)w;
  // printf("Changer sco min a : %f\n", atof(flip->value()));
  MF_Values::scoMin(atof(flip->value()));
  _MAINW_->fullUpdatePanel();
}


/* Callback method for the "Minimum lenght" box */
void MF_ScoMinChooser_lenght_cb(Fl_Widget *w)
{
  int min;

  Fl_Float_Input * flip = (Fl_Float_Input *)w;
  min = (int) atof(flip->value());
  //  printf("Changer length min a : %d\n", min);
  MF_Values::lenghtMin(min);
  _MAINW_->fullUpdatePanel();
}

/* Callback method for the "Minimum identity box" */
void MF_ScoMinChooser_identity_cb(Fl_Widget *w)
{

  float min;
  Fl_Float_Input * flip = (Fl_Float_Input *)w;
  min =  atof(flip->value());
  // printf("Changer length min a : %d\n", min);
  MF_Values::identityMin(min);
  _MAINW_->fullUpdatePanel();
}




MF_ScoMinChooser::MF_ScoMinChooser(int type, int x, int y, const char * txt, int fsize)
  : Fl_Widget(x, y, 0, 0)
{
  int fx, fy, fw, fh, w, h;

  txt_ = strdup(txt);
  fsize_ = fsize;
  type_ = type;

  fw = 40;
  fh = 20;
  fRightMarg_ = 10;
  fLeftMarg_ = 10;
  txtLeftMarg_ = 5;
  topMarg_ = 12;

  fl_font(FL_COURIER, fsize);
  w = 0;
  h = 0;
  fl_measure(txt, w, h);

  w = txtLeftMarg_ + w + fLeftMarg_ + fw + fRightMarg_;
  h = fh + 2*topMarg_;

  this->w(w);
  this->h(h);

  fx = x + w - fw - fRightMarg_;
  fy = y + h/2 - fh/2;

  flip_ = new Fl_Float_Input(fx, fy, fw, fh);
  parent()->add(flip_);

  if(type == _MF_TYPE_SCOREMIN_)
    flip_->callback(MF_ScoMinChooser_score_cb);
  if(type == _MF_TYPE_LENGHTMIN_)
    flip_->callback(MF_ScoMinChooser_lenght_cb);
  if(type == _MF_TYPE_IDENTITYMIN_)
    flip_->callback(MF_ScoMinChooser_identity_cb);

  flip_->when(FL_WHEN_ENTER_KEY);
  
}

void MF_ScoMinChooser::setValue(char *val)
{
  flip_->value(val);
}

void MF_ScoMinChooser::draw(void)
{
  int tx, ty;

  tx = x() + txtLeftMarg_;
  ty = y() + h()/2 + topMarg_/2 - fsize_/5;

  fl_color(FL_BLACK);
  fl_rect(x(), y(), w(), h(), FL_BLACK);
  fl_font(FL_COURIER, fsize_);
  fl_draw(txt_, tx, ty);

}
