/* MF_Sequence.H */

#ifndef _MF_SEQUENCEH_
#define _MF_SEQUENCEH_

#include <FL/Fl.H>
#include <FL/fl_draw.H>

#include "pdflib.h"

#include "globals.h"
#include "lalnview.h"


class MF_Sequence : public Fl_Widget {
public :
  FL_EXPORT MF_Sequence(int id, int x, int y, int w, int h, int leftMarg, int seqH);
  FL_EXPORT  void draw(void);
  void drawFeat(struct FEATURE f, int posy, int firstBase, double rapport);

  void drawPDF(PDF *p, int decx, int decy, int all);
  void drawFeatPDF(PDF *p, struct FEATURE f, int posy, int firstBase, double rapport, int _DECX_, int _DEXY_);

  int handle(int e);
  void handle_push(void);
  int clickOnFeat(int cy);

  void displayFeat(int cx, int numBase);
  void clickOnSequence(int cx);
  void loadTabClicked(int base);
  void showNextBloc(void);
  void showPrevBloc(void);

  void loadTab(void);

  int leftMarg(void);
  int seqY(void);

  void leftMarg(int leftMarg);
private :
  int numSeq_;

  int seqY_;
  int seqH_;
  int leftMarg_;

  int topFeat_;
  int downFeat_;

  int * tabBloc_;
  int nbBloc_;
  int lastBloc_;

  int * tabShown_;
};

#endif
