/* MF_Sequence.cxx */

#include <FL/Fl_Scroll.H>

#include "MF_MainWindow.H"
#include "MF_SecWindow.H"
#include "MF_Sequence.H"
#include "MF_Values.H"
#include "lalnview_utils.H"


#define _SIZEMIN_ 5 /* The minimum size (in pixel) required to draw a black rectangle around the feature. */
#define NBGRAD 20


extern MF_MainWindow * _MAINW_;
extern MF_SecWindow * _SECW_;


MF_Sequence::MF_Sequence(int numSeq, int x, int y, int w, int h, int leftMarg, int seqH)
  : Fl_Widget(x, y, w, h)
{
  numSeq_ = numSeq;
  leftMarg_ = leftMarg;
  seqH_ = seqH;

 if(numSeq==0)
    seqY_ = y + h - MF_Values::SEQSPACE();
  else
    seqY_ = y + MF_Values::SEQSPACE();

 tabShown_ = NULL;
 tabBloc_ = NULL;
 nbBloc_ = 0;
 lastBloc_ = -1;

 topFeat_ = -1;
 downFeat_ = -1;

 loadTab();
}


/* void MF_Sequence::loadTab(void)
   Initializes the table 'tabShown_' with the blocs that can be dsiplayed on the screen.
   The lenght of tabShown_ is the lenght of the sequence and for each base we can found 
   the index of the bloc to be displayed or -1 if no bloc must be displayed at this place.
*/
void MF_Sequence::loadTab(void)
{
  int i, j, lgaln, bck;
  BLOC b;
  SEG s;

  if(tabShown_)
    free(tabShown_);

  tabShown_ = (int *)calloc( (seq[numSeq_].lg) , sizeof(int) );

  for(i=0 ; i<seq[numSeq_].lg ; i++){
    tabShown_[i]=-1;
  }

  float scoMin = MF_Values::scoMin();
  float identityMin = MF_Values::identityMin();
  int lenghtMin = MF_Values::lenghtMin();

  int onlyGreen = 0;
  int onlyRed = 0;

  bck = _MAINW_->getBestSeries()->isChecked();

  if( _MAINW_->bestFirst()==0 ){
    for(i=NBBLOC-1 ; i>=0 ; i--){
      if(seq[numSeq_].bloc[i].sco >= scoMin){
	b = seq[numSeq_].bloc[i];
	s = segm[b.seg];
	lgaln = s.lgaln;

	if( isDrawable(s, scoMin, identityMin, lenghtMin, bck, onlyGreen, onlyRed) ){
	  //printf("Affichage bloc %d [%d-%d] ... s.lgaln:%d\n", i, b.beg, b.end,s.lgaln); 
	  for(j=b.beg ; j<=b.end ; j++){
	    if(tabShown_[j]==-1)
	      tabShown_[j]=i;
	  }
	}
      }
    }
  } else {
    for(i=0 ; i<NBBLOC ; i++){
      b = seq[numSeq_].bloc[i];
      s = segm[b.seg];
      lgaln = s.lgaln;
      
      if( isDrawable(s, scoMin, identityMin, lenghtMin, bck, onlyGreen, onlyRed) ){
	//printf("Affichage bloc %d [%d-%d] ... s.lgaln:%d\n", i, b.beg, b.end,s.lgaln); 
	for(j=b.beg ; j<=b.end ; j++){
	  if(tabShown_[j]==-1)
	    tabShown_[j]=i;
	}
      }
    }
  }
}


/* void MF_Sequence::draw(void)
   Draws every bloc in the sequence and the draws the associated features.
*/
void MF_Sequence::draw(void)
{
  int i, j;
  int sdeb,sfin,  ssize;
  int de, db, rectBeg, rectEnd;
  struct BLOC b;


  MF_MyScroll * ms = (MF_MyScroll *)this->parent();
  double shift =  ms->shift()-leftMarg_;
  double rapport = MF_Values::rapport();
  int firstBase = (int)(shift*rapport);


  if(numSeq_==0)
    seqY_ = y()+ h() - MF_Values::SEQSPACE();
  else
    seqY_ = y() + MF_Values::SEQSPACE();;

  if(NBBLOC<1 || NBSEG<1)
    return;

  int seqY = y()+seqY_;

  int bck = _MAINW_->getBestSeries()->isChecked();
  int onlyRed = 0;
  int onlyGreen = 0;


  /* FIRST PART : displaying the blocs */
  float scoMin = MF_Values::scoMin();
  float identityMin = MF_Values::identityMin();
  int lenghtMin = MF_Values::lenghtMin();
  //for(i=0 ; i<NBBLOC && seq[numSeq_].bloc[i].sco>=scoMin ; i++){
  for(i=0 ; i<NBBLOC ; i++){

    b = seq[this->numSeq_].bloc[i];

    if( !isDrawable(segm[b.seg], scoMin, identityMin, lenghtMin, bck, onlyGreen, onlyRed) )
      continue;

    if(b.end < firstBase)
      continue;

    db = b.beg;
    de = b.end;

    rectBeg = b.beg;
    rectEnd = b.end;

    if( rectBeg<firstBase )
      rectBeg = firstBase;

    /* For each BLOC we have to check if it can be displayed on the screen by checking where the curent BLOC is 
       visible in the previously initialized tabShown_ table.
    */
    for(j=rectBeg ; j<=b.end ; j++){
      for( ; j<=b.end && tabShown_[j]!=i ; j++ )
	;
      if(j>b.end)
	break;
      rectBeg = j;
      
      for( ; j<b.end && tabShown_[j]==i ; j++ )
	;
      rectEnd = j;
      
      sdeb = (int)( (rectBeg-firstBase)/rapport);
      sfin = (int)( (rectEnd-firstBase)/rapport);
      if(sfin>w()){
	sfin=w();
      }
      ssize = (int)(sfin-sdeb);
      /* If the bloc's size is too small to occupate one pixel on the screen, the size is fixed to one pixel so that the bloc can be seen */
      if(ssize<1){
	ssize=1;
	//printf("BLOC TROP PETIT\n");
      }
      fl_rectf(x()+sdeb, seqY_, ssize, seqH_, get_color(b.sim));
    }
  }

  fl_color(FL_BLACK);
  sdeb = (int)((0-firstBase)/rapport);
  sfin = (int)((seq[numSeq_].lg - firstBase)/rapport);
  ssize = sfin-sdeb;
  fl_rect(x()+sdeb, seqY_, ssize, seqH_);



  /*******************************************************************************************************/
  /* SECOND PART : displaying the scale. */
  /* Determination of the interval between two graduations on the scale. */
  int  tabGrad[NBGRAD] = {1, 5, 10, 25, 50, 100, 200, 500, 1000, 2000, 5000, 10000, 20000, 50000, 100000, 200000, 500000, 1000000 , 2000000, 5000000};
  int bmax = seq[numSeq_].lg;
  char val[16];
  sprintf(val, "%d\0", bmax);
  int tw, th;
  tw = th = 0;
  fl_measure(val, tw, th);

  bmax = 0;
  while( ((int)(tabGrad[bmax]/rapport))<tw+10 ){
    bmax++;
  }
  /* tabGrad[bmax] is the interval that allows us to displays the graduations with at least 10 pixels between each graduation. */

  int pas = tabGrad[bmax];
  for(i=firstBase ; (i%pas)!=0 ; i++)
    ;

  int posx, posy;
  if(numSeq_==0)
    posy = seqY_ - 8;
  else
    posy = seqY_ + seqH_ + 15;
  fl_color(FL_BLACK);
  fl_font(FL_COURIER , 12);

  posx = (int)((i-firstBase)/rapport);
  bool full = false;
  while(posx<ms->w() && !full){
    sprintf(val, "%d\0", i);
    if(i>-1)
      fl_draw(val , x()+posx , posy);
    i+=pas;
    posx = (int)((i-firstBase)/rapport);
    if(i>seq[numSeq_].lg)
      full = true;
  }
  /* END of the Scale */
  /****************************************************/

  /*******************************************************************************/
  /* THIRD PART : Displaying the features (if there are some features) */
  if( numSeq_ == 0 )
    posy = seqY_-40;
  else
    posy = seqY_+seqH_+40;

  if(NBFEAT>0){

    fl_color(FL_BLACK);
    fl_line_style(FL_SOLID);

    sdeb = (int)((0-firstBase)/rapport);
    sfin = (int)((seq[numSeq_].lg - firstBase)/rapport);
    fl_line(x()+sdeb, posy, x()+sfin, posy);

    fl_line(x()+leftMarg_, posy, x()+leftMarg_+ssize, posy);

    topFeat_ = posy - (int)(tab_feat[0].lrg*6);
    downFeat_ = posy + (int)(tab_feat[0].lrg*6);

  }
  struct FEATURE f;
  for(i=0 ; i<NBFEAT ; i++){
    f = tab_feat[i];
    if( f.nseq==numSeq_ ){
      drawFeat(f, posy, firstBase, rapport);
      //printf("Seq:%d . f.col:%s . (%d-%d) f.lrg:%.2f \n", numSeq_, f.col, f.deb, f.fin, f.lrg);
    }
  }
  /*******************************************************************************/

}


/* void MF_Sequence::drawFeat(struct FEATURE f, int posy)
   Displays the given 'f' feature on the posy position (eg : verticaly aligned on the y=posy line).
*/
void MF_Sequence::drawFeat(struct FEATURE f, int posy, int firstBase, double rapport)
{
  int sdeb, sfin, ssize, h, cy;

  sdeb = (int)( (f.deb-firstBase)/rapport);
  sfin = (int)( (f.fin-firstBase)/rapport);
  ssize = sfin-sdeb;
  if(ssize<1)
    ssize = 1;
  h = (int)(12*f.lrg);
  cy = posy - (int)(h/2);

  if(cy<topFeat_)
    topFeat_ = cy;
  if(posy+h>downFeat_)
    downFeat_ = posy+(int)(h/2);

    fl_rectf(x()+sdeb, cy, ssize, h, getColor(f.col));

  if(ssize>_SIZEMIN_){
    fl_color(FL_BLACK);
    fl_rect(x()+sdeb, cy, ssize, h);
  }
}

void MF_Sequence::showPrevBloc(void)
{
  int i;
  for(i=0 ; i<nbBloc_ && tabBloc_[i]!=lastBloc_ ; i++)
    ;
  i--;
  if(i<0)
    i=nbBloc_-1;
  lastBloc_ = tabBloc_[i];

  _MAINW_->getParcBloc()->setCurrentBloc(i+1, nbBloc_);

  /*
  MF_MyScroll * grp = (MF_MyScroll *)this->parent();
  grp->setLasts(numSeq_ , lastBloc_);
  this->parent()->redraw();
  */

  MF_MyScroll * grp = (MF_MyScroll *)this->parent();
  grp->setLasts(numSeq_ , lastBloc_);
  grp->reAlign();
  grp->redraw();

  _SECW_->afficheBloc(lastBloc_, numSeq_);
}


void MF_Sequence::showNextBloc(void)
{
  int i;
  for(i=0 ; i<nbBloc_ && tabBloc_[i]!=lastBloc_ ; i++)
    ;

  i++;
  if(i>=nbBloc_)
    i = 0;
  lastBloc_ = tabBloc_[i];

  _MAINW_->getParcBloc()->setCurrentBloc(i+1, nbBloc_);

  MF_MyScroll * grp = (MF_MyScroll *)this->parent();
  grp->setLasts(numSeq_ , lastBloc_);
  grp->reAlign();
  grp->redraw();

  _SECW_->afficheBloc(lastBloc_, numSeq_);
}


void MF_Sequence::loadTabClicked(int base)
{
  int i;
  BLOC b;
  SEG s;

  tabBloc_ = (int *)malloc( NBSEG * sizeof(int) );

  double scoMin = MF_Values::scoMin();
  double identityMin = MF_Values::identityMin();
  int lenghtMin = MF_Values::lenghtMin();

  int  bck = _MAINW_->getBestSeries()->isChecked();
  int onlyGreen = 0;
  int onlyRed = 0;

  nbBloc_ = 0;
  for(i=0 ; i<NBBLOC ; i++){
    b= seq[numSeq_].bloc[i];
    s = segm[b.seg];
    if( b.beg<=base && b.end>=base ){
      s = segm[b.seg];
      //if( s.sco>=scoMin && s.identity>=identityMin && s.lgaln>=lenghtMin && (!bck || s.bestSeries) ){
      if( isDrawable(s, scoMin, identityMin, lenghtMin, bck, onlyGreen, onlyRed) ){
	tabBloc_[nbBloc_] = i;
	nbBloc_++;
      }
    }
  }
}

void MF_Sequence::clickOnSequence(int base)
{
  if(tabBloc_)
    free(tabBloc_);
  loadTabClicked(base);

  /* Activates or Deactivates the buttons that allows user to switch from one bloc to another. */
  if(nbBloc_>1)
    _MAINW_->activerParcBloc();
  else
      _MAINW_->desactiverParcBloc();

  showNextBloc();
}


void MF_Sequence::handle_push(void)
{
  int cx, cy;
  int base;
  double rapport = MF_Values::rapport();
  MF_MyScroll * ms = (MF_MyScroll *)this->parent();

  cx = Fl::event_x();
  cy = Fl::event_y();

  base = (int) ( ( ms->shift() + cx - leftMarg_ - x() )*rapport );

  if(base<0 || base>seq[numSeq_].lg)
	  return;

  /* Checks if the action to be performed on that click is a zoom or an alignment on the bloc. */
  int isZoom = _MAINW_->getZoomer()->getZoom();
  if(isZoom && base>0){
    if(isZoom==1){
      MF_Values::rapport(MF_Values::rapport()*0.7);
    }
    if(isZoom==-1){
      MF_Values::rapport(MF_Values::rapport()*1.3);
    }

    if( MF_Values::rapport()<1.0 )
      MF_Values::rapport( (double)1.0 );
    ms->reAlign();

    rapport = MF_Values::rapport();
    int pos = (int)(base/rapport) + leftMarg_ - cx + x();
    if(pos<0)
      pos = 0;
    ms->reCalibrate(pos);
    ms->redraw();
    return;
  }


  if( cy>(seqY_-2) && cy<(seqY_+seqH_+2) ){
    /* This part of the code deals with 'bad' clicks : if the user clicks in an empty area the program will automaticly search 
       for the nearest bloc. */
    int i = 0;
    int done=0;
    if(tabShown_[base]>-1)
      done = 1;
    
    while( !done && i<seq[numSeq_].lg/2 ){
      if( (base+i)<seq[numSeq_].lg && tabShown_[base+i]>-1 ){
	base += i;
	done = 1;
      }
      if( (base-i)>-1 && tabShown_[base-i]>-1 ){
	base -= i;
	done = 1;
      }
      i++;
    }
	if(!done)
		return;

    clickOnSequence(base);
  }

  if(clickOnFeat(cy)!=-1){
    displayFeat(cx, base);
  }

}



void MF_Sequence::displayFeat(int cx, int numBase)
{
  int i;
  double rapport = MF_Values::rapport();
  int margp = (int)(3*rapport);
  int * tab;
  int nb = 0;
  //  printf("Click sur seq:%d  . base:%d\n", ns, numBase);

  struct FEATURE f;
  for(i=0 ; i<NBFEAT ; i++){
    f = tab_feat[i];
    if( f.deb<(numBase+margp) && f.fin>(numBase-margp)  )
      // printf("Feature %-12s  %8d .. %-8d  %s\n", f.col, f.deb, f.fin, f.lab);
      nb++;
  }
  tab = (int *)malloc(NBFEAT*nb);
  nb = 0;
  for(i=0 ; i<NBFEAT ; i++){
    f = tab_feat[i];
    if( f.nseq==numSeq_ && f.deb<(numBase+margp) && f.fin>(numBase-margp)  ){
      tab[nb]=i;
      nb++;
    }
  }
  _MAINW_->getFeatDisp()->afficheFeat(tab, nb);
}


/* int MF_Bin::clickOnFeat(int cx, int cy)
   Says whether a click concerns a feature or not.
   Returns a feature number or -1
*/
int MF_Sequence::clickOnFeat(int cy)
{
  int i;
  int marg = 8;
  for(i=0 ; i<2 ; i++){
    if( cy>(topFeat_-marg) && cy<(downFeat_+marg))
      return i;
  }
  return -1;
}

/* FL_EXPORT int MF_Sequence::handle(int e)
   The virtual method given by the FLTK library and wich has to be overwrited to catch 
   and handle events.
*/
FL_EXPORT int MF_Sequence::handle(int e)
{
  if(e){
    switch(e){
    case FL_PUSH :
      handle_push();
      return 1;
      break;
    default :
      break;
    }
  }
  return (0);
}

void MF_Sequence::leftMarg(int leftMarg){ leftMarg_ = leftMarg; }

int MF_Sequence::leftMarg(void){ return this->leftMarg_; }
int MF_Sequence::seqY(void){ return this->seqY_; }




/********************************************************************************************************/
/********************************************************************************************************/
/********************************************************************************************************/
/********************************************************************************************************/



/********************************************************************************************************/
/*			FUNCTONS THAT DEAL WITH PDF CREATION						*/
/********************************************************************************************************/


void MF_Sequence::drawPDF(PDF *p, int _DECX_, int _DECY_, int all)
{
  if(NBBLOC<1 || NBSEG<1)
    return;

  int i, j;
  int sdeb,sfin,  ssize;
  int de, db, rectBeg, rectEnd;
  uchar red, green, blue;
  double dred, dgreen, dblue;
  struct BLOC b;

  MF_MyScroll * ms = (MF_MyScroll *)this->parent();
  double shift =  ms->shift()-leftMarg_;
  double rapport = MF_Values::rapport();
  int firstBase = (int)(shift*rapport);

  if(all==1)
    firstBase = (int)( (0-leftMarg_)*rapport);

  if(numSeq_==0)
    seqY_ = y()+ h() - MF_Values::SEQSPACE();
  else
    seqY_ = y() + MF_Values::SEQSPACE();;

  int seqY = y()+seqY_;

  int bck = _MAINW_->getBestSeries()->isChecked();
  int onlyRed = 0;
  int onlyGreen = 0;

  /* FIRST PART : displaying the blocs */
  float scoMin = MF_Values::scoMin();
  float identityMin = MF_Values::identityMin();
  int lenghtMin = MF_Values::lenghtMin();
  for(i=0 ; i<NBBLOC ; i++){
    b = seq[this->numSeq_].bloc[i];

    if( !isDrawable(segm[b.seg], scoMin, identityMin, lenghtMin, bck, onlyGreen, onlyRed) )
      continue;

    if(all==0 && b.end < firstBase)
      continue;

    db = b.beg;
    de = b.end;

    rectBeg = b.beg;
    rectEnd = b.end;


    /* For each BLOC we have to check if it can be displayed on the screen by checking where the curent BLOC is 
       visible in the previously initialized tabShown_ table.
    */
    for(j=rectBeg ; j<=b.end ; j++){
      for( ; j<=b.end && tabShown_[j]!=i ; j++ )
	;
      if(all==0 && j>b.end)
	break;
      rectBeg = j;
      
      for( ; j<b.end && tabShown_[j]==i ; j++ )
	;
      rectEnd = j;

      
      sdeb = (int)( (rectBeg-firstBase)/rapport);
      sfin = (int)( (rectEnd-firstBase)/rapport);
      /*
      if(sfin>w()){
	sfin=w();
      }
      */
      ssize = (int)(sfin-sdeb);
      /* If the bloc's size is too small to occupate one pixel on the screen, the size is fixed to one pixel so that the bloc can be seen */
      if(ssize<1){
	ssize=1;
	//printf("BLOC TROP PETIT\n");
      }
      //fl_rectf(x()+sdeb, seqY_, ssize, seqH_, get_color(b.sim));

      Fl::get_color(get_color(b.sim), red, green, blue);

      dred = (double)(red/(double)255);
      dgreen = (double)(green/(double)255);
      dblue = (double)(blue/(double)255);

      //printf("%.1f --> [%.3f.%.3f.%.3f]\n", b.sim, dred, dgreen, dblue);

      PDF_setcolor(p, "fill", "rgb", dred, dgreen, dblue, 0);
      PDF_rect(p, (float)(_DECX_+sdeb), (float)(_DECY_+seqY_), (float)ssize, (float)seqH_ );
      PDF_fill(p);
    }
  }


  sdeb = (int)((0-firstBase)/rapport);
  sfin = (int)((seq[numSeq_].lg - firstBase)/rapport);
  ssize = sfin-sdeb;
  //fl_rect(x()+sdeb, seqY_, ssize, seqH_);

  PDF_setcolor(p, "stroke", "rgb", (double)0.0, (double)0.0, (double)0.0, (double)0.0);
  PDF_setlinewidth(p, (double)0.5 );
  PDF_rect(p, (float)(_DECX_+sdeb), (float)(_DECY_+seqY_), (float)ssize, (float)seqH_ );
  PDF_stroke(p);


  /*******************************************************************************************************/
  /* SECOND PART : displaying the scale. */
  /* Determination of the interval between two graduations on the scale. */
  int  tabGrad[NBGRAD] = {1, 5, 10, 25, 50, 100, 200, 500, 1000, 2000, 5000, 10000, 20000, 50000, 100000, 200000, 500000, 1000000 , 2000000, 5000000};
  int bmax = seq[numSeq_].lg;
  char val[16];
  sprintf(val, "%d\0", bmax);
  int tw, th;
  tw = th = 0;
  fl_measure(val, tw, th);

  bmax = 0;
  while( ((int)(tabGrad[bmax]/rapport))<tw+10 ){
    bmax++;
  }
  /* tabGrad[bmax] is the interval that allows us to displays the graduations with at least 10 pixels between each graduation. */

  int pas = tabGrad[bmax];
  for(i=firstBase ; (i%pas)!=0 ; i++)
    ;

  int posx, posy;
  if(numSeq_==0)
    posy = seqY_ - 16;
  else
    posy = seqY_ + seqH_ + 2;


  posx = (int)((i-firstBase)/rapport);
  bool full = false;

  int font = PDF_load_font(p, "Helvetica", 0, "host", "");
  PDF_setfont(p, font, 8);
  PDF_setcolor(p, "fillstroke", "rgb", 0.0, 0.0, 0.0, 0.0);

  int stop = ms->w();
  if(all==1)
    stop = ms->getFullSize();
  while(posx<stop && !full){
    sprintf(val, "%d\0", i);
    if(i>-1){

      PDF_set_text_pos(p, (float)(_DECX_+posx), (float)(_DECY_+posy));      
      PDF_show(p, val);
      //fl_draw(val , x()+posx , posy);
    }
    i+=pas;
    posx = (int)((i-firstBase)/rapport);
    if(i>seq[numSeq_].lg)
      full = true;
  }
  /* END of the Scale */
  /****************************************************/

  /*******************************************************************************/
  /* THIRD PART : Displaying the features (if there are some features) */
  if( numSeq_ == 0 )
    posy = seqY_-40;
  else
    posy = seqY_+seqH_+40;

  struct FEATURE f;
  for(i=0 ; i<NBFEAT ; i++){
    f = tab_feat[i];
    if( f.nseq==numSeq_ ){
      drawFeatPDF(p, f, posy, firstBase, rapport, _DECX_, _DECY_);
      // printf("Seq:%d . f.col:%s . (%d-%d) f.lrg:%.2f \n", numSeq_, f.col, f.deb, f.fin, f.lrg);
    }
  }
  /*******************************************************************************/
}


void MF_Sequence::drawFeatPDF(PDF *p, struct FEATURE f, int posy, int firstBase, double rapport, int _DECX_, int _DECY_)
{
  int sdeb, sfin, ssize;
  uchar red, green, blue;
  double dred, dgreen, dblue, h, cy;

  _DECY_ -= 10;

  sdeb = (int)( (f.deb-firstBase)/rapport);
  sfin = (int)( (f.fin-firstBase)/rapport);
  ssize = sfin-sdeb;
  if(ssize<1)
    ssize = 1;
  h = (double)(14*f.lrg);
  cy = (double)( posy + (double)(h/2) );

  if(cy<topFeat_)
    topFeat_ = (int)cy;
  if(posy+h>downFeat_)
    downFeat_ = posy+(int)(h/2);

  Fl::get_color(getColor(f.col), red, green, blue);
  dred = (double)(red/(double)255);
  dgreen = (double)(green/(double)255);
  dblue = (double)(blue/(double)255);

  PDF_setcolor(p, "fill", "rgb", dred, dgreen, dblue, 0);
  PDF_rect(p, (float)(_DECX_+sdeb), (float)(_DECY_+cy), (float)ssize, (float)h );
  PDF_fill(p);

  if(ssize>_SIZEMIN_){
    PDF_setcolor(p, "stroke", "rgb", 0.0, 0.0, 0.0, 0.0);
    PDF_setlinewidth( p, (double)0.001 );
    PDF_rect(p,  (float)(_DECX_+sdeb), (float)(_DECY_+cy), (float)ssize, (float)h );
    PDF_stroke(p);
  }
}
