/* MF_Stats.cxx */

#include "MF_Stats.H"


void MF_Stats::draw(void)
{
  fl_rectf(x(), y(), w(), h(), FL_WHITE);

  fl_color(FL_BLACK);
  fl_rect(x(), y(), w(), h());

  fl_font(FL_COURIER, fsize_);
  sprintf(l1_, "Length = %d  Score = %.1f\0", lg_, score_);
  sprintf(l2_, "Identity = %.2f %c Gap Frequency %.1f %c\0", ident_, '%', gapf_, '%');

  fl_draw(l1_, x(), y()+10, w(), fsize_, FL_ALIGN_CENTER);

  fl_draw(l2_, x(), y()+fsize_+30, w(), fsize_, FL_ALIGN_CENTER); 

}


MF_Stats::MF_Stats(int x, int y, int w, int h)
  : Fl_Widget(x, y, w, h)
{
  fsize_ = 12;
  lg_ = 0;
  score_ = 0.0;
  gapf_ = 0.0;
  ident_ = 0.0;
}

void MF_Stats::afficher(int lg, float score, float ident, float gapf)
{
  lg_ = lg;
  score_ = score;
  ident_ = ident;
  gapf_ = gapf;
  redraw();
}
