/* MF_Text.cxx */

#include "MF_Text.H"
#include "MF_MainWindow.H"


#ifdef __APPLE__
#define _CR_ '\r'
#else
#define _CR_ '\n'
#endif

extern MF_MainWindow * _MAINW_;


MF_Text::MF_Text(int x, int y, int w, int h)
  : Fl_Text_Display(x,y,w,h){
  this->buf_ = new Fl_Text_Buffer();
}

void MF_Text::afficheBloc(int numbloc, int numSeq)
{
  int i, j, lgaln, firstBase, numseg;
  float ident, gapf;
  char *txt;

  if(numbloc<0)
    return;

  numseg = seq[numSeq].bloc[numbloc].seg;
  BLOC b = seq[numSeq].bloc[numbloc];

  get_aln(numseg, &ident, &gapf, &lgaln, numbloc);

  _MAINW_->getStats()->afficher(lgaln, seq[numSeq].bloc[numbloc].sco, ident, gapf);

  this->ident_ = ident_;
  this->gapf_ = gapf_;
  this->lgaln_ = lgaln_;

  
  txt = (char *)malloc((LINAL+1)*4*nb_ligne_aln);
  txt[0]= '\0';


  j = 0;
  char *zz = txt;
  int k;

  for(i=0 ; i<nb_ligne_aln ; i++){
    for(k=0 ; seq_alignee[i][k]!='\0' ; k++, j++)
      txt[j] = seq_alignee[i][k];
    txt[j++]='\n';
  }
  txt[j] = '\0';

  buf_->text(txt);
  free(txt);   

  textfont(FL_COURIER);
  textsize(13);
  
  this->buffer(buf_);

  b = seq[numSeq].bloc[numbloc];
  if(numSeq==0)
    firstBase = b.beg - segm[b.seg].beg0;
  else
    firstBase = b.beg - segm[b.seg].beg1;


  firstBase = firstBase/82;
  firstBase *= 4;
  firstBase += 1;
  this->scroll(firstBase, 0);
}

void MF_Text::raz(void)
{
  buf_->text("\0");
  this->buffer(buf_);  
}
