/* MF_Zoomer.H */

#ifndef _MF_ZOOMERH_
#define _MF_ZOOMERH_

#include <FL/Fl.H>
#include <FL/Fl_GIF_Image.H>

#include "globals.h"
#include "lalnview.h"
#include "MF_Text.H"
#include "MF_Next.H"


#define IMAGESIZE 6301

/* class MF_Zoomer
   Displays a box containing the two buttons used for the zoom.
*/
class MF_Zoomer : public Fl_Widget {
public :
  FL_EXPORT void draw(void);
  MF_Zoomer(int x, int y, int w, int h);

  void desactiver();
  void activer();
  int getZoom(void);
  void flip(Fl_Button * b);

  Fl_Pixmap *imgPlus_;
  Fl_Pixmap * imgMinus_;
  Fl_Pixmap * imgPlusA_;
  Fl_Pixmap * imgMinusA_;

private :
  MF_Next * btMore_;
  MF_Next * btLess_;
  Fl_Button * btWhole_;

  int btLessX_, btLessY_, btLessW_, btLessH_;
  int btMoreX_, btMoreY_, btMoreW_, btMoreH_;
  int decY_;
  int fsize_;
};

void button_cb(Fl_Widget *w);
void btWhole_cb(Fl_Widget *w);

#endif
