/* MF_Zoomer.cxx */

#include<FL/Fl_Bitmap.H>

#include "MF_Zoomer.H"
#include "MF_MainWindow.H"
#include "init.H"
#include "xpms.H"

extern MF_MainWindow * _MAINW_;


/* void button_cb(Fl_Widget *w)
   The callback method wich is called when one of the button is pressed (or unpressed).
*/
void button_cb(Fl_Widget *w)
{

  Fl_Button * b = (Fl_Button *)w;
  _MAINW_->getZoomer()->flip(b); /* flip will set the value of the buttons (pushed or relaxed) */
}


void btWhole_cb(Fl_Widget *w)
{
  if(_MAINW_->getScroll()==NULL)
    return;
  _MAINW_->getScroll()->zoomWhole();
}


MF_Zoomer::MF_Zoomer(int x, int y, int w, int h)
  : Fl_Widget(x,y,w,h)
{
  int wx, wy, wh, ww;

  /* All the stuff that deals with where to put the widgets (buttons) on the screen. */
  btMoreX_ = x+5;
  btMoreY_ =  y + 6;
  btMoreW_ = (w-16)/2;
  btMoreH_ = (int)(h - 25);

  btLessX_ = btMoreX_ + btMoreW_+4;
  btLessY_ = btMoreY_;
  btLessW_ = btMoreW_;
  btLessH_ = btMoreH_;


  /* matrixPLus and matrixMinus contain datas for pixmap images corresponding to the two magnifying glass.
   They are defined in file xpms.H */
  imgPlus_ = new Fl_Pixmap((const char * const *)matrixPlus);
  imgMinus_ = new Fl_Pixmap((const char * const *)matrixMinus);

  imgPlusA_ = new Fl_Pixmap((const char * const *)loupe_plus_active);
  imgMinusA_ = new Fl_Pixmap((const char * const *)loupe_moins_active);
  
  btMore_ = new MF_Next(-1, btMoreX_, btMoreY_, btMoreW_, btMoreH_, NULL);
  btLess_ = new MF_Next(1, btLessX_, btLessY_, btLessW_, btLessH_, NULL);

  /* Sets the image displayed as a label for the buttons. */
  btMore_->image(imgPlus_);
  btLess_->image(imgMinus_);

  parent()->add(btMore_);
  parent()->add(btLess_);

  btMore_->value(0);
  /* Sets the callback methods associated with the buttons. */
  btMore_->callback(button_cb);
  btLess_->callback(button_cb);

  wx = btMore_->x();
  wy = btMore_->y()+btMore_->h()+3;
  wh = 14;
  ww = (btLess_->x()+btLess_->w())-btMore_->x();

  /* BtWhole_ is the button that makes the image fit in the screen. */
  btWhole_ = new Fl_Button(wx, wy, ww, wh, "whole\0");
  parent()->add(btWhole_);
  btWhole_->callback(btWhole_cb);
}

void MF_Zoomer::draw(void)
{
  /* We simply have to draw the black rectangle that circles the area. */
  fl_color(FL_BLACK);
  fl_rect(x(), y(), w(), h());
}

/* void MF_Zoomer::desactiver()
   Deactivates the zoom buttons.
*/
void MF_Zoomer::desactiver()
{
  btMore_->deactivate();
  btLess_->deactivate();
}

/* void MF_Zoomer::activer()
   Activates the zoom buttons.
*/
void MF_Zoomer::activer()
{
  btMore_->activate();
  btLess_->activate();
}

/* int MF_Zoomer::getZoom(void)
   Returns :
   +1 if the zoom+ (zoom More) button is on
   -1 if the zoom- (zoom Less) button is on
   0  if both zoom+ and zoom- are off
*/
int MF_Zoomer::getZoom(void)
{
  if( btMore_->value()==1 )
    return 1;
  if( btLess_->value()==1 )
    return -1;
  return 0;
}

/* void MF_Zoomer::flip(Fl_Button * b)
   Inverts the value of the button 'b' (if b was on (=pressed) it is turned off (=relaxed), if b was off it is turned on)
   and update the status of the other button in order to prevent both zoom+ and zoom- to be ON.
*/
void MF_Zoomer::flip(Fl_Button * b)
{
  int ww = b->w();
  int hh = b->h();

  Fl_Button * b2;
  
  if(b==btMore_)
    b2 = btLess_;
  else
    b2 = btMore_;

  if(b->value()==1){
    b->value(0);
  } else {
    b->value(1);
    b2->value(0);
  }

  if( btMore_->value()==1 )
    btMore_->image(imgPlusA_);
  else
    btMore_->image(imgPlus_);

  if( btLess_->value()==1 )
    btLess_->image(imgMinusA_);
  else
    btLess_->image(imgMinus_);
}

