/* MenuCb.cxx */

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>

#include <FL/Fl_Double_Window.H>
#include <FL/Fl_Pack.H>
#include <FL/Fl_Hold_Browser.H>
#include <FL/fl_ask.H>

#include "MenuCb.H"
#include "MF_About.H"
#include "MF_Values.H"


extern MF_MainWindow * _MAINW_;
extern int NBFEAT;



#define FL_max(a,b)      ( (a) > (b) ? (a):(b) )
#define FL_min(a,b)      ( (a) < (b) ? (a):(b) )

typedef struct {
  Fl_Widget *br_item, *box;
  void *in;
} browser_struct;


void open_cb(){
  char * fic = MG_input_file_chooser("Open", "", "");
  if(!fic)
    return;

  charger_fichier(fic);
}

void export_PDF_cb(void)
{

  if( NBBLOC<1 || NBSEQ<1 || NBSEG<1 ){
    fl_alert("No sequence in memory. PDF export aborted.");
    return;
  }

  int choice = fl_choice("Please select what part of the alignment you want to export", "Cancel", "Current window only", "whole alignment");
  //printf("Choice : %d\n", choice);

  if(choice==0)
    return;

  choice--;

  char *fic = (char *)"hello.pdf";
  fic = MG_output_file_chooser("Save as", "", "");
  if(!fic)
    return;
  _MAINW_->getScroll()->exportPDF((char *)fic, choice);
}

void save_bmp_cb(void)
{
  char *fic = MG_output_file_chooser("Save as", "", "");

  if( !fic )
    return;

  _MAINW_->make_current();
  _MAINW_->redraw();

  _MAINW_->getScroll()->captToBmp(fic);
}


void close_cb()
{
  exit(0);
}


void save_scale_cb()
{
  int res;
  char *fic = MG_output_file_chooser("Save scale as", "", "");
  if( !fic )
    return;
  res = saveColorScale(fic);
  if(res==-1){
    fl_alert("Impossible to save the scale into the file '%s'.", fic);
  }
}


void load_scale_cb()
{
  int res;
  char *fic = MG_input_file_chooser("Load scale colors file", "", "");
  if( !fic )
    return;
  res = loadColorScale(fic);
  if(res==-1){
    fl_alert("Impossible to access the file '%s'", fic);
  }
  if(res==-2){
    fl_alert("Warning, the file '%s' does not seem to be in coorect format.", fic);
  }
}


void open_features_cb()
{
  char *fic = MG_input_file_chooser("Open features file", "", "");
  if(!fic)
    return;
  _MAINW_->fullUpdatePanel();
  get_feature(fic);
  int i;
  struct FEATURE f;
  for(i=0 ; i<NBFEAT ; i++){
    f = tab_feat[i];
    //printf("%d. %.2f %s\n", f.nseq, f.lrg, f.col);
  }
}


void bestScore_cb()
{
  if(NBSEQ<2 || NBBLOC<1)
    return;

  const Fl_Menu_Item * it = _MAINW_->getMenuItems();
  const int val = it[_MENU_BEST_].value();

  if(val){
    _MAINW_->bestFirst(1);
  }
}


void worseScore_cb()
{
  if(NBSEQ<2 || NBBLOC<1)
    return;

  const Fl_Menu_Item * it = _MAINW_->getMenuItems();
  const int val = it[_MENU_WORSE_].value();

  if(val){
    _MAINW_->bestFirst(0);
  }
}


void save_aln_cb()
{
  if(NBBLOC<1){
    fl_alert("No sequence in memory.");
    return;
  }

  char *fic = MG_output_file_chooser("Save alignment in file", "", "");
  if( !fic )
    return;

  FILE * nf = fopen(fic, "w");
  if(!nf){
    fl_alert("Impossible to open file %s.", fic);
    return;
  }
  save_aln_proc(nf);
}


void save_aln_proc(FILE * fic)
{
  int ii, jj, lgaln;
  float gapf, ident;
  int nbmiss = 0;

  float seuil_score_sim = MF_Values::scoMin();
  float seuil_identity = MF_Values::identityMin();
  int seuil_lenght = MF_Values::lenghtMin();

  fprintf(fic, "%s\n", sim_parameter);
  fprintf(fic, "Sequence 1: %-20.20s %d residues\n", seq[0].name, seq[0].lg);
  fprintf(fic, "Sequence 2: %-20.20s %d residues\n\n", seq[1].name, seq[1].lg);

  fprintf(fic, "List of local alignments with score >= %.1f , identity >= %.2f%c and lenght > %d\n", 
	  seuil_score_sim, seuil_identity, '%', seuil_lenght);
  fprintf(fic, "----------\n");


  for(ii = 0; ii < NBSEG; ii++) {
    if(segm[ii].sco < seuil_score_sim || segm[ii].identity < seuil_identity || segm[ii].lgaln < seuil_lenght) {nbmiss++; continue;}
    //printf("GET ALN, numseg : %3d - numbloc : %3d\n", ii+1, -1);
    get_aln(ii+1, &ident, &gapf, &lgaln, -1);

    fprintf(fic, "%3.1f%% identity in %d residues overlap; Score: %.1f; Gap frequency: %3.1f%%\n\n",
	    ident, lgaln, segm[ii].sco, gapf);
    for(jj = 0; jj < nb_ligne_aln; jj++) {
      fprintf(fic, "%s\n", seq_alignee[jj]);
    }
    
    fprintf(fic, "----------\n");
  }

  if(nbmiss > 0) 
    fprintf(fic, "WARNING: %d local alignments have not been reported because of score < %.1f\n", nbmiss, seuil_score_sim);

  fclose(fic);
}


void about_cb(){ _MAINW_->about(); }

char *get_next_help_line(void *in, char *line, int lline)
{
#ifdef WIN32
  static const char match[] = "WIN32";
#elif defined(__APPLE__)
  static const char match[] = "__APPLE__";
#else
  static const char match[] = "unix";
#endif
  static int accept = true;
  static int found = false;
  if( read_next_help_line(line, lline, in) == NULL) { accept = true; return NULL; }
  while(*line != '#') {
    if(accept) return line;
    if( read_next_help_line(line, lline, in) == NULL) { accept = true; return NULL; }
  }
  if(strncmp(line, "#ifdef", 6) == 0 || strncmp(line, "#if ", 4) == 0) {
    accept =  ( strstr(line, match) != NULL ) ;
    found = accept;
  }
  else if(strncmp(line, "#elif", 5) == 0) {
    if(found) accept = false;
    else if( strstr(line, match) != NULL ) {
      accept = true; found = true;
    }
  }
  else if(strncmp(line, "#else", 5) == 0) {
    if(found) accept = false;
    else {
      accept = true; found = true;
    }
  }
  else if(strncmp(line, "#endif", 6) == 0) {
    accept = true;
  }
  else
    accept = true;  // should not occur
  return get_next_help_line(in, line, lline);
}


#ifdef __APPLE__

char *read_next_help_line(char *line, int lline, void *v_in)
{
  static char *pos;
  char *in, *l = line;
  
  in = (char *)v_in;
  if(line == NULL) {
    pos = in;
    return NULL;
  }
  in = pos - 1;
  do	*(line++) = *(++in); while(*in != 0 && *in != '\n' && *in != '\r');
  if(*in == 0) return NULL;
  pos = ++in;
  *line = 0;
  return l;
}
#endif


void browser_titres_callback(Fl_Widget *ob, void *data)
{
  int reponse;
  static char line[200];
  const char *p;
  browser_struct *br_data;
  int w;
  int charwidth, newwidth, maxl;
  Fl_Browser *browser_item;

  reponse = ((Fl_Browser*)ob)->value();
  if(reponse == 0) return;
  br_data = (browser_struct *)data;
  p = ((Fl_Browser*)ob)->text(reponse);
#ifdef __APPLE__
  get_next_help_line(br_data->in, NULL, 0);
#else
  rewind((FILE *)br_data->in);
#endif
  br_data->box->hide();
  browser_item = (Fl_Browser *)br_data->br_item;
  browser_item->clear();
  while( get_next_help_line( br_data->in, line, sizeof(line)) != NULL) {
    if(strncmp(line, ">>>", 3) != 0) continue;
    line[ strlen(line) - 1 ] = 0;
    if(strcmp(line+3, p) != 0) continue;
    maxl = 0;
    while( get_next_help_line(br_data->in, line, sizeof(line)) != NULL && 
	   strncmp(line, ">>>", 3) != 0 ) {
      line[ strlen(line) - 1 ] = 0;
      if(*line == 0) strcpy(line," ");
      browser_item->add(line);
      maxl = FL_max(maxl, (int)strlen(line));
    }
    /* agrandir fenetre si pas assez large */
    w = browser_item->w();
    fl_font( browser_item->textfont(), browser_item->textsize() );
    charwidth = (int)fl_width('W');
    maxl++;
    if( w < maxl * charwidth) {
      newwidth = ob->window()->w() + (maxl * charwidth - w);
      ob->window()->size(newwidth, ob->window()->h() );
    }
    br_data->box->label(p);
    break;
  }
  br_data->box->show();
}


void browser_ok_callback(Fl_Widget *ob, long which)
{
  ob->window()->hide();
}


void help_callback(Fl_Widget *ob, void *data)
{
  static browser_struct browser_data;
  static int first = true;
  static Fl_Window *help_form;
 
  if(first) {
    char line[85];
    Fl_Browser *browser_titres, *browser_item;
    Fl_Button *ok_button;
    Fl_Widget *br_item_label;
    int titres_width, fin_titres;
#ifdef __APPLE__
    get_next_help_line(data, NULL, 0);
#else
    data = (void *)fopen( (char *)data, "r" );
#endif
    if(data == NULL) {
      fl_alert(
#ifdef __APPLE__
	       "No help information in program resources"
#else
	       "Help file not found in PATH directories nor in current directory.\nCheck your .lalnviewrc file or put a copy of 'lalnview.help' in your HOME directory."
#endif
	       );
      return;
    }
    first = false;
    help_form = new Fl_Window( 705, 350);
    help_form->label("Help");
    help_form->box(FL_FLAT_BOX);
    fl_font(FL_HELVETICA, 12);
    titres_width = (int)fl_width("XXXXXX"); /* mieux ensuite */
    browser_titres = new Fl_Hold_Browser(5, 20, titres_width, 
					 help_form->h() - 50, "Choose help item");
    browser_titres->textsize(12);
    browser_titres->has_scrollbar(Fl_Browser_::VERTICAL);
    browser_titres->callback(browser_titres_callback, &browser_data);
    browser_titres->align(FL_ALIGN_TOP);
    browser_titres->color(FL_LIGHT1, browser_titres->selection_color());
    while( get_next_help_line(data, line, sizeof(line)) != NULL) {
      if(strncmp(line, ">>>", 3) != 0) continue;
      line[ strlen(line) - 1 ] = 0;
      browser_titres->add(line+3);
      titres_width = FL_max(titres_width, 
			    (int)fl_width(line + 3) + (int)fl_width("XX") );
    }
    ((Fl_Widget*)browser_titres)->size(titres_width, browser_titres->h() );
    ok_button = new Fl_Button(5,help_form->h() - 25, titres_width,20,"OK");
    ok_button->callback(browser_ok_callback, 0);
    fin_titres = titres_width + 10;
    browser_item = new Fl_Browser(fin_titres, 20, 
				  700 - fin_titres, help_form->h() - 25, "");
    browser_item->has_scrollbar(Fl_Browser_::VERTICAL);
    browser_item->align(FL_ALIGN_TOP);
    browser_item->color(FL_LIGHT1, browser_item->selection_color());
    browser_item->textsize(12);
    browser_item->textfont(FL_COURIER);
    br_item_label = new Fl_Box(FL_NO_BOX, fin_titres, 0, 
			       700 - fin_titres, 20, "Help Info");
    br_item_label->align(FL_ALIGN_CENTER);
    browser_data.box = br_item_label;
    browser_data.br_item = browser_item;
    browser_data.in = data;
    help_form->add_resizable(
			     *new Fl_Box(browser_item->x(), browser_item->y(),
					 browser_item->w(), browser_titres->h() ) );
    help_form->end();
  }
  help_form->show();
}


void greenListAdd_cb(void)
{
  int segNum = _MAINW_->getScroll()->getLastSegment();
  if( segNum>-1 )
    segm[segNum].myList = _LIST_GREEN_;
  _MAINW_->fullUpdatePanel();
}


void greenListRemove_cb(void)
{
  int segNum = _MAINW_->getScroll()->getLastSegment();
  if( segNum>-1 && segm[segNum].myList==_LIST_GREEN_ )
    segm[segNum].myList = 0;
  _MAINW_->fullUpdatePanel();
}

void greenListErase_cb(void)
{
  int i;
  for(i=0 ; i<NBSEG ; i++){
    if( segm[i].myList == _LIST_GREEN_ )
      segm[i].myList = 0;
  }
  _MAINW_->fullUpdatePanel();
}


void redListAdd_cb(void)
{
  int segNum = _MAINW_->getScroll()->getLastSegment();
  if( segNum>-1 )
    segm[segNum].myList = _LIST_RED_;
  _MAINW_->fullUpdatePanel();
}

void redListRemove_cb(void)
{
  int segNum = _MAINW_->getScroll()->getLastSegment();
  if( segNum>-1 && segm[segNum].myList==_LIST_RED_ )
    segm[segNum].myList = 0;
  _MAINW_->fullUpdatePanel();
}

void redListErase_cb(void)
{
  int i;
  for(i=0 ; i<NBSEG ; i++){
    if( segm[i].myList == _LIST_RED_ )
      segm[i].myList = 0;
  }
  _MAINW_->fullUpdatePanel();
}

