#ifndef _BMP_H_
#define _BMP_H_

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>

#include <FL/Fl.H>

typedef struct {
  char bfType[2];
  unsigned char bfSize[4];
  unsigned char bfReserved1[2];
  unsigned char bfReserved2[2];
  unsigned char bfOffBits[4];
} bmfh;

typedef struct {
  unsigned char biSize[4];
  unsigned char biWidth[4];
  unsigned char biHeight[4];
  unsigned char biPlanes[2];
  unsigned char biBitCount[2];
  unsigned char stuff1[16];
  unsigned char biClrUsed[4];
  unsigned char biClrImportant[4];
} bmih;


static int charArray2Int(unsigned char * b, int s, int f);
static void int2bytes2(unsigned char * bytes, int value);
static void int2bytes4(unsigned char * bytes, int value);
int saveBMP( uchar * pic, int width, int height, char * filename);

#endif
