/* bmp.cxx */

#include "bmp.H"

static int charArray2Int(unsigned char * b, int s, int f)
{
  int ret = 0;
  int i;
  int shift = 0;

  for (i = s; i <= f; i++) {
    ret = ret | ((b[i] & 0xff) << shift);
    shift += 8;
  }
  return ret;
}

static void int2bytes2(unsigned char * bytes, int value)
{
  bytes[0] = (unsigned char)(value & 0xff);
  bytes[1] = (unsigned char)((value >> 8) & 0xff);
}

static void int2bytes4(unsigned char * bytes, int value)
{
  bytes[0] = (unsigned char)(value & 0xff);
  bytes[1] = (unsigned char)((value >> 8) & 0xff);
  bytes[2] = (unsigned char)((value >> 16) & 0xff);
  bytes[3] = (unsigned char)((value >> 24) & 0xff);
}

int saveBMP(uchar * pic, int width, int height, char * filename)
{

  FILE * bout;
  bmfh hdr;
  bmih info;
  int bitsInPixel = 24;  // we always save in 24 bit format
  int i, j, k;

  bout = fopen(filename, "wb");
  if (bout == NULL) {
    fprintf(stderr, "Unable to open specified file: %s\n", filename);
    fprintf(stderr, "Errno: %d, errstring: %s\n", errno, strerror(errno));
    return -1;
  }

  int bytesPerPixel = bitsInPixel / 8;
  int bytesPerRow = width * bytesPerPixel;
  bytesPerRow = (bytesPerRow & 0x3) ? 
    ((bytesPerRow >> 2) + 1) << 2 : bytesPerRow;
  int pad = bytesPerRow - (width * bytesPerPixel);
  int bfOffBits = sizeof(hdr) + sizeof(info);
  int bfSize = (bytesPerRow * height) + bfOffBits;

  memset((void *)&hdr, 0, sizeof(hdr));
  memset((void *)&info, 0, sizeof(info));

  hdr.bfType[0]='B';
  hdr.bfType[1]='M';

  /*
  fprintf(stderr, "bfSize: %d (%lx), bfOffBits: %d (%lx)\n",
	  bfSize, (unsigned long)bfSize,
	  bfOffBits, (unsigned long)bfOffBits);
  */

  int2bytes4(hdr.bfSize, bfSize);
  int2bytes4(hdr.bfOffBits, bfOffBits);

  int nwrite;
  nwrite = fwrite(&hdr, sizeof(hdr), 1, bout);

  int2bytes4(info.biSize, 40);
  int2bytes4(info.biWidth, width);
  int2bytes4(info.biHeight, height);
  int2bytes2(info.biPlanes, 1);
  int2bytes2(info.biBitCount, bitsInPixel);

  // all rest are zero since 24 bit, no color table

  nwrite = fwrite(&info, sizeof(info), 1, bout);

  unsigned char red;
  unsigned char green;
  unsigned char blue;

  unsigned char rgb[3];
  unsigned char padbytes[4] = {'\0', '\0', '\0', '\0'};

  /*
  for(i=width*height*3 ; i>=0 ; i-=3){
    red = (unsigned char)pic[i];
    green = (unsigned char)pic[i+1];
    blue = (unsigned char)pic[i+2];

    rgb[0] = blue;
    rgb[1] = green;
    rgb[2] = red;
    nwrite = fwrite(rgb, 1, 3, bout);

    if (pad != 0) {
      nwrite = fwrite(padbytes, 1, pad, bout);
    }
  }
  */  

  for(i=height-1 ; i>=0 ; i--){
    for(j=0 ; j<width ; j++){
      k = 3*width*i+ j*3;
      red = (unsigned char)pic[k];
      green = (unsigned char)pic[k+1];
      blue = (unsigned char)pic[k+2];
      
      rgb[0] = blue;
      rgb[1] = green;
      rgb[2] = red;
      nwrite = fwrite(rgb, 1, 3, bout);
      
      if (pad != 0) {
	//nwrite = fwrite(padbytes, 1, pad, bout);
      }
    }
    nwrite = fwrite(padbytes, 1, pad, bout);
  }

  
  fclose(bout);
  return 0;
}
