/* disjkstra.cxx */

/*
  This file contains all the functions needed to compute the best series of segments with no overlap.
  As you can guess by the file's name, it is based on the Dijkstra algorithm.
  The idea is to consider the series of segments as a graph in wich each segment is a vertex and an edge 
  exists between two non-overlaping segments.

  Two 'artificials' vertexs are added to the graph :
   - _a_ wich is the first vertex
   - _z_ wich is the last vertex
*/

#include "dijkstra.H"
#include "MF_MainWindow.H"
#include "MF_Values.H"

#define _INF_ -1

extern MF_MainWindow * _MAINW_;

float *W;
SEG * S;
int *PREDEC;
int _a_;
int _z_;
int marg;

int lgMin;
double scoMin, idMin;
  int onlyRed, onlyGreen;

/* bool respect(int i)
   Return true if the segment at S[i] respects the given condition of score, lenght and identity.
*/
bool respect(int i)
{
  SEG s = S[i];

  if( onlyRed ){
    if( s.myList != _LIST_RED_ )
      return false;
    return true;
  }

  if( onlyGreen ){
    if( s.myList != _LIST_GREEN_)
      return false;
    return true;
  }

  if( s.myList == _LIST_RED_ )
    return false;

  if( s.myList == _LIST_GREEN_ )
    return true;

  if( S[i].sco>=scoMin && S[i].lgaln>=lgMin && S[i].identity>=idMin )
    return true;
  return false;
}

/* bool chevauchent(int i, int j)
   Returns true if the segments i and j overlap.
   If the function return false, we can say that there is an edge between i and j.
*/
bool chevauchent(int i, int j)
{
  if( i==_a_ && !respect(j) )
    return true;

  if( j==_z_ && !respect(i) )
    return true;

  if( i!=_a_ && j!=_z_)
    if( !respect(i) || !respect(j) )
      return true;

  if( (S[j].beg0 > S[i].beg0 && S[j].beg1 > S[i].beg1) && (S[j].beg0+marg >= S[i].end0 && S[j].beg1+marg >= S[i].end1) ) 
    return false;

  if( S[i].beg0<=S[j].beg0 && S[i].beg1<=S[j].beg1 && S[i].end0<=(S[j].beg0-marg) && S[i].end1<=(S[j].beg1-marg) )
    return false;

  return true;
}

int fcmp1(const void *s1, const void *s2)
{
  if( ((struct SEG *)s1)->beg0 > ((struct SEG *)s2)->beg0 )
    return 1;
  return -1;
}

void relacher(int f, int g)
{
  float p = W[f] + S[g].sco;
  if( (W[f] != _INF_ && W[g]<p)||(W[f]==_INF_ && W[g]==_INF_) ){
    W[g] = p;
    PREDEC[g] = f;
  }
  return;

  if(W[g]<p){
    //    printf("W[%d]=%.2f\n", g, p);
    W[g] = p;
    PREDEC[g] = f;
  }
}

void afficheSegm(int i)
{
  printf("id:%d . (%d-%d) sco:%.2f . idty:%.2f\n", S[i].id, S[i].beg0, S[i].end0, S[i].sco, S[i].identity);
}

void dijkstra()
{
  int i, j, emax;
  int NBSOM = NBSEG + 2;

  scoMin = MF_Values::scoMin();
  lgMin = MF_Values::lenghtMin();
  idMin = MF_Values::identityMin();

  onlyRed = 0;
  onlyGreen = 0;

  _a_ = NBSEG+1;
  _z_ = NBSEG;
  marg = _MAINW_->getBestSeries()->getMarg();
  //printf("marg : %d\n", marg);

  S = (SEG *)malloc(NBSOM*sizeof(SEG));  
  memcpy(S, segm, (NBSEG*sizeof(SEG)));

  qsort(S, NBSEG, sizeof(SEG), fcmp1);

  if(seq[0].lg>seq[1].lg)
    emax = seq[0].lg+1;
  else
    emax = seq[1].lg+1;

  SEG s1, s2;

  s1.id = _a_;
  s1.sco = 0.0;
  s1.beg0 = s1.beg1 = s1.end0 = s1.end1 = -1;


  s2.id = _z_;
  s2.sco = 0.0;
  s2.beg0 = s2.beg1 = emax;
  s2.end0 = s2.end1 = emax;


  S[_a_] = s1;
  S[_z_] = s2;

  int *ENTR = (int *)malloc(NBSEG*sizeof(int));
  int *SORT = (int *)malloc(NBSEG*sizeof(int));
  W = (float *)malloc(NBSOM*sizeof(float));
  PREDEC = (int *)malloc(NBSOM*sizeof(int));

  for(i=0 ; i<NBSEG ; i++){
    ENTR[i] = 0;
    SORT[i] = 0;
    W[i] = _INF_;
    segm[i].bestSeries = 0; /* segm[i].bestSeries will be set to a non-zero value if it must be displayed in the best series of segments */
    PREDEC[i] = -1;
  }

  W[_a_] = 0;
  W[_z_] = _INF_;

  PREDEC[_a_] = PREDEC[_z_] = -1;

  /* Preparaton of the graph.
   if ENTR[i]!=0 --> there is an incoming edge in segm[i]
   if SORT[i]!=0 --> there is an edge outgoing from segm[i]*/
  for(i=0 ; i<NBSEG ; i++){
    for(j=i+1 ; j<NBSEG ; j++){
      if( !chevauchent(i, j) ){
	ENTR[j]++;
	SORT[i]++;
#ifdef DEBUGLOG_DIJKSTRA
	printf("ENTR.add : %d - SORT.add : %d\n", S[j].id, S[i].id);
#endif
      }
    }
  }
  /******************************************************/


  /* ***********************************************************************************************************
     The first loop deals with the 'artificial' first Vertex (called _a_) wich is the entry point in the graph */
  for(i=0 ; i<NBSEG ; i++){
    if( ENTR[i]==0 && !chevauchent(_a_, i) ){
      relacher(_a_, i);
    }
  }
  /****************************************************************************************************************/


  /* The loop wich deals with all others segments. */
  for(i=0 ; i<NBSEG ; i++){
    for(j=i+1 ; j<NBSEG+1 ; j++){
      if(  !chevauchent(i, j) ){
	relacher(i, j);
      }
    }
  }
  /***************************************************/


#ifdef DEBUG
  printf("Cumulated score of the series : %.2f\n", W[_z_]);
#endif

  int cur = _z_;
  SEG sp;
  i=0;
  int max = 800000;
  int k=-1;

  /*
  for(i=0; i<NBSOM ; i++){
	printf("PREDEC[%d] = %d\n", i, PREDEC[i]);
  }
  */

  while(PREDEC[cur] != -1 && i<max){
    k = PREDEC[cur];
    if(k==-1){
		break;
#ifdef DEBUG
      printf("Erreur dans le PREDEC ... \n");
      //return;
#endif
    }
    for(j=0 ; j<NBSEG && segm[j].id!=S[k].id ; j++)
      ;
    if(j<NBSEG){
      segm[j].bestSeries = 1;
      //printf("segm.id=%d --> bestSeries\n", segm[j].id);
    }
    
    sp = S[PREDEC[cur]];
    //    printf("(%d . %d) sco:%.2f\n", sp.beg0, sp.end0, sp.sco);
    cur = PREDEC[cur];
    i++;

  }

  free(S);
  free(SORT);
  free(ENTR);
  free(PREDEC);
}
