#include <stdio.h>
#include <string.h>


char *my_fgets(char *s, int n, FILE *f)
{
  int next_char, ahead;
  char *p;
  
  p = s;
  while(--n > 0) {
    next_char = getc(f);
    if( next_char == '\r' || next_char == '\n' ) {
      *(p++) = '\n';
      ahead = getc(f);
      if(ahead == EOF) break;
      if( (next_char == '\r' && ahead != '\n') || (next_char == '\n' && ahead != '\r') ) {
	ungetc(ahead, f);
      }
      break;
    }
    else if (next_char == EOF) 
      break;
    *(p++) = next_char;
  }
  *p = 0;
  return (p == s ? NULL : s);
}


#ifdef WIN32

#include <Windows.h>
#include <stdio.h>
#include <conio.h>
#include <direct.h>
#include <stdlib.h>
#include <ctype.h>


char *MG_input_file_chooser(const char* message, const char* pat, const char* fname);
char *MG_output_file_chooser(const char* message, const char* pat, const char* fname);

char *MG_win32_file_chooser(const char* message, const char* pattern, const char* fname, const char* deftext, bool save, int* ptfilterindex);

char *MG_win32_file_chooser(const char* message, // title of dialog window
        const char* pattern, // optional "mase format\0*.mase\0MSF format\0*.msf\0"
        const char* fname, // default file name
        const char* defext, // default filename extension or NULL
        bool save, // TRUE iff output file selection
        int *pfilterindex) // (inout) pointer to index (from 1) in series of file types in pattern
{
  static char filenamebuffer[MAX_PATH];
  static OPENFILENAME wreq;
  bool retval;
  
  memset(&wreq, 0, sizeof(wreq));
  wreq.lStructSize = sizeof(OPENFILENAME); 
  wreq.lpstrFilter = pattern;
  if(pattern == NULL) wreq.nFilterIndex = 0;
  else if(pfilterindex != NULL) wreq.nFilterIndex = *pfilterindex;
  else wreq.nFilterIndex = 1;
  if(defext != NULL) wreq.lpstrDefExt = defext;
  wreq.lpstrFile = filenamebuffer;
  wreq.nMaxFile = MAX_PATH;
  wreq.lpstrTitle = message ? message : "Select the filename";
  if(fname) {
    memset(filenamebuffer, 0, MAX_PATH);
    if((filenamebuffer[1] == ':') && (_getdrive() + 'A' - 1 == filenamebuffer[0]))
      strncpy(filenamebuffer, fname + 2, MAX_PATH);
    else
      strncpy(filenamebuffer, fname, MAX_PATH);
  }
  wreq.Flags = OFN_NOCHANGEDIR | OFN_HIDEREADONLY;
  retval = (save ? GetSaveFileName(&wreq) : GetOpenFileName(&wreq));
  if(save && (pfilterindex != NULL) ) *pfilterindex = wreq.nFilterIndex;
  return retval == 0 ? NULL : wreq.lpstrFile;
}

char *MG_input_file_chooser(const char* message, const char* pat, const char* fname)
{
  char *outfname;
  
  outfname = MG_win32_file_chooser(message, 
				   NULL,
				   fname, 
				   memcmp(pat, "*.", 2) == 0 ? pat+2 : NULL,
				   FALSE, NULL);
  return outfname;
}


char *MG_output_file_chooser(const char* message, const char* pat, const char* fname)
{
  char *outfname;
  
  outfname = MG_win32_file_chooser(message, 
				   NULL,
				   fname, 
				   memcmp(pat, "*.", 2) == 0 ? pat+2 : NULL,
				   TRUE, NULL);
  return outfname;
}


#elif defined(__APPLE__)

#include <FL/filename.H>

extern "C" { 
  void CtoP(const void *in, void *out);
  void PtoC(const void *in, void *out);
  void MG_FSSpecToPathname (FSSpec *myFSS, char *fname, int maxl);
}

static pascal void MyNavEventProc (NavEventCallbackMessage callBackSelector, NavCBRecPtr callBackParms, NavCallBackUserData callBackUD);
int MG_GetInputFName(char *fname, int maxl, char *title);
int MG_GetOutputFName(const char *message, char *fname, int maxl, const char *dfault);
char *MG_output_file_chooser(const char* message, const char* pat, const char* fname);
char *MG_input_file_chooser(const char* message, const char* pat, const char* fname);


void PtoC(const void *in, void *out)
{
  char *vin = (char *)in;
  char *vout = (char *)out;
  int l = *vin;
  
  if(l > 0) memcpy(vout, vin + 1, l);
  vout[l] = 0;
}


void CtoP(const void *in, void *out)
{
  char *vout = (char *)out;
  int l;
  if(in == NULL) l = 0;
  else	{
    l = strlen( (char *)in );
    memcpy(vout + 1, in, l);
  }
  vout[0] = l;
}


void MG_FSSpecToPathname (FSSpec *myFSS, char *fname, int maxl)
{
  FSRef myFSRef, pFSRef;
  FSCatalogInfo myinfo;
  static int  anErr = noErr;
  char *p, *q;
  static char buffer[1000], name[256];
  FSSpec fsspec;

  p = buffer;
  anErr = FSpMakeFSRef(myFSS, &myFSRef);
  while(1) {
    anErr = FSGetCatalogInfo(&myFSRef, kFSCatInfoParentDirID, &myinfo, NULL, &fsspec, &pFSRef);
    PtoC(fsspec.name, name);
    /* add the file or dir name to the end of buffer in reverse orientation */
    q = name + strlen(name) - 1;
    while(q >= name) { *p = *q; q--; p++; }
    if(myinfo.parentDirID == fsRtParID) break; /* detect when top level is reached */
    *p = ':'; p++;
    myFSRef = pFSRef;
  }
  *p = 0;
  /* invert buffer into fname */
  maxl--;
  if(maxl > strlen(buffer)) maxl = strlen(buffer);
  q = buffer + maxl - 1;
  p = fname;
  while(q >= buffer) { *p = *q; q--; p++; }
  fname[maxl] = 0;
}


static pascal void MyNavEventProc (NavEventCallbackMessage callBackSelector,
                                   NavCBRecPtr callBackParms,
                                   NavCallBackUserData callBackUD)
{
  return;
}


int MG_GetInputFName(char *fname, int maxl, char *title)
{
  NavEventUPP         eventProc = NewNavEventUPP(MyNavEventProc);
  OSErr               anErr = noErr;
  FSSpec              fss;
  int         rsult = FALSE;
  NavReplyRecord reply;
  NavDialogOptions options;
  NavGetDefaultDialogOptions(&options);
  CtoP(title, options.windowTitle);
  options.dialogOptionFlags &= ~ kNavAllowPreviews;
  options.dialogOptionFlags &= ~ kNavAllowMultipleFiles;
  options.dialogOptionFlags |=   kNavNoTypePopup;
  

  anErr = NavChooseFile (NULL  , &reply, &options, eventProc, NULL, NULL,
			 NULL , 0);
  if (anErr == noErr && reply.validRecord){
    AEKeyword   theKeyword;
    DescType    actualType;
    Size        actualSize;
    FSSpec      documentFSSpec;
    
    anErr = AEGetNthPtr(&(reply.selection), 1,
			typeFSS, &theKeyword,
			&actualType,&documentFSSpec,
			sizeof(documentFSSpec),
			&actualSize);
    if (anErr == noErr){
      MG_FSSpecToPathname (&documentFSSpec, fname, maxl);
      rsult = TRUE;
    }
    //  Dispose of NavReplyRecord, resources, descriptors
    anErr = NavDisposeReply(&reply);
  }
  DisposeNavEventUPP(eventProc);
  return rsult;
}


int MG_GetOutputFName(const char *message, char *fname, int maxl, const char *dfault)
{
    OSErr               anErr = noErr;
    NavReplyRecord      reply;
    NavDialogOptions    dialogOptions;
    FSSpec              fss;
    OSType              fileTypeToSave = 'TEXT';
    OSType              creatorType;
    NavEventUPP         eventProc = NewNavEventUPP(MyNavEventProc);
    char                filename [256];
    NavMenuItemSpec 	*p;
    int  i, rsult = FALSE;

    reply.translationNeeded = false;
    NavGetDefaultDialogOptions(&dialogOptions);
    CtoP(message, dialogOptions.windowTitle);
    CtoP(dfault, dialogOptions.savedFileName);
    creatorType = kNavGenericSignature;
    anErr = NavPutFile(NULL, &reply, &dialogOptions, eventProc, fileTypeToSave, creatorType, NULL);
    if (anErr == noErr && reply.validRecord)
      {
	AEKeyword   theKeyword;
	DescType    actualType;
	Size        actualSize;
	FSSpec      documentFSSpec;
	
	anErr = AEGetNthPtr(&(reply.selection), 1, typeFSS,
			    &theKeyword, &actualType,
			    &documentFSSpec, sizeof(documentFSSpec),
			    &actualSize );
	if (anErr == noErr)
	  {
	    if (reply.replacing)
	      { /* compute the pathname of the pre-existing file */
		      MG_FSSpecToPathname (&documentFSSpec, fname, maxl);
		      rsult = TRUE;
                    }
	    else
	      { /* the chosen file is new, compute pathname to its directory
		   and append new filename */
		char empty[256];
		FSSpec pfss;
		empty[0] = 0;
		/* make an FSSpec from volume + parentID of documentFSSpec
		 */
		FSMakeFSSpec(documentFSSpec.vRefNum, documentFSSpec.parID,
			     (StringPtr) empty, &pfss);
		/* compute pathname for this FSSpec
		 */
		MG_FSSpecToPathname (&pfss, fname, maxl);
		/* append : new filename to this path
		 */
#if TARGET_RT_MAC_MACHO
		strcat(fname, "/");
#else
		strcat(fname, ":");
#endif
		PtoC(documentFSSpec.name, fname + strlen(fname) );
		anErr = FSpCreate(&documentFSSpec, 'ttxt', 'TEXT', smSystemScript);
		
		rsult = TRUE;
	      }
	    anErr = NavCompleteSave(&reply, kNavTranslateInPlace); 
	  }
      }
    NavDisposeReply(&reply);
    return rsult;
}


char *MG_input_file_chooser(const char* message, const char* pat, const char* fname)
{
  static char pathname[FL_PATH_MAX];
  int ok;
  
  ok =  MG_GetInputFName(pathname, FL_PATH_MAX, (char *)message);
  if( ok ) return pathname;
  else return NULL;
}


char *MG_output_file_chooser(const char* message, const char* pat, const char* fname)
{
  static char pathname[FL_PATH_MAX];
  if( MG_GetOutputFName(message, pathname, FL_PATH_MAX, fname) ) 
    return pathname;
  else return NULL;
}

#else

/* for the X11 GUI */
extern char *fl_file_chooser(const char* message, const char* pat, const char* fname, int relative=0);

char *MG_input_file_chooser(const char* message, const char* pat, const char* fname)
{
  return fl_file_chooser(message, pat, fname, 0);
}

char *MG_output_file_chooser(const char* message, const char* pat, const char* fname);

char *MG_output_file_chooser(const char* message, const char* pat, const char* fname)
{
  return fl_file_chooser(message, pat, fname, 0);
}

#endif
