#include "lalnview.h"
#include "lalnview_utils.H"
#include "globals.h"

void get_aln(int numseg, float *ident, float *gapf, int *lgaln, int numbloc)

{
int ii, jj0, jj1, jj2, kk, jj;
int debseg, endseg, lgbloc, lggap1, lggap2;
char *aln1, *aln2, *aln3, *aln4;
char fragseg[4][LINAL];
int deb0, fin0, deb1, fin1, numl;
int lgfrag; /* longueur du fragment qui apparait dans l'alignement */
int nbid = 0, nbgap = 0;


*lgaln = 0;
/* repere debut et fin du segment */

for(ii = 0; ii < NBBLOC; ii++)
	if(seq[0].bloc[ii].seg == numseg) {
		debseg = ii;
		break;
		}

endseg = debseg;
for(ii = debseg; ii <= NBBLOC; ii++) {
	if(ii == NBBLOC) endseg = NBBLOC;
	else if(seq[0].bloc[ii].seg != numseg) {
		endseg = ii;
		break;
		}
	}


if(numbloc != -1)
	lgfrag = LINAL - 40;
else
	lgfrag = 60;


/* libere la memoire */
if(seq_alignee != NULL) {
	for(ii = 0; ii < nb_ligne_aln; ii++)
	  free(seq_alignee[ii]);
	free((char *)seq_alignee);
}

/* calcule la taille de l'alignement */

for(ii = debseg; ii < endseg; ii++) {

	lgbloc = seq[0].bloc[ii].end - seq[0].bloc[ii].beg + 1;
	
	if(ii != (endseg - 1))
	      lggap1 = max_((seq[0].bloc[ii+1].beg - seq[0].bloc[ii].end - 1),
		          (seq[1].bloc[ii+1].beg - seq[1].bloc[ii].end - 1));
	else lggap1 = 0;

	*lgaln+= (lgbloc + lggap1);

	}


nb_ligne_aln = ceil((double) *lgaln / lgfrag) * 4;
//nb_ligne_aln = (int)ceil( (*lgaln) / lgfrag) * 4;


/* alloue la memoire */

seq_alignee = (char **) calloc(nb_ligne_aln, sizeof(char *));
for(ii = 0; ii<nb_ligne_aln; ii++) {
	seq_alignee[ii] = (char *) check_alloc(LINAL, sizeof(char));
	strcpy(seq_alignee[ii], "\0");
	}

aln1 = (char *) calloc(*lgaln+1, sizeof(char));
aln2 = (char *) calloc(*lgaln+1, sizeof(char));
aln3 = (char *) calloc(*lgaln+1, sizeof(char));
aln4 = (char *) calloc(*lgaln+1, sizeof(char));

/* recupere les alignements */

jj0 = 0;
jj1 = 0;
jj2 = 0;
for(ii = debseg; ii < endseg; ii++) {

	if( ii != (endseg - 1))
		lggap1 = seq[0].bloc[ii+1].beg - seq[0].bloc[ii].end - 1;
	else lggap1 = 0;

	if( ii != (endseg - 1))
		lggap2 = seq[1].bloc[ii+1].beg - seq[1].bloc[ii].end - 1;
	else lggap2 = 0;



	for(kk = seq[0].bloc[ii].beg -1; kk < seq[0].bloc[ii].end; kk++) {
		aln1[jj0++] = seq[0].seq[kk];
		if(ii == numbloc) aln4[jj2++] = '_';
		else aln4[jj2++] = ' ';
		}
	

	for(kk = seq[1].bloc[ii].beg -1; kk < seq[1].bloc[ii].end; kk++) 
		aln2[jj1++] = seq[1].seq[kk];

	kk = seq[1].bloc[ii].end;
	for(jj = 0; jj < lggap2; jj++) {
		aln1[jj0++] = '-';
		aln2[jj1++] = seq[1].seq[kk++];
		aln4[jj2++] = ' ';
		}


	kk = seq[0].bloc[ii].end;
	for(jj = 0; jj < lggap1; jj++) {
		aln2[jj1++] = '-';
		aln1[jj0++] = seq[0].seq[kk++];
		aln4[jj2++] = ' ';
		}

	

	}

/* aln3: la ou on mets les * quand identite */

for(kk = 0 ; kk < *lgaln; kk++) {
	if(aln1[kk] == aln2[kk] && aln2[kk] != '-') {
		aln3[kk] = '*';
		nbid++;
		}
	else {
		aln3[kk] = ' ';
		if(aln1[kk] == '-' || aln2[kk] == '-') nbgap++;
		}

	}

if(*lgaln != 0) {
	*ident = (float) nbid / (*lgaln - nbgap) * 100.0;
	*gapf = (float) nbgap / *lgaln * 100.0;
	}
else {
	*ident = 0.0;
	*gapf = 0.0;
	}



aln4[*lgaln] = aln3[*lgaln] = aln2[*lgaln] = aln1[*lgaln] = '\0';

/* remplit seq_alignee */


kk = 0;

deb0 = seq[0].bloc[debseg].beg;
deb1 = seq[1].bloc[debseg].beg;

cur_num_line = -1;

for(numl = 0 ; numl < nb_ligne_aln; numl+=4) {
	lggap1 = lggap2 = 0;

	for(ii = 0; ii < lgfrag; ii++) {
		fragseg[0][ii] = aln1[kk];
		fragseg[1][ii] = aln2[kk];
		fragseg[2][ii] = aln3[kk];
		fragseg[3][ii] = aln4[kk];
		if(aln3[kk] == '\0') {
			for(; ii < lgfrag; ii++) {
				lggap1++;
				lggap2++;
				}
			break;
			}

		if(aln1[kk] == '-') lggap1++;
		if(aln2[kk] == '-') lggap2++;
		kk++;
		}

	/* calcule debut et fin de la seq  */
	fin0 = deb0 + lgfrag - lggap1 - 1;
	fin1 = deb1 + lgfrag - lggap2 - 1;



	fragseg[0][ii] = 
	fragseg[1][ii] = 
	fragseg[2][ii] = 
	fragseg[3][ii] = '\0';

	if(cur_num_line == -1 &&
           strstr(fragseg[3], "_") != NULL) cur_num_line = numl;

	int lgName = strlen(seq[0].name);
	if( strlen(seq[1].name)>lgName )
	  lgName = strlen(seq[1].name);
	lgName+=2;

	if(numbloc != -1) {
		sprintf(seq_alignee[numl], "%-*s %8.5s %s %8.5s",
			lgName, "", "", fragseg[3], "");

		sprintf(seq_alignee[numl+1], "%-*s %8d %s %8d",
			lgName, seq[0].name, deb0, fragseg[0], fin0);

		sprintf(seq_alignee[numl+2], "%-*s %8d %s %8d",
			lgName, seq[1].name, deb1, fragseg[1], fin1);

		sprintf(seq_alignee[numl+3], "%-*s %8.5s %s %8.5s",
			lgName, "", "", fragseg[2], "");
		}

	else {
		sprintf(seq_alignee[numl], "%-10.10s %8.5s %s",
			"", "", fragseg[3]);

		sprintf(seq_alignee[numl+1], "%-10.10s %8d %s",
			seq[0].name, deb0, fragseg[0]);

		sprintf(seq_alignee[numl+2], "%-10.10s %8d %s",
			seq[1].name, deb1, fragseg[1]);

		sprintf(seq_alignee[numl+3], "%-10.10s %8.5s %s",
			"", "", fragseg[2]);

		}
	
	if(lgfrag > lggap1) deb0 = fin0 + 1;
	else deb0 = fin0;
	if(lgfrag > lggap2) deb1 = fin1 + 1;
	else deb1 = fin1;
	}

free((char *)aln1);
free((char *)aln2);
free((char *)aln3);
free((char *)aln4);


}


int max_(int a, int b)
{

if (a > b) return(a);

return(b);

}
