#include <FL/fl_ask.H>

#include "lalnview.h"
#include "lalnview_utils.H"
#include "globals.h"

#define TRUE true
#define FALSE false

void get_numc(char *, int *, char *);
int tri_tab_feat(const void * ,const void *);


void get_feature(char * nomfic)
{
  char *pname, ficname[400];
  FILE *fic;
  char string[300];
  char bufdeb[10], buffin[10], cdeb[2], cfin[2];
  int nseq, deb, fin, ii, jj;
  float lrg;
  char color[30];
  char *label;
  int test_error = 0;
  /*GP_color test_color;*/

  NBFEAT = 0;
  
  if (NBSEQ == 0) {
  //  printf("Impossible de charger des features sans une sequence.\n");
    return;
  }


  if (has_features == TRUE && GET_FEAT_FROM_SIM != TRUE) {
    if(tab_feat != NULL) free((char *) tab_feat);
    feat_decal = 0.0;
    has_features = FALSE;
    return;
  }
  else if (GET_FEAT_FROM_SIM == TRUE) {
    feat_decal = 0.0;
    has_features = FALSE;
    if(tab_feat != NULL) free((char *) tab_feat);
  }

  if(GET_FEAT_FROM_SIM == TRUE) 
    strcpy(ficname, aln_fic_name);  
  else {
    pname=strdup(nomfic);
    
    if(pname == NULL) return;
    strcpy(ficname, pname);
  }
  
  if((fic = fopen(ficname, "r")) == NULL) {
    //printf("Impossible to open this file");
    fl_alert("Impossible to open this file");
    return;
  }
  
  /* se place en debut des features */

  while(fgets(string, 300, fic) != NULL) 
    if(strncmp(string, "# FEATURES BEGIN", 16) == 0) break;
  
  /* compte le nombre de features */
  while(fgets(string, 300, fic) != NULL) {
    if(strncmp(string, "# FEATURES END", 14) == 0) break;
    if(sscanf(string, "%d %s %s %f %s",
	      &nseq, bufdeb, buffin, &lrg, color) == 5) NBFEAT++;
    
  }
  
  
  rewind(fic);

  /* alloue la memoire */


  tab_feat = (struct FEATURE *)check_alloc(NBFEAT,sizeof(struct FEATURE));

  /* initialise */

  for(ii=0; ii<NBFEAT; ii++) {
    tab_feat[ii].nseq = -1;
    tab_feat[ii].lrg = 0;
    tab_feat[ii].fin = 0;
    tab_feat[ii].deb = 0;
    strcpy(tab_feat[ii].cdeb, "");
    strcpy(tab_feat[ii].cfin, "");
    strcpy(tab_feat[ii].col, "");
    strcpy(tab_feat[ii].lab, "");
  }

  /* recupere les donnees */

  ii=0;

  /* se place en debut des features */

  while(fgets(string, 300, fic) != NULL) 
	if(strncmp(string, "# FEATURES BEGIN", 16) == 0) break;
  
  if(NBFEAT > 0) while(fgets(string, 300, fic) != NULL) {
    if(strncmp(string, "# FEATURES END", 14) == 0) break;
    if(sscanf(string, "%d %s %s %f %s",
	      &nseq, bufdeb, buffin, &lrg, color)  != 5) continue;
    nseq = nseq -1;
    
    get_numc(bufdeb, &deb, cdeb);
    get_numc(buffin, &fin, cfin);
    
    if(nseq != 0 && nseq != 1) test_error++;
    else if(deb < 0) test_error++;
    else if(deb > seq[nseq].lg) test_error++;
    else if(fin < 0) test_error++;
    else if(fin > seq[nseq].lg) test_error++;
    else if(lrg < 0) test_error++;
    else {
      if(lrg > MAXFEATLRG) lrg = MAXFEATLRG;
      tab_feat[ii].nseq = nseq;
      if(cdeb[0]== '?') {
	deb = fin;
      }
      
      else if(cfin[0]== '?') {
	fin =deb;
      }
      
      tab_feat[ii].lrg = lrg;
      
      if(fin >= deb) {
	tab_feat[ii].fin = fin;
	tab_feat[ii].deb = deb;
	strcpy(tab_feat[ii].cdeb, cdeb);
	strcpy(tab_feat[ii].cfin, cfin);
      }
      
      else {
	tab_feat[ii].fin = deb;
	tab_feat[ii].deb = fin;
	strcpy(tab_feat[ii].cdeb, cfin);
	strcpy(tab_feat[ii].cfin, cdeb);
      }
      
      /* recupere le label */
      label = strtok(string, " \t\n");
      for(jj = 2; jj < 6; jj++) 
	label = strtok(NULL, " \t\n");
      label = strtok(NULL, "\n");
      
      strcpy(tab_feat[ii].col, color);
      if(label != NULL) strncpy(tab_feat[ii].lab, label, MAXLAB);
      else strcpy(tab_feat[ii].lab, "");
      tab_feat[ii].lab[MAXLAB-1] = '\0';
      ii++;
    }
  }
  

  if(NBFEAT == 0) {
    if  (GET_FEAT_FROM_SIM != TRUE)
      fl_alert("Parsing problem in feature file. \nNo feature read.");
    fclose(fic);
    return;
  }
  
  /*
    if(test_error > 0 && GET_FEAT_FROM_SIM != TRUE)
    printf("Parsing problem in feature file. \nSome features may have been lost.");
  */
  

  has_features = TRUE;
  feat_decal = 1.5;

  qsort(tab_feat, NBFEAT, sizeof(tab_feat[0]), tri_tab_feat);
  
  /*for(ii=0; ii<NBFEAT; ii++) {
    printf("nseq = %d lrg = %f fin = %d deb = %d cdeb = %s cfin = %s col = %s lab = %s\n",
    tab_feat[ii].nseq,
    tab_feat[ii].lrg,
    tab_feat[ii].fin,
    tab_feat[ii].deb,
		tab_feat[ii].cdeb,
		tab_feat[ii].cfin,
		tab_feat[ii].col,
		tab_feat[ii].lab);
	}
  */

  fclose(fic);
}

void get_numc(char *string, int *num, char *c)
{
char buf[6];
int ii, jj = 0;

c[0] = '\0';
c[1] = '\0';

for(ii = 0; ii<20; ii++) {
	if(string[ii] == '\0') break;
	if(string[ii] == ' ') continue;

	if(string[ii] == '>' || string[ii] == '<' || string[ii] == '?') 
		c[0] = string[ii];

	else buf[jj++] = string[ii];
	}
buf[jj] = '\0';

*num = atoi(buf);



}


int tri_tab_feat(const void *a ,const void *b)
{
struct FEATURE *aa, *bb;

aa = (struct FEATURE *) a;
bb = (struct FEATURE *) b;

/* 1er critere de tri: hauteur de la feature */

if(bb->lrg != aa->lrg) {
	if (bb->lrg > aa->lrg) return(1);
	else return(-1);
	}

/* 2eme critere de tri: longueur de la feature */

return((bb->fin - bb->deb) - (aa->fin - aa->deb));


}
