/* init.cxx */


#include <stdio.h>

#include <stdlib.h>
#include <string.h>


#include <iostream>
#include <string>
#include <fstream>

#include "MF_Values.H"
#include "init.H"

#define MAX_SRC_PARAM_LG 8000

#ifdef __APPLE__

extern "C" {
extern void PtoC(const void *in, void *out);
extern void CtoP(const void *in, void *out);
}


void initSrc(void)
{
	;
}

char * getResValue(char *name)
{
  char *p;

  p = load1res(name);
  if(p != NULL)
    return p;
  else
    return NULL;
}

char *load1res(char *resname)
{
	char **h, *p, pname[256]; 
	int l;

	CtoP(resname, pname);
	h = GetNamedResource('TEXT', (ConstStr255Param)pname );
	if(h == NULL) return NULL;
	else	{
		l = GetHandleSize(h);
		p = (char *)malloc(l + 1);
		}
	if(p != NULL) {
		HLock(h);
		memcpy(p, *h, l);
		HUnlock(h);
		p[l] = 0;
		if(p[--l] == '\r') p[l] = 0;
		}
	ReleaseResource(h);
	return p;
}

#else

void initSrc(void)
{
  MF_Values::srcFile(configFile());
}


char * configFile(void)
{
#ifdef WIN32
	char *fullName = (char *)"lalnview.ini";
#else
  char *p = getenv("HOME");
  char * configFile = (char *)"/.lalnviewrc";
  int lg =  strlen(p) + strlen(configFile) + 1;
  char *fullName = (char *)malloc( lg * sizeof(char) );

  sprintf(fullName,"%s%s\0", p, configFile);
#endif
	return fullName;
}


/* Returns the value of the given var parameter in the configuration ($HOME/.lalnviewsrc) file */
char * getSrcValue(char *var)
{
  using namespace std;

  std::ifstream file(MF_Values::srcFile());
  
  if( !file )
    return NULL;
  
  std::string line;
  std::string val;
  std::string svar = var;
  int pos;
  
  while( std::getline(file, line) ){

    //printf("\n\nAnalyse de la ligne : %s\n", line.c_str());

    if( line.substr(0,1) != "#" ){
      pos = line.find("=", 0);
      if( pos==string::npos ){
	//printf("Pas de egal\n");
	continue;
      }
      
      if( line.substr(0, pos) != svar ){
	//printf("!=%s\n", svar.c_str());
	continue;
      }
      
      pos++;
      if(pos==line.size()){
	//printf("Pas de valeur associee\n");
	continue;
      }
      
      val = line.substr(pos, line.size()-pos);
      //printf("Val trouvee : %s\n", val.c_str());
      //return val.c_str();
      if( val.c_str() )
	return strdup(val.c_str());
      else
	return NULL;
    }
  }
  
  return NULL;
}
  
#endif
