#include <stdio.h>

#include <FL/Fl_Output.H>
#include <FL/Fl_Scroll.H>
#include <FL/fl_ask.H>

#include "lalnview.h"
#include "def_globals.h"
#include "lalnview_utils.H"

#include "MF_MainWindow.H"
#include "MF_SecWindow.H"

#include "MF_Values.H"
#include "dijkstra.H"

#include "init.H"

/**************************************************/
float MF_Values::scoMin_ = 10.0;
float MF_Values::identityMin_ = 0.0;
int MF_Values::lenghtMin_ = 0;

int MF_Values::SEQSPACE_ = 33;

double MF_Values::rapport_ = 0.8;

char * MF_Values::srcFile_ = NULL;
/**************************************************/

MF_MainWindow * _MAINW_;
MF_SecWindow * _SECW_;

int main(int argc, char **argv)
{
  _MAINW_ = NULL;
  _SECW_ = NULL;

  nb_ligne_aln = 0;
  NBFEAT = 0;
  seq_alignee = NULL;

  initSrc();

  _MAINW_ = new MF_MainWindow(10,30,950,530,"_lalnview_");
  _MAINW_->addMenu();
  _MAINW_->resizable(_MAINW_->getScroll());

  load_color_lg();
#if defined( __APPLE__ )
  char *defaultScale = getResValue("scale");
#else
  char *defaultScale = getSrcValue("scale");
#endif

  if(defaultScale){
    int scaleOk = loadColorScale(defaultScale);
    if(scaleOk==-1)
      fl_alert("Warning : unable to load default scale '%s' from ressource file.", defaultScale);
  }

  _MAINW_->show();
  _MAINW_->make_current();
  _MAINW_->redraw();
  

  if(argc>1){
    charger_fichier(argv[1]);
    if(argc>2)
        get_feature(argv[2]);
  }

  while(Fl::wait()){
    ;
  }
  return 0;
}

void charger_fichier(char *fic)
{
  int ret, pg, nw, nh;
  int S_NBBLOC, S_NBSEQ, S_NBFEAT;

  S_NBBLOC = NBBLOC;
  S_NBSEQ = NBSEQ;
  S_NBFEAT = NBFEAT;

  NBBLOC = 0;
  NBSEQ = 0;
  NBFEAT = 0;

  strcpy(aln_fic_name, fic);
  ret = load_data(fic);

  if(ret) {
	  /*
    NBBLOC = S_NBBLOC;
    NBSEQ = S_NBSEQ;
    NBFEAT = S_NBFEAT;
	*/
	  NBBLOC = NBSEQ = NBFEAT = 0;
	  if(ret!=9 && ret !=11)
	    fl_alert("Unrecognized file format.");
    return;
  }

  if( strlen(seq[0].name) > strlen(seq[1].name) ){
    pg = 0;
  } else {
    pg = 1;
  }

  nw = 0;
  nh = 0;
  fl_font(FL_COURIER, 12);
  fl_measure(seq[pg].name, nw, nh);

  MF_MyScroll * ms = _MAINW_->getScroll();
  MF_Name * name = _MAINW_->getName();
  MF_Echelle * echelle = _MAINW_->getScale();

  nw+=10;

  ms->myResize( name->x()+nw , ms->y() , _MAINW_->w()-(name->x()+nw) , ms->h() );
  echelle->myResize( ms->x() , echelle->y() , ms->w() , echelle->h() );
  name->myW(nw);

  if(seq[0].lg>seq[1].lg)
    pg = 0;
  else
    pg = 1;
  double rapport = (double)((double)seq[pg].lg/(double)(_MAINW_->getScroll()->w()-25));
  MF_Values::rapport(rapport);

  if(_MAINW_->bestSeries()){
      dijkstra();
  }
  ms->loadSequences();
  _MAINW_->setMins();

  _MAINW_->getFeatDisp()->raz();

  if(_SECW_ == NULL){
    Fl_Group::current(0);  
    _SECW_ = new MF_SecWindow(10,500,900,400, "Full text sequences");
    _SECW_->show();
    Fl_Group::current(_MAINW_);
  } else {
    _SECW_->raz();
  }

  _MAINW_->fullUpdatePanel();

}
