#ifndef _LALNVIEWH_
#define _LALNVIEWH_

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <FL/Enumerations.H>

#define _MAX_PIX_HELP_ 20 /*  */

#define LINAL  123 /* length of line in alignment */
#define MAXMN 50 /* max seq. name length */

#define NBCOL  9 /* nombre de couleurs pour similitude */
#define MAXLAB  4096 /* taille maxi d'un label pour feature */
#define MAXFEATLRG  2.0 /* largeur maxi d'une boite pour feature */
#define DEFAULT_THRESHOLD 120.0 /* valeur par defaut pour seuil_score_sim */

#define _MF_TYPE_SCOREMIN_ 0
#define _MF_TYPE_LENGHTMIN_ 1
#define _MF_TYPE_IDENTITYMIN_ 2

#define _LIST_GREEN_ 1
#define _LIST_RED_ -1

#ifdef MACINTOSH
#define LALN_VERSION "lalnview 3 - Mac"
#else
#define LALN_VERSION "lalnview 3"
#endif

#define FIRST_SHOWN "first shown"


struct COLOR {
	float sco;
	Fl_Color col;
	double x1;
	double x2;
	};


struct FEATURE {
  int nseq;	/* numero de la seq */
  int deb;
  int fin;
  char cdeb[2];
  char cfin[2];
  float lrg;
  char col[30];
  char lab[MAXLAB];
};


struct BLOC {
  int beg;
  int end;
  float sim; /* pourcentage identite entre les 2 blocs */
  float sco; /* score du segment auquel le bloc appartient */
  int seg; /* numero du segment auquel le bloc appartient */
  int idb;
};

struct SEQ {
  char *seq;
  char name[MAXMN];
  struct BLOC *bloc;
  int lg;
  int id;
  int ori;
  double y;
};

struct SEG {
  int id;
  float sco;
  int beg0;
  int end0;
  int beg1;
  int end1;
  int lgaln;
  float identity;
  float gapf;
  int bestSeries;
  int myList;
};


void load_error_mess(void);

void get_feature(char * nomfic);
void get_aln(int, float *, float *, int *, int);
int load_data(char *);

char *check_alloc(int ,int);
Fl_Color get_color(float);
int load_data_sim(FILE *fic);
int load_data_lfasta(FILE *fic);
int compte_bloc_lfasta(int, FILE *, long);
int get_bloc_info_lfasta(int , FILE *, float *, int *, long);
int get_pos_seq(char *string, char * aln);
void draw_scale(struct SEQ);
void draw_seq(struct SEQ);
void draw_link_seg(void);
void draw_color_leg(void);
void draw_features(void);
void get_scale_pas(void);
int get_seq_fasta(char *, int);
void Nieme_mot(char *string, int n, char *separat, char *result);
int max_(int, int);
void load_color_lg(void);

void init_glob(void);
void get_short_name(void);

void charger_fichier(char *fic);

char *my_fgets(char *s, int n, FILE *f);
char *MG_input_file_chooser(const char* message, const char* pat, const char* fname);
char *MG_output_file_chooser(const char* message, const char* pat, const char* fname);
#define fgets my_fgets

#define GLOBDEFINE
#endif

