#include "lalnview_utils.H"



/* These color are the avaible color for the features. */
#define NBFCOL 496

/*
char * stab[NBFCOL] = {"black", "yellow", "red", "blue", "green", "brown"};
Fl_Color ftab[NBFCOL] = {FL_BLACK, FL_YELLOW, FL_RED, FL_BLUE, FL_GREEN, fl_rgb_color(0x9a,0x38,0x22) };
*/


char * stab[NBFCOL] = { "red", "green", "blue", "yellow", 
"AliceBlue","AntiqueWhite","AntiqueWhite1","AntiqueWhite2",
"AntiqueWhite3","AntiqueWhite4","aquamarine","aquamarine1","aquamarine2","aquamarine3","aquamarine4","azure","azure1","azure2","azure3","azure4","beige","bisque","bisque1","bisque2","bisque3","bisque4","black","BlanchedAlmond","blue","blue1","blue2","blue3","blue4","BlueViolet","brown","burlywood","burlywood1","burlywood2","burlywood3","burlywood4","CadetBlue","CadetBlue1","CadetBlue2","CadetBlue3","CadetBlue4","chartreuse","chartreuse1","chartreuse2","chartreuse3","chartreuse4","chocolate","coral","coral1","coral2","coral3","coral4","CornflowerBlue","cornsilk","cornsilk1","cornsilk2","cornsilk3","cornsilk4","cyan","cyan1","cyan2","cyan3","cyan4","DarkBlue","DarkCyan","DarkGoldenrod","DarkGoldenrod1","DarkGoldenrod2","DarkGoldenrod3","DarkGoldenrod4","DarkGray","DarkGreen","DarkKhaki","DarkMagenta","DarkOliveGreen","DarkOliveGreen1","DarkOliveGreen2","DarkOliveGreen3","DarkOliveGreen4","DarkOrange","DarkOrange1","DarkOrange2","DarkOrange3","DarkOrange4","DarkOrchid","DarkOrchid1","DarkOrchid2","DarkOrchid3","DarkOrchid4","DarkRed","DarkSalmon","DarkSeaGreen","DarkSeaGreen1","DarkSeaGreen2","DarkSeaGreen3","DarkSeaGreen4","DarkSlateBlue","DarkSlateGray","DarkSlateGray1","DarkSlateGray2","DarkSlateGray3","DarkSlateGray4","DarkTurquoise","DarkViolet","DeepPink","DeepPink1","DeepPink2","DeepPink3","DeepPink4","DeepSkyBlue","DeepSkyBlue1","DeepSkyBlue2","DeepSkyBlue3","DeepSkyBlue4","DimGray","DodgerBlue","DodgerBlue1","DodgerBlue2","DodgerBlue3","DodgerBlue4","firebrick","FloralWhite","ForestGreen","gainsboro","ghostwhite","gold","gold1","gold2","gold3","gold4","goldenrod","goldenrod1","goldenrod2","goldenrod3","goldenrod4","gray","gray0","gray1","gray10","gray100","gray11","gray2","gray3","gray4","gray41","gray49","gray5","gray54","gray55","gray56","gray57","gray58","gray59","gray6","gray60","gray61","gray62","gray63","gray64","gray65","gray66","gray67","gray68","gray69","gray7","gray70","gray71","gray72","gray73","gray74","gray75","gray76","gray77",
"gray78"
,"gray79","gray8","gray80","gray81","gray82","gray83","gray84","gray85","gray86","gray87","gray88","gray89","gray9","gray90","gray91","gray92","gray93","gray94","gray95","gray96","gray97","gray98","gray99","green","green1","green2","green3","green4","GreenYellow","honeydew","honeydew1","honeydew2","honeydew3","honeydew4","HotPink","HotPink1","HotPink2","HotPink3","HotPink4","IndianRed","IndianRed1","IndianRed2","IndianRed3","IndianRed4","ivory","ivory1","ivory2","ivory3","ivory4","khaki","khaki1","khaki2","khaki3","khaki4","lavender","LavenderBlush","LavenderBlush1","LavenderBlush2","LavenderBlush3","LavenderBlush4","LawnGreen","LemonChiffon","LemonChiffon1","LemonChiffon2","LemonChiffon3","LemonChiffon4","LightBlue","LightBlue1","LightBlue2","LightBlue3","LightBlue4","LightCoral","LightCyan","LightCyan1","LightCyan2","LightCyan3","LightCyan4","LightGoldenrod","LightGoldenrod1","LightGoldenrod2","LightGoldenrod3","LightGoldenrod4","LightGoldenrodYellow","LightGray","LightGreen","LightPink","LightPink1","LightPink2","LightPink3","LightPink4","LightSalmon","LightSalmon1","LightSalmon2","LightSalmon3","LightSalmon4","LightSeaGreen","LightSkyBlue","LightSkyBlue1","LightSkyBlue2","LightSkyBlue3","LightSkyBlue4","LightSlateBlue","LightSlateGray","LightSteelBlue","LightSteelBlue1","LightSteelBlue2","LightSteelBlue3","LightSteelBlue4","LightYellow","LightYellow1","LightYellow2","LightYellow3","LightYellow4","LimeGreen","linen","magenta","magenta1","magenta2","magenta3","magenta4","maroon","maroon1","maroon2","maroon3","maroon4","MediumAquamarine","MediumBlue","MediumOrchid","MediumOrchid1","MediumOrchid2","MediumOrchid3","MediumOrchid4","MediumPurple","MediumPurple1","MediumPurple2","MediumPurple3","MediumPurple4","MediumSeaGreen","MediumSlateBlue","MediumSpringGreen","MediumTurquoise","MediumVioletRed","MidnightBlue","MintCream","MistyRose","MistyRose1","MistyRose2","MistyRose3","MistyRose4","moccasin","NavajoWhite","NavajoWhite1","NavajoWhite2","NavajoWhite3","NavajoWhite4","navy",
"NavyBlue","OldLace","OliveDrab","OliveDrab1","OliveDrab2","OliveDrab3","OliveDrab4","orange","orange1","orange2","orange3","orange4","OrangeRed","OrangeRed1","OrangeRed2","OrangeRed3","OrangeRed4","orchid","orchid1","orchid2","orchid3","orchid4","PaleGoldenrod","PaleGreen","PaleGreen1","PaleGreen2","PaleGreen3","PaleGreen4","PaleTurquoise","PaleTurquoise1","PaleTurquoise2","PaleTurquoise3","PaleTurquoise4","PaleVioletRed","PaleVioletRed1","PaleVioletRed2","PaleVioletRed3","PaleVioletRed4","PapayaWhip","PeachPuff","PeachPuff1","PeachPuff2","PeachPuff3","PeachPuff4","peru","pink","pink1","pink2","pink3","pink4","plum","plum1","plum2","plum3","plum4","PowderBlue","purple","purple1","purple2","purple3","purple4","red1","red2","red3","red4","RosyBrown","RosyBrown1","RosyBrown2","RosyBrown3","RosyBrown4","RoyalBlue","RoyalBlue1","RoyalBlue2","RoyalBlue3","RoyalBlue4","SaddleBrown","salmon","salmon3","salmon4","SandyBrown","SeaGreen","SeaGreen1","SeaGreen2","SeaGreen3","SeaGreen4","seashell","seashell1","seashell2","seashell3","seashell4","sienna","sienna1","sienna2","sienna3","sienna4","SkyBlue","SkyBlue1","SkyBlue2","SkyBlue3","SkyBlue4","SlateBlue","SlateBlue1","SlateBlue2","SlateBlue3","SlateBlue4","SlateGray","SlateGray1","SlateGray2","SlateGray3","SlateGray4","snow","snow1","snow2","snow3","snow4","SpringGreen","SpringGreen1","SpringGreen2","SpringGreen3","SpringGreen4","SteelBlue","SteelBlue1","SteelBlue2","SteelBlue3","SteelBlue4","tan","tan1","tan2","thistle","thistle1","thistle2","thistle3","thistle4","tomato","tomato1","tomato2","tomato3","tomato4","turquoise","turquoise1","turquoise2","turquoise3","turquoise4","violet","VioletRed","VioletRed1","VioletRed2","VioletRed3","VioletRed4","wheat","wheat1","wheat2","wheat3","wheat4","white","whitesmoke","yellow",
"yellow1","yellow2","yellow3","yellow4","YellowGreen"};


Fl_Color ftab[NBFCOL] = { 
FL_RED, FL_GREEN, FL_BLUE, FL_YELLOW,
fl_rgb_color(0xf0,0xe6,0xfa),fl_rgb_color(0xfa,0xeb,0xd7),fl_rgb_color(0xff,0xef,0xdb),fl_rgb_color(0xee,0xdf,0xcc),fl_rgb_color(0xcd,0xc0,0xb0),fl_rgb_color(0x8b,0x83,0x78),fl_rgb_color(0x7f,0xff,0xd4),fl_rgb_color(0x7f,0xff,0xd4),fl_rgb_color(0x76,0xcd,0xaa),fl_rgb_color(0x66,0xcd,0xaa),fl_rgb_color(0x45,0x8b,0x74),fl_rgb_color(0xf0,0xff,0xff),fl_rgb_color(0xf0,0xff,0xff),fl_rgb_color(0xe0,0xcd,0xcd),fl_rgb_color(0xc1,0xcd,0xcd),fl_rgb_color(0x83,0x8b,0x8b),fl_rgb_color(0xf5,0xf5,0xdc),fl_rgb_color(0xff,0xe4,0xc4),fl_rgb_color(0xff,0xe4,0xc4),fl_rgb_color(0xee,0xd5,0xb7),fl_rgb_color(0xcd,0xb7,0x9e),fl_rgb_color(0x8b,0x7d,0x6b),fl_rgb_color(0x00,0x00,0x00),fl_rgb_color(0xff,0xeb,0xcd),fl_rgb_color(0x00,0x00,0xff),fl_rgb_color(0x00,0x00,0xff),fl_rgb_color(0x00,0x00,0xee),fl_rgb_color(0x00,0x00,0xcd),fl_rgb_color(0x00,0x00,0x8b),fl_rgb_color(0x8a,0x2b,0xe2),fl_rgb_color(0xa5,0x2a,0x2a),fl_rgb_color(0xde,0xb8,0x87),fl_rgb_color(0xff,0xd3,0x9b),fl_rgb_color(0xee,0xc5,0x9e),fl_rgb_color(0xcd,0xaa,0x7d),fl_rgb_color(0x8b,0x73,0x55),fl_rgb_color(0x5f,0x9e,0xa0),fl_rgb_color(0x98,0xf5,0xff),fl_rgb_color(0x8e,0xe5,0xee),fl_rgb_color(0x7a,0xc5,0xcd),fl_rgb_color(0x53,0x86,0x8b),fl_rgb_color(0x7f,0xff,0x00),fl_rgb_color(0x7f,0xff,0x00),fl_rgb_color(0x76,0xee,0x00),fl_rgb_color(0x66,0xcd,0x00),fl_rgb_color(0x45,0x8b,0x00),fl_rgb_color(0xd2,0x69,0x1e),fl_rgb_color(0xff,0x7f,0x50),fl_rgb_color(0xff,0x72,0x56),fl_rgb_color(0xee,0x6a,0x50),fl_rgb_color(0xcd,0x5b,0x45),fl_rgb_color(0x8b,0x3e,0x2f),fl_rgb_color(0x64,0x95,0xed),fl_rgb_color(0xff,0xf8,0xdc),fl_rgb_color(0xff,0xf8,0xdc),fl_rgb_color(0xee,0xe8,0xcd),fl_rgb_color(0xcd,0xc8,0xb1),fl_rgb_color(0x8b,0x88,0x78),fl_rgb_color(0x00,0xff,0xff),fl_rgb_color(0x00,0xff,0xff),fl_rgb_color(0x00,0xee,0xee),fl_rgb_color(0x00,0xcd,0xcd),fl_rgb_color(0x00,0x8b,0x8b),fl_rgb_color(0x00,0x00,0x8b),fl_rgb_color(0x00,0x8b,0x8b),fl_rgb_color(0xb8,0x86,0x0b),fl_rgb_color(0xff,0xb9,0x0f),fl_rgb_color(0xee,0xad,0x0e),fl_rgb_color(0xcd,0x95,0x0c),fl_rgb_color(0x8b,0x65,0x08),
fl_rgb_color(0xa9,
0xa9,0xa9),fl_rgb_color(0x64,0x00,0x00),fl_rgb_color(0xbd,0xb7,0x6b),fl_rgb_color(0x8b,0x00,0x8b),fl_rgb_color(0x55,0x6b,0x2f),fl_rgb_color(0xca,0xff,0x70),fl_rgb_color(0xbc,0xee,0x68),fl_rgb_color(0xa2,0xcd,0x5a),fl_rgb_color(0x6e,0x8b,0x3d),fl_rgb_color(0xff,0x8c,0x00),fl_rgb_color(0xff,0x7f,0x00),fl_rgb_color(0xee,0x76,0x00),fl_rgb_color(0xcd,0x66,0x00),fl_rgb_color(0x8b,0x45,0x00),fl_rgb_color(0x99,0x32,0xcc),fl_rgb_color(0xbf,0x3e,0xff),fl_rgb_color(0xb2,0x3a,0xee),fl_rgb_color(0x9a,0x32,0xcd),fl_rgb_color(0x68,0x22,0x8b),fl_rgb_color(0x8b,0x00,0x00),fl_rgb_color(0xe9,0x96,0x7a),fl_rgb_color(0x8f,0xbc,0x8f),fl_rgb_color(0xc1,0xff,0xc1),fl_rgb_color(0xb4,0xee,0xb4),fl_rgb_color(0x9b,0xcd,0x9b),fl_rgb_color(0x69,0x8b,0x69),fl_rgb_color(0x48,0x3d,0x8b),fl_rgb_color(0x2f,0x4f,0x4f),fl_rgb_color(0x9b,0xff,0xff),fl_rgb_color(0x8d,0xee,0xee),fl_rgb_color(0x79,0xcd,0xcd),fl_rgb_color(0x52,0x8b,0x8b),fl_rgb_color(0x00,0xce,0xd1),fl_rgb_color(0x94,0x00,0xd3),fl_rgb_color(0xff,0x14,0x93),fl_rgb_color(0xff,0x14,0x93),fl_rgb_color(0xee,0x12,0x89),fl_rgb_color(0xcd,0x10,0x76),fl_rgb_color(0xcd,0x10,0x76),fl_rgb_color(0x00,0xbf,0xff),fl_rgb_color(0x00,0xbf,0xff),fl_rgb_color(0x00,0xb2,0xee),fl_rgb_color(0x00,0x9a,0xcd),fl_rgb_color(0x00,0x68,0x8b),fl_rgb_color(0x69,0x69,0x69),fl_rgb_color(0x1e,0x90,0xff),fl_rgb_color(0x1e,0x90,0xff),fl_rgb_color(0x1c,0x86,0xee),fl_rgb_color(0x18,0x74,0xcd),fl_rgb_color(0x10,0x4e,0x8b),fl_rgb_color(0xb2,0x22,0x22),fl_rgb_color(0xff,0xfa,0xf0),fl_rgb_color(0x22,0x8b,0x22),fl_rgb_color(0xdc,0xdc,0xdc),fl_rgb_color(0xF8,0xF8,0xFF),fl_rgb_color(0xff,0xd7,0x00),fl_rgb_color(0xff,0xd7,0x00),fl_rgb_color(0xee,0xc9,0x00),fl_rgb_color(0xcd,0xad,0x00),fl_rgb_color(0x8b,0x75,0x00),fl_rgb_color(0xda,0xa5,0x20),fl_rgb_color(0x8b,0x75,0x00),fl_rgb_color(0xee,0xb4,0x22),fl_rgb_color(0xcd,0x9b,0x1d),fl_rgb_color(0x8b,0x69,0x14),fl_rgb_color(0xbe,0xbe,0xbe),fl_rgb_color(0x00,0x00,0x00),fl_rgb_color(0x30,0x30,0x30),fl_rgb_color(0x1a,0x1a,0x1a),fl_rgb_color(0xff,0xff,0xff),fl_rgb_color(0x1c,0x1c,0x1c),
fl_rgb_color(0x50,0x50,0x50),fl_rgb_color(0x80,0x80,0x80),fl_rgb_color(0x0a,0x0a,0x0a),fl_rgb_color(0x69,0x69,0x69),fl_rgb_color(0x7d,0x7d,0x7d),fl_rgb_color(0x0d,0x0d,0x0d),fl_rgb_color(0x8a,0x8a,0x8a),fl_rgb_color(0x8c,0x8c,0x8c),fl_rgb_color(0x8f,0x8f,0x8f),fl_rgb_color(0x91,0x91,0x91),fl_rgb_color(0x94,0x94,0x94),fl_rgb_color(0x96,0x96,0x96),fl_rgb_color(0x0f,0x0f,0x0f),fl_rgb_color(0x99,0x99,0x99),fl_rgb_color(0x9c,0x9c,0x9c),fl_rgb_color(0x9e,0x9e,0x9e),fl_rgb_color(0xa1,0xa1,0xa1),fl_rgb_color(0xa3,0xa3,0xa3),fl_rgb_color(0xa6,0xa6,0xa6),fl_rgb_color(0xa8,0xa8,0xa8),fl_rgb_color(0xab,0xab,0xab),fl_rgb_color(0xad,0xad,0xad),fl_rgb_color(0xb0,0xb0,0xb0),fl_rgb_color(0x12,0x12,0x12),fl_rgb_color(0xb3,0xb3,0xb3),fl_rgb_color(0xb5,0xb5,0xb5),fl_rgb_color(0xb8,0xb8,0xb8),fl_rgb_color(0xba,0xba,0xba),fl_rgb_color(0xbd,0xbd,0xbd),fl_rgb_color(0xbf,0xbf,0xbf),fl_rgb_color(0xc2,0xc2,0xc2),fl_rgb_color(0xc4,0xc4,0xc4),fl_rgb_color(0xc7,0xc7,0xc7),fl_rgb_color(0xc9,0xc9,0xc9),fl_rgb_color(0x14,0x14,0x14),fl_rgb_color(0xcc,0xcc,0xcc),fl_rgb_color(0xcf,0xcf,0xcf),fl_rgb_color(0xd1,0xd1,0xd1),fl_rgb_color(0xd4,0xd4,0xd4),fl_rgb_color(0xd6,0xd6,0xd6),fl_rgb_color(0xd9,0xd9,0xd9),fl_rgb_color(0xdb,0xdb,0xdb),fl_rgb_color(0xde,0xde,0xde),fl_rgb_color(0xe0,0xe0,0xe0),fl_rgb_color(0xe3,0xe3,0xe3),fl_rgb_color(0x17,0x17,0x17),fl_rgb_color(0xe5,0xe5,0xe5),fl_rgb_color(0xe8,0xe8,0xe8),fl_rgb_color(0xeb,0xeb,0xeb),fl_rgb_color(0xed,0xed,0xed),fl_rgb_color(0xf0,0xf0,0xf0),fl_rgb_color(0xf2,0xf2,0xf2),fl_rgb_color(0xf5,0xf5,0xf5),fl_rgb_color(0xf7,0xf7,0xf7),fl_rgb_color(0xfa,0xfa,0xfa),fl_rgb_color(0xfc,0xfc,0xfc),fl_rgb_color(0x00,0xff,0x00),fl_rgb_color(0x00,0xff,0x00),fl_rgb_color(0x00,0xee,0x00),fl_rgb_color(0x00,0xcd,0x00),fl_rgb_color(0x00,0x8b,0x00),fl_rgb_color(0xad,0xff,0x2f),fl_rgb_color(0xf0,0xff,0xf0),fl_rgb_color(0xf0,0xff,0xf0),fl_rgb_color(0xe0,0xee,0xe0),fl_rgb_color(0xc1,0xcd,0xc1),fl_rgb_color(0x83,0x8b,0x83),fl_rgb_color(0xff,0x69,0xb4),fl_rgb_color(0xff,0x6e,0xb4),
fl_rgb_color(0xee,0x6a,0xa7),fl_rgb_color(0xcd,0x60,0x90),fl_rgb_color(0x8b,0x3a,0x62),fl_rgb_color(0xcd,0x5c,0x5c),fl_rgb_color(0xff,0x6a,0x6a),fl_rgb_color(0xee,0x63,0x63),fl_rgb_color(0xcd,0x55,0x55),fl_rgb_color(0x8b,0x3a,0x3a),fl_rgb_color(0xff,0xff,0xf0),fl_rgb_color(0xff,0xff,0xf0),fl_rgb_color(0xee,0xee,0xe0),fl_rgb_color(0xcd,0xcd,0xc1),fl_rgb_color(0x8b,0x8b,0x83),fl_rgb_color(0xf0,0xe6,0x8c),fl_rgb_color(0xff,0xf6,0x8f),fl_rgb_color(0xee,0xe6,0x85),fl_rgb_color(0xcd,0xc6,0x73),fl_rgb_color(0x8b,0x86,0x4e),fl_rgb_color(0xe6,0xe6,0xfa),fl_rgb_color(0xff,0xf0,0xf5),fl_rgb_color(0xff,0xf0,0xf5),fl_rgb_color(0xee,0xe0,0xe5),fl_rgb_color(0xcd,0xc1,0xc5),fl_rgb_color(0x8b,0x83,0x86),fl_rgb_color(0x7c,0xfc,0x7f),fl_rgb_color(0xe1,0xfa,0xcd),fl_rgb_color(0xff,0xfa,0xcd),fl_rgb_color(0xee,0xc9,0xa5),fl_rgb_color(0xcd,0xc9,0xa5),fl_rgb_color(0x8b,0x89,0x70),fl_rgb_color(0xad,0xd8,0xe6),fl_rgb_color(0xbf,0xef,0xff),fl_rgb_color(0xb2,0xdf,0xee),fl_rgb_color(0x9a,0xc0,0xcd),fl_rgb_color(0x68,0x83,0x8b),fl_rgb_color(0xf0,0x80,0x80),fl_rgb_color(0xe1,0xff,0xff),fl_rgb_color(0xe0,0xff,0xff),fl_rgb_color(0x68,0x83,0x8b),fl_rgb_color(0xb4,0xcd,0xcd),fl_rgb_color(0x7a,0x8b,0x82),fl_rgb_color(0xee,0xdd,0x82),fl_rgb_color(0xff,0xec,0x8b),fl_rgb_color(0xee,0xdc,0x82),fl_rgb_color(0xcd,0xbe,0x70),fl_rgb_color(0x8b,0x81,0x4c),fl_rgb_color(0xfa,0xfa,0xd2),fl_rgb_color(0xd3,0xd3,0xd3),fl_rgb_color(0x90,0xee,0x90),fl_rgb_color(0xff,0xb6,0xc1),fl_rgb_color(0xff,0xae,0xb9),fl_rgb_color(0xee,0xa2,0xad),fl_rgb_color(0xcd,0x8c,0x95),fl_rgb_color(0x8b,0x5f,0x65),fl_rgb_color(0xff,0xa0,0x7a),fl_rgb_color(0xff,0xa0,0x7a),fl_rgb_color(0xee,0x95,0x72),fl_rgb_color(0xcd,0x81,0x62),fl_rgb_color(0x8b,0x57,0x42),fl_rgb_color(0x20,0xb2,0xaa),fl_rgb_color(0x87,0xce,0xfa),fl_rgb_color(0xb0,0xe2,0xff),fl_rgb_color(0xa4,0xd3,0xee),fl_rgb_color(0x8d,0xb6,0xcd),fl_rgb_color(0x60,0x7b,0x8b),fl_rgb_color(0x84,0x70,0xff),fl_rgb_color(0x77,0x88,0x99),fl_rgb_color(0xb0,0xc4,0xde),fl_rgb_color(0xca,0xe1,0xff),
fl_rgb_color(0xbc,0xd2,0xee),fl_rgb_color(0xa2,0xb5,0xcd),
fl_rgb_color(0x6e,0x7b,0x8b),fl_rgb_color(0xff,0xff,0xe0),fl_rgb_color(0xff,0xff,0xe0),fl_rgb_color(0xee,0xee,0xd1),fl_rgb_color(0xcd,0xcd,0xb4),fl_rgb_color(0x8b,0x8b,0x6a),fl_rgb_color(0x32,0xcd,0x32),fl_rgb_color(0xfa,0xf0,0xe6),fl_rgb_color(0xff,0x00,0xff),fl_rgb_color(0xff,0x00,0xff),fl_rgb_color(0xee,0x00,0xee),fl_rgb_color(0xcd,0x00,0xcd),fl_rgb_color(0x8b,0x00,0x8b),fl_rgb_color(0xb0,0x2e,0x60),fl_rgb_color(0xff,0x34,0xb3),fl_rgb_color(0xee,0x30,0xa7),fl_rgb_color(0xcd,0x29,0x90),fl_rgb_color(0x8b,0x1c,0x62),fl_rgb_color(0x66,0xcd,0xaa),fl_rgb_color(0x00,0x00,0xcd),fl_rgb_color(0xba,0x55,0xd3),fl_rgb_color(0xd1,0x5f,0xee),fl_rgb_color(0xd1,0x5f,0xee),fl_rgb_color(0xb4,0x52,0xcd),fl_rgb_color(0x7a,0x37,0x8b),fl_rgb_color(0xa0,0x20,0xf0),fl_rgb_color(0xab,0x82,0xff),fl_rgb_color(0x9f,0x79,0xee),fl_rgb_color(0x89,0x68,0xcd),fl_rgb_color(0x5d,0x47,0x8b),fl_rgb_color(0x3c,0xb3,0x71),fl_rgb_color(0x7b,0x68,0xee),fl_rgb_color(0x00,0xfa,0x9a),fl_rgb_color(0x48,0xd1,0xcc),fl_rgb_color(0xc7,0x15,0x85),fl_rgb_color(0x19,0x19,0x70),fl_rgb_color(0xf5,0xff,0xfa),fl_rgb_color(0xff,0xe4,0xe1),fl_rgb_color(0xff,0xe4,0xe1),fl_rgb_color(0xee,0xd5,0xd2),fl_rgb_color(0xcd,0xb7,0xb5),fl_rgb_color(0x8b,0x7d,0x7b),fl_rgb_color(0xff,0xe4,0xb5),fl_rgb_color(0xff,0xda,0xb9),fl_rgb_color(0xff,0xde,0xad),fl_rgb_color(0xee,0xcf,0xa1),fl_rgb_color(0xcd,0xb3,0x8b),fl_rgb_color(0x8b,0x79,0x5e),fl_rgb_color(0x80,0x00,0x00),fl_rgb_color(0x80,0x00,0x00),fl_rgb_color(0xfa,0xf5,0xe6),fl_rgb_color(0x6b,0x8e,0x23),fl_rgb_color(0xc0,0xff,0x3e),fl_rgb_color(0xb3,0xee,0x3a),fl_rgb_color(0x9a,0xcd,0x32),fl_rgb_color(0x69,0x8b,0x22),fl_rgb_color(0xff,0xa5,0x00),fl_rgb_color(0xff,0xa5,0x00),fl_rgb_color(0xee,0x9a,0x00),fl_rgb_color(0xcd,0x85,0x00),fl_rgb_color(0x8b,0x5a,0x00),fl_rgb_color(0xff,0x41,0x00),fl_rgb_color(0xff,0x45,0x00),fl_rgb_color(0xee,0x40,0x00),fl_rgb_color(0xcd,0x37,0x00),fl_rgb_color(0x8b,0x25,0x00),fl_rgb_color(0xda,0x70,0xd6),fl_rgb_color(0x8b,0x00,0x8b),fl_rgb_color(0xee,0x7a,0xe9),
fl_rgb_color(0xcd,0x69,0xc9),fl_rgb_color(0x8b,0x47,0x89),fl_rgb_color(0xee,0xe8,0xaa),
fl_rgb_color(0x98,0xfb,0x98),fl_rgb_color(0x9a,0xff,0x9a),fl_rgb_color(0x90,0xee,0x90),fl_rgb_color(0x7c,0xcd,0x7c),fl_rgb_color(0x54,0x8b,0x54),fl_rgb_color(0xaf,0xee,0xee),fl_rgb_color(0xbb,0xff,0xff),fl_rgb_color(0xae,0xee,0xee),fl_rgb_color(0x96,0xcd,0xcd),fl_rgb_color(0x66,0x8b,0x8b),fl_rgb_color(0xdb,0x70,0x93),fl_rgb_color(0xff,0x82,0xab),fl_rgb_color(0xee,0x79,0x9f),fl_rgb_color(0xcd,0x68,0x89),fl_rgb_color(0x8b,0x47,0x5d),fl_rgb_color(0xff,0xef,0xd5),fl_rgb_color(0xff,0xda,0xb9),fl_rgb_color(0xff,0xda,0xb9),fl_rgb_color(0xee,0xcb,0xad),fl_rgb_color(0xcd,0xaf,0x95),fl_rgb_color(0x8b,0x77,0x65),fl_rgb_color(0xcd,0x85,0x3f),fl_rgb_color(0xff,0xc0,0xcb),fl_rgb_color(0xff,0xb5,0xc5),fl_rgb_color(0xee,0xa9,0xb8),fl_rgb_color(0xcd,0x91,0x9e),fl_rgb_color(0x8b,0x63,0x6c),fl_rgb_color(0xdd,0xa0,0xdd),fl_rgb_color(0xff,0xbb,0xff),fl_rgb_color(0xee,0xae,0xee),fl_rgb_color(0xcd,0x96,0xcd),fl_rgb_color(0x8b,0x66,0x8b),fl_rgb_color(0xb0,0xe0,0xe6),fl_rgb_color(0xa0,0x20,0xf0),fl_rgb_color(0x9b,0x30,0xff),fl_rgb_color(0x91,0x2c,0xee),fl_rgb_color(0x7d,0x26,0xcd),fl_rgb_color(0x55,0x1a,0x8b),fl_rgb_color(0xff,0x00,0x00),fl_rgb_color(0xee,0x00,0x00),fl_rgb_color(0xcd,0x00,0x00),fl_rgb_color(0x8b,0x00,0x00),fl_rgb_color(0xbc,0x8f,0x8f),fl_rgb_color(0xff,0xb6,0xb6),fl_rgb_color(0xee,0xb4,0xb4),fl_rgb_color(0xcd,0x9b,0x9b),fl_rgb_color(0x8b,0x69,0x69),fl_rgb_color(0x41,0x69,0xe1),fl_rgb_color(0x48,0x76,0xff),fl_rgb_color(0x43,0x6e,0xee),fl_rgb_color(0x3a,0x5f,0xcd),fl_rgb_color(0x27,0x40,0x8b),fl_rgb_color(0x8b,0x45,0x13),fl_rgb_color(0xfa,0x80,0x72),fl_rgb_color(0xcd,0x70,0x54),fl_rgb_color(0x8b,0x4c,0x39),fl_rgb_color(0xf4,0xa4,0x60),fl_rgb_color(0x2e,0x8b,0x57),fl_rgb_color(0x54,0xff,0x9f),fl_rgb_color(0x4e,0xee,0x94),fl_rgb_color(0x43,0xcd,0x80),fl_rgb_color(0x2e,0x8b,0x57),fl_rgb_color(0xff,0xf5,0xee),fl_rgb_color(0xff,0xf5,0xee),fl_rgb_color(0xee,0xe5,0xde),fl_rgb_color(0xcd,0xc5,0xbf),fl_rgb_color(0x8b,0x86,0x82),
fl_rgb_color(0xa0,0x52,0x2d),fl_rgb_color(0xff,0x82,0x47),
fl_rgb_color(0xee,0x79,0x42),fl_rgb_color(0xcd,0x68,0x39),fl_rgb_color(0x8b,0x47,0x36),fl_rgb_color(0x87,0xce,0xeb),fl_rgb_color(0x87,0xce,0xff),fl_rgb_color(0x7e,0xc0,0xee),fl_rgb_color(0x6c,0xa6,0xcd),fl_rgb_color(0x4a,0x70,0x8b),fl_rgb_color(0x6a,0x5a,0xcd),fl_rgb_color(0x83,0x6f,0xff),fl_rgb_color(0x7a,0x67,0xee),fl_rgb_color(0x69,0x59,0xcd),fl_rgb_color(0x47,0x3c,0x8b),fl_rgb_color(0x70,0x80,0x90),fl_rgb_color(0xc6,0xe2,0xff),fl_rgb_color(0xb9,0xd3,0xee),fl_rgb_color(0x9f,0xb6,0xcd),fl_rgb_color(0x6c,0x7b,0x8b),fl_rgb_color(0xFF,0xFA,0xFA),fl_rgb_color(0x8b,0x89,0x89),fl_rgb_color(0xee,0xe9,0xe9),fl_rgb_color(0xcd,0xc9,0xc9),fl_rgb_color(0x8b,0x89,0x89),fl_rgb_color(0x00,0xff,0x7f),fl_rgb_color(0x00,0xff,0x7f),fl_rgb_color(0x00,0xee,0x76),fl_rgb_color(0x00,0xcd,0x66),fl_rgb_color(0x00,0x8b,0x45),fl_rgb_color(0x46,0x82,0xb4),fl_rgb_color(0x63,0xb8,0x8b),fl_rgb_color(0x5c,0xac,0xee),fl_rgb_color(0x4f,0x94,0xcd),fl_rgb_color(0x36,0x64,0x8b),fl_rgb_color(0xd2,0xb4,0x8c),fl_rgb_color(0xff,0xa5,0x4f),fl_rgb_color(0xee,0x9a,0x49),fl_rgb_color(0x8b,0x89,0x89),fl_rgb_color(0xff,0xe1,0xff),fl_rgb_color(0xee,0xd2,0xee),fl_rgb_color(0xcd,0xb5,0xcd),fl_rgb_color(0x8b,0x7b,0x8b),fl_rgb_color(0xff,0x63,0x47),fl_rgb_color(0xff,0x63,0x47),fl_rgb_color(0xee,0x5c,0x42),fl_rgb_color(0xcd,0x4f,0x39),fl_rgb_color(0x8b,0x36,0x26),fl_rgb_color(0x40,0xe0,0xd0),fl_rgb_color(0x00,0xf5,0xff),fl_rgb_color(0x00,0xef,0xee),fl_rgb_color(0x00,0xc5,0xcd),fl_rgb_color(0x00,0x86,0x8b),fl_rgb_color(0xee,0x82,0xee),fl_rgb_color(0xd0,0x20,0x90),fl_rgb_color(0xff,0x3e,0x96),fl_rgb_color(0xee,0x3a,0x8c),fl_rgb_color(0xcd,0x32,0x78),fl_rgb_color(0x8b,0x22,0x52),fl_rgb_color(0xf5,0xde,0xb3),fl_rgb_color(0xff,0xe7,0xba),fl_rgb_color(0xee,0x8e,0xae),fl_rgb_color(0xcd,0xba,0x96),fl_rgb_color(0x8b,0x7e,0x66),fl_rgb_color(0xFF,0xFF,0xFF),fl_rgb_color(0xf5,0xf5,0xf5),fl_rgb_color(0xff,0xff,0x00),fl_rgb_color(0xff,0xff,0x00),
fl_rgb_color(0xee,0xee,0x00),fl_rgb_color(0xcd,0xcd,0x00),
fl_rgb_color(0x8b,0x8b,0x00),fl_rgb_color(0x9a,0xcd,0x32)
};


Fl_Color getColor(char *col)
{
  int i;

  for(i=0 ; i<NBFCOL ; i++){
    if( strcmp(stab[i], col)==0 )
      return ftab[i];
  }
#ifdef DEBUG
  printf("Couleur de feature non disponible (%s)\n", col);
#endif
  return FL_WHITE;
}


char *check_alloc(int nbrelt, int sizelt)
{
	char *retval;

	if( (retval=(char *)calloc(nbrelt,sizelt)) != NULL ){
	  return(retval);
	}

#ifdef MACINTOSH
	ShowMessage("\pERROR: not enough memory (check_alloc).",FALSE);
#else
	fprintf(stderr,"\nERROR: not enough memory (check_alloc).\n");
#endif

return NULL;
      
}


Fl_Color get_color(float sim) 
{
	int ii;

	for(ii=0; ii < NBCOL; ii++)
		if(sim >= color_lg[ii].sco) return(color_lg[ii].col);

	return(FL_WHITE);
}


void load_color_lg(void)
{
  Fl_Color liscol[]={FL_BLACK, 
		     fl_rgb_color(0x85, 0x11, 0x49), 
		     fl_rgb_color(0xd8, 0x17, 0x9b),
		     FL_RED,
		     fl_rgb_color(0xe8, 0x7a, 0x3b),
		     fl_rgb_color(0xff, 0xcc, 0x6c),
		     fl_rgb_color(0xfa, 0xff, 0xb),
		     fl_rgb_color(0xda, 0xda, 0xdf),
		     fl_rgb_color(0xef, 0xef, 0xdd)
  };

  float lissco[]={100.0, 90.0, 80.0, 70.0, 60.0, 50.0, 40.0, 30.0, 20.0};
  char * labels[]={"100","90","80","70","60","50","40","30","20"};
  int ii;

  for(ii = 0; ii < NBCOL; ii++) {
    //strcpy(color_lg[ii].col, liscol[ii]);
    color_lg[ii].col = liscol[ii];
    color_lg[ii].sco = lissco[ii];
  }
}

int saveColorScale(char *fic)
{
  int i;
  FILE * nf;
  nf = fopen(fic, "w+");
  if( !nf )
    return -1;

  for(i=0 ; i<NBCOL ; i++){
    fwrite(&color_lg[i].col, sizeof(color_lg[i].col), 1, nf);
  }
  fclose(nf);

  return 0;
}

int loadColorScale(char *fic)
{
  int i;
  FILE * nf;
  nf = fopen(fic, "r");
  if( !nf )
    return -1;

  for(i=0 ; i<NBCOL ; i++){
    if(feof(nf)){
      //printf("Bad format file.\n");
      fclose(nf);
      return -2;
    }
    fread(&color_lg[i].col, sizeof(color_lg[i].col), 1, nf);
  }
  char c;
  fread(&c, sizeof(c), 1, nf);
  if( !feof(nf) ){
    fclose(nf);
    return -2;
  }

  fclose(nf);
  return 0;
}

int fcmpSeg(const void * s1, const void *s2)
{
  if( ((struct SEG *)s1)->sco > ((struct SEG *)s2)->sco )
    return -1;

  if( ((struct SEG *)s1)->sco == ((struct SEG *)s2)->sco ){
    if( ((struct SEG *)s1)->beg0 > ((struct SEG *)s2)->beg0 )
      return 1;
    else
      return -1;
  }
    return 0;

  return 1;
}



/* int fcmpBloc(const void *b1, const void *b2)
   Used to sort the blocs.
*/
int fcmpBloc(const void *b1, const void *b2)
{
  if( ((struct BLOC *)b1)->seg > ((struct BLOC *)b2)->seg )
    return 1;

  if( ((struct BLOC *)b1)->seg == ((struct BLOC *)b2)->seg ){
    if(((struct BLOC *)b1)->beg > ((struct BLOC *)b2)->beg )
      return 1;
    else
      return -1;
  }

  return -1;
}

void scrolb_cb(Fl_Widget * w)
{
  Fl_Scrollbar * scrolb = (Fl_Scrollbar *)w;

  MF_MyScroll * grp = (MF_MyScroll *)scrolb->parent();
  grp->redraw();
}




/* void echange(SEG *tab, int i, int j)
   swaps two segments.
*/
void echange(SEG *tab, int i, int j)
{
  SEG s = tab[i];
  tab[i] = tab[j];
  tab[j] = s;
}

/* void tribulle(SEG *tab, int n)
   A sort function used to sort the segments.
*/
void tribulle(SEG *tab, int n)
{
  int ok, i;
  do {
    ok = 1;
    for(i=1 ; i<n ; i++){
      if(tab[i-1].sco < tab[i].sco || (tab[i-1].sco==tab[i].sco && tab[i-1].beg0 < tab[i].beg0) ){
	ok = 0;
	echange(tab, i-1, i);
      }
    }
  }
  while(!ok);
}

/* void listeSegm(void)
   Simply displays all the segments in text mode (not used in the programm but quite useful 
   to check things when debbuging).
*/
void listeSegm(void)
{
  int i;
  for(i=0 ; i<NBSEG ; i++)
    printf("Seg %3d - id : %3d - score : %.2f\n", i, segm[i].id, segm[i].sco);
}

/* void listeBloc(int ns)
   Displays all the blocks in text mode.
*/
void listeBloc(int ns)
{
  int i;
  BLOC b;
  for(i=0 ; i<NBBLOC ; i++){
    b = seq[ns].bloc[i];
    if(b.seg<4)
      printf("BLOC %3d sur Seg : %3d\n", i, b.seg);
  }
}

/* void displayBloc(BLOC b)
   Displays the given BLOC ('b') in text mode.
*/
void displayBloc(BLOC b)
{
  printf("BLOC ( %-6d-%6d ) sur Seg %d\n", b.beg, b.end, b.seg);
}


void afficherSegm(int i)
{
  printf("segm[%d] : ( %-4d - %4d )\n", i, segm[i].beg0, segm[i].end0);
}

/* void trier(void)
   sorts the segments inside the segm table.
   Once this function has been called, the table segm is sorted with the best segments in the first ranges.
*/
void trier(void)
{
  int i, j, k;
  BLOC b;

  for(i=0 ; i<NBBLOC ; i++){
    seq[0].bloc[i].idb = i;
  }


#ifdef DEBUGLOG
  FILE *nf;
  nf = fopen("segm_av.data", "w");
  for(i=0 ; i<NBSEG ; i++){
    SEG s = segm[i];
    fprintf(nf, "segm[%3d] : sco : %4.2f - deb0 : %4d-%4d - deb1 : %4d-%4d\n", 
	   i, s.sco, s.beg0, s.end0, s.beg1, s.end1);
  }
  fclose(nf);

  nf = fopen("bloc_av.data", "w");
  for(i=0 ; i<NBBLOC ; i++){
    b = seq[0].bloc[i];
    fprintf(nf, "seq[0].bloc[%3d] (%3d) : b.seg:%d | b.beg:%d | b.end:%d\n", i, b.idb, b.seg, b.beg, b.end);
  }
  fclose(nf);
#endif

  
  for(i=0 ; i<2 ; i++){
    for(j=0 ; j<NBBLOC ; j++){
      seq[i].bloc[j].seg--;
    }
  }
  
  int nbsb;

  /*************************************************************************************/
  for(i=0 ; i<NBSEG ; i++){
    if(segm[i].beg0<0 || segm[i].beg1<0){
#ifdef DEBUG
      printf("Suppression du segment %d\n", i);
      printf("WARNING : found segment with lenght < 2 ... segment ignored.\n");
#endif
      nbsb = NBBLOC;
      for(j=0 ; j<NBBLOC ; j++){
	if(seq[0].bloc[j].seg==i){
#ifdef DEBUG
	  printf("Suppression du bloc seq[%d].bloc[%d]\n", 0, j);
#endif
	  seq[0].bloc[j]=seq[0].bloc[NBBLOC-1];
	  NBBLOC--;
	}
      }
      NBBLOC = nbsb;
      for(j=0 ; j<NBBLOC ; j++){
	if(seq[1].bloc[j].seg==i){
	  seq[1].bloc[j]=seq[1].bloc[NBBLOC-1];
	  NBBLOC--;
	}
      }
      segm[i]=segm[NBSEG-1];
      NBSEG--;
    }
  }
  /******************************************************************/  

  for(i=0 ; i<NBSEG ; i++){
    segm[i].id = i;
  }


  /* Les segments sont tries par score decroissant */
  //  qsort(segm, NBSEG, sizeof(struct SEG), fcmpSeg);
  tribulle(segm, NBSEG);


#ifdef DEBUGLOG
  nf = fopen("segm_ap.data", "w");
  for(i=0 ; i<NBSEG ; i++){
    SEG s = segm[i];
    fprintf(nf, "segm[%3d].sco : %.2f   -   deb0 : %4d-%4d - deb1 : %-4d-%4d\n", 
	   i, s.sco, s.beg0, s.end0, s.beg1, s.end1);
  }
  fclose(nf);
#endif

  for(i=0 ; i<2 ; i++){
    for(j=0 ; j<NBBLOC ; j++){
      b = seq[i].bloc[j];
      if( segm[b.seg].id != b.seg ){
	for(k=0 ; k<NBSEG && segm[k].id!=b.seg ; k++)
	  ;
	seq[i].bloc[j].seg = k;
      }
    }
  }

  for(i=0 ; i<2 ; i++){
    qsort(seq[i].bloc, NBBLOC, sizeof(struct BLOC), fcmpBloc);
  }


#ifdef DEBUGLOG
  nf = fopen("bloc_ap.data", "w");
  for(l=0 ; l<NBBLOC ; l++){
    b = seq[0].bloc[l];
    fprintf(nf, "seq[0].bloc[%3d] (%3d) : b.seg:%d .  (%d - %d) ... seg.scp:%.2f\n", l, b.idb, b.seg, b.beg, b.end, segm[seq[0].bloc[l].seg].sco);
  }
  fclose(nf);
#endif


#ifdef DEBUGSHOWALL
  for(i=0 ; i<NBBLOC ; i++){
    b = seq[0].bloc[i];
    if(b.seg<2 || 1)
      displayBloc(b);
  }

  printf("----------------------------\n");

  for(numbloc=0 ; numbloc<NBBLOC ; numbloc++){
    numseg = seq[0].bloc[numbloc].seg;
    get_aln(numseg, &ident, &gapf, &lgaln, numbloc);
    printf("BLOC %d, numseg : %d - lgaln : %d - ident : %.2f\n", numbloc, numseg, lgaln, ident);
  }
#endif

}

bool isDrawable(SEG s, float scoMin, float identityMin, int lenghtMin, int bck, int onlyGreen, int onlyRed)
{
  if( onlyRed ){
    if( s.myList == _LIST_RED_ )
      return true;
    return false;
  }

  if( onlyGreen ){
    if( s.myList == _LIST_GREEN_ )
      return true;
    return false;
  }

  if( s.myList == _LIST_GREEN_ )
    return true;

  if( s.myList == _LIST_RED_ )
    return false;

  if( s.sco>=scoMin && s.identity>=identityMin && s.lgaln>=lenghtMin && (!bck || s.bestSeries))
    return true;
  return false;
}
