#include <FL/fl_ask.H>

#include "lalnview.h"
#include "globals.h"


#define TRUE true
#define FALSE false

/*
char aln_fic_name[300];
char aln_fic_name_short[300];
*/

/* charge l'alignement. Retourne 0 si Ok, sinon numero d'erreur */
void complement(char *seq);
char *_ficname_;
char *_dirname_;


int load_data(char *ficname)

{
  char _DIRSEP_ = '/';

#ifdef WIN32
	_DIRSEP_ = '\\';
#elif defined( __APPLE__ )
	_DIRSEP_ = ':';
#endif

  FILE *fic;
  char string[100];
  int test = 0;
  int i, j;
 _ficname_ = strdup(ficname);

 j = 0;
 for(i=0 ; i<strlen(_ficname_) ; i++)
   if(_ficname_[i] == _DIRSEP_ )
     j = i;
 j++;
 _dirname_ = (char *)malloc( (j+1)*sizeof(char) );
 strncpy(_dirname_, _ficname_, j);
 _dirname_[j] = '\0';

 
 //printf("%s\n", FIRST_SHOWN);
 
 if((fic = fopen(ficname, "r"))==NULL) return(8);
 
 fgets(string, 100, fic);
 ;
 
if(strncmp(string, "#:lav", 5) == 0) test = 1;
 
 else if(strncmp(string, " searching", 10) == 0 ||
	 strncmp(string, " Comparison of:", 15) == 0) test = 2;
 
 else {
   while(fgets(string, 100, fic)!=NULL) {
     if(strncmp(string, " Comparison of:", 15) == 0) {
       test = 2;
       break;
     }
   }
   rewind(fic);
 }
 
 if (test == 0) {
   fclose(fic);
   return(1);
 }
 
 
 NBSEQ = 2;
 NBBLOC = 0;
 NBSEG = 0;
 
 seq[0].y = (double) 0.52;
 seq[1].y = (double) 0.22;
 
 dist12 = seq[1].y - seq[0].y - lrg_box;
 
 
 seq[0].ori = 0;
 seq[1].ori = 0;
 
 seq[0].id = 0;
 seq[1].id = 1;
 
 
 if(test == 1) {
   test = load_data_sim(fic);
   fclose(fic);
   NEWSEQ = 1;
   return(test);
 }
 
 if(test == 2) {
   test = load_data_lfasta(fic);
   fclose(fic);
   NEWSEQ = 1;
   return(test);
 }
 
 
 else {
   fclose(fic);
   return(1);
 }
}

int load_data_sim(FILE *fic)
  
{
  int ii, lg;
  char string[100], fic_name[2][400];
  int segnum; 		/* numero d'un segment = d'un ensemble de blocs */
  float score;
  float bestscore;
  char buf[MAXMN];
  
  bestscore = 0.0;
  
  /* get seq. info */
  strcpy(sim_parameter, "");
  
  while(fgets(string, 100, fic)!=NULL) {
    if(strstr(string, "d {") != NULL) {
      for(;;) {
	fgets(string, 100, fic);
	if(string[0] == '}') break;
	strcat(sim_parameter, string);
      }
      
      break;
    }
  }
  
  while(fgets(string, 100, fic)!=NULL) {
    if(strstr(string, "s {") != NULL) {
      fgets(string, 100, fic);
      if(sscanf(string, "%s %*s %d", fic_name[0], &lg) != 2) return(2);
      seq[0].lg = lg;
      
      Nieme_mot(fic_name[0], 1, "\"", fic_name[0]);
      
      
      fgets(string, 100, fic);
      if(sscanf(string, "%s %*s %d", fic_name[1], &lg) != 2) return(3);
      seq[1].lg = lg;
      
      Nieme_mot(fic_name[1], 1, "\"", fic_name[1]);
      
      break;
    }
  }
  
  
  if(seq[0].lg > seq[1].lg) maxscroll = (double) seq[0].lg;
  else maxscroll = (double) seq[1].lg;
  
  /* alloue memoire pour les seq. */
  
  if(seq[0].seq != NULL) free(seq[0].seq);
  if(seq[1].seq != NULL) free(seq[1].seq);
  
  if((seq[0].seq = (char *)calloc(seq[0].lg + 1,sizeof(char))) == NULL ) return(13);
  if((seq[1].seq = (char *)calloc(seq[1].lg + 1,sizeof(char))) == NULL ) {
    free(seq[0].seq); return(13); }
  
  
  
  /* counts number of blocks */
  GET_SEQ_FROM_SIM = false;
  GET_FEAT_FROM_SIM = false;
  
  while(fgets(string, 100, fic)!=NULL) {
    if(strncmp(string, "a {", 3) == 0) NBSEG++;
    if(strncmp(string, "  l ", 4) == 0) NBBLOC++;
    if(strncmp(string, "# SEQUENCES BEGIN", 17) == 0) 
      GET_SEQ_FROM_SIM = true;
    if(strncmp(string, "# FEATURES BEGIN", 16) == 0) 
      GET_FEAT_FROM_SIM = true;
  }
  
  ii = get_seq_fasta(fic_name[0], 0);
  if(ii != 0) return(ii);
  
  ii = get_seq_fasta(fic_name[1], 1);
  if(ii != 0) return(ii);
  
  if(GET_FEAT_FROM_SIM == TRUE){
    //   printf("get_feature(%s);\n", _ficname_);
    get_feature(_ficname_);
  }
  
  rewind(fic);
  
  if(seq[0].bloc != NULL) free((char *) seq[0].bloc);
  if(seq[1].bloc != NULL) free((char *) seq[1].bloc);
  if(segm != NULL) free((char *) segm);
  
  seq[0].bloc = (struct BLOC *)check_alloc(NBBLOC+1,sizeof(struct BLOC));
  seq[1].bloc = (struct BLOC *)check_alloc(NBBLOC+1,sizeof(struct BLOC));
  segm = (struct SEG *)check_alloc(NBSEG+1,sizeof(struct SEG));
  
  
  /* get blocks info */
  
  segnum = 0;
  ii = 0;
  
  COMPLEMENT = 0;
  while(fgets(string, 100, fic)!=NULL) {
    
    /* in SIM4  if R!0 requires that shorter sequence be 
       reverse complemented. */
    
    if(strncmp(string, "(complement)", 12) == 0) {
      COMPLEMENT = 1;
      if(seq[0].lg < seq[1].lg) {
	sprintf(buf, "C_%s", seq[0].name);
	strcpy(seq[0].name, buf);
	complement(seq[0].seq);
      }
      else {
	sprintf(buf, "C_%s", seq[1].name);
	strcpy(seq[1].name, buf);
	complement(seq[1].seq);
      }
    }
    
    if(strncmp(string, "  s ", 4) == 0) {
      if(sscanf(string, "%*s %f", &score) != 1) return(4);
      segm[segnum].sco = score;
      if(score > bestscore) bestscore = score;
      continue;
    }
    
    if(strncmp(string, "  b ", 4) == 0) {
      if(sscanf(string, "%*s %d %d", 
		&segm[segnum].beg0, &segm[segnum].beg1) != 2) return(5);
      continue;
    }
    
    if(strncmp(string, "  e ", 4) == 0) {
      if(sscanf(string, "%*s %d %d", 
		&segm[segnum].end0, &segm[segnum].end1) != 2) return(6);
      segnum++;
      continue;
    }

    if(strncmp(string, "  l ", 4) != 0) continue;
    
    if(sscanf(string, "%*s %d %d %d %d %f", 
	      &seq[0].bloc[ii].beg,
	      &seq[1].bloc[ii].beg,
	      &seq[0].bloc[ii].end,
	      &seq[1].bloc[ii].end,
	      &seq[0].bloc[ii].sim
	      ) != 5) return(7);
    seq[1].bloc[ii].sim = seq[0].bloc[ii].sim;
    seq[1].bloc[ii].seg = seq[0].bloc[ii].seg = segnum;
    seq[1].bloc[ii].sco = seq[0].bloc[ii].sco = score;
    
    ii++;
  }
  
  if(seq[0].lg > seq[1].lg) LGSEQMAX = seq[0].lg;
  else LGSEQMAX = seq[1].lg;
  
  if(bestscore < seuil_score_sim) seuil_score_sim = bestscore;
  cur_seq_view = LGSEQMAX;
  
  
  
  return(0);
}


void Nieme_mot(char *string, int n, char *separat, char *result)
{

  int ii;
  char *mot;
  char  *phrase;
  
  
  if((phrase = (char*) malloc((1+strlen(string)) * sizeof(char))) == NULL){
    fprintf(stderr,"ERROR: not enough memory in function: Nieme_mot \n");
    exit(3);
  }
  
  strcpy(phrase,string);
  
  mot = strtok(phrase, separat);
  for(ii = 1; ii < n; ii++) 
    if(mot != NULL)
      mot = strtok(NULL, separat);
  
  if(mot != NULL) strcpy(result, mot);
  else strcpy(result, "\0");
  
  free(phrase);
  
  return;
}


int get_seq_fasta(char *fic_name, int num)
{
  FILE *fic;
  char string[300], buf[300];
  unsigned char c;
  long ii;
  char repere[100];
  int lg;
  char *absName;

  absName = (char *)malloc( sizeof(char)*(strlen(_dirname_)+strlen(fic_name)+1) );
  if( strlen(_dirname_)>1 ){
    sprintf(absName, "%s%s\0", _dirname_, fic_name);
    sprintf(fic_name, "%s", absName);
  }

  // DEBUG !!!!!!!!!!  
  // GET_SEQ_FROM_SIM = true;
  if(GET_SEQ_FROM_SIM == TRUE) strcpy(fic_name, aln_fic_name);
  
 //printf("fic : %s\n", fic_name); 
  
  if((fic = fopen(fic_name, "r"))==NULL) {
    ii = strlen(fic_name) - 1;
    if(fic_name[ii] == '-') fic_name[ii] = 0;
    if((fic = fopen(fic_name, "r"))==NULL) {
      
      /*
#ifdef MACINTOSH
      sprintf(buf, "ERROR: impossible to open %s\n", fic_name);
      ShowMessage(c2pstr(buf),FALSE);
#else
      fl_alert(stderr, "ERROR: impossible to open %s\n", fic_name);
#endif
      */
		NBBLOC = NBSEQ = 0;
      fl_alert("ERROR: impossible to open %s\n", fic_name);
      return(9);
    }
  }
  
  if(GET_SEQ_FROM_SIM == TRUE) {
    sprintf(repere, "# SEQUENCES BEGIN %d", num+1);
    lg = (int) strlen(repere);
    
    while(fgets(string, 300, fic)!= NULL) {
      if(strncmp(string, repere, lg) == 0) break;
      if(strncmp(string, "# SEQUENCES END", 15) == 0) return(12);
    }
  }
  
  
  fgets(string, 300, fic);
  
  
  if(string[0] != '>') {
#ifdef MACINTOSH
    sprintf(buf, "ERROR:  %s not in FASTA format\n", fic_name);
    ShowMessage(c2pstr(buf),FALSE);
#else
    fprintf(stderr, "ERROR:  %s not in FASTA format\n", fic_name);
#endif
    return(10);
  }
  
  Nieme_mot(string+1, 1, " \t\n", seq[num].name);
  
  
  ii = 0;
  while( (c = (char) fgetc(fic)) != EOF) {
    if(c == ' ') continue;
    if(c == '\t') continue;
    if(c == '\n' || c == '\r') continue;
    if(c == '*') continue;
    if(c == '#') break;
    if(feof(fic) != 0) break;
    seq[num].seq[ii++] = c;
    
    if(ii > seq[num].lg ) {

      fl_alert("ERROR: sequence longer than expected");
      /*
	#ifdef MACINTOSH
	sprintf(buf, "ERROR: sequence longer than expected\n");
	ShowMessage(c2pstr(buf),FALSE);
	#else
	fprintf(stderr, "ERROR: sequence longer than expected\n");
	#endif
      */
      return(11);
    }
    
  }

  seq[num].seq[ii] = '\0';
  
  fclose(fic);
  return(0);
}


/* reads alignment from LFASTA or LALIGN */

int load_data_lfasta(FILE *fic)
{
  int ii, jj, lg, num;
  char string[100], fic_name[2][400];
  int numbloc;
  float bestscore;
  char *aln1, *aln0;
  long *lis_pos, pos;
  
  bestscore = 0.0;
  
  /* get seq. info */
  while(fgets(string, 100, fic)!=NULL) {
    num = -1;
    if     (strncmp(string, "(A) ", 4) == 0) num = 0;
    else if(strncmp(string, "(B) ", 4) == 0) num = 1;
    
    if(num != -1) {
      Nieme_mot(string, 2, " ", fic_name[num]);
      ii= strlen(string) - 4;
      string[ii] = '\0';
      for(;ii>=0; ii--) if(string[ii] == ' ') break;
      ii++;
      seq[num].lg = atoi(string+ii);
      
    }
    if(num == 1) break;
  }
  
  
  /* get alignment parameters */
  
  while(fgets(string, 100, fic)!=NULL) {
    if(strncmp(string, " using", 6) == 0) {
      strcpy(sim_parameter, string);
      break;
    }
  }
  
  
  if(seq[0].lg > seq[1].lg) maxscroll = (double) seq[0].lg;
  else maxscroll = (double) seq[1].lg;
  
  /* alloue memoire pour les seq. */
  
  if(seq[0].seq != NULL) free(seq[0].seq);
  if(seq[1].seq != NULL) free(seq[1].seq);
  
  if((seq[0].seq = (char *)calloc(seq[0].lg + 1,sizeof(char))) == NULL ) return(13);
  if((seq[1].seq = (char *)calloc(seq[1].lg + 1,sizeof(char))) == NULL ) {
    free(seq[0].seq); return(13); }
  
  
  
  
  /* counts number of segments */
  GET_SEQ_FROM_SIM = FALSE;
  GET_FEAT_FROM_SIM = FALSE;
  
  while(fgets(string, 100, fic)!=NULL) {
    if(strstr(string, " overlap; ") != NULL) NBSEG++;
    if(strncmp(string, "# SEQUENCES BEGIN", 17) == 0) 
      GET_SEQ_FROM_SIM = TRUE;
    if(strncmp(string, "# FEATURES BEGIN", 16) == 0) 
      GET_FEAT_FROM_SIM = TRUE;
  }
  
  ii = get_seq_fasta(fic_name[0], 0);
  if(ii != 0) return(ii);
  
  ii = get_seq_fasta(fic_name[1], 1);
  if(ii != 0) return(ii);
  
  if(GET_FEAT_FROM_SIM == TRUE){
    //printf("get_feature(%s);\n", _ficname_);
    get_feature(_ficname_);
  }
  
  /* recupere les positions des fragments dans le fichier */
  lis_pos = (long *) check_alloc(NBSEG,sizeof(long));
  
  rewind(fic);
  
  ii = 0;
 pos = ftell(fic);
 while(fgets(string, 100, fic)!=NULL) {
   if(strstr(string, " overlap; ") != NULL) lis_pos[ii++] = pos;
   pos = ftell(fic);
 }
 
 /* compte les blocs */
 for(ii = 0; ii < NBSEG; ii++) {
   jj = compte_bloc_lfasta(ii, fic, lis_pos[ii]);
   if(jj < 0) {free((char *) lis_pos); return(abs(jj));}
   NBBLOC+= jj;
 }

 if(seq[0].bloc != NULL) free((char *) seq[0].bloc);
 if(seq[1].bloc != NULL) free((char *) seq[1].bloc);
 if(segm != NULL) free((char *) segm);
 

 seq[0].bloc = (struct BLOC *)check_alloc(NBBLOC+1,sizeof(struct BLOC));
 seq[1].bloc = (struct BLOC *)check_alloc(NBBLOC+1,sizeof(struct BLOC));
 segm = (struct SEG *)check_alloc(NBSEG+1,sizeof(struct SEG));
 
 



 /* get blocks info */

 numbloc = 0;

 for(ii = 0; ii < NBSEG; ii++) {
   jj = get_bloc_info_lfasta(ii, fic, &bestscore, &numbloc, lis_pos[ii]);
   if(jj < 0) {free((char *) lis_pos); return(abs(jj));}
 }
 
 

 if(seq[0].lg > seq[1].lg) LGSEQMAX = seq[0].lg;
 else LGSEQMAX = seq[1].lg;
 
 if(bestscore < seuil_score_sim) seuil_score_sim = bestscore;
 cur_seq_view = LGSEQMAX;
 

 free((char *) lis_pos);

 return(0);


} /* fin de load_data_lfasta */



int compte_bloc_lfasta(int numseg, FILE *fic, long pos)

{
  char string[100], buf[100];
  char *aln0;
  char *aln1;
  int lgaln, nbbloc = 0, ii;

  /* alloue les seq. alignees: au plus, lg aln = somme des seq */

  if((aln0 = (char *)calloc((seq[0].lg + seq[1].lg + 1),
			    sizeof(char))) == NULL ) return(-13);
  
  if((aln1 = (char *)calloc((seq[0].lg + seq[1].lg + 1),
			    sizeof(char))) == NULL ) { free(aln0); return(-13); }


  /* positionne en debut de fragment */
  fseek(fic, pos, 0);
  fgets(string, 100, fic);
  
  /* recupere les seq alignees */
  
  aln0[0] = '\0';
  aln1[0] = '\0';
  
  for(;;) {
    fgets(string, 100, fic);			/* vide */
    fgets(string, 100, fic);			/* numerotation 1 */
    if(strncmp(string, "----------", 10) == 0) break;
    fgets(string, 100, fic);			/* aln0 */
    Nieme_mot(string+7, 1, "\n", buf);
    if((int)(strlen(buf) + strlen(aln0)) > (seq[0].lg + seq[1].lg))
      { free(aln0); free(aln1); return(-14); }
    
    strcat(aln0, buf);
    fgets(string, 100, fic);			/* inter-aln */
    fgets(string, 100, fic);			/* aln1 */
    Nieme_mot(string+7, 1, "\n", buf);
    if((int)(strlen(buf) + strlen(aln1)) > (seq[0].lg + seq[1].lg))
      { free(aln0); free(aln1); return(-14); }
    
    strcat(aln1, buf);
    fgets(string, 100, fic);			/* numerotation 2 */
    
  }
  
  lgaln = strlen(aln0);
  
  for(ii = 1; ii < lgaln; ii++) {
    if(aln0[ii] == '-' && aln0[ii-1] != '-') nbbloc++;
    if(aln1[ii] == '-' && aln1[ii-1] != '-') nbbloc++;
  }
  
  if(aln0[lgaln-1] != '-' && aln1[lgaln-1] != '-') nbbloc++;
  
  free(aln0);
  free(aln1);
  
  return(nbbloc);
  
} /* fin de compte_bloc_lfasta */ 


int get_bloc_info_lfasta(int segnum, FILE *fic, float *bestscore, int *numbloc, long pos)
{
  char string[100], buf[100];
  char *aln0;
  char *aln1;
  int lgaln, nbbloc = 0, ii, jj;
  float score;
  int pos_seq;
  long posfic;
  int blocnum;
  
  int deb0, deb1, cur0, cur1, nbid;
  int nbgap1, nbgap2, debaln;
  
  blocnum = *numbloc;
  
  /* alloue les seq. alignees: au plus, lg aln = somme des seq */
  
  if((aln0 = (char *)calloc((seq[0].lg + seq[1].lg + 1),
			    sizeof(char))) == NULL ) return(-13);
  
  if((aln1 = (char *)calloc((seq[0].lg + seq[1].lg + 1),
			    sizeof(char))) == NULL ) { free(aln0); return(-13); }
  
  
  /* positionne en debut de fragment */
  fseek(fic, pos, 0);
  fgets(string, 100, fic);
  
  posfic = ftell(fic);


  /* recupere le score */
  if(strstr(string, " init:") != NULL) {
    if(sscanf(string, "%*s %*s %*s %*s %*s %*s %*s %*s %*s %f", 
	      &score) != 1) {free(aln0); free(aln1); return(-4);};
    segm[segnum].sco = score;
  }
  
  else if(strstr(string, " score:") != NULL) {
    if(sscanf(string, "%*s %*s %*s %*s %*s %*s %*s %f", 
	      &score) != 1) {free(aln0); free(aln1); return(-4);};
    segm[segnum].sco = score;
  }
  if(*bestscore < score) *bestscore = score;
  
  

  /* recupere les seq alignees */

  aln0[0] = '\0';
  aln1[0] = '\0';
  
  segm[segnum].beg0 = seq[0].lg;
  segm[segnum].beg1 = seq[1].lg;
  
  for(;;) {
    fgets(string, 100, fic);			/* vide */
    fgets(string, 100, fic);			/* numerotation 1 */
    if(strncmp(string, "----------", 10) == 0) break;
    fgets(string, 100, fic);			/* aln0 */
    Nieme_mot(string+7, 1, "\n", buf);
    if((int)(strlen(buf) + strlen(aln0)) > (seq[0].lg + seq[1].lg))
      { free(aln0); free(aln1); return(-14); }
    strcat(aln0, buf);
    fgets(string, 100, fic);			/* inter-aln */
    fgets(string, 100, fic);			/* aln1 */
    Nieme_mot(string+7, 1, "\n", buf);
    if((int)(strlen(buf) + strlen(aln1)) > (seq[0].lg + seq[1].lg))
      { free(aln0); free(aln1); return(-14); }
    strcat(aln1, buf);
    fgets(string, 100, fic);			/* numerotation 2 */
    
  }
  
  
  /* recupere les positions de debut de segment */
  
  fseek(fic, posfic, 0);
  
  fgets(string, 100, fic);			/* vide */
  fgets(string, 100, fic);			/* numerotation 1 */
  if((pos_seq = get_pos_seq(string, aln0)) < segm[segnum].beg0){
#ifdef DEBUG
    if(pos_seq<0)
      printf("NEGATIF : %d\n", segnum);
#endif
    segm[segnum].beg0 = pos_seq;
  }
  fgets(string, 100, fic);			/* aln0 */
  fgets(string, 100, fic);			/* inter-aln */
  fgets(string, 100, fic);			/* aln1 */
  fgets(string, 100, fic);			/* numerotation 2 */
  if((pos_seq = get_pos_seq(string, aln1)) < segm[segnum].beg1)
    segm[segnum].beg1 = pos_seq;
  
  
  lgaln = strlen(aln0);
  
  /* recupere les positions de fin de segment */
  segm[segnum].end0 = segm[segnum].beg0;
  for(ii=1; ii < lgaln; ii++) if(aln0[ii] != '-') segm[segnum].end0++;
  
  segm[segnum].end1 = segm[segnum].beg1;
  for(ii=1; ii < lgaln; ii++) if(aln1[ii] != '-') segm[segnum].end1++;
  
  deb0 = segm[segnum].beg0;
  deb1 = segm[segnum].beg1;
  cur0 = deb0;
  cur1 = deb1;
  nbid = 0;
  nbgap1 = nbgap2 = 0;
  debaln = 1;
  

  /* cherche debut du 1er bloc (cas ou l'aln debute par des gaps) */
  for(jj =0; jj < lgaln; jj++) {
    if(aln0[jj] != '-' && aln1[jj] != '-') break;
    else if(aln0[jj] != '-') cur0++;
    
    else if(aln1[jj] != '-') cur1++;
    
    
    deb0 = cur0;
    deb1 = cur1;
    
    
  }
  
  ii = jj;
  
  if(ii == 0 ) 	ii = 1;
  
  
  /* traite le 1er residu aligne */
  if(aln0[ii-1] == aln1[ii-1] &&  aln0[ii-1] != '-') nbid++;
  
  
  for(; ii < lgaln; ii++) {
    if(aln0[ii] != '-') cur0++;
    else nbgap1++;
    
    if(aln1[ii] != '-') cur1++;
    else nbgap2++;
    
    if(aln0[ii] == aln1[ii]) nbid++;
    
    if((aln0[ii] == '-' && aln0[ii-1] != '-') ||
       (aln1[ii] == '-' && aln1[ii-1] != '-')) {
      cur0 = cur0-nbgap2;
      cur1 = cur1-nbgap1;
      
      seq[0].bloc[blocnum].beg = deb0;
      seq[1].bloc[blocnum].beg = deb1;
      seq[0].bloc[blocnum].end = cur0;
      seq[1].bloc[blocnum].end = cur1;
      
      seq[0].bloc[blocnum].sim = 100. * (float) nbid / 
	(float)(ii - debaln - nbgap1 - nbgap2 +1);
      
      seq[1].bloc[blocnum].sim = seq[0].bloc[blocnum].sim;
      seq[1].bloc[blocnum].seg = seq[0].bloc[blocnum].seg = segnum+1;
      seq[1].bloc[blocnum].sco = seq[0].bloc[blocnum].sco = score;
      
      blocnum++;
      
      nbid = 0;
      nbgap1 = nbgap2 = 0;
      debaln = ii;
      
      /* cherche debut du bloc suivant */
      for(jj = ii; jj < lgaln; jj++) {
	deb0 = cur0+1;
	deb1 = cur1+1;
	
	if(aln0[jj] != '-' && aln1[jj] != '-') break;
	
	else if(aln0[jj] != '-') cur0++;
	
	else if(aln1[jj] != '-') cur1++;
	
      }
      
    }
  }
  
  /* traite le dernier bloc - sauf si aln se termine par des gap*/
  
  if(aln0[lgaln -1] != '-' && aln1[lgaln -1] != '-' ) {
    seq[0].bloc[blocnum].beg = deb0;
    seq[1].bloc[blocnum].beg = deb1;
    seq[0].bloc[blocnum].end = cur0-nbgap2;
    seq[1].bloc[blocnum].end = cur1-nbgap1;
    
    seq[0].bloc[blocnum].sim = 100. * (float) nbid / 
      (float)(ii - debaln - nbgap1 - nbgap2 +1);
    seq[1].bloc[blocnum].sim = seq[0].bloc[blocnum].sim;
    seq[1].bloc[blocnum].seg = seq[0].bloc[blocnum].seg = segnum+1;
    seq[1].bloc[blocnum].sco = seq[0].bloc[blocnum].sco = score;
    blocnum++;
  }
  
  free(aln0);
  free(aln1);
  
  *numbloc = blocnum;
  return(nbbloc);
  
  
} /* fin de get_bloc_info_lfasta */


int get_pos_seq(char *string, char *aln)
{
  char buf[20];
  int ii, jj, firstnum, nbgap=0;
  
  for(ii=0; ii < 80; ii++)
    if(string[ii] != ' ') break;
  
  for(; ii < 80; ii++)
    if(string[ii] == ' ') break;
  
  
  Nieme_mot(string, 1, " \n", buf);
  firstnum = atoi(buf);
  
  ii-= 8;
  
  for(jj=0; jj<ii; jj++) if(aln[jj] == '-') nbgap++;
  
  firstnum = firstnum - ii + nbgap;
  
  return(firstnum);
  
}


void complement(char *seq)
{
  int lg, ii;
  char *buf, c;

  lg = strlen(seq);

  if((buf = (char *)calloc(lg + 1,sizeof(char))) == NULL ) {
    fprintf(stderr, "ERROR: not enough memory!\n");
    exit(1);
  }
  lg --;
  ii = 0;
  for(;lg >= 0; lg--) {
    if     (seq[lg] == 'A' || seq[lg]== 'a') c = 'T';
    else if(seq[lg] == 'T' || seq[lg]== 't') c = 'A';
    else if(seq[lg] == 'U' || seq[lg]== 'u') c = 'A';
    else if(seq[lg] == 'C' || seq[lg]== 'c') c = 'G';
    else if(seq[lg] == 'G' || seq[lg]== 'g') c = 'C';
    else c = 'N';
    buf[ii++] = c;
  }
  buf[ii] = 0;
  strcpy(seq, buf);
  
  free(buf);
  
}
