#ifdef __APPLE__

#include <FL/filename.H>

extern "C" { 
	void CtoP(const void *in, void *out);
	void PtoC(const void *in, void *out);
	void MG_FSSpecToPathname (FSSpec *myFSS, char *fname, int maxl);
}

int MG_GetInputFName(char *fname, int maxl, char *title);
char* fl_file_chooser(const char* message, const char* pat, const char* fname, int relative=0);


void PtoC(const void *in, void *out)
{
	char *vin = (char *)in;
	char *vout = (char *)out;
	int l = *vin;
	
	if(l > 0) memcpy(vout, vin + 1, l);
	vout[l] = 0;
}


void CtoP(const void *in, void *out)
{
	char *vout = (char *)out;
	int l;
	if(in == NULL) l = 0;
	else	{
		l = strlen( (char *)in );
		memcpy(vout + 1, in, l);
	}
	vout[0] = l;
}


void MG_FSSpecToPathname (FSSpec *myFSS, char *fname, int maxl)
{
	FSRef myFSRef, pFSRef;
	FSCatalogInfo myinfo;
	static int  anErr = noErr;
	char *p, *q;
	static char buffer[1000], name[256];
	FSSpec fsspec;
	
	p = buffer;
	anErr = FSpMakeFSRef(myFSS, &myFSRef);
	while(1) {
		anErr = FSGetCatalogInfo(&myFSRef, kFSCatInfoParentDirID, &myinfo, NULL, &fsspec, &pFSRef);
		PtoC(fsspec.name, name);
		/* add the file or dir name to the end of buffer in reverse orientation */
		q = name + strlen(name) - 1;
		while(q >= name) { *p = *q; q--; p++; }
		if(myinfo.parentDirID == fsRtParID) break; /* detect when top level is reached */
		*p = ':'; p++;
		myFSRef = pFSRef;
	}
	*p = 0;
	/* invert buffer into fname */
	maxl--;
	if(maxl > strlen(buffer)) maxl = strlen(buffer);
	q = buffer + maxl - 1;
	p = fname;
	while(q >= buffer) { *p = *q; q--; p++; }
	fname[maxl] = 0;
}


static pascal void MyNavEventProc (NavEventCallbackMessage callBackSelector,
                                   NavCBRecPtr callBackParms,
                                   NavCallBackUserData callBackUD)
{
	return;
}


int MG_GetInputFName(char *fname, int maxl, char *title)
{
	NavEventUPP         eventProc = NewNavEventUPP(MyNavEventProc);
	OSErr               anErr = noErr;
	FSSpec              fss;
	int         rsult = FALSE;
	NavReplyRecord reply;
	NavDialogOptions options;
	NavGetDefaultDialogOptions(&options);
	CtoP(title, options.windowTitle);
	options.dialogOptionFlags &= ~ kNavAllowPreviews;
	options.dialogOptionFlags &= ~ kNavAllowMultipleFiles;
	options.dialogOptionFlags |=   kNavNoTypePopup;
	
	
	anErr = NavChooseFile (NULL  , &reply, &options, eventProc, NULL, NULL,
		NULL , 0);
	if (anErr == noErr && reply.validRecord)
    {
		AEKeyword   theKeyword;
		DescType    actualType;
		Size        actualSize;
		FSSpec      documentFSSpec;
		
		anErr = AEGetNthPtr(&(reply.selection), 1,
			typeFSS, &theKeyword,
			&actualType,&documentFSSpec,
			sizeof(documentFSSpec),
			&actualSize);
		if (anErr == noErr)
		{
			MG_FSSpecToPathname (&documentFSSpec, fname, maxl);
			rsult = TRUE;
		}
		//  Dispose of NavReplyRecord, resources, descriptors
		anErr = NavDisposeReply(&reply);
    }
	DisposeNavEventUPP(eventProc);
	return rsult;
}


char* fl_file_chooser(const char* message, const char* pat, const char* fname, int relative)
{
	static char pathname[FL_PATH_MAX];
	int ok;
	
	ok =  MG_GetInputFName(pathname, FL_PATH_MAX, (char *)message);
	if( ok ) return pathname;
	else return NULL;
}

#endif

