(* ::Package:: *)

(************************************************************************)
(* This file was generated automatically by the Mathematica front end.  *)
(* It contains Initialization cells from a Notebook file, which         *)
(* typically will have the same name as this file except ending in      *)
(* ".nb" instead of ".m".                                               *)
(*                                                                      *)
(* This file is intended to be loaded into the Mathematica kernel using *)
(* the package loading commands Get or Needs.  Doing so is equivalent   *)
(* to using the Evaluate Initialization Cells menu command in the front *)
(* end.                                                                 *)
(*                                                                      *)
(* DO NOT EDIT THIS FILE.  This entire file is regenerated              *)
(* automatically each time the parent Notebook file is saved in the     *)
(* Mathematica front end.  Any changes you make to this file will be    *)
(* overwritten.                                                         *)
(************************************************************************)



(* :Title: FigError *)
(* :Context: SciDraw` *)
(* :Summary: Error passing and messaging utilities *)
(* :Author: Mark A. Caprio, Department of Physics, University of Notre Dame *)
(* :Copyright: Copyright FIGYEAR, Mark A. Caprio *)
(* :Package Version: FIGVERSION *)
(* :Mathematica Version: MATHVERSION *)
(* :Discussion: FIGDISCUSSION *)
(* :History: See main package file. *)


BeginPackage["SciDraw`",SciDraw`Private`$ExternalContexts];


Unprotect[Evaluate[$Context<>"*"]];


Begin["`Private`"];





FigMessage[f_Symbol,m_String,Args___]:=Message[MessageName[f,m],Args];
FigMessage[s_Object,m_String,Args___]:=FigMessage[ObjectClass[s],m,Args];


General::figobj="While `1` a `2` object named \"`3`\"...";
General::figobjanon="While `1` a `2` object (no name specified)...";


FigWarnObject[Self_Object,Action_String]:=If[
MatchQ[ObjectName[Self],_Symbol]&&Context[Evaluate[ObjectName[Self]]]==$ObjectInstanceContext,
FigMessage[SciDraw,"figobjanon",Action,ObjectClass[Self]],
FigMessage[SciDraw,"figobj",Action,ObjectClass[Self],ObjectName[Self]]
];


FigError[f_Symbol,m_String,Args___]:=Module[
{},
FigMessage[f,m,Args];
Abort[]
];
FigError[s_Object,m_String,Args___]:=Module[
{},
FigWarnObject[s,"constructing"];
FigMessage[s,m,Args];
Abort[]
];
FigError[MakeAnchor,s_Object,m_String,Args___]:=Module[
{},
FigWarnObject[s,"constructing an anchor for"];
FigMessage[s,m,Args];
Abort[]
];
FigError[MakeBoundingBox,s_Object,m_String,Args___]:=Module[
{},
FigWarnObject[s,"constructing the bounding region for"];
FigMessage[s,m,Args];
Abort[]
];


(*
NewSymbolPattern=((x_Symbol)/;(Context[x]=!="System`"));
SaneObjectNamePattern=NewSymbolPattern|NewSymbolPattern[___]|(_String);

General::figobjbadname="The object name `1`  is not of the recommended form and might therefore lead to syntax ambiguities.  For object names, it is recommended that you use a string (e.g., \"name\"), a new symbol (e.g., Name) not already defined as a Mathematica reserved symbol, or an expression headed by such a symbol (e.g., Name[1,2]).";

FigCheckObjectName[Self:Object[A_]/;!MatchQ[A,SaneObjectNamePattern]]:=
FigMessage[Self,"figobjbadname",ObjectName[Self]];
*)


FigCheckObjectName[Self:Object[A_]]:=Null;


General::notinfigobj="Attempted to create figure object outside of a figure.";General::notinfigfcn="This function may only be used inside a Figure environment.";


FigCheckInFigure[Self_Object]/;(!SciDraw`Private`$InFigure):=FigError[Self,"notinfigobj"];
FigCheckInFigure[Self_Symbol]/;(!SciDraw`Private`$InFigure):=FigError[Self,"notinfigfcn"];


General::figargs="Missing or unexpected arguments in `1`.";
General::figargsnull="One of the arguments in `1` is Null.  Check for extra commas among the arguments.";


SetAttributes[FigFallThroughError,HoldRest];
FigFallThroughError[Self_Symbol,Expr_]:=Module[
{},
If[
Count[Hold[Expr],Null,{2}]>0,
FigError[Self,"figargsnull",HoldForm[Expr]],
FigError[Self,"figargs",HoldForm[Expr]]
]
];


DeclareFigFallThroughError[f_Symbol]:=(Expr:HoldPattern[f[___]]:=FigFallThroughError[f,Expr]);


SetAttributes[SuppressMessage,HoldAll];
SuppressMessage[MessageID_,Body_]:=Module[
{WasOn,EvaluatedBody,Aborted},
AbortProtect[

(* record prior message status *)
WasOn=Switch[
Head[MessageID],
String|MessageName,True,
$Off,False
];

(* evaluate body with message disabled *)
Off[MessageID];
Aborted=False;
CheckAbort[
EvaluatedBody=Body,
Aborted=True
];

(* restore message status *)
If[WasOn,On[MessageID]];
];

(* return value *)
(* passes through abort, and also explicitly returns $Aborted in case Abort[] is suppressed *)
If[Aborted,Abort[];$Aborted,EvaluatedBody]
];


General::figbadopt="Option `1` has invalid value `2`.";


FigCheckOption[Caller:((_Object)|(_Symbol)),OptionName_Symbol,TestPattern_,OptionList_List]:=Module[
{},
If[
!MatchQ[(OptionName/.OptionList),TestPattern],
FigError[Caller,"figbadopt",OptionName,(OptionName/.OptionList)]
]
];
FigCheckOption[SpecialMode:MakeAnchor,Caller:((_Object)|(_Symbol)),OptionName_Symbol,TestPattern_,OptionList_List]:=Module[
{},
If[
!MatchQ[(OptionName/.OptionList),TestPattern],
FigError[SpecialMode,Caller,"figbadopt",OptionName,(OptionName/.OptionList)]
]
];


General::figbadvalue="The `1` has an invalid value `2`.";


FigCheckValue[Caller:((_Object)|(_Symbol)),Value_,TestPattern_,Description_String]:=Module[
{},
If[
!MatchQ[Value,TestPattern],
FigError[Caller,"figbadvalue",Description,Value]
]
];


General::figbadvaluelist="One of the `1` has an invalid value `2`.";


FigCheckValueList[Caller:((_Object)|(_Symbol)),ValueList_List,TestPattern_,Description_String]:=Module[
{Value},
Do[
If[
!MatchQ[Value,TestPattern],
FigError[Caller,"figbadvaluelist",Description,Value]
],
{Value,ValueList}
]
];


End[];


Protect[Evaluate[$Context<>"*"]];
Unprotect[Evaluate[$Context<>"$*"]];
EndPackage[];
