/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.nbcr.opal.dashboard.servlet;

import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.SyndFeedOutput;
import edu.sdsc.nbcr.opal.AppServiceImpl;
import edu.sdsc.nbcr.opal.dashboard.servlet.OpalInfoServlet;
import edu.sdsc.nbcr.opal.gui.common.GetServiceListHelper;
import edu.sdsc.nbcr.opal.gui.common.OPALService;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.axis.AxisProperties;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OpalServices
extends HttpServlet {
    protected static Log log = LogFactory.getLog((String)OpalServices.class.getName());
    private static final String FEED_TYPE = "atom_1.0";
    private static final String MIME_TYPE = "application/xml; charset=UTF-8";
    public static final String OPTION_SERVER_CONFIG_FILE = "axis.ServerConfigFile";
    protected static final String SERVER_CONFIG_FILE = "server-config.wsdd";

    public final void init(ServletConfig config) throws ServletException {
        super.init(config);
        log.info((Object)"Loading OpalServices (init method).");
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.processRequest(req, res);
    }

    public final void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doGet(req, res);
    }

    public void processRequest(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        OPALService[] servicesList = this.getServiceList(res);
        if (servicesList == null) {
            String msg = "Unable to get the service list from the Axis...";
            log.error((Object)msg);
            res.sendError(500, msg);
            return;
        }
        try {
            SyndFeed feed = this.getFeed(servicesList);
            feed.setFeedType(FEED_TYPE);
            res.setContentType(MIME_TYPE);
            SyndFeedOutput output = new SyndFeedOutput();
            output.output(feed, (Writer)res.getWriter());
        }
        catch (FeedException ex) {
            String msg = "Unable to generate the feed...";
            log.error((Object)msg, (Throwable)ex);
            res.sendError(500, msg);
            return;
        }
    }

    private SyndFeed getFeed(OPALService[] servicesList) {
        String serverConfigFile = AxisProperties.getProperty((String)OPTION_SERVER_CONFIG_FILE, (String)SERVER_CONFIG_FILE);
        Date lastUpdate = new Date(new File(serverConfigFile).lastModified());
        SyndFeedImpl feed = new SyndFeedImpl();
        feed.setTitle("Opal Service List");
        feed.setLink(AppServiceImpl.getOpalBaseURL());
        feed.setDescription("This feed lists the available services on the Opal server " + AppServiceImpl.getOpalBaseURL());
        feed.setPublishedDate(lastUpdate);
        ArrayList<SyndEntryImpl> entries = new ArrayList<SyndEntryImpl>();
        for (int i = 0; i < servicesList.length; ++i) {
            SyndEntryImpl entry = new SyndEntryImpl();
            entry.setTitle(servicesList[i].getServiceName());
            entry.setLink(servicesList[i].getURL());
            SyndContentImpl description = new SyndContentImpl();
            description.setType("text/plain");
            description.setValue(servicesList[i].getDescription());
            entry.setDescription((SyndContent)description);
            entries.add(entry);
        }
        feed.setEntries(entries);
        return feed;
    }

    private OPALService[] getServiceList(HttpServletResponse res) {
        String url = this.getServletContext().getInitParameter("OPAL_URL");
        if (url == null) {
            log.warn((Object)"OPAL_URL not found in web.xml. Using default.");
            url = "http://localhost:8080/opal2/services";
        }
        GetServiceListHelper helper = new GetServiceListHelper();
        helper.setBasePrivateURL(url);
        Object publicUrl = null;
        String tomcatUrl = null;
        tomcatUrl = OpalInfoServlet.getTomcatUrl();
        URL tempURL = null;
        try {
            tempURL = new URL(url);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (tempURL != null && tomcatUrl != null) {
            helper.setBasePublicURL(tomcatUrl + tempURL.getFile());
        } else {
            helper.setBasePublicURL(url);
        }
        SOAPBodyElement list = helper.getServiceList();
        if (list == null) {
            OpalServices.returnServiceError(res, "Unable to get the service list from the server");
            return null;
        }
        OPALService[] servicesList = helper.parseServiceList(list.toString());
        if (servicesList == null) {
            OpalServices.returnServiceError(res, "Unable to parse the service list from the server");
            return null;
        }
        if (!helper.setServiceName(servicesList)) {
            OpalServices.returnServiceError(res, "An error occurred when trying to the services names");
            return null;
        }
        return servicesList;
    }

    private static void returnServiceError(HttpServletResponse res, String error) {
        log.error((Object)("Unable to create the service list: " + error));
        try {
            res.sendError(500);
        }
        catch (Exception e) {
            log.error((Object)"Unable to return the error page.", (Throwable)e);
        }
    }
}

