/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.nbcr.opal.gui.actions;

import edu.sdsc.nbcr.opal.AppServiceLocator;
import edu.sdsc.nbcr.opal.AppServicePortType;
import edu.sdsc.nbcr.opal.FaultType;
import edu.sdsc.nbcr.opal.InputFileType;
import edu.sdsc.nbcr.opal.JobInputType;
import edu.sdsc.nbcr.opal.JobSubOutputType;
import edu.sdsc.nbcr.opal.StatusOutputType;
import edu.sdsc.nbcr.opal.gui.common.AppMetadata;
import edu.sdsc.nbcr.opal.gui.common.ArgFlag;
import edu.sdsc.nbcr.opal.gui.common.ArgParam;
import java.io.File;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionRedirect;
import org.apache.struts.actions.MappingDispatchAction;
import org.apache.struts.upload.FormFile;

public class LaunchJobAction
extends MappingDispatchAction {
    protected Log log = LogFactory.getLog((String)"edu.sdsc.nbcr.opal");
    protected ArrayList errors;
    protected HttpServletRequest request;
    protected ActionMapping mapping;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InputFileType[] files;
        this.log.debug((Object)"Action: LaunchJob");
        if (request.getSession(false) == null || request.getSession(false).getAttribute("appMetadata") == null) {
            this.log.error((Object)"*** Session has timed out ***");
            this.errors = new ArrayList();
            this.errors.add("Session timed out");
            request.setAttribute("ERROR_MESSAGES", (Object)this.errors);
            return mapping.findForward("Timeout");
        }
        AppMetadata app = (AppMetadata)form;
        if (app == null) {
            this.log.error((Object)"Error the appMetadata is not present.");
            this.errors.add("We could not find the input values please go back to the welcome page");
            this.errors.add("appMetadata is not available");
            request.setAttribute("ERROR_MESSAGES", (Object)this.errors);
            return mapping.findForward("Error");
        }
        String debug = "";
        if (app.isArgMetadataEnable()) {
            ArgParam[] params;
            ArgFlag[] flags = app.getArgFlags();
            if (flags != null) {
                for (int i = 0; i < flags.length; ++i) {
                    debug = debug + "for flags " + flags[i].getId() + " the user has entered: " + flags[i].isSelected() + "\n";
                }
            } else {
                debug = debug + "no falgs found";
            }
            if ((params = app.getArgParams()) != null) {
                for (int i = 0; i < params.length; ++i) {
                    debug = debug + "for flags " + params[i].getId() + " the user has entered: " + params[i].getSelectedValue() + "\n";
                }
            } else {
                debug = debug + "no parameters found\n";
            }
            files = this.getFiles(app);
        } else {
            files = this.getDynamicFiles(app);
        }
        this.log.debug((Object)("the following parameters has been posted:\n" + debug));
        String cmd = this.makeCmdLine(app);
        if (cmd == null) {
            request.setAttribute("ERROR_MESSAGES", (Object)this.errors);
            return mapping.findForward("Error");
        }
        JobInputType in = new JobInputType();
        in.setArgList(cmd);
        in.setExtractInputs(app.isExtractInputs());
        int numCpu = -1;
        if (app.getNumCpu() != null && app.getNumCpu().length() >= 1) {
            try {
                numCpu = Integer.parseInt(app.getNumCpu());
                if (numCpu <= 0) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException e) {
                this.log.error((Object)"the user has entered wrong number of cpu");
                this.errors.add("the number of cpu is worng.");
                this.errors.add("Number of cpu should be a positive integer number and not a \"" + app.getNumCpu() + "\"");
                request.setAttribute("ERROR_MESSAGES", (Object)this.errors);
                return mapping.findForward("Error");
            }
        }
        if (numCpu != -1) {
            in.setNumProcs(numCpu);
        }
        if (app.getUserEmail() != null && app.getUserEmail().length() >= 1) {
            in.setUserEmail(app.getUserEmail());
            in.setSendNotification(true);
        }
        if (files != null) {
            in.setInputFile(files);
        } else {
            this.log.debug((Object)"No file has been submitted.");
        }
        JobSubOutputType subOut = null;
        try {
            AppServiceLocator asl = new AppServiceLocator();
            AppServicePortType appServicePort = asl.getAppServicePort(new URL(app.getURL()));
            subOut = appServicePort.launchJob(in);
            if (subOut == null) {
                throw new Exception("launchJob returned null");
            }
        }
        catch (FaultType e) {
            this.log.error((Object)"A remote error occurred while submitting the job.");
            this.log.error((Object)("The remote error message is: " + e.getMessage1()), (Throwable)((Object)e));
            this.errors.add("A remote error occured while submitting the job to the remote server");
            this.errors.add("The remote error message is: " + e.getMessage1());
            request.setAttribute("ERROR_MESSAGES", (Object)this.errors);
            return mapping.findForward("Error");
        }
        catch (Exception e) {
            if (e == null) {
                this.log.error((Object)"*** Session has timed out 2 ***");
                return mapping.findForward("Timeout");
            }
            if (e.getMessage() == null) {
                this.log.error((Object)"*** Session has timed out 3 ***");
                this.errors.add("Session timed out");
                request.setAttribute("ERROR_MESSAGES", (Object)this.errors);
                return mapping.findForward("Timeout");
            }
            this.log.error((Object)"An error occurred while submitting the job.");
            this.log.error((Object)("The error message is: " + e.getMessage()), (Throwable)e);
            this.errors.add("An error occured while submitting the job to the remote server");
            this.errors.add("The error message is: " + e.getMessage());
            this.errors.add("Please go back to the List of Applications page and try resubmitting the job");
            request.setAttribute("ERROR_MESSAGES", (Object)this.errors);
            return mapping.findForward("Error");
        }
        app.setJobId(subOut.getJobID());
        this.log.debug((Object)("Submitted job received jobID: " + subOut.getJobID()));
        StatusOutputType status = subOut.getStatus();
        this.log.debug((Object)("Current Status:\n\tCode: " + status.getCode() + "\n" + "\tMessage: " + status.getMessage() + "\n" + "\tOutput Base URL: " + status.getBaseURL()));
        this.log.debug((Object)"redirecting to the status page...");
        return new ActionRedirect(mapping.findForward("JobStatus").getPath() + "?jobId=" + subOut.getJobID() + "&serviceID=" + app.getServiceID());
    }

    private String makeCmdLine(AppMetadata app) {
        String cmd = "";
        this.errors = new ArrayList();
        if (app.isArgMetadataEnable()) {
            if (app.getArgFlags() != null) {
                ArgFlag[] flags = app.getArgFlags();
                for (int i = 0; i < flags.length; ++i) {
                    if (!flags[i].isSelected()) continue;
                    cmd = cmd + " " + flags[i].getTag();
                }
            }
            if (app.getArgParams() != null) {
                int i;
                ArgParam[] params = app.getArgParams();
                String taggedParams = "";
                String separator = app.getSeparator();
                if (separator == null) {
                    separator = " ";
                }
                String[] untaggedParams = new String[app.getNumUnttagedParams()];
                for (i = 0; i < untaggedParams.length; ++i) {
                    untaggedParams[i] = "";
                }
                this.log.debug((Object)("We have " + app.getNumUnttagedParams() + " untaggged parameters."));
                for (i = 0; i < params.length; ++i) {
                    this.log.debug((Object)("Analizing param: " + params[i].getId()));
                    if (params[i].getTag() != null) {
                        if (params[i].isFileUploaded()) {
                            taggedParams = taggedParams + " " + params[i].getTag() + separator + params[i].getFile().getFileName();
                            continue;
                        }
                        if (params[i].getSelectedValue() == null || params[i].getSelectedValue().length() <= 0) continue;
                        taggedParams = taggedParams + " " + params[i].getTag() + separator + params[i].getSelectedValue();
                        continue;
                    }
                    if (params[i].isFileUploaded()) {
                        untaggedParams[params[i].getPosition()] = " " + params[i].getFile().getFileName();
                        continue;
                    }
                    if (params[i].getSelectedValue() == null || params[i].getSelectedValue().length() <= 0) continue;
                    untaggedParams[params[i].getPosition()] = " " + params[i].getSelectedValue();
                    this.log.debug((Object)("Adding the " + i + " untagged paramters with: " + untaggedParams[params[i].getPosition()]));
                }
                if (taggedParams.length() > 0) {
                    cmd = cmd + taggedParams;
                }
                for (i = 0; i < app.getNumUnttagedParams(); ++i) {
                    cmd = cmd + untaggedParams[i];
                }
            }
        } else {
            cmd = app.getCmdLine();
        }
        if (cmd == null) {
            this.log.error((Object)"The command line is null!");
            this.errors.add("We could not built the command line from your input parameters");
        }
        this.log.info((Object)("Submitted job command line: " + cmd));
        return cmd;
    }

    private void logFileInfo(int pos, FormFile ff) {
        String fileInfo;
        String fname = ff.getFileName();
        if (ff == null) {
            String fileInfo2 = "(" + pos + ") file name : there was an error uploading file";
            return;
        }
        if (fname.length() == 0) {
            fileInfo = "(" + pos + ") file name has zero length";
        } else {
            fileInfo = "(" + pos + ") file name :" + ff.getFileName();
            fileInfo = fileInfo + " type: " + ff.getContentType();
            fileInfo = fileInfo + " size: " + ff.getFileSize();
        }
        this.log.debug((Object)fileInfo);
    }

    private InputFileType[] getDynamicFiles(AppMetadata app) {
        InputFileType[] files = null;
        try {
            ArrayList al = app.getFormFiles();
            ArrayList<InputFileType> filesArrayReturn = new ArrayList<InputFileType>();
            this.log.debug((Object)("User uploads " + al.size() + " dynamic input file(s)"));
            for (int i = 0; i < al.size(); ++i) {
                FormFile ff = (FormFile)al.get(i);
                String fname = ff.getFileName();
                if (fname.length() == 0) continue;
                this.logFileInfo(i + 1, ff);
                InputFileType file = new InputFileType();
                file.setName(fname);
                File osFile = this.getStoredFile(ff);
                if (osFile != null) {
                    DataHandler dh = new DataHandler((DataSource)new FileDataSource(osFile));
                    file.setAttachment(dh);
                } else {
                    file.setContents(ff.getFileData());
                }
                filesArrayReturn.add(file);
            }
            files = filesArrayReturn.toArray(new InputFileType[filesArrayReturn.size()]);
        }
        catch (Exception e) {
            this.log.error((Object)"There was an error reading uploaded files!");
            this.log.error((Object)("The exception is: " + e.getMessage()), e.getCause());
            e.printStackTrace();
            return null;
        }
        return files;
    }

    private InputFileType[] getFiles(AppMetadata app) {
        InputFileType[] files = null;
        try {
            if (app.getNumArgFileSubmitted() > 0) {
                int numFile = app.getNumArgFileSubmitted();
                this.log.info((Object)("User uploads " + numFile + " input file(s)"));
                files = new InputFileType[numFile];
                for (int i = 0; i < numFile; ++i) {
                    ArgParam param = app.getArgFileSubmitted(i);
                    files[i] = new InputFileType();
                    FormFile ff = param.getFile();
                    if (ff != null) {
                        files[i].setName(ff.getFileName());
                        File osFile = this.getStoredFile(ff);
                        if (osFile != null) {
                            DataHandler dh = new DataHandler((DataSource)new FileDataSource(osFile));
                            files[i].setAttachment(dh);
                        } else {
                            files[i].setContents(ff.getFileData());
                        }
                    } else {
                        this.log.error((Object)("This is very nasty... Contact developers!!\n The arg: " + (Object)((Object)param) + "lost the file..."));
                        return null;
                    }
                    this.logFileInfo(i + 1, ff);
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)"There was an error reading uploaded files!");
            this.log.error((Object)("The exception is: " + e.getMessage()), e.getCause());
            e.printStackTrace();
            return null;
        }
        return files;
    }

    private File getStoredFile(FormFile file) {
        try {
            File osFile = null;
            Class<?> formClass = file.getClass();
            Field fileItemField = formClass.getDeclaredField("fileItem");
            fileItemField.setAccessible(true);
            Object o = fileItemField.get(file);
            if (o instanceof DiskFileItem) {
                DiskFileItem df = (DiskFileItem)o;
                if (df.isInMemory()) {
                    this.log.debug((Object)"FormFile is actually in memory - no need to write it out to File");
                    return null;
                }
                osFile = df.getStoreLocation();
                String path = osFile.getAbsolutePath();
                this.log.debug((Object)("FormFile found at absolute path: " + path));
                return osFile;
            }
            this.log.error((Object)"Can't retrieve stored File for FormFile");
            return null;
        }
        catch (Exception e) {
            this.log.error((Object)"Can't retrieve stored File for FormFile");
            this.log.error((Object)e);
            return null;
        }
    }
}

