/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.nbcr.opal.manager;

import edu.sdsc.nbcr.opal.AppConfigType;
import edu.sdsc.nbcr.opal.StatusOutputType;
import edu.sdsc.nbcr.opal.manager.JobManagerException;
import edu.sdsc.nbcr.opal.manager.OpalJobManager;
import edu.sdsc.nbcr.opal.state.HibernateUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ForkJobManager
implements OpalJobManager {
    private static Logger logger = Logger.getLogger((String)ForkJobManager.class.getName());
    private Properties props;
    private AppConfigType config;
    private Process proc;
    private StatusOutputType status;
    private String handle;
    private Thread stdoutThread;
    private Thread stderrThread;
    private boolean started = false;
    private volatile boolean done = false;
    private final Object lock = new Object();

    @Override
    public void initialize(Properties props, AppConfigType config, String handle) throws JobManagerException {
        logger.debug((Object)"called");
        this.props = props;
        this.config = config;
        this.handle = handle;
        this.status = new StatusOutputType();
    }

    @Override
    public void destroyJobManager() throws JobManagerException {
        logger.debug((Object)"called");
        throw new JobManagerException("destroyJobManager() method not implemented");
    }

    @Override
    public String launchJob(String argList, Integer numProcs, final String workingDir) throws JobManagerException {
        logger.info((Object)"called");
        if (this.config == null) {
            String msg = "Can't find application configuration - Plugin not initialized correctly";
            logger.error((Object)msg);
            throw new JobManagerException(msg);
        }
        String args = this.config.getDefaultArgs();
        if (args == null) {
            args = argList;
        } else {
            String userArgs = argList;
            if (userArgs != null) {
                args = args + " " + userArgs;
            }
        }
        if (args != null) {
            args = args.trim();
        }
        logger.debug((Object)("Argument list: " + args));
        String systemProcsString = this.props.getProperty("num.procs");
        int systemProcs = 0;
        if (systemProcsString != null) {
            systemProcs = Integer.parseInt(systemProcsString);
        }
        String cmd = null;
        if (this.config.isParallel()) {
            if (numProcs == null) {
                String msg = "Number of processes unspecified for parallel job";
                logger.error((Object)msg);
                throw new JobManagerException(msg);
            }
            if (numProcs > systemProcs) {
                String msg = "Processors required - " + numProcs + ", available - " + systemProcs;
                logger.error((Object)msg);
                throw new JobManagerException(msg);
            }
            String mpiRun = this.props.getProperty("mpi.run");
            if (mpiRun == null) {
                String msg = "Can't find property mpi.run for running parallel job";
                logger.error((Object)msg);
                throw new JobManagerException(msg);
            }
            cmd = new String(mpiRun + " " + "-np " + numProcs + " " + this.config.getBinaryLocation());
        } else {
            cmd = new String(this.config.getBinaryLocation());
        }
        if (args != null && !args.equals("")) {
            logger.debug((Object)("Appending arguments: " + args));
            cmd = cmd + " " + args;
        }
        logger.debug((Object)("CMD: " + cmd));
        final String finalCmd = cmd;
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ForkJobManager.this.executeJob(workingDir, finalCmd);
                }
                catch (JobManagerException jme) {
                    String msg = "Error while executing job: " + jme.getMessage();
                    logger.error((Object)jme);
                    ForkJobManager.this.status.setCode(4);
                    ForkJobManager.this.status.setMessage(msg);
                    ForkJobManager.this.started = true;
                    Object object = ForkJobManager.this.lock;
                    synchronized (object) {
                        ForkJobManager.this.lock.notifyAll();
                    }
                }
            }
        }.start();
        if (this.proc != null) {
            return this.proc.toString();
        }
        return new String("Unavailable");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StatusOutputType waitForActivation() throws JobManagerException {
        logger.debug((Object)"called");
        while (!this.started) {
            try {
                Object object = this.lock;
                synchronized (object) {
                    this.lock.wait();
                }
            }
            catch (InterruptedException ie) {
                logger.error((Object)ie.getMessage());
            }
        }
        if (this.status.getCode() == 4) {
            throw new JobManagerException(this.status.getMessage());
        }
        return this.status;
    }

    @Override
    public StatusOutputType waitForCompletion() throws JobManagerException {
        logger.debug((Object)"called");
        if (this.proc == null) {
            String msg = "Can't wait for a process that hasn't be started";
            logger.error((Object)msg);
            throw new JobManagerException(msg);
        }
        int exitValue = 0;
        try {
            exitValue = this.proc.waitFor();
        }
        catch (InterruptedException ie) {
            String msg = "Exception while waiting for process to finish";
            logger.error((Object)msg, (Throwable)ie);
            throw new JobManagerException(msg + " - " + ie.getMessage());
        }
        if (exitValue == 0) {
            this.status.setCode(8);
            this.status.setMessage("Execution complete - check outputs to verify successful execution");
        } else {
            this.status.setCode(4);
            this.status.setMessage("Execution failed - process exited with value " + exitValue);
        }
        this.done = true;
        try {
            logger.debug((Object)"Waiting for all outputs to be written out");
            this.stdoutThread.join();
            this.stderrThread.join();
            logger.debug((Object)"All outputs successfully written out");
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.status;
    }

    @Override
    public StatusOutputType destroyJob() throws JobManagerException {
        logger.debug((Object)"called");
        if (this.proc == null) {
            String msg = "Can't destroy a process that hasn't be started";
            logger.error((Object)msg);
            throw new JobManagerException(msg);
        }
        this.proc.destroy();
        this.status.setCode(4);
        this.status.setMessage("Process destroyed on user request");
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeJob(String workingDir, String cmd) throws JobManagerException {
        try {
            if (this.props.getProperty("fork.jobs.limit") != null) {
                long jobLimit = Integer.parseInt(this.props.getProperty("fork.jobs.limit"));
                while (true) {
                    long runningJobs;
                    try {
                        runningJobs = HibernateUtil.getNumExecutingJobs();
                        logger.debug((Object)("Number of running jobs: " + runningJobs));
                    }
                    catch (Exception e) {
                        String msg = "Exception while retrieving number of jobs from database: " + e.getMessage();
                        logger.error((Object)msg);
                        throw new JobManagerException(msg);
                    }
                    if (runningJobs < jobLimit) break;
                    try {
                        logger.debug((Object)"Waiting for number of Fork jobs to fall below limit");
                        Thread.sleep(10000L);
                    }
                    catch (Exception e) {
                        logger.warn((Object)e);
                    }
                }
            }
            logger.debug((Object)("Working directory: " + workingDir));
            this.proc = Runtime.getRuntime().exec(cmd, null, new File(workingDir));
            this.stdoutThread = this.writeStdOut(this.proc, workingDir);
            this.stderrThread = this.writeStdErr(this.proc, workingDir);
        }
        catch (IOException ioe) {
            String msg = "Error while running executable via fork - " + ioe.getMessage();
            logger.error((Object)msg);
            throw new JobManagerException(msg);
        }
        this.status.setCode(2);
        this.status.setMessage("Execution in progress");
        this.started = true;
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    private Thread writeStdOut(Process p, String outputDirName) {
        File outputDir = new File(outputDirName);
        final InputStreamReader isr = new InputStreamReader(p.getInputStream());
        final String outfileName = outputDir.getAbsolutePath() + File.separator + "stdout.txt";
        Thread t_input = new Thread(){

            @Override
            public void run() {
                FileWriter fw;
                try {
                    fw = new FileWriter(outfileName);
                }
                catch (IOException ioe) {
                    logger.error((Object)ioe);
                    return;
                }
                int bytes = 0;
                char[] buf = new char[256];
                while (!ForkJobManager.this.done || bytes >= 0) {
                    try {
                        bytes = isr.read(buf);
                        if (bytes <= 0) continue;
                        fw.write(buf, 0, bytes);
                        fw.flush();
                    }
                    catch (IOException ignore) {
                        // empty catch block
                        break;
                    }
                }
                try {
                    fw.close();
                }
                catch (IOException ioe) {
                    logger.error((Object)ioe);
                    return;
                }
                logger.debug((Object)"Done writing standard output");
            }
        };
        t_input.start();
        return t_input;
    }

    private Thread writeStdErr(Process p, String outputDirName) {
        File outputDir = new File(outputDirName);
        final InputStreamReader isr = new InputStreamReader(p.getErrorStream());
        final String errfileName = outputDir.getAbsolutePath() + File.separator + "stderr.txt";
        Thread t_error = new Thread(){

            @Override
            public void run() {
                FileWriter fw;
                try {
                    fw = new FileWriter(errfileName);
                }
                catch (IOException ioe) {
                    logger.error((Object)ioe);
                    return;
                }
                int bytes = 0;
                char[] buf = new char[256];
                while (!ForkJobManager.this.done || bytes >= 0) {
                    try {
                        bytes = isr.read(buf);
                        if (bytes <= 0) continue;
                        fw.write(buf, 0, bytes);
                        fw.flush();
                    }
                    catch (IOException ignore) {
                        // empty catch block
                        break;
                    }
                }
                try {
                    fw.close();
                }
                catch (IOException ioe) {
                    logger.error((Object)ioe);
                    return;
                }
                logger.debug((Object)"Done writing standard error");
            }
        };
        t_error.start();
        return t_error;
    }
}

