/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.nbcr.opal.manager.condorAPI;

import edu.sdsc.nbcr.opal.manager.condorAPI.Condor;
import edu.sdsc.nbcr.opal.manager.condorAPI.CondorException;
import edu.sdsc.nbcr.opal.manager.condorAPI.HandlerSet;
import edu.sdsc.nbcr.opal.manager.condorAPI.Job;
import edu.sdsc.nbcr.opal.manager.condorAPI.JobId;
import java.util.AbstractCollection;
import java.util.NoSuchElementException;

public class Cluster
extends AbstractCollection {
    public int id;
    Job[] jobs;
    HandlerSet handlers;

    Cluster(int clusterId, int noOfJobs, Condor condor) {
        this.id = clusterId;
        this.jobs = new Job[noOfJobs];
        for (int i = 0; i < noOfJobs; ++i) {
            this.jobs[i] = new Job(new JobId(clusterId, i), condor);
        }
    }

    void setHandlerSet(HandlerSet handlers) {
        this.handlers = handlers;
        for (int i = 0; i < this.jobs.length; ++i) {
            this.jobs[i].setHandlerSet(handlers);
        }
    }

    public void waitFor() throws CondorException {
        for (int i = 0; i < this.jobs.length; ++i) {
            this.jobs[i].waitFor();
        }
    }

    @Override
    public String toString() {
        return "Cluster " + this.id + " : " + this.jobs.length + " jobs";
    }

    public String dump() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.jobs.length; ++i) {
            sb.append(" ");
            sb.append(this.jobs[i].toString());
        }
        return this.toString() + " -  [" + sb.toString() + " ]";
    }

    public Job getJob(int i) {
        return this.jobs[i];
    }

    public int length() {
        return this.jobs.length;
    }

    @Override
    public java.util.Iterator iterator() {
        return new Iterator();
    }

    @Override
    public int size() {
        return this.jobs.length;
    }

    public class Iterator
    implements java.util.Iterator {
        int index = 0;

        public Object next() throws NoSuchElementException {
            if (this.index >= Cluster.this.jobs.length) {
                throw new NoSuchElementException();
            }
            return Cluster.this.jobs[this.index++];
        }

        @Override
        public boolean hasNext() {
            return this.index < Cluster.this.jobs.length;
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }
}

