/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.nbcr.opal.manager.condorAPI;

import condor.classad.ClassAdParser;
import condor.classad.Expr;
import condor.classad.ListExpr;
import edu.sdsc.nbcr.opal.manager.condorAPI.Cluster;
import edu.sdsc.nbcr.opal.manager.condorAPI.CondorException;
import edu.sdsc.nbcr.opal.manager.condorAPI.Event;
import edu.sdsc.nbcr.opal.manager.condorAPI.Handler;
import edu.sdsc.nbcr.opal.manager.condorAPI.Job;
import edu.sdsc.nbcr.opal.manager.condorAPI.JobDescription;
import edu.sdsc.nbcr.opal.manager.condorAPI.JobId;
import edu.sdsc.nbcr.opal.manager.condorAPI.LogMonitor;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Condor
implements Runnable {
    static final String SUBMIT_OUTPUT_PATTERN = "(\\d*) job\\(s\\) submitted to cluster (\\d*)\\.";
    static final String CONDOR_SUBMIT = "condor_submit";
    static final String CONDOR_RM = "condor_rm";
    static final String CONDOR_STATUS = "condor_status";
    static final String CONDOR_Q = "condor_q";
    static final String CONDOR_RESCHEDULE = "condor_reschedule";
    static final String CONDOR_DEFAULT_LOG = "condor.log";
    static final int CONDOR_DEFAULT_INTERVAL = 5;
    static boolean debug = false;
    Map map = new HashMap();
    Map monitors = new HashMap();
    String logfile;
    LogMonitor monitor;
    int activeJobCounter = 0;
    Thread dummyThread;

    public static void setDebug(boolean debug) {
        Condor.debug = debug;
    }

    public void reschedule() throws CondorException {
        Runtime runtime = Runtime.getRuntime();
        try {
            Process proc = runtime.exec(new String[]{CONDOR_RESCHEDULE});
            proc.waitFor();
        }
        catch (IOException e) {
            throw new CondorException(e.toString());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void rm(Job job) throws CondorException {
        Runtime runtime = Runtime.getRuntime();
        try {
            Process proc = runtime.exec(new String[]{CONDOR_RM, job.jobId.toString()});
            proc.waitFor();
        }
        catch (IOException e) {
            throw new CondorException(e.toString());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void rm(Cluster cluster) throws CondorException {
        Runtime runtime = Runtime.getRuntime();
        try {
            Process proc = runtime.exec(new String[]{CONDOR_RM, "" + cluster.id});
            proc.waitFor();
        }
        catch (IOException e) {
            throw new CondorException(e.toString());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void setLogFile(String logfile, int interval) {
        this.logfile = logfile;
        this.monitor = (LogMonitor)this.monitors.get(logfile);
        if (this.monitor == null) {
            this.monitor = new LogMonitor(this, logfile, interval);
        } else {
            this.monitor.setInterval(interval);
        }
    }

    public void startLogMonitor() {
        this.monitor.start();
        this.monitors.put(this.logfile, this.monitor);
    }

    public Cluster submit(JobDescription jd) throws CondorException {
        return jd.submit(this);
    }

    public synchronized Job getJob(JobId jobId) {
        Job job = (Job)this.map.get(jobId);
        if (job == null) {
            job = new Job(jobId, this);
            this.jobSubmitted(job);
        }
        return job;
    }

    synchronized void informEvent(Event e) {
        Job job = (Job)this.map.get(e.jobId);
        if (job != null) {
            e.job = job;
            if (debug) {
                System.err.println(e);
            }
            job.event(e);
        }
    }

    synchronized void updateJobStatus() throws CondorException {
        Runtime runtime = Runtime.getRuntime();
        try {
            Process proc = runtime.exec(new String[]{CONDOR_Q, "-xml"});
            LineNumberReader lnr = new LineNumberReader(new InputStreamReader(proc.getInputStream()));
            for (int i = 0; i < 5; ++i) {
                lnr.readLine();
            }
            ClassAdParser parser = new ClassAdParser((Reader)lnr, 1);
            Expr expr = parser.parse();
            ListExpr list = (ListExpr)expr;
            for (Expr tmp : list) {
                System.out.println(" - " + tmp.getClass().getName() + " -");
                System.out.println(expr);
            }
        }
        catch (IOException e) {
            throw new CondorException(e.toString());
        }
    }

    synchronized Cluster submitFile(String filename) throws CondorException {
        Runtime runtime = Runtime.getRuntime();
        try {
            Process proc = runtime.exec(new String[]{CONDOR_SUBMIT, filename});
            int exitCode = 0;
            while (true) {
                try {
                    exitCode = proc.waitFor();
                }
                catch (InterruptedException e) {
                    continue;
                }
                break;
            }
            LineNumberReader lnr = new LineNumberReader(new InputStreamReader(proc.getInputStream()));
            if (exitCode != 0) {
                String tmp;
                StringBuffer sb = new StringBuffer();
                while ((tmp = lnr.readLine()) != null) {
                    sb.append(tmp + "\n");
                }
                lnr = new LineNumberReader(new InputStreamReader(proc.getErrorStream()));
                while ((tmp = lnr.readLine()) != null) {
                    sb.append(tmp + "\n");
                }
                throw new CondorException(sb.toString());
            }
            String line = lnr.readLine();
            line = lnr.readLine();
            Pattern pattern = Pattern.compile(SUBMIT_OUTPUT_PATTERN);
            Matcher matcher = pattern.matcher(line);
            if (!matcher.matches()) {
                throw new CondorException("faied to parse the cluster number.");
            }
            int noJobs = Integer.parseInt(matcher.group(1));
            int clusterId = Integer.parseInt(matcher.group(2));
            Cluster cluster = new Cluster(clusterId, noJobs, this);
            for (Job job : cluster) {
                this.jobSubmitted(job);
            }
            return cluster;
        }
        catch (IOException e) {
            throw new CondorException(e.toString());
        }
    }

    synchronized void jobSubmitted(Job job) {
        this.map.put(job.jobId, job);
        ++this.activeJobCounter;
        if (this.dummyThread == null) {
            this.dummyThread = new Thread((Runnable)this, "dummyThread");
            this.dummyThread.start();
        }
    }

    synchronized void jobTerminated(Job job) {
        --this.activeJobCounter;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Condor condor = this;
        synchronized (condor) {
            while (this.activeJobCounter > 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.dummyThread = null;
    }

    public static void main(String[] args) throws CondorException {
        Condor.setDebug(true);
        Condor condor = new Condor();
        JobDescription jd = new JobDescription("test.submit");
        jd.setHandlerOnSuccess(new Handler(){

            @Override
            public void handle(Event e) {
                System.err.println("success " + e);
            }
        });
        Cluster c = condor.submit(jd);
        System.out.println("submitted");
        System.out.println("done");
        JobDescription jd2 = new JobDescription();
        jd2.addAttribute("executable", "/bin/date");
        jd2.addAttribute("universe", "vanilla");
        jd2.addAttribute("initialdir", "/tmp/opal-jobs");
        jd2.addQueue();
        jd2.setHandlerOnSuccess(new Handler(){

            @Override
            public void handle(Event e) {
                System.err.println("success " + e);
            }
        });
        Cluster c2 = condor.submit(jd2);
        System.out.println("submitted");
        System.out.println("done");
    }
}

