/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.nbcr.opal.manager.condorAPI;

import edu.sdsc.nbcr.opal.manager.condorAPI.Condor;
import edu.sdsc.nbcr.opal.manager.condorAPI.CondorException;
import edu.sdsc.nbcr.opal.manager.condorAPI.Event;
import edu.sdsc.nbcr.opal.manager.condorAPI.EventType;
import edu.sdsc.nbcr.opal.manager.condorAPI.Handler;
import edu.sdsc.nbcr.opal.manager.condorAPI.HandlerSet;
import edu.sdsc.nbcr.opal.manager.condorAPI.JobId;
import edu.sdsc.nbcr.opal.manager.condorAPI.Node;
import edu.sdsc.nbcr.opal.manager.condorAPI.Status;
import edu.sdsc.nbcr.opal.manager.condorAPI.event.EventJobEvicted;
import edu.sdsc.nbcr.opal.manager.condorAPI.event.EventJobTerminated;
import java.util.ArrayList;
import java.util.List;

public class Job
implements Status,
EventType {
    JobId jobId;
    Node[] nodes;
    int status = 0;
    HandlerSet handlers = new HandlerSet();
    Condor condor;
    List eventList = new ArrayList();

    Job(JobId jobId, Condor condor) {
        this.jobId = jobId;
        this.condor = condor;
    }

    public JobId getJobId() {
        return (JobId)this.jobId.clone();
    }

    void setHandlerSet(HandlerSet handlers) {
        this.handlers = (HandlerSet)handlers.clone();
    }

    public synchronized void waitFor() throws CondorException {
        while (this.status == 0 || this.status == 2 || this.status == 1 || this.status == 5) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized void waitForRun() throws CondorException {
        while (this.status == 0 || this.status == 1 || this.status == 5) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public boolean isHeld() {
        return this.status == 5;
    }

    public boolean isRunning() {
        return this.status == 2;
    }

    public boolean isIdle() {
        return this.status == 1;
    }

    public boolean isRemoved() {
        return this.status == 3;
    }

    public boolean isCompleted() {
        return this.status == 4;
    }

    public void setHandlerOnFailure(Handler handler) {
        this.handlers.setHandlerOnFailure(handler);
    }

    public void setHandlerOnSuccess(Handler handler) {
        this.handlers.setHandlerOnSuccess(handler);
    }

    public void setHandler(int eventType, Handler handler) {
        this.handlers.setHandler(eventType, handler);
    }

    private void invokeCompletedHandler(Event e) {
        EventJobTerminated event = (EventJobTerminated)e;
        if (event.returnValue == 0) {
            Handler handler = this.handlers.getHandlerOnSuccess();
            if (handler != null) {
                handler.handle(e);
            }
        } else {
            Handler handler = this.handlers.getHandlerOnFailure();
            if (handler != null) {
                handler.handle(e);
            }
        }
    }

    public String toString() {
        return this.jobId.toString() + " " + names[this.status];
    }

    synchronized void setStatus(int status, Event e) {
        if (this.status != status) {
            this.status = status;
            if (status == 4) {
                this.condor.jobTerminated(this);
            }
            if (e.type == 5) {
                this.invokeCompletedHandler(e);
            }
            this.notifyAll();
        }
    }

    public int getStatus() {
        return this.status;
    }

    void event(Event e) {
        this.eventList.add(e);
        switch (e.type) {
            case 0: {
                this.setStatus(1, e);
                break;
            }
            case 1: {
                this.setStatus(2, e);
                break;
            }
            case 2: {
                this.setStatus(1, e);
                break;
            }
            case 3: {
                this.setStatus(1, e);
                break;
            }
            case 4: {
                if (((EventJobEvicted)e).terminatedAndRequeued) {
                    this.setStatus(1, e);
                    break;
                }
                this.setStatus(3, e);
                break;
            }
            case 5: {
                this.setStatus(4, e);
                break;
            }
            case 7: {
                this.setStatus(1, e);
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                this.setStatus(4, e);
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                this.setStatus(5, e);
                break;
            }
            case 13: {
                this.setStatus(1, e);
                break;
            }
        }
        Handler handler = this.handlers.getHandler(e.type);
        if (handler != null) {
            handler.handle(e);
        }
    }
}

