/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.nbcr.opal.manager.condorAPI;

import condor.classad.ClassAdParser;
import condor.classad.RecordExpr;
import edu.sdsc.nbcr.opal.manager.condorAPI.Condor;
import edu.sdsc.nbcr.opal.manager.condorAPI.Event;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;

class LogMonitor
implements Runnable {
    Condor condor;
    String filename;
    LineNumberReader lnr;
    ClassAdParser parser = new ClassAdParser(1);
    int counter = 0;
    int maxError = 10;
    int sleepSec = 5;
    Thread t;
    StringBuffer sb = new StringBuffer();

    LogMonitor(Condor condor, String filename, int sleepSec) {
        this.condor = condor;
        this.filename = filename;
        this.sleepSec = sleepSec;
    }

    void setInterval(int sleepSec) {
        this.sleepSec = sleepSec;
        if (this.t != null) {
            this.t.interrupt();
        }
    }

    void openLnr() {
        if (this.lnr == null) {
            try {
                FileReader reader = new FileReader(this.filename);
                this.lnr = new LineNumberReader(reader);
            }
            catch (IOException e) {
                System.err.println("Failed to open filename " + this.filename + ", retry.");
                ++this.counter;
                return;
            }
        }
    }

    RecordExpr readExpr() throws IOException {
        String tmp;
        do {
            if ((tmp = this.lnr.readLine()) == null) {
                return null;
            }
            this.sb.append(tmp);
        } while (!tmp.trim().equals("</c>"));
        String adString = this.sb.toString();
        this.sb = new StringBuffer();
        this.parser = new ClassAdParser(1);
        this.parser.reset(adString);
        return (RecordExpr)this.parser.parse();
    }

    void readLog() {
        try {
            RecordExpr expr;
            while ((expr = this.readExpr()) != null) {
                Event event = Event.getEvent(expr);
                if (this.condor == null) continue;
                this.condor.informEvent(event);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            ++this.counter;
        }
    }

    public void start() {
        this.t = new Thread((Runnable)this, "log Monitor for filname");
        this.t.setDaemon(true);
        this.t.start();
    }

    @Override
    public void run() {
        while (this.counter < this.maxError) {
            this.openLnr();
            if (this.lnr != null) {
                this.readLog();
            }
            try {
                Thread.sleep(this.sleepSec * 1000);
            }
            catch (InterruptedException interruptedException) {}
        }
        System.err.println("LogMonitor for " + this.filename + " exits: too many errors");
    }

    public static void main(String[] args) {
        String filename = args[0];
        LogMonitor monitor = new LogMonitor(null, filename, 10);
        monitor.start();
    }
}

