package gomo;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ResourceBundle;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.WindowConstants;


public class DAGParserGUI extends JFrame {
	private static final long serialVersionUID = 1l;
	
	private ResourceBundle translate;
	
	private JPanel pnlOBOFile;
	private JTextField txtOBOFile;
	private JButton btnOBOFile;
	
	private JPanel pnlButtons;
	private JButton btnCancel;
	private JButton btnSave;
	
	private JFileChooser jfcFile;
	
	public DAGParserGUI() {
		createComponents();
		createListeners();
		createLayout();
	}
	
	private void createComponents() {
		translate = ResourceBundle.getBundle(DAGParserGUI.class.getCanonicalName());
		setTitle(translate.getString("TITLE"));
		
		pnlOBOFile = new JPanel();
		pnlOBOFile.setBorder(BorderFactory.createTitledBorder(translate.getString("OBOFILE")));
		
		txtOBOFile = new JTextField(30);
		btnOBOFile = new JButton(translate.getString("OPEN"));
		
		Insets insets = pnlOBOFile.getBorder().getBorderInsets(pnlOBOFile);
		pnlButtons = new JPanel();
		pnlButtons.setBorder(BorderFactory.createEmptyBorder(0, insets.left, 0, insets.right));
		
		btnCancel = new JButton(translate.getString("CANCEL"));
		btnSave = new JButton(translate.getString("SAVE"));
		
		jfcFile = new JFileChooser();
		
	}
	
	private void createListeners() {
		btnOBOFile.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				openOBO();
			}
		});
		btnCancel.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				cancelOutput();
			}
		});
		btnSave.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				saveOutput();
			}
		});
	}
	
	private void createLayout() {
		GridBagConstraints c;
		Insets pad = new Insets(5,5,5,5);
		
		pnlOBOFile.setLayout(new GridBagLayout());
		c = new GridBagConstraints();
		c.insets = pad;
		c.fill = GridBagConstraints.BOTH;
		setGBC(c, 0,0,1,1);
		c.weightx = 1;
		pnlOBOFile.add(txtOBOFile, c);
		setGBC(c, 1,0,1,1);
		c.weightx = 0;
		pnlOBOFile.add(btnOBOFile, c);
		
		pnlButtons.setLayout(new GridBagLayout());
		c = new GridBagConstraints();
		c.insets = pad;
		c.fill = GridBagConstraints.NONE;
		c.weightx = 1;
		c.weighty = 1;
		setGBC(c, 0,0,1,1);
		c.anchor = GridBagConstraints.LAST_LINE_END;
		pnlButtons.add(btnSave, c);
		setGBC(c, 1,0,1,1);
		c.weightx = 0;
		c.anchor = GridBagConstraints.LAST_LINE_END;
		pnlButtons.add(btnCancel, c);
		
		setLayout(new GridBagLayout());
		c = new GridBagConstraints();
		c.fill = GridBagConstraints.BOTH;
		c.weightx = 1;
		setGBC(c, 0,0,1,1);
		add(pnlOBOFile, c);
		c.weighty = 1;
		setGBC(c, 0,1,1,1);
		add(pnlButtons, c);
		
	}
	
	private void openOBO() {
		int response;
		File before = new File(txtOBOFile.getText());
		if (before.exists()) {
			jfcFile.setSelectedFile(before);
		} else if (before.getParentFile() != null && before.getParentFile().exists()) {
			jfcFile.setSelectedFile(new File(""));
			jfcFile.setCurrentDirectory(before.getParentFile());
		} else {
			jfcFile.setSelectedFile(new File(""));
			jfcFile.setCurrentDirectory(null);
		}
		response = jfcFile.showOpenDialog(this);
		if (response == JFileChooser.APPROVE_OPTION) {
			File oboFile = jfcFile.getSelectedFile();
			txtOBOFile.setText(oboFile.getAbsolutePath());
		}
	}
	
	private void cancelOutput() {
		setVisible(false);
		dispose();
	}
	
	private void saveOutput() {
		int response;
		final File oboFile = new File(txtOBOFile.getText());
		if (!oboFile.exists() || !oboFile.isFile()) {
			JOptionPane.showMessageDialog(this, translate.getString("MSG_MISSING_OBO"), 
					translate.getString("TLE_MISSING_OBO"), JOptionPane.ERROR_MESSAGE);
			return;
		}
		jfcFile.setSelectedFile(new File(oboFile.getParentFile(), translate.getString("DAG_FILE_NAME")));
		response = jfcFile.showSaveDialog(this);
		if (response == JFileChooser.APPROVE_OPTION) {
			final File dagFile = jfcFile.getSelectedFile();
			try {
				dagFile.createNewFile();
			} catch (Exception e) {
				JOptionPane.showMessageDialog(this, translate.getString("MSG_CREATE_FAILED"), 
						translate.getString("TLE_CREATE_FAILED"), JOptionPane.ERROR_MESSAGE);
				return;
			}
			if (!dagFile.canWrite()) {
				JOptionPane.showMessageDialog(this, translate.getString("MSG_WRITE_FAILED"), 
						translate.getString("TLE_WRITE_FAILED"), JOptionPane.ERROR_MESSAGE);
				return;
			}
			javax.swing.SwingUtilities.invokeLater(new Runnable() {
				public void run() {
					try {
						DAGParser.parse(oboFile, dagFile);
					} catch (Exception e) {
						JOptionPane.showMessageDialog(null, e.toString(), 
								translate.getString("TLE_ERROR"), JOptionPane.ERROR_MESSAGE);
						DAGParserGUI.this.pack();
						DAGParserGUI.this.setVisible(true);
					} catch (Error e) {
						JOptionPane.showMessageDialog(null, e.toString(), 
								translate.getString("TLE_SERIOUS"), JOptionPane.ERROR_MESSAGE);
					}
				}
			});
			setVisible(false);
			dispose();
		}
	}
	
	protected void setGBC(GridBagConstraints c, int x, int y, int w, int h) {
		c.gridx = x;
		c.gridy = y;
		c.gridwidth = w;
		c.gridheight = h;
	}
	
	public static void createNShow() {
		JFrame frame = new DAGParserGUI();
		frame.pack();
		frame.setLocationByPlatform(true);
		frame.setDefaultCloseOperation(WindowConstants.EXIT_ON_CLOSE);
		frame.setVisible(true);
	}
	
	public static void main(String[] args) {
		javax.swing.SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				createNShow();
			}
		});
	}
}
