(* ::Package:: *)

(* ::Title:: *)
(*Rational Function Integration Problems Involving Linear Polynomials*)


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a+b x)^n*)


(* Integrands of the form x^m*(a+b*x) where m is an integer *)
{x^4*(a + b*x), x, 2, (a*x^5)/5 + (b*x^6)/6}
{x^3*(a + b*x), x, 2, (a*x^4)/4 + (b*x^5)/5}
{x^2*(a + b*x), x, 2, (a*x^3)/3 + (b*x^4)/4}
{x*(a + b*x), x, 2, (a*x^2)/2 + (b*x^3)/3}
{(a + b*x), x, 1, a*x + (b*x^2)/2}
{(a + b*x)/x, x, 2, b*x + a*Log[x]}
{(a + b*x)/x^2, x, 2, -(a/x) + b*Log[x]}
{(a + b*x)/x^3, x, 2, -(a/(2*x^2)) - b/x}
{(a + b*x)/x^4, x, 2, -(a/(3*x^3)) - b/(2*x^2)}
{(a + b*x)/x^5, x, 2, -(a/(4*x^4)) - b/(3*x^3)}
{(a + b*x)/x^6, x, 2, -(a/(5*x^5)) - b/(4*x^4)}


(* Integrands of the form x^m*(a+b*x)^2 where m is an integer *)
{x^4*(a + b*x)^2, x, 2, (a^2*x^5)/5 + (1/3)*a*b*x^6 + (b^2*x^7)/7}
{x^3*(a + b*x)^2, x, 2, (a^2*x^4)/4 + (2/5)*a*b*x^5 + (b^2*x^6)/6}
{x^2*(a + b*x)^2, x, 2, (a^2*x^3)/3 + (1/2)*a*b*x^4 + (b^2*x^5)/5}
{x*(a + b*x)^2, x, 2, (a^2*x^2)/2 + (2/3)*a*b*x^3 + (b^2*x^4)/4}
{(a + b*x)^2, x, 1, (a + b*x)^3/(3*b)}
{(a + b*x)^2/x, x, 2, 2*a*b*x + (b^2*x^2)/2 + a^2*Log[x]}
{(a + b*x)^2/x^2, x, 2, -(a^2/x) + b^2*x + 2*a*b*Log[x]}
{(a + b*x)^2/x^3, x, 2, -(a^2/(2*x^2)) - (2*a*b)/x + b^2*Log[x]}
{(a + b*x)^2/x^4, x, 1, -((a + b*x)^3/(3*a*x^3))}
{(a + b*x)^2/x^5, x, 2, -(a^2/(4*x^4)) - (2*a*b)/(3*x^3) - b^2/(2*x^2)}
{(a + b*x)^2/x^6, x, 2, -(a^2/(5*x^5)) - (a*b)/(2*x^4) - b^2/(3*x^3)}
{(a + b*x)^2/x^7, x, 2, -(a^2/(6*x^6)) - (2*a*b)/(5*x^5) - b^2/(4*x^4)}


(* Integrands of the form x^m*(a+b*x)^3 where m is an integer *)
{x^4*(a + b*x)^3, x, 2, (a^3*x^5)/5 + (1/2)*a^2*b*x^6 + (3/7)*a*b^2*x^7 + (b^3*x^8)/8}
{x^3*(a + b*x)^3, x, 2, (a^3*x^4)/4 + (3/5)*a^2*b*x^5 + (1/2)*a*b^2*x^6 + (b^3*x^7)/7}
{x^2*(a + b*x)^3, x, 2, (a^3*x^3)/3 + (3/4)*a^2*b*x^4 + (3/5)*a*b^2*x^5 + (b^3*x^6)/6}
{x*(a + b*x)^3, x, 2, -((a*(a + b*x)^4)/(20*b^2)) + (x*(a + b*x)^4)/(5*b)}
{(a + b*x)^3, x, 1, (a + b*x)^4/(4*b)}
{(a + b*x)^3/x, x, 2, 3*a^2*b*x + (3/2)*a*b^2*x^2 + (b^3*x^3)/3 + a^3*Log[x]}
{(a + b*x)^3/x^2, x, 2, -(a^3/x) + 3*a*b^2*x + (b^3*x^2)/2 + 3*a^2*b*Log[x]}
{(a + b*x)^3/x^3, x, 2, -a^3/(2*x^2) - (3*a^2*b)/x + b^3*x + 3*a*b^2*Log[x]}
{(a + b*x)^3/x^4, x, 2, -(a^3/(3*x^3)) - (3*a^2*b)/(2*x^2) - (3*a*b^2)/x + b^3*Log[x]}
{(a + b*x)^3/x^5, x, 1, -((a + b*x)^4/(4*a*x^4))}
{(a + b*x)^3/x^6, x, 2, -(a^3/(5*x^5)) - (3*a^2*b)/(4*x^4) - (a*b^2)/x^3 - b^3/(2*x^2)}
{(a + b*x)^3/x^7, x, 2, -(a^3/(6*x^6)) - (3*a^2*b)/(5*x^5) - (3*a*b^2)/(4*x^4) - b^3/(3*x^3)}
{(a + b*x)^3/x^8, x, 2, -(a^3/(7*x^7)) - (a^2*b)/(2*x^6) - (3*a*b^2)/(5*x^5) - b^3/(4*x^4)}


(* Integrands of the form x^m/(a+b*x) where m is an integer *)
{x^5/(a + b*x), x, 4, (a^4*x)/b^5 - (a^3*x^2)/(2*b^4) + (a^2*x^3)/(3*b^3) - (a*x^4)/(4*b^2) + x^5/(5*b) - (a^5*Log[a + b*x])/b^6}
{x^4/(a + b*x), x, 4, -((a^3*x)/b^4) + (a^2*x^2)/(2*b^3) - (a*x^3)/(3*b^2) + x^4/(4*b) + (a^4*Log[a + b*x])/b^5}
{x^3/(a + b*x), x, 4, (a^2*x)/b^3 - (a*x^2)/(2*b^2) + x^3/(3*b) - (a^3*Log[a + b*x])/b^4}
{x^2/(a + b*x), x, 4, -((a*x)/b^2) + x^2/(2*b) + (a^2*Log[a + b*x])/b^3}
{x/(a + b*x), x, 3, x/b - (a*Log[a + b*x])/b^2}
{1/(a + b*x), x, 1, Log[a + b*x]/b}
{1/(x*(a + b*x)), x, 1, Log[x]/a - Log[a + b*x]/a}
{1/(x^2*(a + b*x)), x, 4, -(1/(a*x)) - (b*Log[x])/a^2 + (b*Log[a + b*x])/a^2}
{1/(x^3*(a + b*x)), x, 4, -(1/(2*a*x^2)) + b/(a^2*x) + (b^2*Log[x])/a^3 - (b^2*Log[a + b*x])/a^3}
{1/(x^4*(a + b*x)), x, 4, -(1/(3*a*x^3)) + b/(2*a^2*x^2) - b^2/(a^3*x) - (b^3*Log[x])/a^4 + (b^3*Log[a + b*x])/a^4}
{1/(x^5*(a + b*x)), x, 4, -(1/(4*a*x^4)) + b/(3*a^2*x^3) - b^2/(2*a^3*x^2) + b^3/(a^4*x) + (b^4*Log[x])/a^5 - (b^4*Log[a + b*x])/a^5}

(* Ensure content factored out of denominator before including in Log! *)
{1/(2 + 2*x), x, 2, Log[1 + x]/2}
{1/(4 - 6*x), x, 2, -Log[2 - 3*x]/6}
{1/(a + Sqrt[a]*x), x, 2, Log[Sqrt[a] + x]/Sqrt[a]}
{1/(a + Sqrt[-a]*x), x, 2, Log[Sqrt[-a] - x]/Sqrt[-a]}
{1/(a^2 + Sqrt[-a]*x), x, 2, Log[(-a)^(3/2) + x]/Sqrt[-a]}
{1/(a^3 + Sqrt[-a]*x), x, 2, Log[(-a)^(5/2) - x]/Sqrt[-a]}
{1/(1/a + Sqrt[-a]*x), x, 2, Log[1 - (-a)^(3/2)*x]/Sqrt[-a]}
{1/(1/a^2 + Sqrt[-a]*x), x, 2, Log[1 + (-a)^(5/2)*x]/Sqrt[-a]}

(* Integrands of the form 1/(x^m*(a+b*x)) where m>0 is an integer and a^2=1 *)
{1/(x*(1 + b*x)), x, 1, -2*ArcTanh[1 + 2*b*x]}
{1/(x*(-1 + b*x)), x, 1, 2*ArcTanh[1 - 2*b*x]}
{1/(x^2*(1 + b*x)), x, 4, -(1/x) + 2*b*ArcTanh[1 + 2*b*x]}
{1/(x^2*(-1 + b*x)), x, 4, 1/x + 2*b*ArcTanh[1 - 2*b*x]}

(* Integrands of the form 1/(x^m*(a+b*x)) where m>0 is an integer and b/a is rational *)
{1/(x*(2 + 3*x)), x, 1, -ArcTanh[1 + 3*x]}
{1/(x*(4 + 6*x)), x, 2, (-(1/2))*ArcTanh[1 + 3*x]}
{1/(x^2*(4 + 6*x)), x, 4, -(1/(4*x)) + (3/4)*ArcTanh[1 + 3*x]}
{1/(x^3*(4 + 6*x)), x, 4, -(1/(8*x^2)) + 3/(8*x) - (9/8)*ArcTanh[1 + 3*x]}
{1/(x^4*(4 + 6*x)), x, 4, -(1/(12*x^3)) + 3/(16*x^2) - 9/(16*x) + (27/16)*ArcTanh[1 + 3*x]}
{1/(x^5*(4 + 6*x)), x, 4, -(1/(16*x^4)) + 1/(8*x^3) - 9/(32*x^2) + 27/(32*x) - (81/32)*ArcTanh[1 + 3*x]}


(* Integrands of the form x^m/(a+b*x)^2 where m is an integer *)
{x^5/(a + b*x)^2, x, 5, -((4*a^3*x)/b^5) + (3*a^2*x^2)/(2*b^4) - (2*a*x^3)/(3*b^3) + x^4/(4*b^2) + a^5/(b^6*(a + b*x)) + (5*a^4*Log[a + b*x])/b^6}
{x^4/(a + b*x)^2, x, 5, (3*a^2*x)/b^4 - (a*x^2)/b^3 + x^3/(3*b^2) - a^4/(b^5*(a + b*x)) - (4*a^3*Log[a + b*x])/b^5}
{x^3/(a + b*x)^2, x, 5, -((2*a*x)/b^3) + x^2/(2*b^2) + a^3/(b^4*(a + b*x)) + (3*a^2*Log[a + b*x])/b^4}
{x^2/(a + b*x)^2, x, 4, x/b^2 - a^2/(b^3*(a + b*x)) - (2*a*Log[a + b*x])/b^3}
{x/(a + b*x)^2, x, 4, a/(b^2*(a + b*x)) + Log[a + b*x]/b^2}
{1/(a + b*x)^2, x, 1, -(1/(b*(a + b*x)))}
{1/(x*(a + b*x)^2), x, 4, 1/(a*(a + b*x)) + Log[x]/a^2 - Log[a + b*x]/a^2}
{1/(x^2*(a + b*x)^2), x, 5, -(1/(a^2*x)) - b/(a^2*(a + b*x)) - (2*b*Log[x])/a^3 + (2*b*Log[a + b*x])/a^3}
{1/(x^3*(a + b*x)^2), x, 5, -(1/(2*a^2*x^2)) + (2*b)/(a^3*x) + b^2/(a^3*(a + b*x)) + (3*b^2*Log[x])/a^4 - (3*b^2*Log[a + b*x])/a^4}
{1/(x^4*(a + b*x)^2), x, 5, -(1/(3*a^2*x^3)) + b/(a^3*x^2) - (3*b^2)/(a^4*x) - b^3/(a^4*(a + b*x)) - (4*b^3*Log[x])/a^5 + (4*b^3*Log[a + b*x])/a^5}
{1/(x^5*(a + b*x)^2), x, 5, -(1/(4*a^2*x^4)) + (2*b)/(3*a^3*x^3) - (3*b^2)/(2*a^4*x^2) + (4*b^3)/(a^5*x) + b^4/(a^5*(a + b*x)) + (5*b^4*Log[x])/a^6 - (5*b^4*Log[a + b*x])/a^6}

(* Integrands of the form 1/(x^m*(a+b*x)^2) where m>0 is an integer and b/a is rational *)
{1/(x*(4 + 6*x)^2), x, 4, 1/(8*(2 + 3*x)) - (1/8)*ArcTanh[1 + 3*x]}
{1/(x^2*(4 + 6*x)^2), x, 5, -(1/(16*x)) - 3/(16*(2 + 3*x)) + (3/8)*ArcTanh[1 + 3*x]}
{1/(x^3*(4 + 6*x)^2), x, 5, -(1/(32*x^2)) + 3/(16*x) + 9/(32*(2 + 3*x)) - (27/32)*ArcTanh[1 + 3*x]}
{1/(x^4*(4 + 6*x)^2), x, 5, -(1/(48*x^3)) + 3/(32*x^2) - 27/(64*x) - 27/(64*(2 + 3*x)) + (27/16)*ArcTanh[1 + 3*x]}
{1/(x^5*(4 + 6*x)^2), x, 5, -(1/(64*x^4)) + 1/(16*x^3) - 27/(128*x^2) + 27/(32*x) + 81/(128*(2 + 3*x)) - (405/128)*ArcTanh[1 + 3*x]}


(* Integrands of the form x^m/(a+b*x)^3 where m is an integer *)
{x^5/(a + b*x)^3, x, 6, (6*a^2*x)/b^5 - (3*a*x^2)/(2*b^4) + x^3/(3*b^3) + a^5/(2*b^6*(a + b*x)^2) - (5*a^4)/(b^6*(a + b*x)) - (10*a^3*Log[a + b*x])/b^6}
{x^4/(a + b*x)^3, x, 6, -((3*a*x)/b^4) + x^2/(2*b^3) - a^4/(2*b^5*(a + b*x)^2) + (4*a^3)/(b^5*(a + b*x)) + (6*a^2*Log[a + b*x])/b^5}
{x^3/(a + b*x)^3, x, 5, x/b^3 + a^3/(2*b^4*(a + b*x)^2) - (3*a^2)/(b^4*(a + b*x)) - (3*a*Log[a + b*x])/b^4}
{x^2/(a + b*x)^3, x, 5, -(a^2/(2*b^3*(a + b*x)^2)) + (2*a)/(b^3*(a + b*x)) + Log[a + b*x]/b^3}
{x/(a + b*x)^3, x, 1, x^2/(2*a*(a + b*x)^2)}
{1/(a + b*x)^3, x, 1, -1/(2*b*(a + b*x)^2)}
{1/(x*(a + b*x)^3), x, 5, 1/(2*a*(a + b*x)^2) + 1/(a^2*(a + b*x)) + Log[x]/a^3 - Log[a + b*x]/a^3}
{1/(x^2*(a + b*x)^3), x, 6, -(1/(a^3*x)) - b/(2*a^2*(a + b*x)^2) - (2*b)/(a^3*(a + b*x)) - (3*b*Log[x])/a^4 + (3*b*Log[a + b*x])/a^4}
{1/(x^3*(a + b*x)^3), x, 6, -(1/(2*a^3*x^2)) + (3*b)/(a^4*x) + b^2/(2*a^3*(a + b*x)^2) + (3*b^2)/(a^4*(a + b*x)) + (6*b^2*Log[x])/a^5 - (6*b^2*Log[a + b*x])/a^5}
{1/(x^4*(a + b*x)^3), x, 6, -(1/(3*a^3*x^3)) + (3*b)/(2*a^4*x^2) - (6*b^2)/(a^5*x) - b^3/(2*a^4*(a + b*x)^2) - (4*b^3)/(a^5*(a + b*x)) - (10*b^3*Log[x])/a^6 + (10*b^3*Log[a + b*x])/a^6}
{1/(x^5*(a + b*x)^3), x, 6, -(1/(4*a^3*x^4)) + b/(a^4*x^3) - (3*b^2)/(a^5*x^2) + (10*b^3)/(a^6*x) + b^4/(2*a^5*(a + b*x)^2) + (5*b^4)/(a^6*(a + b*x)) + (15*b^4*Log[x])/a^7 - (15*b^4*Log[a + b*x])/a^7}

(* Integrands of the form 1/(x^m*(a+b*x)^3) where m>0 is an integer and b/a is rational *)
{1/(x*(4 + 6*x)^3), x, 5, 1/(32*(2 + 3*x)^2) + 1/(32*(2 + 3*x)) - (1/32)*ArcTanh[1 + 3*x]}
{1/(x^2*(4 + 6*x)^3), x, 6, -(1/(64*x)) - 3/(64*(2 + 3*x)^2) - 3/(32*(2 + 3*x)) + (9/64)*ArcTanh[1 + 3*x]}
{1/(x^3*(4 + 6*x)^3), x, 6, -(1/(128*x^2)) + 9/(128*x) + 9/(128*(2 + 3*x)^2) + 27/(128*(2 + 3*x)) - (27/64)*ArcTanh[1 + 3*x]}
{1/(x^4*(4 + 6*x)^3), x, 6, -(1/(192*x^3)) + 9/(256*x^2) - 27/(128*x) - 27/(256*(2 + 3*x)^2) - 27/(64*(2 + 3*x)) + (135/128)*ArcTanh[1 + 3*x]}
{1/(x^5*(4 + 6*x)^3), x, 6, -(1/(256*x^4)) + 3/(128*x^3) - 27/(256*x^2) + 135/(256*x) + 81/(512*(2 + 3*x)^2) + 405/(512*(2 + 3*x)) - (1215/512)*ArcTanh[1 + 3*x]}


(* Integrands of the form x^m*(a+b*x)^7 where m is an integer *)
{x^7*(a + b*x)^7, x, 2, (a^7*x^8)/8 + (7*a^6*b*x^9)/9 + (21*a^5*b^2*x^10)/10 + (35*a^4*b^3*x^11)/11 + (35*a^3*b^4*x^12)/12 + (21*a^2*b^5*x^13)/13 + (a*b^6*x^14)/2 + (b^7*x^15)/15}
{x^6*(a + b*x)^7, x, 2, (a^7*x^7)/7 + (7*a^6*b*x^8)/8 + (7*a^5*b^2*x^9)/3 + (7*a^4*b^3*x^10)/2 + (35*a^3*b^4*x^11)/11 + (7*a^2*b^5*x^12)/4 + (7*a*b^6*x^13)/13 + (b^7*x^14)/14}
{x^5*(a + b*x)^7, x, 2, (a^7*x^6)/6 + a^6*b*x^7 + (21*a^5*b^2*x^8)/8 + (35*a^4*b^3*x^9)/9 + (7*a^3*b^4*x^10)/2 + (21*a^2*b^5*x^11)/11 + (7*a*b^6*x^12)/12 + (b^7*x^13)/13}
{x^4*(a + b*x)^7, x, 2, (a^7*x^5)/5 + (7/6)*a^6*b*x^6 + 3*a^5*b^2*x^7 + (35/8)*a^4*b^3*x^8 + (35/9)*a^3*b^4*x^9 + (21/10)*a^2*b^5*x^10 + (7/11)*a*b^6*x^11 + (b^7*x^12)/12}
{x^3*(a + b*x)^7, x, 4, -((a^3*(a + b*x)^8)/(1320*b^4)) + (a^2*x*(a + b*x)^8)/(165*b^3) - (3*a*x^2*(a + b*x)^8)/(110*b^2) + (x^3*(a + b*x)^8)/(11*b)}
{x^2*(a + b*x)^7, x, 3, (a^2*(a + b*x)^8)/(360*b^3) - (a*x*(a + b*x)^8)/(45*b^2) + (x^2*(a + b*x)^8)/(10*b)}
{x*(a + b*x)^7, x, 2, -((a*(a + b*x)^8)/(72*b^2)) + (x*(a + b*x)^8)/(9*b)}
{(a + b*x)^7, x, 1, (a + b*x)^8/(8*b)}
{(a + b*x)^7/x, x, 2, 7*a^6*b*x + (21*a^5*b^2*x^2)/2 + (35*a^4*b^3*x^3)/3 + (35*a^3*b^4*x^4)/4 + (21*a^2*b^5*x^5)/5 + (7*a*b^6*x^6)/6 + (b^7*x^7)/7 + a^7*Log[x]}
{(a + b*x)^7/x^2, x, 2, -(a^7/x) + 21*a^5*b^2*x + (35*a^4*b^3*x^2)/2 + (35*a^3*b^4*x^3)/3 + (21*a^2*b^5*x^4)/4 + (7*a*b^6*x^5)/5 + (b^7*x^6)/6 + 7*a^6*b*Log[x]}
{(a + b*x)^7/x^3, x, 2, -a^7/(2*x^2) - (7*a^6*b)/x + 35*a^4*b^3*x + (35*a^3*b^4*x^2)/2 + 7*a^2*b^5*x^3 + (7*a*b^6*x^4)/4 + (b^7*x^5)/5 + 21*a^5*b^2*Log[x]}
{(a + b*x)^7/x^4, x, 2, -(a^7/(3*x^3)) - (7*a^6*b)/(2*x^2) - (21*a^5*b^2)/x + 35*a^3*b^4*x + (21/2)*a^2*b^5*x^2 + (7/3)*a*b^6*x^3 + (b^7*x^4)/4 + 35*a^4*b^3*Log[x]}
{(a + b*x)^7/x^5, x, 2, -(a^7/(4*x^4)) - (7*a^6*b)/(3*x^3) - (21*a^5*b^2)/(2*x^2) - (35*a^4*b^3)/x + 21*a^2*b^5*x + (7/2)*a*b^6*x^2 + (b^7*x^3)/3 + 35*a^3*b^4*Log[x]}
{(a + b*x)^7/x^6, x, 2, -(a^7/(5*x^5)) - (7*a^6*b)/(4*x^4) - (7*a^5*b^2)/x^3 - (35*a^4*b^3)/(2*x^2) - (35*a^3*b^4)/x + 7*a*b^6*x + (b^7*x^2)/2 + 21*a^2*b^5*Log[x]}
{(a + b*x)^7/x^7, x, 2, -(a^7/(6*x^6)) - (7*a^6*b)/(5*x^5) - (21*a^5*b^2)/(4*x^4) - (35*a^4*b^3)/(3*x^3) - (35*a^3*b^4)/(2*x^2) - (21*a^2*b^5)/x + b^7*x + 7*a*b^6*Log[x]}
{(a + b*x)^7/x^8, x, 2, -(a^7/(7*x^7)) - (7*a^6*b)/(6*x^6) - (21*a^5*b^2)/(5*x^5) - (35*a^4*b^3)/(4*x^4) - (35*a^3*b^4)/(3*x^3) - (21*a^2*b^5)/(2*x^2) - (7*a*b^6)/x + b^7*Log[x]}
{(a + b*x)^7/x^9, x, 1, -(a + b*x)^8/(8*a*x^8)}
{(a + b*x)^7/x^10, x, 2, -((a + b*x)^8/(9*a*x^9)) + (b*(a + b*x)^8)/(72*a^2*x^8)}
{(a + b*x)^7/x^11, x, 3, -((a + b*x)^8/(10*a*x^10)) + (b*(a + b*x)^8)/(45*a^2*x^9) - (b^2*(a + b*x)^8)/(360*a^3*x^8)}
{(a + b*x)^7/x^12, x, 4, -((a + b*x)^8/(11*a*x^11)) + (3*b*(a + b*x)^8)/(110*a^2*x^10) - (b^2*(a + b*x)^8)/(165*a^3*x^9) + (b^3*(a + b*x)^8)/(1320*a^4*x^8)}
{(a + b*x)^7/x^13, x, 2, -(a^7/(12*x^12)) - (7*a^6*b)/(11*x^11) - (21*a^5*b^2)/(10*x^10) - (35*a^4*b^3)/(9*x^9) - (35*a^3*b^4)/(8*x^8) - (3*a^2*b^5)/x^7 - (7*a*b^6)/(6*x^6) - b^7/(5*x^5)}
{(a + b*x)^7/x^14, x, 2, -(a^7/(13*x^13)) - (7*a^6*b)/(12*x^12) - (21*a^5*b^2)/(11*x^11) - (7*a^4*b^3)/(2*x^10) - (35*a^3*b^4)/(9*x^9) - (21*a^2*b^5)/(8*x^8) - (a*b^6)/x^7 - b^7/(6*x^6)}
{(a + b*x)^7/x^15, x, 2, -(a^7/(14*x^14)) - (7*a^6*b)/(13*x^13) - (7*a^5*b^2)/(4*x^12) - (35*a^4*b^3)/(11*x^11) - (7*a^3*b^4)/(2*x^10) - (7*a^2*b^5)/(3*x^9) - (7*a*b^6)/(8*x^8) - b^7/(7*x^7)}
{(a + b*x)^7/x^16, x, 2, -(a^7/(15*x^15)) - (a^6*b)/(2*x^14) - (21*a^5*b^2)/(13*x^13) - (35*a^4*b^3)/(12*x^12) - (35*a^3*b^4)/(11*x^11) - (21*a^2*b^5)/(10*x^10) - (7*a*b^6)/(9*x^9) - b^7/(8*x^8)}
{(a + b*x)^7/x^17, x, 2, -(a^7/(16*x^16)) - (7*a^6*b)/(15*x^15) - (3*a^5*b^2)/(2*x^14) - (35*a^4*b^3)/(13*x^13) - (35*a^3*b^4)/(12*x^12) - (21*a^2*b^5)/(11*x^11) - (7*a*b^6)/(10*x^10) - b^7/(9*x^9)}
{(a + b*x)^7/x^18, x, 2, -a^7/(17*x^17) - (7*a^6*b)/(16*x^16) - (7*a^5*b^2)/(5*x^15) - (5*a^4*b^3)/(2*x^14) - (35*a^3*b^4)/(13*x^13) - (7*a^2*b^5)/(4*x^12) - (7*a*b^6)/(11*x^11) - b^7/(10*x^10)}


(* Integrands of the form x^m/(a+b*x)^7 where m is an integer *)
{x^10/(a + b*x)^7, x, 10, -((84*a^3*x)/b^10) + (14*a^2*x^2)/b^9 - (7*a*x^3)/(3*b^8) + x^4/(4*b^7) - a^10/(6*b^11*(a + b*x)^6) + (2*a^9)/(b^11*(a + b*x)^5) - (45*a^8)/(4*b^11*(a + b*x)^4) + (40*a^7)/(b^11*(a + b*x)^3) - (105*a^6)/(b^11*(a + b*x)^2) + (252*a^5)/(b^11*(a + b*x)) + (210*a^4*Log[a + b*x])/b^11}
{x^9/(a + b*x)^7, x, 10, (28*a^2*x)/b^9 - (7*a*x^2)/(2*b^8) + x^3/(3*b^7) + a^9/(6*b^10*(a + b*x)^6) - (9*a^8)/(5*b^10*(a + b*x)^5) + (9*a^7)/(b^10*(a + b*x)^4) - (28*a^6)/(b^10*(a + b*x)^3) + (63*a^5)/(b^10*(a + b*x)^2) - (126*a^4)/(b^10*(a + b*x)) - (84*a^3*Log[a + b*x])/b^10}
{x^8/(a + b*x)^7, x, 10, -((7*a*x)/b^8) + x^2/(2*b^7) - a^8/(6*b^9*(a + b*x)^6) + (8*a^7)/(5*b^9*(a + b*x)^5) - (7*a^6)/(b^9*(a + b*x)^4) + (56*a^5)/(3*b^9*(a + b*x)^3) - (35*a^4)/(b^9*(a + b*x)^2) + (56*a^3)/(b^9*(a + b*x)) + (28*a^2*Log[a + b*x])/b^9}
{x^7/(a + b*x)^7, x, 9, x/b^7 + a^7/(6*b^8*(a + b*x)^6) - (7*a^6)/(5*b^8*(a + b*x)^5) + (21*a^5)/(4*b^8*(a + b*x)^4) - (35*a^4)/(3*b^8*(a + b*x)^3) + (35*a^3)/(2*b^8*(a + b*x)^2) - (21*a^2)/(b^8*(a + b*x)) - (7*a*Log[a + b*x])/b^8}
{x^6/(a + b*x)^7, x, 9, -(a^6/(6*b^7*(a + b*x)^6)) + (6*a^5)/(5*b^7*(a + b*x)^5) - (15*a^4)/(4*b^7*(a + b*x)^4) + (20*a^3)/(3*b^7*(a + b*x)^3) - (15*a^2)/(2*b^7*(a + b*x)^2) + (6*a)/(b^7*(a + b*x)) + Log[a + b*x]/b^7}
{x^5/(a + b*x)^7, x, 1, x^6/(6*a*(a + b*x)^6)}
{x^4/(a + b*x)^7, x, 2, x^5/(6*a*(a + b*x)^6) + x^5/(30*a^2*(a + b*x)^5)}
{x^3/(a + b*x)^7, x, 6, a^3/(6*b^4*(a + b*x)^6) - (3*a^2)/(5*b^4*(a + b*x)^5) + (3*a)/(4*b^4*(a + b*x)^4) - 1/(3*b^4*(a + b*x)^3)}
{x^2/(a + b*x)^7, x, 5, -(a^2/(6*b^3*(a + b*x)^6)) + (2*a)/(5*b^3*(a + b*x)^5) - 1/(4*b^3*(a + b*x)^4)}
{x/(a + b*x)^7, x, 4, a/(6*b^2*(a + b*x)^6) - 1/(5*b^2*(a + b*x)^5)}
{1/(a + b*x)^7, x, 1, -1/(6*b*(a + b*x)^6)}
{1/(x*(a + b*x)^7), x, 9, 1/(6*a*(a + b*x)^6) + 1/(5*a^2*(a + b*x)^5) + 1/(4*a^3*(a + b*x)^4) + 1/(3*a^4*(a + b*x)^3) + 1/(2*a^5*(a + b*x)^2) + 1/(a^6*(a + b*x)) + Log[x]/a^7 - Log[a + b*x]/a^7}
{1/(x^2*(a + b*x)^7), x, 10, -(1/(a^7*x)) - b/(6*a^2*(a + b*x)^6) - (2*b)/(5*a^3*(a + b*x)^5) - (3*b)/(4*a^4*(a + b*x)^4) - (4*b)/(3*a^5*(a + b*x)^3) - (5*b)/(2*a^6*(a + b*x)^2) - (6*b)/(a^7*(a + b*x)) - (7*b*Log[x])/a^8 + (7*b*Log[a + b*x])/a^8}
{1/(x^3*(a + b*x)^7), x, 10, -(1/(2*a^7*x^2)) + (7*b)/(a^8*x) + b^2/(6*a^3*(a + b*x)^6) + (3*b^2)/(5*a^4*(a + b*x)^5) + (3*b^2)/(2*a^5*(a + b*x)^4) + (10*b^2)/(3*a^6*(a + b*x)^3) + (15*b^2)/(2*a^7*(a + b*x)^2) + (21*b^2)/(a^8*(a + b*x)) + (28*b^2*Log[x])/a^9 - (28*b^2*Log[a + b*x])/a^9}
{1/(x^4*(a + b*x)^7), x, 10, -(1/(3*a^7*x^3)) + (7*b)/(2*a^8*x^2) - (28*b^2)/(a^9*x) - b^3/(6*a^4*(a + b*x)^6) - (4*b^3)/(5*a^5*(a + b*x)^5) - (5*b^3)/(2*a^6*(a + b*x)^4) - (20*b^3)/(3*a^7*(a + b*x)^3) - (35*b^3)/(2*a^8*(a + b*x)^2) - (56*b^3)/(a^9*(a + b*x)) - (84*b^3*Log[x])/a^10 + (84*b^3*Log[a + b*x])/a^10}
{1/(x^5*(a + b*x)^7), x, 10, -(1/(4*a^7*x^4)) + (7*b)/(3*a^8*x^3) - (14*b^2)/(a^9*x^2) + (84*b^3)/(a^10*x) + b^4/(6*a^5*(a + b*x)^6) + b^4/(a^6*(a + b*x)^5) + (15*b^4)/(4*a^7*(a + b*x)^4) + (35*b^4)/(3*a^8*(a + b*x)^3) + (35*b^4)/(a^9*(a + b*x)^2) + (126*b^4)/(a^10*(a + b*x)) + (210*b^4*Log[x])/a^11 - (210*b^4*Log[a + b*x])/a^11}


(* ::Subsection::Closed:: *)
(*Products of powers of two linear binomials *)


(* Integrands of the form (a+b*x)^m*(c+d*x)^n where m and n are positive integers *)
{(a + b*x)*(c + d*x), x, 2, a*c*x + (1/2)*(b*c + a*d)*x^2 + (1/3)*b*d*x^3}
{(a + b*x)^2*(c + d*x), x, 2, ((4*b*c - a*d)*(a + b*x)^3)/(12*b^2) + (d*x*(a + b*x)^3)/(4*b)}
{(a + b*x)^3*(c + d*x), x, 2, ((5*b*c - a*d)*(a + b*x)^4)/(20*b^2) + (d*x*(a + b*x)^4)/(5*b)}
{(a + b*x)^4*(c + d*x), x, 2, ((6*b*c - a*d)*(a + b*x)^5)/(30*b^2) + (d*x*(a + b*x)^5)/(6*b)}
{(a + b*x)^5*(c + d*x), x, 2, ((7*b*c - a*d)*(a + b*x)^6)/(42*b^2) + (d*x*(a + b*x)^6)/(7*b)}

{(a + b*x)^2*(c + d*x)^2, x, 3, ((b*c - a*d)^2*(a + b*x)^3)/(30*b^3) + ((b*c - a*d)*(a + b*x)^3*(c + d*x))/(10*b^2) + ((a + b*x)^3*(c + d*x)^2)/(5*b)}
{(a + b*x)^3*(c + d*x)^2, x, 3, ((b*c - a*d)^2*(a + b*x)^4)/(60*b^3) + ((b*c - a*d)*(a + b*x)^4*(c + d*x))/(15*b^2) + ((a + b*x)^4*(c + d*x)^2)/(6*b)}
{(a + b*x)^4*(c + d*x)^2, x, 3, ((b*c - a*d)^2*(a + b*x)^5)/(105*b^3) + ((b*c - a*d)*(a + b*x)^5*(c + d*x))/(21*b^2) + ((a + b*x)^5*(c + d*x)^2)/(7*b)}
{(a + b*x)^5*(c + d*x)^2, x, 3, ((b*c - a*d)^2*(a + b*x)^6)/(168*b^3) + ((b*c - a*d)*(a + b*x)^6*(c + d*x))/(28*b^2) + ((a + b*x)^6*(c + d*x)^2)/(8*b)}

{(a + b*x)^3*(c + d*x)^3, x, 4, ((b*c - a*d)^3*(a + b*x)^4)/(140*b^4) + ((b*c - a*d)^2*(a + b*x)^4*(c + d*x))/(35*b^3) + ((b*c - a*d)*(a + b*x)^4*(c + d*x)^2)/(14*b^2) + ((a + b*x)^4*(c + d*x)^3)/(7*b)}
{(a + b*x)^4*(c + d*x)^3, x, 4, ((b*c - a*d)^3*(a + b*x)^5)/(280*b^4) + ((b*c - a*d)^2*(a + b*x)^5*(c + d*x))/(56*b^3) + (3*(b*c - a*d)*(a + b*x)^5*(c + d*x)^2)/(56*b^2) + ((a + b*x)^5*(c + d*x)^3)/(8*b)}
{(a + b*x)^5*(c + d*x)^3, x, 4, ((b*c - a*d)^3*(a + b*x)^6)/(504*b^4) + ((b*c - a*d)^2*(a + b*x)^6*(c + d*x))/(84*b^3) + ((b*c - a*d)*(a + b*x)^6*(c + d*x)^2)/(24*b^2) + ((a + b*x)^6*(c + d*x)^3)/(9*b)}


(* Integrands of the form (a+b*x)^m/(c+d*x) where m is an integer *)
{(a + b*x)^(-3)/(c + d*x), x, 6, -(1/(2*(b*c - a*d)*(a + b*x)^2)) + d/((b*c - a*d)^2*(a + b*x)) + (d^2*Log[a + b*x])/(b*c - a*d)^3 - (d^2*Log[c + d*x])/(b*c - a*d)^3}
{(a + b*x)^(-2)/(c + d*x), x, 5, -(1/((b*c - a*d)*(a + b*x))) - (d*Log[a + b*x])/(b*c - a*d)^2 + (d*Log[c + d*x])/(b*c - a*d)^2}
{(a + b*x)^(-1)/(c + d*x), x, 4, Log[a + b*x]/(b*c - a*d) - Log[c + d*x]/(b*c - a*d)}
{(4 + 6*x)^(-1)/(c + d*x), x, 5, Log[2 + 3*x]/(2*(3*c - 2*d)) - Log[c + d*x]/(2*(3*c - 2*d))}
{(a + b*x)^0/(c + d*x), x, 1, Log[c + d*x]/d}
{(a + b*x)^1/(c + d*x), x, 3, (b*x)/d - ((b*c - a*d)*Log[c + d*x])/d^2}
{(a + b*x)^2/(c + d*x), x, 4, -((b*(b*c - a*d)*x)/d^2) + (a + b*x)^2/(2*d) + ((b*c - a*d)^2*Log[c + d*x])/d^3}
{(a + b*x)^3/(c + d*x), x, 5, (b*(b*c - a*d)^2*x)/d^3 - ((b*c - a*d)*(a + b*x)^2)/(2*d^2) + (a + b*x)^3/(3*d) - ((b*c - a*d)^3*Log[c + d*x])/d^4}
{(a + b*x)^4/(c + d*x), x, 6, -((b*(b*c - a*d)^3*x)/d^4) + ((b*c - a*d)^2*(a + b*x)^2)/(2*d^3) - ((b*c - a*d)*(a + b*x)^3)/(3*d^2) + (a + b*x)^4/(4*d) + ((b*c - a*d)^4*Log[c + d*x])/d^5}
{(a + b*x)^5/(c + d*x), x, 7, (b*(b*c - a*d)^4*x)/d^5 - ((b*c - a*d)^3*(a + b*x)^2)/(2*d^4) + ((b*c - a*d)^2*(a + b*x)^3)/(3*d^3) - ((b*c - a*d)*(a + b*x)^4)/(4*d^2) + (a + b*x)^5/(5*d) - ((b*c - a*d)^5*Log[c + d*x])/d^6}
{(a + b*x)^6/(c + d*x), x, 8, -((b*(b*c - a*d)^5*x)/d^6) + ((b*c - a*d)^4*(a + b*x)^2)/(2*d^5) - ((b*c - a*d)^3*(a + b*x)^3)/(3*d^4) + ((b*c - a*d)^2*(a + b*x)^4)/(4*d^3) - ((b*c - a*d)*(a + b*x)^5)/(5*d^2) + (a + b*x)^6/(6*d) + ((b*c - a*d)^6*Log[c + d*x])/d^7}


(* Integrands of the form (a+b*x)^m/(c+d*x)^2 where m is an integer *)
{(a + b*x)^(-3)/(c + d*x)^2, x, 7, -(b/(2*(b*c - a*d)^2*(a + b*x)^2)) + (2*b*d)/((b*c - a*d)^3*(a + b*x)) + d^2/((b*c - a*d)^3*(c + d*x)) + (3*b*d^2*Log[a + b*x])/(b*c - a*d)^4 - (3*b*d^2*Log[c + d*x])/(b*c - a*d)^4}
{(a + b*x)^(-2)/(c + d*x)^2, x, 6, -(b/((b*c - a*d)^2*(a + b*x))) - d/((b*c - a*d)^2*(c + d*x)) - (2*b*d*Log[a + b*x])/(b*c - a*d)^3 + (2*b*d*Log[c + d*x])/(b*c - a*d)^3}
{(a + b*x)^(-1)/(c + d*x)^2, x, 5, 1/((b*c - a*d)*(c + d*x)) + (b*Log[a + b*x])/(b*c - a*d)^2 - (b*Log[c + d*x])/(b*c - a*d)^2}
{(a + b*x)^0/(c + d*x)^2, x, 1, -(1/(d*(c + d*x)))}
{(a + b*x)^1/(c + d*x)^2, x, 4, (b*c - a*d)/(d^2*(c + d*x)) + (b*Log[c + d*x])/d^2}
{(a + b*x)^2/(c + d*x)^2, x, 4, (b^2*x)/d^2 - (b*c - a*d)^2/(d^3*(c + d*x)) - (2*b*(b*c - a*d)*Log[c + d*x])/d^3}
{(a + b*x)^3/(c + d*x)^2, x, 5, -((2*b^2*(b*c - a*d)*x)/d^3) + (b*(a + b*x)^2)/(2*d^2) + (b*c - a*d)^3/(d^4*(c + d*x)) + (3*b*(b*c - a*d)^2*Log[c + d*x])/d^4}
{(a + b*x)^4/(c + d*x)^2, x, 6, (3*b^2*(b*c - a*d)^2*x)/d^4 - (b*(b*c - a*d)*(a + b*x)^2)/d^3 + (b*(a + b*x)^3)/(3*d^2) - (b*c - a*d)^4/(d^5*(c + d*x)) - (4*b*(b*c - a*d)^3*Log[c + d*x])/d^5}
{(a + b*x)^5/(c + d*x)^2, x, 7, -((4*b^2*(b*c - a*d)^3*x)/d^5) + (3*b*(b*c - a*d)^2*(a + b*x)^2)/(2*d^4) - (2*b*(b*c - a*d)*(a + b*x)^3)/(3*d^3) + (b*(a + b*x)^4)/(4*d^2) + (b*c - a*d)^5/(d^6*(c + d*x)) + (5*b*(b*c - a*d)^4*Log[c + d*x])/d^6}
{(a + b*x)^6/(c + d*x)^2, x, 8, (5*b^2*(b*c - a*d)^4*x)/d^6 - (2*b*(b*c - a*d)^3*(a + b*x)^2)/d^5 + (b*(b*c - a*d)^2*(a + b*x)^3)/d^4 - (b*(b*c - a*d)*(a + b*x)^4)/(2*d^3) + (b*(a + b*x)^5)/(5*d^2) - (b*c - a*d)^6/(d^7*(c + d*x)) - (6*b*(b*c - a*d)^5*Log[c + d*x])/d^7}


(* Integrands of the form (a+b*x)^m/(c+d*x)^3 where m is an integer *)
{(a + b*x)^(-3)/(c + d*x)^3, x, 8, -(b^2/(2*(b*c - a*d)^3*(a + b*x)^2)) + (3*b^2*d)/((b*c - a*d)^4*(a + b*x)) + d^2/(2*(b*c - a*d)^3*(c + d*x)^2) + (3*b*d^2)/((b*c - a*d)^4*(c + d*x)) + (6*b^2*d^2*Log[a + b*x])/(b*c - a*d)^5 - (6*b^2*d^2*Log[c + d*x])/(b*c - a*d)^5}
{(a + b*x)^(-2)/(c + d*x)^3, x, 7, -(b^2/((b*c - a*d)^3*(a + b*x))) - d/(2*(b*c - a*d)^2*(c + d*x)^2) - (2*b*d)/((b*c - a*d)^3*(c + d*x)) - (3*b^2*d*Log[a + b*x])/(b*c - a*d)^4 + (3*b^2*d*Log[c + d*x])/(b*c - a*d)^4}
{(a + b*x)^(-1)/(c + d*x)^3, x, 6, 1/(2*(b*c - a*d)*(c + d*x)^2) + b/((b*c - a*d)^2*(c + d*x)) + (b^2*Log[a + b*x])/(b*c - a*d)^3 - (b^2*Log[c + d*x])/(b*c - a*d)^3}
{(a + b*x)^0/(c + d*x)^3, x, 1, -(1/(2*d*(c + d*x)^2))}
{(a + b*x)^1/(c + d*x)^3, x, 1, (a + b*x)^2/(2*(b*c - a*d)*(c + d*x)^2)}
{(a + b*x)^2/(c + d*x)^3, x, 5, -((b*c - a*d)^2/(2*d^3*(c + d*x)^2)) + (2*b*(b*c - a*d))/(d^3*(c + d*x)) + (b^2*Log[c + d*x])/d^3}
{(a + b*x)^3/(c + d*x)^3, x, 5, (b^3*x)/d^3 + (b*c - a*d)^3/(2*d^4*(c + d*x)^2) - (3*b*(b*c - a*d)^2)/(d^4*(c + d*x)) - (3*b^2*(b*c - a*d)*Log[c + d*x])/d^4}
{(a + b*x)^4/(c + d*x)^3, x, 6, -((3*b^3*(b*c - a*d)*x)/d^4) + (b^2*(a + b*x)^2)/(2*d^3) - (b*c - a*d)^4/(2*d^5*(c + d*x)^2) + (4*b*(b*c - a*d)^3)/(d^5*(c + d*x)) + (6*b^2*(b*c - a*d)^2*Log[c + d*x])/d^5}
{(a + b*x)^5/(c + d*x)^3, x, 7, (6*b^3*(b*c - a*d)^2*x)/d^5 - (3*b^2*(b*c - a*d)*(a + b*x)^2)/(2*d^4) + (b^2*(a + b*x)^3)/(3*d^3) + (b*c - a*d)^5/(2*d^6*(c + d*x)^2) - (5*b*(b*c - a*d)^4)/(d^6*(c + d*x)) - (10*b^2*(b*c - a*d)^3*Log[c + d*x])/d^6}
{(a + b*x)^6/(c + d*x)^3, x, 8, -((10*b^3*(b*c - a*d)^3*x)/d^6) + (3*b^2*(b*c - a*d)^2*(a + b*x)^2)/d^5 - (b^2*(b*c - a*d)*(a + b*x)^3)/d^4 + (b^2*(a + b*x)^4)/(4*d^3) - (b*c - a*d)^6/(2*d^7*(c + d*x)^2) + (6*b*(b*c - a*d)^5)/(d^7*(c + d*x)) + (15*b^2*(b*c - a*d)^4*Log[c + d*x])/d^7}


{(a + b*x)^4/(c + d*x)^5, x, 7, -((b*c - a*d)^4/(4*d^5*(c + d*x)^4)) + (4*b*(b*c - a*d)^3)/(3*d^5*(c + d*x)^3) - (3*b^2*(b*c - a*d)^2)/(d^5*(c + d*x)^2) + (4*b^3*(b*c - a*d))/(d^5*(c + d*x)) + (b^4*Log[c + d*x])/d^5}
{(a + b*x)^5/(c + d*x)^5, x, 7, (b^5*x)/d^5 + (b*c - a*d)^5/(4*d^6*(c + d*x)^4) - (5*b*(b*c - a*d)^4)/(3*d^6*(c + d*x)^3) + (5*b^2*(b*c - a*d)^3)/(d^6*(c + d*x)^2) - (10*b^3*(b*c - a*d)^2)/(d^6*(c + d*x)) - (5*b^4*(b*c - a*d)*Log[c + d*x])/d^6}


(* Integrands of the form (a+b*x)^m/(c+d*x)^8 where m is an integer *)
(* {(a + b*x)^(-4)/(c + d*x)^8, x, 14, -(b^7/(3*(b*c - a*d)^8*(a + b*x)^3)) + (4*b^7*d)/((b*c - a*d)^9*(a + b*x)^2) - (36*b^7*d^2)/((b*c - a*d)^10*(a + b*x)) - d^3/(7*(b*c - a*d)^4*(c + d*x)^7) - (2*b*d^3)/(3*(b*c - a*d)^5*(c + d*x)^6) - (2*b^2*d^3)/((b*c - a*d)^6*(c + d*x)^5) - (5*b^3*d^3)/((b*c - a*d)^7*(c + d*x)^4) - (35*b^4*d^3)/(3*(b*c - a*d)^8*(c + d*x)^3) - (28*b^5*d^3)/((b*c - a*d)^9*(c + d*x)^2) - (84*b^6*d^3)/((b*c - a*d)^10*(c + d*x)) - (120*b^7*d^3*Log[a + b*x])/(b*c - a*d)^11 + (120*b^7*d^3*Log[c + d*x])/(b*c - a*d)^11} *)
(* {(a + b*x)^(-3)/(c + d*x)^8, x, 13, -(b^7/(2*(b*c - a*d)^8*(a + b*x)^2)) + (8*b^7*d)/((b*c - a*d)^9*(a + b*x)) + d^2/(7*(b*c - a*d)^3*(c + d*x)^7) + (b*d^2)/(2*(b*c - a*d)^4*(c + d*x)^6) + (6*b^2*d^2)/(5*(b*c - a*d)^5*(c + d*x)^5) + (5*b^3*d^2)/(2*(b*c - a*d)^6*(c + d*x)^4) + (5*b^4*d^2)/((b*c - a*d)^7*(c + d*x)^3) + (21*b^5*d^2)/(2*(b*c - a*d)^8*(c + d*x)^2) + (28*b^6*d^2)/((b*c - a*d)^9*(c + d*x)) + (36*b^7*d^2*Log[a + b*x])/(b*c - a*d)^10 - (36*b^7*d^2*Log[c + d*x])/(b*c - a*d)^10} *)
{(a + b*x)^(-2)/(c + d*x)^8, x, 12, -(b^7/((b*c - a*d)^8*(a + b*x))) - d/(7*(b*c - a*d)^2*(c + d*x)^7) - (b*d)/(3*(b*c - a*d)^3*(c + d*x)^6) - (3*b^2*d)/(5*(b*c - a*d)^4*(c + d*x)^5) - (b^3*d)/((b*c - a*d)^5*(c + d*x)^4) - (5*b^4*d)/(3*(b*c - a*d)^6*(c + d*x)^3) - (3*b^5*d)/((b*c - a*d)^7*(c + d*x)^2) - (7*b^6*d)/((b*c - a*d)^8*(c + d*x)) - (8*b^7*d*Log[a + b*x])/(b*c - a*d)^9 + (8*b^7*d*Log[c + d*x])/(b*c - a*d)^9}
{(a + b*x)^(-1)/(c + d*x)^8, x, 11, 1/(7*(b*c - a*d)*(c + d*x)^7) + b/(6*(b*c - a*d)^2*(c + d*x)^6) + b^2/(5*(b*c - a*d)^3*(c + d*x)^5) + b^3/(4*(b*c - a*d)^4*(c + d*x)^4) + b^4/(3*(b*c - a*d)^5*(c + d*x)^3) + b^5/(2*(b*c - a*d)^6*(c + d*x)^2) + b^6/((b*c - a*d)^7*(c + d*x)) + (b^7*Log[a + b*x])/(b*c - a*d)^8 - (b^7*Log[c + d*x])/(b*c - a*d)^8}
{(a + b*x)^0/(c + d*x)^8, x, 1, -(1/(7*d*(c + d*x)^7))}
{(a + b*x)^1/(c + d*x)^8, x, 4, (b*c - a*d)/(7*d^2*(c + d*x)^7) - b/(6*d^2*(c + d*x)^6)}
{(a + b*x)^2/(c + d*x)^8, x, 5, -((b*c - a*d)^2/(7*d^3*(c + d*x)^7)) + (b*(b*c - a*d))/(3*d^3*(c + d*x)^6) - b^2/(5*d^3*(c + d*x)^5)}
{(a + b*x)^3/(c + d*x)^8, x, 6, (b*c - a*d)^3/(7*d^4*(c + d*x)^7) - (b*(b*c - a*d)^2)/(2*d^4*(c + d*x)^6) + (3*b^2*(b*c - a*d))/(5*d^4*(c + d*x)^5) - b^3/(4*d^4*(c + d*x)^4)}
{(a + b*x)^4/(c + d*x)^8, x, 3, (a + b*x)^5/(7*(b*c - a*d)*(c + d*x)^7) + (b*(a + b*x)^5)/(21*(b*c - a*d)^2*(c + d*x)^6) + (b^2*(a + b*x)^5)/(105*(b*c - a*d)^3*(c + d*x)^5)}
{(a + b*x)^5/(c + d*x)^8, x, 2, (a + b*x)^6/(7*(b*c - a*d)*(c + d*x)^7) + (b*(a + b*x)^6)/(42*(b*c - a*d)^2*(c + d*x)^6)}
{(a + b*x)^6/(c + d*x)^8, x, 1, (a + b*x)^7/(7*(b*c - a*d)*(c + d*x)^7)}
{(a + b*x)^7/(c + d*x)^8, x, 10, (b*c - a*d)^7/(7*d^8*(c + d*x)^7) - (7*b*(b*c - a*d)^6)/(6*d^8*(c + d*x)^6) + (21*b^2*(b*c - a*d)^5)/(5*d^8*(c + d*x)^5) - (35*b^3*(b*c - a*d)^4)/(4*d^8*(c + d*x)^4) + (35*b^4*(b*c - a*d)^3)/(3*d^8*(c + d*x)^3) - (21*b^5*(b*c - a*d)^2)/(2*d^8*(c + d*x)^2) + (7*b^6*(b*c - a*d))/(d^8*(c + d*x)) + (b^7*Log[c + d*x])/d^8}
{(a + b*x)^8/(c + d*x)^8, x, 10, (b^8*x)/d^8 - (b*c - a*d)^8/(7*d^9*(c + d*x)^7) + (4*b*(b*c - a*d)^7)/(3*d^9*(c + d*x)^6) - (28*b^2*(b*c - a*d)^6)/(5*d^9*(c + d*x)^5) + (14*b^3*(b*c - a*d)^5)/(d^9*(c + d*x)^4) - (70*b^4*(b*c - a*d)^4)/(3*d^9*(c + d*x)^3) + (28*b^5*(b*c - a*d)^3)/(d^9*(c + d*x)^2) - (28*b^6*(b*c - a*d)^2)/(d^9*(c + d*x)) - (8*b^7*(b*c - a*d)*Log[c + d*x])/d^9}
{(a + b*x)^9/(c + d*x)^8, x, 11, -((8*b^8*(b*c - a*d)*x)/d^9) + (b^7*(a + b*x)^2)/(2*d^8) + (b*c - a*d)^9/(7*d^10*(c + d*x)^7) - (3*b*(b*c - a*d)^8)/(2*d^10*(c + d*x)^6) + (36*b^2*(b*c - a*d)^7)/(5*d^10*(c + d*x)^5) - (21*b^3*(b*c - a*d)^6)/(d^10*(c + d*x)^4) + (42*b^4*(b*c - a*d)^5)/(d^10*(c + d*x)^3) - (63*b^5*(b*c - a*d)^4)/(d^10*(c + d*x)^2) + (84*b^6*(b*c - a*d)^3)/(d^10*(c + d*x)) + (36*b^7*(b*c - a*d)^2*Log[c + d*x])/d^10}
(* {(a + b*x)^10/(c + d*x)^8, x, 12, (36*b^8*(b*c - a*d)^2*x)/d^10 - (4*b^7*(b*c - a*d)*(a + b*x)^2)/d^9 + (b^7*(a + b*x)^3)/(3*d^8) - (b*c - a*d)^10/(7*d^11*(c + d*x)^7) + (5*b*(b*c - a*d)^9)/(3*d^11*(c + d*x)^6) - (9*b^2*(b*c - a*d)^8)/(d^11*(c + d*x)^5) + (30*b^3*(b*c - a*d)^7)/(d^11*(c + d*x)^4) - (70*b^4*(b*c - a*d)^6)/(d^11*(c + d*x)^3) + (126*b^5*(b*c - a*d)^5)/(d^11*(c + d*x)^2) - (210*b^6*(b*c - a*d)^4)/(d^11*(c + d*x)) - (120*b^7*(b*c - a*d)^3*Log[c + d*x])/d^11} *)
(* {(a + b*x)^11/(c + d*x)^8, x, 13, -((120*b^8*(b*c - a*d)^3*x)/d^11) + (18*b^7*(b*c - a*d)^2*(a + b*x)^2)/d^10 - (8*b^7*(b*c - a*d)*(a + b*x)^3)/(3*d^9) + (b^7*(a + b*x)^4)/(4*d^8) + (b*c - a*d)^11/(7*d^12*(c + d*x)^7) - (11*b*(b*c - a*d)^10)/(6*d^12*(c + d*x)^6) + (11*b^2*(b*c - a*d)^9)/(d^12*(c + d*x)^5) - (165*b^3*(b*c - a*d)^8)/(4*d^12*(c + d*x)^4) + (110*b^4*(b*c - a*d)^7)/(d^12*(c + d*x)^3) - (231*b^5*(b*c - a*d)^6)/(d^12*(c + d*x)^2) + (462*b^6*(b*c - a*d)^5)/(d^12*(c + d*x)) + (330*b^7*(b*c - a*d)^4*Log[c + d*x])/d^12} *)
(* {(a + b*x)^12/(c + d*x)^8, x, 14, (330*b^8*(b*c - a*d)^4*x)/d^12 - (60*b^7*(b*c - a*d)^3*(a + b*x)^2)/d^11 + (12*b^7*(b*c - a*d)^2*(a + b*x)^3)/d^10 - (2*b^7*(b*c - a*d)*(a + b*x)^4)/d^9 + (b^7*(a + b*x)^5)/(5*d^8) - (b*c - a*d)^12/(7*d^13*(c + d*x)^7) + (2*b*(b*c - a*d)^11)/(d^13*(c + d*x)^6) - (66*b^2*(b*c - a*d)^10)/(5*d^13*(c + d*x)^5) + (55*b^3*(b*c - a*d)^9)/(d^13*(c + d*x)^4) - (165*b^4*(b*c - a*d)^8)/(d^13*(c + d*x)^3) + (396*b^5*(b*c - a*d)^7)/(d^13*(c + d*x)^2) - (924*b^6*(b*c - a*d)^6)/(d^13*(c + d*x)) - (792*b^7*(b*c - a*d)^5*Log[c + d*x])/d^13} *)


(* Integrands of the form (a+b*x)^7/(c+d*x)^n where n>0 is an integer *)
{(a + b*x)^7/(c + d*x), x, 9, (b*(b*c - a*d)^6*x)/d^7 - ((b*c - a*d)^5*(a + b*x)^2)/(2*d^6) + ((b*c - a*d)^4*(a + b*x)^3)/(3*d^5) - ((b*c - a*d)^3*(a + b*x)^4)/(4*d^4) + ((b*c - a*d)^2*(a + b*x)^5)/(5*d^3) - ((b*c - a*d)*(a + b*x)^6)/(6*d^2) + (a + b*x)^7/(7*d) - ((b*c - a*d)^7*Log[c + d*x])/d^8}
{(a + b*x)^7/(c + d*x)^2, x, 9, -((6*b^2*(b*c - a*d)^5*x)/d^7) + (5*b*(b*c - a*d)^4*(a + b*x)^2)/(2*d^6) - (4*b*(b*c - a*d)^3*(a + b*x)^3)/(3*d^5) + (3*b*(b*c - a*d)^2*(a + b*x)^4)/(4*d^4) - (2*b*(b*c - a*d)*(a + b*x)^5)/(5*d^3) + (b*(a + b*x)^6)/(6*d^2) + (b*c - a*d)^7/(d^8*(c + d*x)) + (7*b*(b*c - a*d)^6*Log[c + d*x])/d^8}
{(a + b*x)^7/(c + d*x)^3, x, 9, (15*b^3*(b*c - a*d)^4*x)/d^7 - (5*b^2*(b*c - a*d)^3*(a + b*x)^2)/d^6 + (2*b^2*(b*c - a*d)^2*(a + b*x)^3)/d^5 - (3*b^2*(b*c - a*d)*(a + b*x)^4)/(4*d^4) + (b^2*(a + b*x)^5)/(5*d^3) + (b*c - a*d)^7/(2*d^8*(c + d*x)^2) - (7*b*(b*c - a*d)^6)/(d^8*(c + d*x)) - (21*b^2*(b*c - a*d)^5*Log[c + d*x])/d^8}
{(a + b*x)^7/(c + d*x)^4, x, 9, -((20*b^4*(b*c - a*d)^3*x)/d^7) + (5*b^3*(b*c - a*d)^2*(a + b*x)^2)/d^6 - (4*b^3*(b*c - a*d)*(a + b*x)^3)/(3*d^5) + (b^3*(a + b*x)^4)/(4*d^4) + (b*c - a*d)^7/(3*d^8*(c + d*x)^3) - (7*b*(b*c - a*d)^6)/(2*d^8*(c + d*x)^2) + (21*b^2*(b*c - a*d)^5)/(d^8*(c + d*x)) + (35*b^3*(b*c - a*d)^4*Log[c + d*x])/d^8}
{(a + b*x)^7/(c + d*x)^5, x, 9, (15*b^5*(b*c - a*d)^2*x)/d^7 - (5*b^4*(b*c - a*d)*(a + b*x)^2)/(2*d^6) + (b^4*(a + b*x)^3)/(3*d^5) + (b*c - a*d)^7/(4*d^8*(c + d*x)^4) - (7*b*(b*c - a*d)^6)/(3*d^8*(c + d*x)^3) + (21*b^2*(b*c - a*d)^5)/(2*d^8*(c + d*x)^2) - (35*b^3*(b*c - a*d)^4)/(d^8*(c + d*x)) - (35*b^4*(b*c - a*d)^3*Log[c + d*x])/d^8}
{(a + b*x)^7/(c + d*x)^6, x, 9, -((6*b^6*(b*c - a*d)*x)/d^7) + (b^5*(a + b*x)^2)/(2*d^6) + (b*c - a*d)^7/(5*d^8*(c + d*x)^5) - (7*b*(b*c - a*d)^6)/(4*d^8*(c + d*x)^4) + (7*b^2*(b*c - a*d)^5)/(d^8*(c + d*x)^3) - (35*b^3*(b*c - a*d)^4)/(2*d^8*(c + d*x)^2) + (35*b^4*(b*c - a*d)^3)/(d^8*(c + d*x)) + (21*b^5*(b*c - a*d)^2*Log[c + d*x])/d^8}
{(a + b*x)^7/(c + d*x)^7, x, 9, (b^7*x)/d^7 + (b*c - a*d)^7/(6*d^8*(c + d*x)^6) - (7*b*(b*c - a*d)^6)/(5*d^8*(c + d*x)^5) + (21*b^2*(b*c - a*d)^5)/(4*d^8*(c + d*x)^4) - (35*b^3*(b*c - a*d)^4)/(3*d^8*(c + d*x)^3) + (35*b^4*(b*c - a*d)^3)/(2*d^8*(c + d*x)^2) - (21*b^5*(b*c - a*d)^2)/(d^8*(c + d*x)) - (7*b^6*(b*c - a*d)*Log[c + d*x])/d^8}
{(a + b*x)^7/(c + d*x)^8, x, 10, (b*c - a*d)^7/(7*d^8*(c + d*x)^7) - (7*b*(b*c - a*d)^6)/(6*d^8*(c + d*x)^6) + (21*b^2*(b*c - a*d)^5)/(5*d^8*(c + d*x)^5) - (35*b^3*(b*c - a*d)^4)/(4*d^8*(c + d*x)^4) + (35*b^4*(b*c - a*d)^3)/(3*d^8*(c + d*x)^3) - (21*b^5*(b*c - a*d)^2)/(2*d^8*(c + d*x)^2) + (7*b^6*(b*c - a*d))/(d^8*(c + d*x)) + (b^7*Log[c + d*x])/d^8}
{(a + b*x)^7/(c + d*x)^9, x, 1, (a + b*x)^8/(8*(b*c - a*d)*(c + d*x)^8)}
{(a + b*x)^7/(c + d*x)^10, x, 2, (a + b*x)^8/(9*(b*c - a*d)*(c + d*x)^9) + (b*(a + b*x)^8)/(72*(b*c - a*d)^2*(c + d*x)^8)}
(* {(a + b*x)^7/(c + d*x)^11, x, 3, (a + b*x)^8/(10*(b*c - a*d)*(c + d*x)^10) + (b*(a + b*x)^8)/(45*(b*c - a*d)^2*(c + d*x)^9) + (b^2*(a + b*x)^8)/(360*(b*c - a*d)^3*(c + d*x)^8)} *)
(* {(a + b*x)^7/(c + d*x)^12, x, 4, (a + b*x)^8/(11*(b*c - a*d)*(c + d*x)^11) + (3*b*(a + b*x)^8)/(110*(b*c - a*d)^2*(c + d*x)^10) + (b^2*(a + b*x)^8)/(165*(b*c - a*d)^3*(c + d*x)^9) + (b^3*(a + b*x)^8)/(1320*(b*c - a*d)^4*(c + d*x)^8)} *)


(* Integrands of the form (a+b*x)^m/(c+d*x)^3 where b*c-a*d=0 and m is an integer *)
{(a + b*x)^5/(a*d/b + d*x)^3, x, 2, (b^2*(a + b*x)^3)/(3*d^3)}
{(a + b*x)^4/(a*d/b + d*x)^3, x, 2, (a*b^3*x)/d^3 + (b^4*x^2)/(2*d^3)}
{(a + b*x)^3/(a*d/b + d*x)^3, x, 2, (b^3*x)/d^3}
{(a + b*x)^2/(a*d/b + d*x)^3, x, 2, (b^2*Log[a + b*x])/d^3}
{(a + b*x)^1/(a*d/b + d*x)^3, x, 2, -(b^2/(d^3*(a + b*x)))}
{1/((a + b*x)*(a*d/b + d*x)^3), x, 2, -(b^2/(3*d^3*(a + b*x)^3))}
{1/((a + b*x)^2*(a*d/b + d*x)^3), x, 2, -(b^2/(4*d^3*(a + b*x)^4))}
{1/((a + b*x)^3*(a*d/b + d*x)^3), x, 2, -(b^2/(5*d^3*(a + b*x)^5))}

{(b*c/d + b*x)^5/(c + d*x)^3, x, 2, (b^5*(c + d*x)^3)/(3*d^6)}
{(b*c/d + b*x)^4/(c + d*x)^3, x, 2, (b^4*c*x)/d^4 + (b^4*x^2)/(2*d^3)}
{(b*c/d + b*x)^3/(c + d*x)^3, x, 2, (b^3*x)/d^3}
{(b*c/d + b*x)^2/(c + d*x)^3, x, 2, (b^2*Log[c + d*x])/d^3}
{(b*c/d + b*x)^1/(c + d*x)^3, x, 2, -(b/(d^2*(c + d*x)))}
{1/((b*c/d + b*x)*(c + d*x)^3), x, 2, -(1/(3*b*(c + d*x)^3))}
{1/((b*c/d + b*x)^2*(c + d*x)^3), x, 2, -(d/(4*b^2*(c + d*x)^4))}
{1/((b*c/d + b*x)^3*(c + d*x)^3), x, 2, -(d^2/(5*b^3*(c + d*x)^5))}


(* Integrands of the form (a+b*x)^5*(a*c+b*c*x)^n where n is an integer *)
{(a + b*x)^5*(a*c + b*c*x)^n, x, 2, (a*c + b*c*x)^(6 + n)/(b*c^6*(6 + n))}
{(a + b*x)^5*(a*c + b*c*x)^3, x, 2, (c^3*(a + b*x)^9)/(9*b)}
{(a + b*x)^5*(a*c + b*c*x)^2, x, 2, (c^2*(a + b*x)^8)/(8*b)}
{(a + b*x)^5*(a*c + b*c*x), x, 2, (c*(a + b*x)^7)/(7*b)}
{(a + b*x)^5/(a*c + b*c*x), x, 2, (a + b*x)^5/(5*b*c)}
{(a + b*x)^5/(a*c + b*c*x)^2, x, 2, (a + b*x)^4/(4*b*c^2)}
{(a + b*x)^5/(a*c + b*c*x)^3, x, 2, (a + b*x)^3/(3*b*c^3)}
{(a + b*x)^5/(a*c + b*c*x)^4, x, 2, (a*x)/c^4 + (b*x^2)/(2*c^4)}
{(a + b*x)^5/(a*c + b*c*x)^5, x, 2, x/c^5}
{(a + b*x)^5/(a*c + b*c*x)^6, x, 2, Log[a + b*x]/(b*c^6)}
{(a + b*x)^5/(a*c + b*c*x)^7, x, 2, -(1/(b*c^7*(a + b*x)))}
{(a + b*x)^5/(a*c + b*c*x)^8, x, 2, -(1/(2*b*c^8*(a + b*x)^2))}


(* ::Subsection::Closed:: *)
(*Products of monomials and powers of two linear binomials *)


(* Integrands of the form x^m*(a+b*x)/(c+d*x)^n where m and n>0 are integers *)
{x^5*(a + b*x)/(c + d*x), x, 4, -((c^4*(b*c - a*d)*x)/d^6) + (c^3*(b*c - a*d)*x^2)/(2*d^5) - (c^2*(b*c - a*d)*x^3)/(3*d^4) + (c*(b*c - a*d)*x^4)/(4*d^3) - ((b*c - a*d)*x^5)/(5*d^2) + (b*x^6)/(6*d) + (c^5*(b*c - a*d)*Log[c + d*x])/d^7}
{x^4*(a + b*x)/(c + d*x), x, 4, (c^3*(b*c - a*d)*x)/d^5 - (c^2*(b*c - a*d)*x^2)/(2*d^4) + (c*(b*c - a*d)*x^3)/(3*d^3) - ((b*c - a*d)*x^4)/(4*d^2) + (b*x^5)/(5*d) - (c^4*(b*c - a*d)*Log[c + d*x])/d^6}
{x^3*(a + b*x)/(c + d*x), x, 4, -((c^2*(b*c - a*d)*x)/d^4) + (c*(b*c - a*d)*x^2)/(2*d^3) - ((b*c - a*d)*x^3)/(3*d^2) + (b*x^4)/(4*d) + (c^3*(b*c - a*d)*Log[c + d*x])/d^5}
{x^2*(a + b*x)/(c + d*x), x, 4, (c*(b*c - a*d)*x)/d^3 - ((b*c - a*d)*x^2)/(2*d^2) + (b*x^3)/(3*d) - (c^2*(b*c - a*d)*Log[c + d*x])/d^4}
{x*(a + b*x)/(c + d*x), x, 4, -(((b*c - a*d)*x)/d^2) + (b*x^2)/(2*d) + (c*(b*c - a*d)*Log[c + d*x])/d^3}
{(a + b*x)/(c + d*x), x, 3, (b*x)/d - ((b*c - a*d)*Log[c + d*x])/d^2}
{(a + b*x)/(x*(c + d*x)), x, 4, (a*Log[x])/c + ((b*c - a*d)*Log[c + d*x])/(c*d)}
{(a + b*x)/(x^2*(c + d*x)), x, 4, -(a/(c*x)) + ((b*c - a*d)*Log[x])/c^2 - ((b*c - a*d)*Log[c + d*x])/c^2}
{(a + b*x)/(x^3*(c + d*x)), x, 4, -(a/(2*c*x^2)) - (b*c - a*d)/(c^2*x) - (d*(b*c - a*d)*Log[x])/c^3 + (d*(b*c - a*d)*Log[c + d*x])/c^3}
{(a + b*x)/(x^4*(c + d*x)), x, 4, -(a/(3*c*x^3)) - (b*c - a*d)/(2*c^2*x^2) + (d*(b*c - a*d))/(c^3*x) + (d^2*(b*c - a*d)*Log[x])/c^4 - (d^2*(b*c - a*d)*Log[c + d*x])/c^4}
{(a + b*x)/(x^5*(c + d*x)), x, 4, -(a/(4*c*x^4)) - (b*c - a*d)/(3*c^2*x^3) + (d*(b*c - a*d))/(2*c^3*x^2) - (d^2*(b*c - a*d))/(c^4*x) - (d^3*(b*c - a*d)*Log[x])/c^5 + (d^3*(b*c - a*d)*Log[c + d*x])/c^5}

{x^5*(a + b*x)/(c + d*x)^2, x, 5, (c^3*(5*b*c - 4*a*d)*x)/d^6 - (c^2*(4*b*c - 3*a*d)*x^2)/(2*d^5) + (c*(3*b*c - 2*a*d)*x^3)/(3*d^4) - ((2*b*c - a*d)*x^4)/(4*d^3) + (b*x^5)/(5*d^2) - (c^5*(b*c - a*d))/(d^7*(c + d*x)) - (c^4*(6*b*c - 5*a*d)*Log[c + d*x])/d^7}
{x^4*(a + b*x)/(c + d*x)^2, x, 5, -((c^2*(4*b*c - 3*a*d)*x)/d^5) + (c*(3*b*c - 2*a*d)*x^2)/(2*d^4) - ((2*b*c - a*d)*x^3)/(3*d^3) + (b*x^4)/(4*d^2) + (c^4*(b*c - a*d))/(d^6*(c + d*x)) + (c^3*(5*b*c - 4*a*d)*Log[c + d*x])/d^6}
{x^3*(a + b*x)/(c + d*x)^2, x, 5, (c*(3*b*c - 2*a*d)*x)/d^4 - ((2*b*c - a*d)*x^2)/(2*d^3) + (b*x^3)/(3*d^2) - (c^3*(b*c - a*d))/(d^5*(c + d*x)) - (c^2*(4*b*c - 3*a*d)*Log[c + d*x])/d^5}
{x^2*(a + b*x)/(c + d*x)^2, x, 5, -(((2*b*c - a*d)*x)/d^3) + (b*x^2)/(2*d^2) + (c^2*(b*c - a*d))/(d^4*(c + d*x)) + (c*(3*b*c - 2*a*d)*Log[c + d*x])/d^4}
{x*(a + b*x)/(c + d*x)^2, x, 4, (b*x)/d^2 - (c*(b*c - a*d))/(d^3*(c + d*x)) - ((2*b*c - a*d)*Log[c + d*x])/d^3}
{(a + b*x)/(c + d*x)^2, x, 4, (b*c - a*d)/(d^2*(c + d*x)) + (b*Log[c + d*x])/d^2}
{(a + b*x)/(x*(c + d*x)^2), x, 4, -((b*c - a*d)/(c*d*(c + d*x))) + (a*Log[x])/c^2 - (a*Log[c + d*x])/c^2}
{(a + b*x)/(x^2*(c + d*x)^2), x, 5, -(a/(c^2*x)) + (b*c - a*d)/(c^2*(c + d*x)) + ((b*c - 2*a*d)*Log[x])/c^3 - ((b*c - 2*a*d)*Log[c + d*x])/c^3}
{(a + b*x)/(x^3*(c + d*x)^2), x, 5, -(a/(2*c^2*x^2)) - (b*c - 2*a*d)/(c^3*x) - (d*(b*c - a*d))/(c^3*(c + d*x)) - (d*(2*b*c - 3*a*d)*Log[x])/c^4 + (d*(2*b*c - 3*a*d)*Log[c + d*x])/c^4}
{(a + b*x)/(x^4*(c + d*x)^2), x, 5, -(a/(3*c^2*x^3)) - (b*c - 2*a*d)/(2*c^3*x^2) + (d*(2*b*c - 3*a*d))/(c^4*x) + (d^2*(b*c - a*d))/(c^4*(c + d*x)) + (d^2*(3*b*c - 4*a*d)*Log[x])/c^5 - (d^2*(3*b*c - 4*a*d)*Log[c + d*x])/c^5}
{(a + b*x)/(x^5*(c + d*x)^2), x, 5, -(a/(4*c^2*x^4)) - (b*c - 2*a*d)/(3*c^3*x^3) + (d*(2*b*c - 3*a*d))/(2*c^4*x^2) - (d^2*(3*b*c - 4*a*d))/(c^5*x) - (d^3*(b*c - a*d))/(c^5*(c + d*x)) - (d^3*(4*b*c - 5*a*d)*Log[x])/c^6 + (d^3*(4*b*c - 5*a*d)*Log[c + d*x])/c^6}


(* Integrands of the form x^m/((a+b*x)*(c+d*x)^n) where m and n>0 are integers *)
{x^5/((a + b*x)*(c + d*x)), x, 5, -(((b^3*c^3 + a*b^2*c^2*d + a^2*b*c*d^2 + a^3*d^3)*x)/(b^4*d^4)) + ((b^2*c^2 + a*b*c*d + a^2*d^2)*x^2)/(2*b^3*d^3) - ((b*c + a*d)*x^3)/(3*b^2*d^2) + x^4/(4*b*d) - (a^5*Log[a + b*x])/(b^5*(b*c - a*d)) + (c^5*Log[c + d*x])/(d^5*(b*c - a*d))}
{x^4/((a + b*x)*(c + d*x)), x, 5, ((b^2*c^2 + a*b*c*d + a^2*d^2)*x)/(b^3*d^3) - ((b*c + a*d)*x^2)/(2*b^2*d^2) + x^3/(3*b*d) + (a^4*Log[a + b*x])/(b^4*(b*c - a*d)) - (c^4*Log[c + d*x])/(d^4*(b*c - a*d))}
{x^3/((a + b*x)*(c + d*x)), x, 5, -(((b*c + a*d)*x)/(b^2*d^2)) + x^2/(2*b*d) - (a^3*Log[a + b*x])/(b^3*(b*c - a*d)) + (c^3*Log[c + d*x])/(d^3*(b*c - a*d))}
{x^2/((a + b*x)*(c + d*x)), x, 4, x/(b*d) + (a^2*Log[a + b*x])/(b^2*(b*c - a*d)) - (c^2*Log[c + d*x])/(d^2*(b*c - a*d))}
{x/((a + b*x)*(c + d*x)), x, 4, -((a*Log[a + b*x])/(b*(b*c - a*d))) + (c*Log[c + d*x])/(d*(b*c - a*d))}
{1/((a + b*x)*(c + d*x)), x, 4, Log[a + b*x]/(b*c - a*d) - Log[c + d*x]/(b*c - a*d)}
{1/(x*(a + b*x)*(c + d*x)), x, 5, Log[x]/(a*c) - (b*Log[a + b*x])/(a*(b*c - a*d)) + (d*Log[c + d*x])/(c*(b*c - a*d))}
{1/(x^2*(a + b*x)*(c + d*x)), x, 5, -(1/(a*c*x)) - ((b*c + a*d)*Log[x])/(a^2*c^2) + (b^2*Log[a + b*x])/(a^2*(b*c - a*d)) - (d^2*Log[c + d*x])/(c^2*(b*c - a*d))}
{1/(x^3*(a + b*x)*(c + d*x)), x, 5, -(1/(2*a*c*x^2)) + (b*c + a*d)/(a^2*c^2*x) + ((b^2*c^2 + a*b*c*d + a^2*d^2)*Log[x])/(a^3*c^3) - (b^3*Log[a + b*x])/(a^3*(b*c - a*d)) + (d^3*Log[c + d*x])/(c^3*(b*c - a*d))}
{1/(x^4*(a + b*x)*(c + d*x)), x, 5, -(1/(3*a*c*x^3)) + (b*c + a*d)/(2*a^2*c^2*x^2) - (b^2*c^2 + a*b*c*d + a^2*d^2)/(a^3*c^3*x) - ((b^3*c^3 + a*b^2*c^2*d + a^2*b*c*d^2 + a^3*d^3)*Log[x])/(a^4*c^4) + (b^4*Log[a + b*x])/(a^4*(b*c - a*d)) - (d^4*Log[c + d*x])/(c^4*(b*c - a*d))}
{1/(x^5*(a + b*x)*(c + d*x)), x, 5, -(1/(4*a*c*x^4)) + (b*c + a*d)/(3*a^2*c^2*x^3) - (b^2*c^2 + a*b*c*d + a^2*d^2)/(2*a^3*c^3*x^2) + (b^3*c^3 + a*b^2*c^2*d + a^2*b*c*d^2 + a^3*d^3)/(a^4*c^4*x) + ((b^4*c^4 + a*b^3*c^3*d + a^2*b^2*c^2*d^2 + a^3*b*c*d^3 + a^4*d^4)*Log[x])/(a^5*c^5) - (b^5*Log[a + b*x])/(a^5*(b*c - a*d)) + (d^5*Log[c + d*x])/(c^5*(b*c - a*d))}

{x^5/((a + b*x)*(c + d*x)^2), x, 6, ((3*b^2*c^2 + 2*a*b*c*d + a^2*d^2)*x)/(b^3*d^4) - ((2*b*c + a*d)*x^2)/(2*b^2*d^3) + x^3/(3*b*d^2) - c^5/(d^5*(b*c - a*d)*(c + d*x)) - (a^5*Log[a + b*x])/(b^4*(b*c - a*d)^2) - (c^4*(4*b*c - 5*a*d)*Log[c + d*x])/(d^5*(b*c - a*d)^2)}
{x^4/((a + b*x)*(c + d*x)^2), x, 6, -(((2*b*c + a*d)*x)/(b^2*d^3)) + x^2/(2*b*d^2) + c^4/(d^4*(b*c - a*d)*(c + d*x)) + (a^4*Log[a + b*x])/(b^3*(b*c - a*d)^2) + (c^3*(3*b*c - 4*a*d)*Log[c + d*x])/(d^4*(b*c - a*d)^2)}
{x^3/((a + b*x)*(c + d*x)^2), x, 5, x/(b*d^2) - c^3/(d^3*(b*c - a*d)*(c + d*x)) - (a^3*Log[a + b*x])/(b^2*(b*c - a*d)^2) - (c^2*(2*b*c - 3*a*d)*Log[c + d*x])/(d^3*(b*c - a*d)^2)}
{x^2/((a + b*x)*(c + d*x)^2), x, 5, c^2/(d^2*(b*c - a*d)*(c + d*x)) + (a^2*Log[a + b*x])/(b*(b*c - a*d)^2) + (c*(b*c - 2*a*d)*Log[c + d*x])/(d^2*(b*c - a*d)^2)}
{x/((a + b*x)*(c + d*x)^2), x, 5, -(c/(d*(b*c - a*d)*(c + d*x))) - (a*Log[a + b*x])/(b*c - a*d)^2 + (a*Log[c + d*x])/(b*c - a*d)^2}
{1/((a + b*x)*(c + d*x)^2), x, 5, 1/((b*c - a*d)*(c + d*x)) + (b*Log[a + b*x])/(b*c - a*d)^2 - (b*Log[c + d*x])/(b*c - a*d)^2}
{1/(x*(a + b*x)*(c + d*x)^2), x, 6, -(d/(c*(b*c - a*d)*(c + d*x))) + Log[x]/(a*c^2) - (b^2*Log[a + b*x])/(a*(b*c - a*d)^2) + (d*(2*b*c - a*d)*Log[c + d*x])/(c^2*(b*c - a*d)^2)}
{1/(x^2*(a + b*x)*(c + d*x)^2), x, 6, -(1/(a*c^2*x)) + d^2/(c^2*(b*c - a*d)*(c + d*x)) - ((b*c + 2*a*d)*Log[x])/(a^2*c^3) + (b^3*Log[a + b*x])/(a^2*(b*c - a*d)^2) - (d^2*(3*b*c - 2*a*d)*Log[c + d*x])/(c^3*(b*c - a*d)^2)}
{1/(x^3*(a + b*x)*(c + d*x)^2), x, 6, -(1/(2*a*c^2*x^2)) + (b*c + 2*a*d)/(a^2*c^3*x) - d^3/(c^3*(b*c - a*d)*(c + d*x)) + ((b^2*c^2 + 2*a*b*c*d + 3*a^2*d^2)*Log[x])/(a^3*c^4) - (b^4*Log[a + b*x])/(a^3*(b*c - a*d)^2) + (d^3*(4*b*c - 3*a*d)*Log[c + d*x])/(c^4*(b*c - a*d)^2)}
{1/(x^4*(a + b*x)*(c + d*x)^2), x, 6, -(1/(3*a*c^2*x^3)) + (b*c + 2*a*d)/(2*a^2*c^3*x^2) - (b^2*c^2 + 2*a*b*c*d + 3*a^2*d^2)/(a^3*c^4*x) + d^4/(c^4*(b*c - a*d)*(c + d*x)) - ((b^3*c^3 + 2*a*b^2*c^2*d + 3*a^2*b*c*d^2 + 4*a^3*d^3)*Log[x])/(a^4*c^5) + (b^5*Log[a + b*x])/(a^4*(b*c - a*d)^2) - (d^4*(5*b*c - 4*a*d)*Log[c + d*x])/(c^5*(b*c - a*d)^2)}
{1/(x^5*(a + b*x)*(c + d*x)^2), x, 6, -(1/(4*a*c^2*x^4)) + (b*c + 2*a*d)/(3*a^2*c^3*x^3) - (b^2*c^2 + 2*a*b*c*d + 3*a^2*d^2)/(2*a^3*c^4*x^2) + (b^3*c^3 + 2*a*b^2*c^2*d + 3*a^2*b*c*d^2 + 4*a^3*d^3)/(a^4*c^5*x) - d^5/(c^5*(b*c - a*d)*(c + d*x)) + ((b^4*c^4 + 2*a*b^3*c^3*d + 3*a^2*b^2*c^2*d^2 + 4*a^3*b*c*d^3 + 5*a^4*d^4)*Log[x])/(a^5*c^6) - (b^6*Log[a + b*x])/(a^5*(b*c - a*d)^2) + (d^5*(6*b*c - 5*a*d)*Log[c + d*x])/(c^6*(b*c - a*d)^2)}

{x^5/((a + b*x)*(c + d*x)^3), x, 7, -(((3*b*c + a*d)*x)/(b^2*d^4)) + x^2/(2*b*d^3) - c^5/(2*d^5*(b*c - a*d)*(c + d*x)^2) + (c^4*(4*b*c - 5*a*d))/(d^5*(b*c - a*d)^2*(c + d*x)) - (a^5*Log[a + b*x])/(b^3*(b*c - a*d)^3) + (c^3*(6*b^2*c^2 - 15*a*b*c*d + 10*a^2*d^2)*Log[c + d*x])/(d^5*(b*c - a*d)^3)}
{x^4/((a + b*x)*(c + d*x)^3), x, 6, x/(b*d^3) + c^4/(2*d^4*(b*c - a*d)*(c + d*x)^2) - (c^3*(3*b*c - 4*a*d))/(d^4*(b*c - a*d)^2*(c + d*x)) + (a^4*Log[a + b*x])/(b^2*(b*c - a*d)^3) - (c^2*(3*b^2*c^2 - 8*a*b*c*d + 6*a^2*d^2)*Log[c + d*x])/(d^4*(b*c - a*d)^3)}
{x^3/((a + b*x)*(c + d*x)^3), x, 6, -(c^3/(2*d^3*(b*c - a*d)*(c + d*x)^2)) + (c^2*(2*b*c - 3*a*d))/(d^3*(b*c - a*d)^2*(c + d*x)) - (a^3*Log[a + b*x])/(b*(b*c - a*d)^3) + (c*(b^2*c^2 - 3*a*b*c*d + 3*a^2*d^2)*Log[c + d*x])/(d^3*(b*c - a*d)^3)}
{x^2/((a + b*x)*(c + d*x)^3), x, 6, c^2/(2*d^2*(b*c - a*d)*(c + d*x)^2) - (c*(b*c - 2*a*d))/(d^2*(b*c - a*d)^2*(c + d*x)) + (a^2*Log[a + b*x])/(b*c - a*d)^3 - (a^2*Log[c + d*x])/(b*c - a*d)^3}
{x/((a + b*x)*(c + d*x)^3), x, 6, -(c/(2*d*(b*c - a*d)*(c + d*x)^2)) - a/((b*c - a*d)^2*(c + d*x)) - (a*b*Log[a + b*x])/(b*c - a*d)^3 + (a*b*Log[c + d*x])/(b*c - a*d)^3}
{1/((a + b*x)*(c + d*x)^3), x, 6, 1/(2*(b*c - a*d)*(c + d*x)^2) + b/((b*c - a*d)^2*(c + d*x)) + (b^2*Log[a + b*x])/(b*c - a*d)^3 - (b^2*Log[c + d*x])/(b*c - a*d)^3}
{1/(x*(a + b*x)*(c + d*x)^3), x, 7, -(d/(2*c*(b*c - a*d)*(c + d*x)^2)) - (d*(2*b*c - a*d))/(c^2*(b*c - a*d)^2*(c + d*x)) + Log[x]/(a*c^3) - (b^3*Log[a + b*x])/(a*(b*c - a*d)^3) + (d*(3*b^2*c^2 - 3*a*b*c*d + a^2*d^2)*Log[c + d*x])/(c^3*(b*c - a*d)^3)}
{1/(x^2*(a + b*x)*(c + d*x)^3), x, 7, -(1/(a*c^3*x)) + d^2/(2*c^2*(b*c - a*d)*(c + d*x)^2) + (d^2*(3*b*c - 2*a*d))/(c^3*(b*c - a*d)^2*(c + d*x)) - ((b*c + 3*a*d)*Log[x])/(a^2*c^4) + (b^4*Log[a + b*x])/(a^2*(b*c - a*d)^3) - (d^2*(6*b^2*c^2 - 8*a*b*c*d + 3*a^2*d^2)*Log[c + d*x])/(c^4*(b*c - a*d)^3)}
{1/(x^3*(a + b*x)*(c + d*x)^3), x, 7, -(1/(2*a*c^3*x^2)) + (b*c + 3*a*d)/(a^2*c^4*x) - d^3/(2*c^3*(b*c - a*d)*(c + d*x)^2) - (d^3*(4*b*c - 3*a*d))/(c^4*(b*c - a*d)^2*(c + d*x)) + ((b^2*c^2 + 3*a*b*c*d + 6*a^2*d^2)*Log[x])/(a^3*c^5) - (b^5*Log[a + b*x])/(a^3*(b*c - a*d)^3) + (d^3*(10*b^2*c^2 - 15*a*b*c*d + 6*a^2*d^2)*Log[c + d*x])/(c^5*(b*c - a*d)^3)}
{1/(x^4*(a + b*x)*(c + d*x)^3), x, 7, -(1/(3*a*c^3*x^3)) + (b*c + 3*a*d)/(2*a^2*c^4*x^2) - (b^2*c^2 + 3*a*b*c*d + 6*a^2*d^2)/(a^3*c^5*x) + d^4/(2*c^4*(b*c - a*d)*(c + d*x)^2) + (d^4*(5*b*c - 4*a*d))/(c^5*(b*c - a*d)^2*(c + d*x)) - ((b^3*c^3 + 3*a*b^2*c^2*d + 6*a^2*b*c*d^2 + 10*a^3*d^3)*Log[x])/(a^4*c^6) + (b^6*Log[a + b*x])/(a^4*(b*c - a*d)^3) - (d^4*(15*b^2*c^2 - 24*a*b*c*d + 10*a^2*d^2)*Log[c + d*x])/(c^6*(b*c - a*d)^3)}
(* {1/(x^5*(a + b*x)*(c + d*x)^3), x, 7, -(1/(4*a*c^3*x^4)) + (b*c + 3*a*d)/(3*a^2*c^4*x^3) - (b^2*c^2 + 3*a*b*c*d + 6*a^2*d^2)/(2*a^3*c^5*x^2) + (b^3*c^3 + 3*a*b^2*c^2*d + 6*a^2*b*c*d^2 + 10*a^3*d^3)/(a^4*c^6*x) - d^5/(2*c^5*(b*c - a*d)*(c + d*x)^2) - (d^5*(6*b*c - 5*a*d))/(c^6*(b*c - a*d)^2*(c + d*x)) + ((b^4*c^4 + 3*a*b^3*c^3*d + 6*a^2*b^2*c^2*d^2 + 10*a^3*b*c*d^3 + 15*a^4*d^4)*Log[x])/(a^5*c^7) - (b^7*Log[a + b*x])/(a^5*(b*c - a*d)^3) + (d^5*(21*b^2*c^2 - 35*a*b*c*d + 15*a^2*d^2)*Log[c + d*x])/(c^7*(b*c - a*d)^3)} *)


(* Integrands of the form x^m/((a+b*x)^2*(c+d*x)^n) where m and n>0 are integers *)
{x^5/((a + b*x)^2*(c + d*x)^2), x, 7, -((2*(b*c + a*d)*x)/(b^3*d^3)) + x^2/(2*b^2*d^2) + a^5/(b^4*(b*c - a*d)^2*(a + b*x)) + c^5/(d^4*(b*c - a*d)^2*(c + d*x)) + (a^4*(5*b*c - 3*a*d)*Log[a + b*x])/(b^4*(b*c - a*d)^3) + (c^4*(3*b*c - 5*a*d)*Log[c + d*x])/(d^4*(b*c - a*d)^3)}
{x^4/((a + b*x)^2*(c + d*x)^2), x, 6, x/(b^2*d^2) - a^4/(b^3*(b*c - a*d)^2*(a + b*x)) - c^4/(d^3*(b*c - a*d)^2*(c + d*x)) - (2*a^3*(2*b*c - a*d)*Log[a + b*x])/(b^3*(b*c - a*d)^3) - (2*c^3*(b*c - 2*a*d)*Log[c + d*x])/(d^3*(b*c - a*d)^3)}
{x^3/((a + b*x)^2*(c + d*x)^2), x, 6, a^3/(b^2*(b*c - a*d)^2*(a + b*x)) + c^3/(d^2*(b*c - a*d)^2*(c + d*x)) + (a^2*(3*b*c - a*d)*Log[a + b*x])/(b^2*(b*c - a*d)^3) + (c^2*(b*c - 3*a*d)*Log[c + d*x])/(d^2*(b*c - a*d)^3)}
{x^2/((a + b*x)^2*(c + d*x)^2), x, 6, -(a^2/(b*(b*c - a*d)^2*(a + b*x))) - c^2/(d*(b*c - a*d)^2*(c + d*x)) - (2*a*c*Log[a + b*x])/(b*c - a*d)^3 + (2*a*c*Log[c + d*x])/(b*c - a*d)^3}
{x/((a + b*x)^2*(c + d*x)^2), x, 6, a/((b*c - a*d)^2*(a + b*x)) + c/((b*c - a*d)^2*(c + d*x)) + ((b*c + a*d)*Log[a + b*x])/(b*c - a*d)^3 - ((b*c + a*d)*Log[c + d*x])/(b*c - a*d)^3}
{1/((a + b*x)^2*(c + d*x)^2), x, 6, -(b/((b*c - a*d)^2*(a + b*x))) - d/((b*c - a*d)^2*(c + d*x)) - (2*b*d*Log[a + b*x])/(b*c - a*d)^3 + (2*b*d*Log[c + d*x])/(b*c - a*d)^3}
{1/(x*(a + b*x)^2*(c + d*x)^2), x, 7, b^2/(a*(b*c - a*d)^2*(a + b*x)) + d^2/(c*(b*c - a*d)^2*(c + d*x)) + Log[x]/(a^2*c^2) - (b^2*(b*c - 3*a*d)*Log[a + b*x])/(a^2*(b*c - a*d)^3) - (d^2*(3*b*c - a*d)*Log[c + d*x])/(c^2*(b*c - a*d)^3)}
{1/(x^2*(a + b*x)^2*(c + d*x)^2), x, 7, -(1/(a^2*c^2*x)) - b^3/(a^2*(b*c - a*d)^2*(a + b*x)) - d^3/(c^2*(b*c - a*d)^2*(c + d*x)) - (2*(b*c + a*d)*Log[x])/(a^3*c^3) + (2*b^3*(b*c - 2*a*d)*Log[a + b*x])/(a^3*(b*c - a*d)^3) + (2*d^3*(2*b*c - a*d)*Log[c + d*x])/(c^3*(b*c - a*d)^3)}
{1/(x^3*(a + b*x)^2*(c + d*x)^2), x, 7, -(1/(2*a^2*c^2*x^2)) + (2*(b*c + a*d))/(a^3*c^3*x) + b^4/(a^3*(b*c - a*d)^2*(a + b*x)) + d^4/(c^3*(b*c - a*d)^2*(c + d*x)) + ((3*b^2*c^2 + 4*a*b*c*d + 3*a^2*d^2)*Log[x])/(a^4*c^4) - (b^4*(3*b*c - 5*a*d)*Log[a + b*x])/(a^4*(b*c - a*d)^3) - (d^4*(5*b*c - 3*a*d)*Log[c + d*x])/(c^4*(b*c - a*d)^3)}
{1/(x^4*(a + b*x)^2*(c + d*x)^2), x, 7, -(1/(3*a^2*c^2*x^3)) + (b*c + a*d)/(a^3*c^3*x^2) - (3*b^2*c^2 + 4*a*b*c*d + 3*a^2*d^2)/(a^4*c^4*x) - b^5/(a^4*(b*c - a*d)^2*(a + b*x)) - d^5/(c^4*(b*c - a*d)^2*(c + d*x)) - (2*(2*b^3*c^3 + 3*a*b^2*c^2*d + 3*a^2*b*c*d^2 + 2*a^3*d^3)*Log[x])/(a^5*c^5) + (2*b^5*(2*b*c - 3*a*d)*Log[a + b*x])/(a^5*(b*c - a*d)^3) + (2*d^5*(3*b*c - 2*a*d)*Log[c + d*x])/(c^5*(b*c - a*d)^3)}
(* {1/(x^5*(a + b*x)^2*(c + d*x)^2), x, 7, -(1/(4*a^2*c^2*x^4)) + (2*(b*c + a*d))/(3*a^3*c^3*x^3) - (3*b^2*c^2 + 4*a*b*c*d + 3*a^2*d^2)/(2*a^4*c^4*x^2) + (2*(2*b^3*c^3 + 3*a*b^2*c^2*d + 3*a^2*b*c*d^2 + 2*a^3*d^3))/(a^5*c^5*x) + b^6/(a^5*(b*c - a*d)^2*(a + b*x)) + d^6/(c^5*(b*c - a*d)^2*(c + d*x)) + ((5*b^4*c^4 + 8*a*b^3*c^3*d + 9*a^2*b^2*c^2*d^2 + 8*a^3*b*c*d^3 + 5*a^4*d^4)*Log[x])/(a^6*c^6) - (b^6*(5*b*c - 7*a*d)*Log[a + b*x])/(a^6*(b*c - a*d)^3) - (d^6*(7*b*c - 5*a*d)*Log[c + d*x])/(c^6*(b*c - a*d)^3)} *)

{x^5/((a + b*x)^2*(c + d*x)^3), x, 7, x/(b^2*d^3) + a^5/(b^3*(b*c - a*d)^3*(a + b*x)) + c^5/(2*d^4*(b*c - a*d)^2*(c + d*x)^2) - (c^4*(3*b*c - 5*a*d))/(d^4*(b*c - a*d)^3*(c + d*x)) + (a^4*(5*b*c - 2*a*d)*Log[a + b*x])/(b^3*(b*c - a*d)^4) - (c^3*(3*b^2*c^2 - 10*a*b*c*d + 10*a^2*d^2)*Log[c + d*x])/(d^4*(b*c - a*d)^4)}
{x^4/((a + b*x)^2*(c + d*x)^3), x, 7, -(a^4/(b^2*(b*c - a*d)^3*(a + b*x))) - c^4/(2*d^3*(b*c - a*d)^2*(c + d*x)^2) + (2*c^3*(b*c - 2*a*d))/(d^3*(b*c - a*d)^3*(c + d*x)) - (a^3*(4*b*c - a*d)*Log[a + b*x])/(b^2*(b*c - a*d)^4) + (c^2*(b^2*c^2 - 4*a*b*c*d + 6*a^2*d^2)*Log[c + d*x])/(d^3*(b*c - a*d)^4)}
{x^3/((a + b*x)^2*(c + d*x)^3), x, 7, a^3/(b*(b*c - a*d)^3*(a + b*x)) + c^3/(2*d^2*(b*c - a*d)^2*(c + d*x)^2) - (c^2*(b*c - 3*a*d))/(d^2*(b*c - a*d)^3*(c + d*x)) + (3*a^2*c*Log[a + b*x])/(b*c - a*d)^4 - (3*a^2*c*Log[c + d*x])/(b*c - a*d)^4}
{x^2/((a + b*x)^2*(c + d*x)^3), x, 7, -(a^2/((b*c - a*d)^3*(a + b*x))) - c^2/(2*d*(b*c - a*d)^2*(c + d*x)^2) - (2*a*c)/((b*c - a*d)^3*(c + d*x)) - (a*(2*b*c + a*d)*Log[a + b*x])/(b*c - a*d)^4 + (a*(2*b*c + a*d)*Log[c + d*x])/(b*c - a*d)^4}
{x/((a + b*x)^2*(c + d*x)^3), x, 7, (a*b)/((b*c - a*d)^3*(a + b*x)) + c/(2*(b*c - a*d)^2*(c + d*x)^2) + (b*c + a*d)/((b*c - a*d)^3*(c + d*x)) + (b*(b*c + 2*a*d)*Log[a + b*x])/(b*c - a*d)^4 - (b*(b*c + 2*a*d)*Log[c + d*x])/(b*c - a*d)^4}
{1/((a + b*x)^2*(c + d*x)^3), x, 7, -(b^2/((b*c - a*d)^3*(a + b*x))) - d/(2*(b*c - a*d)^2*(c + d*x)^2) - (2*b*d)/((b*c - a*d)^3*(c + d*x)) - (3*b^2*d*Log[a + b*x])/(b*c - a*d)^4 + (3*b^2*d*Log[c + d*x])/(b*c - a*d)^4}
{1/(x*(a + b*x)^2*(c + d*x)^3), x, 8, b^3/(a*(b*c - a*d)^3*(a + b*x)) + d^2/(2*c*(b*c - a*d)^2*(c + d*x)^2) + (d^2*(3*b*c - a*d))/(c^2*(b*c - a*d)^3*(c + d*x)) + Log[x]/(a^2*c^3) - (b^3*(b*c - 4*a*d)*Log[a + b*x])/(a^2*(b*c - a*d)^4) - (d^2*(6*b^2*c^2 - 4*a*b*c*d + a^2*d^2)*Log[c + d*x])/(c^3*(b*c - a*d)^4)}
{1/(x^2*(a + b*x)^2*(c + d*x)^3), x, 8, -(1/(a^2*c^3*x)) - b^4/(a^2*(b*c - a*d)^3*(a + b*x)) - d^3/(2*c^2*(b*c - a*d)^2*(c + d*x)^2) - (2*d^3*(2*b*c - a*d))/(c^3*(b*c - a*d)^3*(c + d*x)) - ((2*b*c + 3*a*d)*Log[x])/(a^3*c^4) + (b^4*(2*b*c - 5*a*d)*Log[a + b*x])/(a^3*(b*c - a*d)^4) + (d^3*(10*b^2*c^2 - 10*a*b*c*d + 3*a^2*d^2)*Log[c + d*x])/(c^4*(b*c - a*d)^4)}
{1/(x^3*(a + b*x)^2*(c + d*x)^3), x, 8, -(1/(2*a^2*c^3*x^2)) + (2*b*c + 3*a*d)/(a^3*c^4*x) + b^5/(a^3*(b*c - a*d)^3*(a + b*x)) + d^4/(2*c^3*(b*c - a*d)^2*(c + d*x)^2) + (d^4*(5*b*c - 3*a*d))/(c^4*(b*c - a*d)^3*(c + d*x)) + (3*(b^2*c^2 + 2*a*b*c*d + 2*a^2*d^2)*Log[x])/(a^4*c^5) - (3*b^5*(b*c - 2*a*d)*Log[a + b*x])/(a^4*(b*c - a*d)^4) - (3*d^4*(5*b^2*c^2 - 6*a*b*c*d + 2*a^2*d^2)*Log[c + d*x])/(c^5*(b*c - a*d)^4)}
(* {1/(x^4*(a + b*x)^2*(c + d*x)^3), x, 8, -(1/(3*a^2*c^3*x^3)) + (2*b*c + 3*a*d)/(2*a^3*c^4*x^2) - (3*(b^2*c^2 + 2*a*b*c*d + 2*a^2*d^2))/(a^4*c^5*x) - b^6/(a^4*(b*c - a*d)^3*(a + b*x)) - d^5/(2*c^4*(b*c - a*d)^2*(c + d*x)^2) - (2*d^5*(3*b*c - 2*a*d))/(c^5*(b*c - a*d)^3*(c + d*x)) - ((4*b^3*c^3 + 9*a*b^2*c^2*d + 12*a^2*b*c*d^2 + 10*a^3*d^3)*Log[x])/(a^5*c^6) + (b^6*(4*b*c - 7*a*d)*Log[a + b*x])/(a^5*(b*c - a*d)^4) + (d^5*(21*b^2*c^2 - 28*a*b*c*d + 10*a^2*d^2)*Log[c + d*x])/(c^6*(b*c - a*d)^4)} *)
(* {1/(x^5*(a + b*x)^2*(c + d*x)^3), x, 8, -(1/(4*a^2*c^3*x^4)) + (2*b*c + 3*a*d)/(3*a^3*c^4*x^3) - (3*(b^2*c^2 + 2*a*b*c*d + 2*a^2*d^2))/(2*a^4*c^5*x^2) + (4*b^3*c^3 + 9*a*b^2*c^2*d + 12*a^2*b*c*d^2 + 10*a^3*d^3)/(a^5*c^6*x) + b^7/(a^5*(b*c - a*d)^3*(a + b*x)) + d^6/(2*c^5*(b*c - a*d)^2*(c + d*x)^2) + (d^6*(7*b*c - 5*a*d))/(c^6*(b*c - a*d)^3*(c + d*x)) + ((5*b^4*c^4 + 12*a*b^3*c^3*d + 18*a^2*b^2*c^2*d^2 + 20*a^3*b*c*d^3 + 15*a^4*d^4)*Log[x])/(a^6*c^7) - (b^7*(5*b*c - 8*a*d)*Log[a + b*x])/(a^6*(b*c - a*d)^4) - (d^6*(28*b^2*c^2 - 40*a*b*c*d + 15*a^2*d^2)*Log[c + d*x])/(c^7*(b*c - a*d)^4)} *)


(* Integrands of the form x^m/((a+b*x)^3*(c+d*x)^n) where m and n>0 are integers *)
{x^5/((a + b*x)^3*(c + d*x)^3), x, 8, a^5/(2*b^3*(b*c - a*d)^3*(a + b*x)^2) - (a^4*(5*b*c - 2*a*d))/(b^3*(b*c - a*d)^4*(a + b*x)) - c^5/(2*d^3*(b*c - a*d)^3*(c + d*x)^2) + (c^4*(2*b*c - 5*a*d))/(d^3*(b*c - a*d)^4*(c + d*x)) - (a^3*(10*b^2*c^2 - 5*a*b*c*d + a^2*d^2)*Log[a + b*x])/(b^3*(b*c - a*d)^5) + (c^3*(b^2*c^2 - 5*a*b*c*d + 10*a^2*d^2)*Log[c + d*x])/(d^3*(b*c - a*d)^5)}
{x^4/((a + b*x)^3*(c + d*x)^3), x, 8, -(a^4/(2*b^2*(b*c - a*d)^3*(a + b*x)^2)) + (a^3*(4*b*c - a*d))/(b^2*(b*c - a*d)^4*(a + b*x)) + c^4/(2*d^2*(b*c - a*d)^3*(c + d*x)^2) - (c^3*(b*c - 4*a*d))/(d^2*(b*c - a*d)^4*(c + d*x)) + (6*a^2*c^2*Log[a + b*x])/(b*c - a*d)^5 - (6*a^2*c^2*Log[c + d*x])/(b*c - a*d)^5}
{x^3/((a + b*x)^3*(c + d*x)^3), x, 8, a^3/(2*b*(b*c - a*d)^3*(a + b*x)^2) - (3*a^2*c)/((b*c - a*d)^4*(a + b*x)) - c^3/(2*d*(b*c - a*d)^3*(c + d*x)^2) - (3*a*c^2)/((b*c - a*d)^4*(c + d*x)) - (3*a*c*(b*c + a*d)*Log[a + b*x])/(b*c - a*d)^5 + (3*a*c*(b*c + a*d)*Log[c + d*x])/(b*c - a*d)^5}
{x^2/((a + b*x)^3*(c + d*x)^3), x, 8, -(a^2/(2*(b*c - a*d)^3*(a + b*x)^2)) + (a*(2*b*c + a*d))/((b*c - a*d)^4*(a + b*x)) + c^2/(2*(b*c - a*d)^3*(c + d*x)^2) + (c*(b*c + 2*a*d))/((b*c - a*d)^4*(c + d*x)) + ((b^2*c^2 + 4*a*b*c*d + a^2*d^2)*Log[a + b*x])/(b*c - a*d)^5 - ((b^2*c^2 + 4*a*b*c*d + a^2*d^2)*Log[c + d*x])/(b*c - a*d)^5}
{x/((a + b*x)^3*(c + d*x)^3), x, 8, (a*b)/(2*(b*c - a*d)^3*(a + b*x)^2) - (b*(b*c + 2*a*d))/((b*c - a*d)^4*(a + b*x)) - (c*d)/(2*(b*c - a*d)^3*(c + d*x)^2) - (d*(2*b*c + a*d))/((b*c - a*d)^4*(c + d*x)) - (3*b*d*(b*c + a*d)*Log[a + b*x])/(b*c - a*d)^5 + (3*b*d*(b*c + a*d)*Log[c + d*x])/(b*c - a*d)^5}
{1/((a + b*x)^3*(c + d*x)^3), x, 8, -(b^2/(2*(b*c - a*d)^3*(a + b*x)^2)) + (3*b^2*d)/((b*c - a*d)^4*(a + b*x)) + d^2/(2*(b*c - a*d)^3*(c + d*x)^2) + (3*b*d^2)/((b*c - a*d)^4*(c + d*x)) + (6*b^2*d^2*Log[a + b*x])/(b*c - a*d)^5 - (6*b^2*d^2*Log[c + d*x])/(b*c - a*d)^5}
{1/(x*(a + b*x)^3*(c + d*x)^3), x, 9, b^3/(2*a*(b*c - a*d)^3*(a + b*x)^2) + (b^3*(b*c - 4*a*d))/(a^2*(b*c - a*d)^4*(a + b*x)) - d^3/(2*c*(b*c - a*d)^3*(c + d*x)^2) - (d^3*(4*b*c - a*d))/(c^2*(b*c - a*d)^4*(c + d*x)) + Log[x]/(a^3*c^3) - (b^3*(b^2*c^2 - 5*a*b*c*d + 10*a^2*d^2)*Log[a + b*x])/(a^3*(b*c - a*d)^5) + (d^3*(10*b^2*c^2 - 5*a*b*c*d + a^2*d^2)*Log[c + d*x])/(c^3*(b*c - a*d)^5)}
{1/(x^2*(a + b*x)^3*(c + d*x)^3), x, 9, -(1/(a^3*c^3*x)) - b^4/(2*a^2*(b*c - a*d)^3*(a + b*x)^2) - (b^4*(2*b*c - 5*a*d))/(a^3*(b*c - a*d)^4*(a + b*x)) + d^4/(2*c^2*(b*c - a*d)^3*(c + d*x)^2) + (d^4*(5*b*c - 2*a*d))/(c^3*(b*c - a*d)^4*(c + d*x)) - (3*(b*c + a*d)*Log[x])/(a^4*c^4) + (3*b^4*(b^2*c^2 - 4*a*b*c*d + 5*a^2*d^2)*Log[a + b*x])/(a^4*(b*c - a*d)^5) - (3*d^4*(5*b^2*c^2 - 4*a*b*c*d + a^2*d^2)*Log[c + d*x])/(c^4*(b*c - a*d)^5)}
(* {1/(x^3*(a + b*x)^3*(c + d*x)^3), x, 9, -(1/(2*a^3*c^3*x^2)) + (3*(b*c + a*d))/(a^4*c^4*x) + b^5/(2*a^3*(b*c - a*d)^3*(a + b*x)^2) + (3*b^5*(b*c - 2*a*d))/(a^4*(b*c - a*d)^4*(a + b*x)) - d^5/(2*c^3*(b*c - a*d)^3*(c + d*x)^2) - (3*d^5*(2*b*c - a*d))/(c^4*(b*c - a*d)^4*(c + d*x)) + (3*(2*b^2*c^2 + 3*a*b*c*d + 2*a^2*d^2)*Log[x])/(a^5*c^5) - (3*b^5*(2*b^2*c^2 - 7*a*b*c*d + 7*a^2*d^2)*Log[a + b*x])/(a^5*(b*c - a*d)^5) + (3*d^5*(7*b^2*c^2 - 7*a*b*c*d + 2*a^2*d^2)*Log[c + d*x])/(c^5*(b*c - a*d)^5)} *)
(* {1/(x^4*(a + b*x)^3*(c + d*x)^3), x, 9, -(1/(3*a^3*c^3*x^3)) + (3*(b*c + a*d))/(2*a^4*c^4*x^2) - (3*(2*b^2*c^2 + 3*a*b*c*d + 2*a^2*d^2))/(a^5*c^5*x) - b^6/(2*a^4*(b*c - a*d)^3*(a + b*x)^2) - (b^6*(4*b*c - 7*a*d))/(a^5*(b*c - a*d)^4*(a + b*x)) + d^6/(2*c^4*(b*c - a*d)^3*(c + d*x)^2) + (d^6*(7*b*c - 4*a*d))/(c^5*(b*c - a*d)^4*(c + d*x)) - (2*(5*b^3*c^3 + 9*a*b^2*c^2*d + 9*a^2*b*c*d^2 + 5*a^3*d^3)*Log[x])/(a^6*c^6) + (2*b^6*(5*b^2*c^2 - 16*a*b*c*d + 14*a^2*d^2)*Log[a + b*x])/(a^6*(b*c - a*d)^5) - (2*d^6*(14*b^2*c^2 - 16*a*b*c*d + 5*a^2*d^2)*Log[c + d*x])/(c^6*(b*c - a*d)^5)} *)
(* {1/(x^5*(a + b*x)^3*(c + d*x)^3), x, 9, -(1/(4*a^3*c^3*x^4)) + (b*c + a*d)/(a^4*c^4*x^3) - (3*(2*b^2*c^2 + 3*a*b*c*d + 2*a^2*d^2))/(2*a^5*c^5*x^2) + (2*(5*b^3*c^3 + 9*a*b^2*c^2*d + 9*a^2*b*c*d^2 + 5*a^3*d^3))/(a^6*c^6*x) + b^7/(2*a^5*(b*c - a*d)^3*(a + b*x)^2) + (b^7*(5*b*c - 8*a*d))/(a^6*(b*c - a*d)^4*(a + b*x)) - d^7/(2*c^5*(b*c - a*d)^3*(c + d*x)^2) - (d^7*(8*b*c - 5*a*d))/(c^6*(b*c - a*d)^4*(c + d*x)) + (3*(5*b^4*c^4 + 10*a*b^3*c^3*d + 12*a^2*b^2*c^2*d^2 + 10*a^3*b*c*d^3 + 5*a^4*d^4)*Log[x])/(a^7*c^7) - (3*b^7*(5*b^2*c^2 - 15*a*b*c*d + 12*a^2*d^2)*Log[a + b*x])/(a^7*(b*c - a*d)^5) + (3*d^7*(12*b^2*c^2 - 15*a*b*c*d + 5*a^2*d^2)*Log[c + d*x])/(c^7*(b*c - a*d)^5)} *)


(* ::Subsection::Closed:: *)
(*Products of powers of three or more linear binomials *)


(* Integrands of the form (a+b*x)^m*(c+d*x)^n*(e+f*x)^p where m, n and p are integers *)
{(a+b*x)*(c+d*x)*(e+f*x), x, 2, a*c*e*x + (1/2)*(b*c*e + a*d*e + a*c*f)*x^2 + (1/3)*(b*d*e + b*c*f + a*d*f)*x^3 + (1/4)*b*d*f*x^4}
{(a+b*x)*(c+d*x)/(e+f*x), x, 4, -(((b*d*e - b*c*f - a*d*f)*x)/f^2) + (b*d*x^2)/(2*f) + ((b*e - a*f)*(d*e - c*f)*Log[e + f*x])/f^3}
{(a+b*x)/((c+d*x)*(e+f*x)), x, 4, -(((b*c - a*d)*Log[c + d*x])/(d*(d*e - c*f))) + ((b*e - a*f)*Log[e + f*x])/(f*(d*e - c*f))}
{1/((a+b*x)*(c+d*x)*(e+f*x)), x, 5, (b*Log[a + b*x])/((b*c - a*d)*(b*e - a*f)) - (d*Log[c + d*x])/((b*c - a*d)*(d*e - c*f)) + (f*Log[e + f*x])/((b*e - a*f)*(d*e - c*f))}


(* Integrands of the form (a+b*x)^m*(c+d*x)^n*(e+f*x)^p*(g+h*x)^q where m, n, p and q are integers *)
{(a+b*x)*(c+d*x)*(e+f*x)*(g+h*x), x, 2, a*c*e*g*x + (1/2)*(b*c*e*g + a*(d*e*g + c*f*g + c*e*h))*x^2 + (1/3)*(b*(d*e*g + c*f*g + c*e*h) + a*(d*f*g + d*e*h + c*f*h))*x^3 + (1/4)*(a*d*f*h + b*(d*f*g + d*e*h + c*f*h))*x^4 + (1/5)*b*d*f*h*x^5}
{(a+b*x)*(c+d*x)*(e+f*x)/(g+h*x), x, 4, ((b*(d*g - c*h)*(f*g - e*h) - a*h*(d*f*g - d*e*h - c*f*h))*x)/h^3 + ((a*d*f*h - b*(d*f*g - d*e*h - c*f*h))*x^2)/(2*h^2) + (b*d*f*x^3)/(3*h) - ((b*g - a*h)*(d*g - c*h)*(f*g - e*h)*Log[g + h*x])/h^4}
{(a+b*x)*(c+d*x)/((e+f*x)*(g+h*x)), x, 4, (b*d*x)/(f*h) + ((b*e - a*f)*(d*e - c*f)*Log[e + f*x])/(f^2*(f*g - e*h)) - ((b*g - a*h)*(d*g - c*h)*Log[g + h*x])/(h^2*(f*g - e*h))}
{(a+b*x)/((c+d*x)*(e+f*x)*(g+h*x)), x, 5, -(((b*c - a*d)*Log[c + d*x])/((d*e - c*f)*(d*g - c*h))) + ((b*e - a*f)*Log[e + f*x])/((d*e - c*f)*(f*g - e*h)) - ((b*g - a*h)*Log[g + h*x])/((d*g - c*h)*(f*g - e*h))}
{1/((a+b*x)*(c+d*x)*(e+f*x)*(g+h*x)), x, 6, (b^2*Log[a + b*x])/((b*c - a*d)*(b*e - a*f)*(b*g - a*h)) - (d^2*Log[c + d*x])/((b*c - a*d)*(d*e - c*f)*(d*g - c*h)) + (f^2*Log[e + f*x])/((b*e - a*f)*(d*e - c*f)*(f*g - e*h)) - (h^2*Log[g + h*x])/((b*g - a*h)*(d*g - c*h)*(f*g - e*h))}


(* ::Subsection::Closed:: *)
(*Quotients of monomials by constants plus squares of linear binomials *)


(* Integrands of the form x^m/(c+(a+b*x)^2) where m is an integer *)
{1/(c+(a+b*x)^2), x, 2, ArcTan[(a + b*x)/Sqrt[c]]/(b*Sqrt[c])}
{x/(c+(a+b*x)^2), x, 3, -((a*ArcTan[(a + b*x)/Sqrt[c]])/(b^2*Sqrt[c])) + Log[a^2 + c + 2*a*b*x + b^2*x^2]/(2*b^2)}
{x^2/(c+(a+b*x)^2), x, 4, x/b^2 + ((a^2 - c)*ArcTan[(a + b*x)/Sqrt[c]])/(b^3*Sqrt[c]) - (a*Log[a^2 + c + 2*a*b*x + b^2*x^2])/b^3}
{x^3/(c+(a+b*x)^2), x, 5, -((2*a*x)/b^3) + x^2/(2*b^2) - (a*(a^2 - 3*c)*ArcTan[(a + b*x)/Sqrt[c]])/(b^4*Sqrt[c]) + ((3*a^2 - c)*Log[a^2 + c + 2*a*b*x + b^2*x^2])/(2*b^4)}
{1/(x*(c+(a+b*x)^2)), x, 5, -((a*ArcTan[(a + b*x)/Sqrt[c]])/(Sqrt[c]*(a^2 + c))) + Log[x]/(a^2 + c) - Log[a^2 + c + 2*a*b*x + b^2*x^2]/(2*(a^2 + c))}
{1/(x^2*(c+(a+b*x)^2)), x, 5, -(1/((a^2 + c)*x)) + (b*(a^2 - c)*ArcTan[(a + b*x)/Sqrt[c]])/(Sqrt[c]*(a^2 + c)^2) - (2*a*b*Log[x])/(a^2 + c)^2 + (a*b*Log[a^2 + c + 2*a*b*x + b^2*x^2])/(a^2 + c)^2}
{1/(x^3*(c+(a+b*x)^2)), x, 5, -(1/(2*(a^2 + c)*x^2)) + (2*a*b)/((a^2 + c)^2*x) - (a*b^2*(a^2 - 3*c)*ArcTan[(a + b*x)/Sqrt[c]])/(Sqrt[c]*(a^2 + c)^3) + (b^2*(3*a^2 - c)*Log[x])/(a^2 + c)^3 - (b^2*(3*a^2 - c)*Log[a^2 + c + 2*a*b*x + b^2*x^2])/(2*(a^2 + c)^3)}

{1/(-c+(a+b*x)^2), x, 2, -(ArcTanh[(a + b*x)/Sqrt[c]]/(b*Sqrt[c]))}
{x/(-c+(a+b*x)^2), x, 3, (a*ArcTanh[(a + b*x)/Sqrt[c]])/(b^2*Sqrt[c]) + Log[a^2 - c + 2*a*b*x + b^2*x^2]/(2*b^2)}
{x^2/(-c+(a+b*x)^2), x, 4, x/b^2 - ((a^2 + c)*ArcTanh[(a + b*x)/Sqrt[c]])/(b^3*Sqrt[c]) - (a*Log[a^2 - c + 2*a*b*x + b^2*x^2])/b^3}
{x^3/(-c+(a+b*x)^2), x, 5, -((2*a*x)/b^3) + x^2/(2*b^2) + (a*(a^2 + 3*c)*ArcTanh[(a + b*x)/Sqrt[c]])/(b^4*Sqrt[c]) + ((3*a^2 + c)*Log[a^2 - c + 2*a*b*x + b^2*x^2])/(2*b^4)}
{1/(x*(-c+(a+b*x)^2)), x, 5, (a*ArcTanh[(a + b*x)/Sqrt[c]])/((a^2 - c)*Sqrt[c]) + Log[x]/(a^2 - c) - Log[a^2 - c + 2*a*b*x + b^2*x^2]/(2*(a^2 - c))}
{1/(x^2*(-c+(a+b*x)^2)), x, 5, -(1/((a^2 - c)*x)) - (b*(a^2 + c)*ArcTanh[(a + b*x)/Sqrt[c]])/((a^2 - c)^2*Sqrt[c]) - (2*a*b*Log[x])/(a^2 - c)^2 + (a*b*Log[a^2 - c + 2*a*b*x + b^2*x^2])/(a^2 - c)^2}
{1/(x^3*(-c+(a+b*x)^2)), x, 5, -(1/(2*(a^2 - c)*x^2)) + (2*a*b)/((a^2 - c)^2*x) + (a*b^2*(a^2 + 3*c)*ArcTanh[(a + b*x)/Sqrt[c]])/((a^2 - c)^3*Sqrt[c]) + (b^2*(3*a^2 + c)*Log[x])/(a^2 - c)^3 - (b^2*(3*a^2 + c)*Log[a^2 - c + 2*a*b*x + b^2*x^2])/(2*(a^2 - c)^3)}

{x^2/(1 + (-1 + x)^2), x, 3, x + Log[2 - 2*x + x^2]}


(* ::Subsection::Closed:: *)
(*Miscellaneous integrands involving powers of linear binomials*)


(* Mathematica's penchant for rationalizing cause ExpandExpression to expand these! *) 
{1/(Sqrt[-a] + e*(c + d*x)), x, 2, Log[Sqrt[-a] + c*e + d*e*x]/(d*e)}
{1/(Sqrt[-a] + e*(c + d*x)^2), x, 2, ArcTan[(Sqrt[e]*(c + d*x))/(-a)^(1/4)]/((-a)^(1/4)*d*Sqrt[e])}


{x^(-1 + n)*(a + b*x)^(-1 - n), x, 1, x^n/(a*n*(a + b*x)^n)}
{(2 + x)/(1 + (2 + x)^2), x, 2, (1/2)*Log[1 + (2 + x)^2]}
{(2 + x)/(1 + (2 + x)^2)^2, x, 2, -(1/(2*(1 + (2 + x)^2)))}
{(1 + (a + b*x)^2)^2/x, x, 2, 4*a*(1 + a^2)*b*x + (1 + 3*a^2)*b^2*x^2 + (4/3)*a*b^3*x^3 + (b^4*x^4)/4 + (1 + a^2)^2*Log[x]}

(* Following integrands are equivalent: *) 
{2/(-1 + 4*x^2), x, 2, -ArcTanh[2*x]}
{(-1 + 2*x)^(-1) - (1 + 2*x)^(-1), x, 3, (1/2)*Log[1 - 2*x] - (1/2)*Log[1 + 2*x]}
