/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.util.CachedPainter14;
import ch.randelshofer.quaqua.util.Images;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import javax.swing.border.Border;

public class CachedImageBevelBorder14
extends CachedPainter14
implements Border {
    private static final boolean VERBOSE = false;
    private Image image;
    private Insets borderInsets;
    private Insets imageInsets;
    private boolean fillContentArea;
    private Object[] args = new Object[]{this};

    public CachedImageBevelBorder14(Image img, Insets borderInsets) {
        this(img, borderInsets, borderInsets, true);
    }

    public CachedImageBevelBorder14(Image img, Insets imageInsets, Insets borderInsets) {
        this(img, imageInsets, borderInsets, true);
    }

    public CachedImageBevelBorder14(Image img, Insets imageInsets, Insets borderInsets, boolean fillContentArea) {
        super(32);
        this.image = img;
        this.imageInsets = imageInsets;
        this.borderInsets = borderInsets;
        this.fillContentArea = fillContentArea;
    }

    public boolean isBorderOpaque() {
        return false;
    }

    public Insets getBorderInsets(Component c) {
        return (Insets)this.borderInsets.clone();
    }

    public void paintBorder(Component c, Graphics gr, int x, int y, int width, int height) {
        if (this.image == null) {
            return;
        }
        if (!gr.getClipBounds().intersects(x, y, width, height)) {
            return;
        }
        this.paint(c, gr, x, y, width, height, this.args);
    }

    protected Image createImage(Component c, int w, int h, GraphicsConfiguration config) {
        if (config == null) {
            return new BufferedImage(w, h, 3);
        }
        return config.createCompatibleImage(w, h, 3);
    }

    protected void paintToImage(Component c, Graphics gr, int width, int height, Object[] args) {
        TexturePaint paint;
        Graphics2D g = (Graphics2D)gr.create();
        this.image = Images.toBufferedImage(this.image);
        BufferedImage img = (BufferedImage)this.image;
        int top = this.imageInsets.top;
        int left = this.imageInsets.left;
        int bottom = this.imageInsets.bottom;
        int right = this.imageInsets.right;
        int imgWidth = img.getWidth();
        int imgHeight = img.getHeight();
        if (this.fillContentArea && width == imgWidth && height == imgHeight) {
            g.drawImage((Image)img, 0, 0, c);
            g.dispose();
            return;
        }
        if (width == imgWidth) {
            left = imgWidth;
            right = 0;
        }
        if (height == imgHeight) {
            top = imgHeight;
            bottom = 0;
        }
        if (width < left + right) {
            left = Math.min(left, width / 2);
            right = width - left;
        }
        if (height < top + bottom) {
            top = Math.min(top, height / 2);
            bottom = height - top;
        }
        if (top > 0 && left > 0) {
            g.drawImage(img, 0, 0, left, top, 0, 0, left, top, c);
        }
        if (top > 0 && right > 0) {
            g.drawImage(img, width - right, 0, width, top, imgWidth - right, 0, imgWidth, top, c);
        }
        if (bottom > 0 && left > 0) {
            g.drawImage(img, 0, height - bottom, left, height, 0, imgHeight - bottom, left, imgHeight, c);
        }
        if (bottom > 0 && right > 0) {
            g.drawImage(img, width - right, height - bottom, width, height, imgWidth - right, imgHeight - bottom, imgWidth, imgHeight, c);
        }
        BufferedImage subImg = null;
        if (top > 0 && left + right < width && imgWidth > right + left) {
            subImg = img.getSubimage(left, 0, imgWidth - right - left, top);
            paint = new TexturePaint(subImg, new Rectangle(left, 0, imgWidth - left - right, top));
            g.setPaint(paint);
            g.fillRect(left, 0, width - left - right, top);
        }
        if (bottom > 0 && left + right < width && imgHeight > bottom && imgWidth > right + left) {
            subImg = img.getSubimage(left, imgHeight - bottom, imgWidth - right - left, bottom);
            paint = new TexturePaint(subImg, new Rectangle(left, height - bottom, imgWidth - left - right, bottom));
            g.setPaint(paint);
            g.fillRect(left, height - bottom, width - left - right, bottom);
        }
        if (left > 0 && top + bottom < height && imgHeight > top + bottom) {
            subImg = img.getSubimage(0, top, left, imgHeight - top - bottom);
            paint = new TexturePaint(subImg, new Rectangle(0, top, left, imgHeight - top - bottom));
            g.setPaint(paint);
            g.fillRect(0, top, left, height - top - bottom);
        }
        if (right > 0 && top + bottom < height && imgWidth > right && imgHeight > top + bottom) {
            subImg = img.getSubimage(imgWidth - right, top, right, imgHeight - top - bottom);
            paint = new TexturePaint(subImg, new Rectangle(width - right, top, right, imgHeight - top - bottom));
            g.setPaint(paint);
            g.fillRect(width - right, top, right, height - top - bottom);
        }
        if (this.fillContentArea && left + right < imgWidth && top + bottom < imgHeight) {
            subImg = img.getSubimage(left, top, imgWidth - right - left, imgHeight - top - bottom);
            paint = new TexturePaint(subImg, new Rectangle(left, top, imgWidth - right - left, imgHeight - top - bottom));
            g.setPaint(paint);
            g.fillRect(left, top, width - right - left, height - top - bottom);
        }
        g.dispose();
    }
}

