/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.util.PaintableColor;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.peer.ComponentPeer;
import java.beans.PropertyChangeEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlException;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JRootPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicRootPaneUI;

public class Quaqua13RootPaneUI
extends BasicRootPaneUI {
    private static Quaqua13RootPaneUI rootPaneUI = new Quaqua13RootPaneUI();
    private AncestorListener ancestorListener;
    private static boolean isWindowModifiedSupported = true;
    private static Method setWindowModifiedMethod = null;

    public static ComponentUI createUI(JComponent c) {
        return rootPaneUI;
    }

    protected void installDefaults(JRootPane c) {
        super.installDefaults(c);
        LookAndFeel.installColorsAndFont(c, "RootPane.background", "RootPane.foreground", "RootPane.font");
        LookAndFeel.installBorder(c, "RootPane.border");
        c.setOpaque(true);
    }

    public void update(Graphics gr, JComponent c) {
        if (c.isOpaque()) {
            Graphics2D g = (Graphics2D)gr;
            g.setPaint(PaintableColor.getPaint(c.getBackground(), c));
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
        this.paint(gr, c);
    }

    protected void installListeners(JRootPane root) {
        super.installListeners(root);
        this.ancestorListener = this.createAncestorListener();
        if (this.ancestorListener != null) {
            root.addAncestorListener(this.ancestorListener);
        }
    }

    protected void uninstallListeners(JRootPane root) {
        super.uninstallListeners(root);
        if (this.ancestorListener != null) {
            root.removeAncestorListener(this.ancestorListener);
        }
    }

    protected AncestorListener createAncestorListener() {
        return new RootPaneAncestorListener();
    }

    private static void updateWindowModified(JRootPane rootpane) {
        ComponentPeer peer;
        Container parent;
        if (isWindowModifiedSupported && (parent = rootpane.getParent()) != null && parent instanceof Window && (peer = parent.getPeer()) != null) {
            if (setWindowModifiedMethod == null) {
                try {
                    setWindowModifiedMethod = peer.getClass().getMethod("setDocumentEdited", Boolean.TYPE);
                }
                catch (NoSuchMethodException ex1) {
                    try {
                        setWindowModifiedMethod = peer.getClass().getMethod("setModified", Boolean.TYPE);
                    }
                    catch (NoSuchMethodException ex2) {
                        isWindowModifiedSupported = false;
                    }
                }
                catch (AccessControlException ex1) {
                    isWindowModifiedSupported = false;
                }
            }
            if (setWindowModifiedMethod != null) {
                try {
                    Object value = rootpane.getClientProperty("windowModified");
                    if (value == null) {
                        value = Boolean.FALSE;
                    }
                    setWindowModifiedMethod.invoke((Object)peer, value);
                }
                catch (IllegalAccessException ex) {
                    isWindowModifiedSupported = false;
                }
                catch (InvocationTargetException ex) {
                    isWindowModifiedSupported = false;
                }
            }
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        super.propertyChange(e);
        if (e.getPropertyName().equals("windowModified")) {
            JRootPane rootpane = (JRootPane)e.getSource();
            Quaqua13RootPaneUI.updateWindowModified(rootpane);
        }
    }

    private static class RootPaneAncestorListener
    implements AncestorListener,
    WindowListener {
        private RootPaneAncestorListener() {
        }

        public void ancestorAdded(AncestorEvent evt) {
            Window window;
            Container ancestor = evt.getAncestor();
            Window window2 = window = ancestor instanceof Window ? (Window)ancestor : SwingUtilities.getWindowAncestor(ancestor);
            if (window != null) {
                window.addWindowListener(this);
                Quaqua13RootPaneUI.updateWindowModified((JRootPane)evt.getSource());
            }
        }

        public void ancestorMoved(AncestorEvent evt) {
        }

        public void ancestorRemoved(AncestorEvent evt) {
            Container ancestorParent = evt.getAncestorParent();
            if (ancestorParent != null) {
                Window window;
                Window window2 = window = ancestorParent instanceof Window ? (Window)ancestorParent : SwingUtilities.getWindowAncestor(ancestorParent);
                if (window != null) {
                    window.removeWindowListener(this);
                }
            }
        }

        public void windowActivated(WindowEvent e) {
            RootPaneAncestorListener.updateComponentTreeUIActivation(e.getComponent(), Boolean.TRUE);
        }

        public void windowClosed(WindowEvent e) {
        }

        public void windowClosing(WindowEvent e) {
        }

        public void windowDeactivated(WindowEvent e) {
            RootPaneAncestorListener.updateComponentTreeUIActivation(e.getComponent(), Boolean.FALSE);
        }

        public void windowDeiconified(WindowEvent e) {
        }

        public void windowIconified(WindowEvent e) {
        }

        public void windowOpened(WindowEvent e) {
        }

        private static void updateComponentTreeUIActivation(Component c, Boolean isActive) {
            if (c instanceof JComponent) {
                ((JComponent)c).putClientProperty("Frame.active", isActive);
            }
            Component[] children = null;
            if (c instanceof JMenu) {
                children = ((JMenu)c).getMenuComponents();
            } else if (c instanceof Container) {
                children = ((Container)c).getComponents();
            }
            if (children != null) {
                for (int i = 0; i < children.length; ++i) {
                    RootPaneAncestorListener.updateComponentTreeUIActivation(children[i], isActive);
                }
            }
        }
    }
}

