/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.ButtonStateBorder;
import ch.randelshofer.quaqua.QuaquaBorderFactory;
import ch.randelshofer.quaqua.QuaquaComboBoxUI;
import ch.randelshofer.quaqua.QuaquaUtilities;
import ch.randelshofer.quaqua.util.Images;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.CellRendererPane;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class QuaquaComboBoxButton
extends JButton {
    protected JComboBox comboBox;
    protected JList listBox;
    protected CellRendererPane rendererPane;
    protected Icon comboIcon;
    protected boolean iconOnly = false;
    private static Border focusRing;
    private static Border cellBorder;
    private static Border buttonBorder;
    private static Border smallCellBorder;
    private static Border smallButtonBorder;

    private static Border getFocusRing() {
        if (focusRing == null) {
            focusRing = QuaquaBorderFactory.create(Images.createImage(QuaquaComboBoxButton.class.getResource("images/ComboBox.focusRing.png")), new Insets(4, 6, 4, 6), new Insets(0, 0, 0, 0), false);
        }
        return focusRing;
    }

    private static Border getCellBorder() {
        if (cellBorder == null) {
            cellBorder = new ButtonStateBorder(Images.split(Images.createImage(QuaquaComboBoxButton.class.getResource("images/ComboBox.cellBorders.png")), 10, true), new Insets(10, 8, 14, 0), new Insets(1, 1, 1, 1), true);
        }
        return cellBorder;
    }

    private static Border getButtonBorder() {
        if (buttonBorder == null) {
            buttonBorder = new ButtonStateBorder(Images.split(Images.createImage(QuaquaComboBoxButton.class.getResource("images/ComboBox.buttonBorders.png")), 10, true), new Insets(10, 1, 14, 8), new Insets(1, 1, 1, 1), true);
        }
        return buttonBorder;
    }

    private static Border getSmallCellBorder() {
        if (smallCellBorder == null) {
            smallCellBorder = new ButtonStateBorder(Images.split(Images.createImage(QuaquaComboBoxButton.class.getResource("images/ComboBox.cellBorders.png")), 10, true), new Insets(8, 8, 16, 0), new Insets(1, 1, 1, 1), true);
        }
        return smallCellBorder;
    }

    private static Border getSmallButtonBorder() {
        if (smallButtonBorder == null) {
            smallButtonBorder = new ButtonStateBorder(Images.split(Images.createImage(QuaquaComboBoxButton.class.getResource("images/ComboBox.buttonBorders.png")), 10, true), new Insets(8, 1, 16, 8), new Insets(1, 1, 1, 1), true);
        }
        return smallButtonBorder;
    }

    public final JComboBox getComboBox() {
        return this.comboBox;
    }

    public final void setComboBox(JComboBox cb) {
        this.comboBox = cb;
    }

    public final Icon getComboIcon() {
        return this.comboIcon;
    }

    public final void setComboIcon(Icon i) {
        this.comboIcon = i;
    }

    public final boolean isIconOnly() {
        return this.iconOnly;
    }

    public final void setIconOnly(boolean isIconOnly) {
        this.iconOnly = isIconOnly;
    }

    public QuaquaComboBoxButton(QuaquaComboBoxUI ui, JComboBox cb, Icon i, boolean onlyIcon, CellRendererPane pane, JList list) {
        super("");
        DefaultButtonModel model = new DefaultButtonModel(){

            public void setArmed(boolean armed) {
                super.setArmed(this.isPressed() ? true : armed);
            }
        };
        this.setModel(model);
        this.setBorder(null);
        this.comboBox = cb;
        this.comboIcon = i;
        this.rendererPane = pane;
        this.listBox = list;
        this.setEnabled(this.comboBox.isEnabled());
        this.iconOnly = onlyIcon;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void setBorder(Border b) {
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.setBackground(this.comboBox.getBackground());
            this.setForeground(this.comboBox.getForeground());
        } else {
            this.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
            this.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
        }
    }

    public void paintBorder(Graphics g) {
    }

    public void paintComponent(Graphics g) {
        Object savedHints = QuaquaUtilities.beginGraphics((Graphics2D)g);
        QuaquaComboBoxUI ui = (QuaquaComboBoxUI)this.comboBox.getUI();
        int buttonWidth = ui.getArrowWidth();
        boolean isFrameActive = QuaquaUtilities.isOnActiveWindow(this.comboBox);
        boolean isTableCellEditor = ui.isTableCellEditor();
        boolean isEditable = this.comboBox.isEditable();
        boolean isSmall = ui.isSmall();
        Insets insets = this.getInsets();
        int x = insets.left;
        int y = insets.top;
        int width = this.getWidth() - insets.left - insets.right;
        int height = this.getHeight() - insets.top - insets.bottom;
        if (this.comboBox.isOpaque()) {
            g.setColor(this.comboBox.getBackground());
            g.fillRect(0, 0, width, height);
        }
        if (!isTableCellEditor) {
            if (this.iconOnly) {
                QuaquaComboBoxButton.getButtonBorder().paintBorder(this, g, x, y, width, height);
            } else {
                Border border = isSmall ? QuaquaComboBoxButton.getSmallCellBorder() : QuaquaComboBoxButton.getCellBorder();
                border.paintBorder(this, g, x, y, width - buttonWidth, height);
                border = isSmall ? QuaquaComboBoxButton.getSmallButtonBorder() : QuaquaComboBoxButton.getButtonBorder();
                border.paintBorder(this, g, width - buttonWidth, y, buttonWidth, height);
            }
        }
        boolean leftToRight = QuaquaUtilities.isLeftToRight(this.comboBox);
        this.comboIcon = ui.getArrowIcon();
        if (this.comboIcon != null) {
            int iconWidth = this.comboIcon.getIconWidth();
            int iconHeight = this.comboIcon.getIconHeight();
            int iconTop = 0;
            int iconLeft = 0;
            if (this.iconOnly) {
                iconLeft = x + (width - buttonWidth) / 2 + (buttonWidth - iconWidth) / 2 - 2;
                iconTop = y + (height - iconHeight) / 2;
            } else {
                iconLeft = leftToRight ? x + width - buttonWidth + (buttonWidth - iconWidth) / 2 - 1 : 0;
                iconTop = y + (height - iconHeight) / 2;
            }
            this.comboIcon.paintIcon(this, g, iconLeft, iconTop);
            if (QuaquaUtilities.isFocused(this.comboBox) && !isTableCellEditor) {
                Border border = null;
                border = QuaquaComboBoxButton.getFocusRing();
                if (border != null) {
                    border.paintBorder(this, g, x, y, width, height);
                }
            }
        }
        if (!this.iconOnly && this.comboBox != null) {
            ListCellRenderer<Object> renderer = this.comboBox.getRenderer();
            boolean renderPressed = this.getModel().isPressed();
            Component c = renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, renderPressed, false);
            c.setFont(this.comboBox.getFont());
            Rectangle cellBounds = ((QuaquaComboBoxUI)this.comboBox.getUI()).rectangleForCurrentValue();
            boolean shouldValidate = false;
            if (c instanceof JPanel) {
                shouldValidate = true;
            }
            boolean wasOpaque = c.isOpaque();
            if (c instanceof JComponent) {
                ((JComponent)c).setOpaque(false);
            }
            if (leftToRight) {
                this.rendererPane.paintComponent(g, c, this, cellBounds.x - this.getX(), cellBounds.y - this.getY(), cellBounds.width, cellBounds.height, shouldValidate);
            } else {
                this.rendererPane.paintComponent(g, c, this, cellBounds.x, cellBounds.y, cellBounds.width, cellBounds.height, shouldValidate);
            }
            if (c instanceof JComponent) {
                ((JComponent)c).setOpaque(wasOpaque);
            }
        }
        QuaquaUtilities.endGraphics((Graphics2D)g, savedHints);
    }
}

