/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.filechooser.Files;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class QuaquaManager {
    private static Properties properties;
    private static final String version;
    public static final int CHEETAH = 0;
    public static final int PUMA = 1;
    public static final int JAGUAR = 2;
    public static final int PANTHER = 3;
    public static final int TIGER = 4;
    public static final int WINDOWS = 5;
    public static final int UNKNOWN = -1;
    private static int OS;
    private static boolean isOSX;
    private static int design;
    private static HashMap lafs;

    private static void updateDesignAndOS() {
        String property;
        isOSX = QuaquaManager.getProperty("os.name").equals("Mac OS X");
        if (isOSX) {
            property = QuaquaManager.getProperty("os.version");
            int p = property.indexOf(46);
            if ((p = property.indexOf(46, p + 1)) != -1) {
                property = property.substring(0, p);
            }
            OS = property.equals("10.0") ? 0 : (property.equals("10.1") ? 1 : (property.equals("10.2") ? 2 : (property.equals("10.3") ? 3 : (property.equals("10.4") ? 4 : 4))));
        } else {
            OS = QuaquaManager.getProperty("os.name").startsWith("Windows") ? 5 : -1;
        }
        property = QuaquaManager.getProperty("Quaqua.design", "auto").toLowerCase();
        if (property.equals("cheetah")) {
            design = 2;
        } else if (property.equals("puma")) {
            design = 2;
        } else if (property.equals("jaguar")) {
            design = 2;
        } else if (property.equals("panther")) {
            design = 3;
        } else if (property.equals("tiger")) {
            design = 4;
        } else {
            switch (OS) {
                case 0: {
                    design = 2;
                    break;
                }
                case 1: {
                    design = 2;
                    break;
                }
                case 2: {
                    design = 2;
                    break;
                }
                case 3: {
                    design = 3;
                    break;
                }
                default: {
                    design = 4;
                }
            }
        }
    }

    private static void updateAvailableLAFs() {
        lafs = new HashMap();
        try {
            BufferedReader r;
            InputStream s = QuaquaManager.class.getResourceAsStream("laf.txt");
            if (s != null) {
                r = new BufferedReader(new InputStreamReader(s, "UTF8"));
                StreamTokenizer tt = new StreamTokenizer(r);
                tt.ordinaryChar(61);
                tt.ordinaryChar(59);
                while (true) {
                    if (tt.nextToken() == -1) break;
                    if (tt.ttype != -3) {
                        throw new IOException("Illegal token for 'design.version' in laf.txt File");
                    }
                    String lafKey = tt.sval;
                    if (tt.nextToken() != 61) {
                        throw new IOException("Illegal token for '=' in laf.txt File");
                    }
                    if (tt.nextToken() != -3) {
                        throw new IOException("Illegal token for 'class' in laf.txt File at key '" + lafKey + "'");
                    }
                    String className = tt.sval;
                    if (tt.nextToken() != 59) {
                        throw new IOException("Illegal token for ';' in laf.txt File");
                    }
                    lafs.put(lafKey, className);
                }
            } else {
                throw new IOException("File laf.txt not found");
            }
            r.close();
        }
        catch (IOException e) {
            System.err.println("Warning: " + QuaquaManager.class + ".updateAvailableLAFs() couldn't access resource file \"laf.txt\".");
            lafs.put("Jaguar.13", "ch.randelshofer.quaqua.jaguar.Quaqua13JaguarLookAndFeel");
            lafs.put("Jaguar.14", "ch.randelshofer.quaqua.jaguar.Quaqua14JaguarLookAndFeel");
            lafs.put("Panther.13", "ch.randelshofer.quaqua.panther.Quaqua13PantherLookAndFeel");
            lafs.put("Panther.14", "ch.randelshofer.quaqua.panther.Quaqua14PantherLookAndFeel");
            lafs.put("Panther.15", "ch.randelshofer.quaqua.panther.Quaqua15PantherLookAndFeel");
            lafs.put("Tiger.13", "ch.randelshofer.quaqua.tiger.Quaqua13TigerLookAndFeel");
            lafs.put("Tiger.14", "ch.randelshofer.quaqua.tiger.Quaqua14TigerLookAndFeel");
            lafs.put("Tiger.15", "ch.randelshofer.quaqua.tiger.Quaqua15TigerLookAndFeel");
            lafs.put("CrossPlatform.14", "ch.randelshofer.quaqua.tiger.Quaqua14TigerCrossPlatformLookAndFeel");
        }
    }

    private QuaquaManager() {
    }

    public static int getOS() {
        return OS;
    }

    public static boolean isOSX() {
        return isOSX;
    }

    public static int getDesign() {
        return design;
    }

    public static String getLookAndFeelClassName() {
        QuaquaManager.updateDesignAndOS();
        if (QuaquaManager.getProperty("Quaqua.noQuaqua", "false").equals("true")) {
            return UIManager.getCrossPlatformLookAndFeelClassName();
        }
        String lafKey = null;
        String className = "apple.laf.AquaLookAndFeel";
        try {
            Class.forName(className);
        }
        catch (ClassNotFoundException e1) {
            className = "com.apple.mrj.swing.MacLookAndFeel";
            try {
                Class.forName(className);
            }
            catch (ClassNotFoundException e2) {
                className = UIManager.getCrossPlatformLookAndFeelClassName();
            }
        }
        if (className.equals("com.apple.mrj.swing.MacLookAndFeel")) {
            switch (design) {
                case 2: {
                    lafKey = "Jaguar.13";
                    break;
                }
                case 3: {
                    lafKey = "Panther.13";
                    break;
                }
                default: {
                    lafKey = "Tiger.13";
                    break;
                }
            }
        } else if (className.equals("apple.laf.AquaLookAndFeel")) {
            String javaVersion = QuaquaManager.getProperty("java.version", "");
            if (javaVersion.startsWith("1.4")) {
                switch (design) {
                    case 2: {
                        lafKey = "Jaguar.14";
                        break;
                    }
                    case 3: {
                        lafKey = "Panther.14";
                        break;
                    }
                    default: {
                        lafKey = "Tiger.14";
                        break;
                    }
                }
            } else {
                switch (design) {
                    case 2: {
                        lafKey = "Jaguar.14";
                        break;
                    }
                    case 3: {
                        lafKey = "Panther.15";
                        break;
                    }
                    default: {
                        lafKey = "Tiger.15";
                    }
                }
            }
        } else {
            lafKey = "CrossPlatform.14";
        }
        if (lafs.containsKey(lafKey)) {
            className = (String)lafs.get(lafKey);
        }
        return className;
    }

    public static LookAndFeel getLookAndFeel() {
        try {
            return (LookAndFeel)Class.forName(QuaquaManager.getLookAndFeelClassName()).newInstance();
        }
        catch (Exception e) {
            InternalError ie = new InternalError(e.toString());
            throw ie;
        }
    }

    public static boolean getBoolean(String key) {
        Object value = UIManager.get(key);
        return value instanceof Boolean ? (Boolean)value : false;
    }

    public static String getProperty(String key) {
        try {
            if (properties == null || !properties.containsKey(key)) {
                return System.getProperty(key);
            }
            return properties.getProperty(key);
        }
        catch (SecurityException e) {
            return null;
        }
    }

    public static String getProperty(String key, String def) {
        try {
            if (properties == null || !properties.containsKey(key)) {
                return System.getProperty(key, def);
            }
            return properties.getProperty(key, def);
        }
        catch (SecurityException e) {
            return def;
        }
    }

    public static int[] getProperty(String key, int[] def) {
        StringTokenizer tt;
        String value;
        try {
            value = properties == null || !properties.containsKey(key) ? System.getProperty(key, null) : properties.getProperty(key, null);
        }
        catch (SecurityException e) {
            value = null;
        }
        if (value != null && (tt = new StringTokenizer(value, ",")).countTokens() == def.length) {
            int[] result = new int[def.length];
            try {
                for (int i = 0; i < result.length; ++i) {
                    result[i] = Integer.decode(tt.nextToken());
                }
                return result;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return def;
    }

    public static String setProperty(String key, String value) {
        if (properties == null) {
            properties = new Properties();
        }
        return (String)properties.setProperty(key, value);
    }

    public static void removeProperty(String key) {
        if (properties != null) {
            properties.remove(key);
        }
    }

    public static String getVersion() {
        return version;
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(QuaquaManager.getLookAndFeelClassName());
        }
        catch (Exception e) {
            // empty catch block
        }
        JFrame f = new JFrame("Quaqua Look and Feel");
        f.setDefaultCloseOperation(3);
        JLabel label = new JLabel("<html><p align=center><b>Quaqua Look and Feel " + version + "</b><br><br>" + "Copyright 2003-2007 Werner Randelshofer<br>" + "All Rights Reserved.<br>" + "<br>" + "This is a software library.<br>" + "Please read the accompanying documentation<br>for additional information.");
        label.setBorder(new EmptyBorder(12, 20, 20, 20));
        f.getContentPane().add(label);
        f.pack();
        f.setVisible(true);
    }

    public static boolean isNativeCodeAvailable() {
        return Files.canWorkWithAliases();
    }

    static {
        String v = null;
        try {
            InputStream s = QuaquaManager.class.getResourceAsStream("version.txt");
            if (s != null) {
                BufferedReader r = new BufferedReader(new InputStreamReader(s, "UTF8"));
                v = r.readLine();
                r.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        version = v == null ? "unknown" : v;
        QuaquaManager.updateAvailableLAFs();
        QuaquaManager.updateDesignAndOS();
    }
}

