/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import java.awt.Component;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.UIResource;

public class VisualMargin
extends AbstractBorder
implements UIResource {
    private Insets layoutMargin;
    private String uiManagerPropertyName = "Component.visualMargin";
    private String propertyName = "Quaqua.Component.visualMargin";
    private boolean isTopFixed;
    private boolean isLeftFixed;
    private boolean isBottomFixed;
    private boolean isRightFixed;

    public VisualMargin() {
        this.layoutMargin = new Insets(0, 0, 0, 0);
    }

    public VisualMargin(int top, int left, int bottom, int right) {
        this.layoutMargin = new Insets(top, left, bottom, right);
    }

    public VisualMargin(int top, int left, int bottom, int right, boolean ftop, boolean fleft, boolean fbottom, boolean fright) {
        this.layoutMargin = new Insets(top, left, bottom, right);
        this.isTopFixed = ftop;
        this.isLeftFixed = fleft;
        this.isBottomFixed = fbottom;
        this.isRightFixed = fright;
    }

    public VisualMargin(boolean ftop, boolean fleft, boolean fbottom, boolean fright) {
        this.layoutMargin = new Insets(0, 0, 0, 0);
        this.isTopFixed = ftop;
        this.isLeftFixed = fleft;
        this.isBottomFixed = fbottom;
        this.isRightFixed = fright;
    }

    public VisualMargin(Insets layoutMargin) {
        this.layoutMargin = layoutMargin;
    }

    public void setPropertyName(String propertyName) {
    }

    public void setFixed(boolean top, boolean left, boolean bottom, boolean right) {
        this.isTopFixed = top;
        this.isLeftFixed = left;
        this.isBottomFixed = bottom;
        this.isRightFixed = right;
    }

    public Insets getVisualMargin(Component c) {
        return this.getVisualMargin(c, new Insets(0, 0, 0, 0));
    }

    public Insets getBorderInsets(Component c) {
        return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        return this.getVisualMargin(c, insets);
    }

    protected Insets getVisualMargin(Component c, Insets insets) {
        insets.top = -this.layoutMargin.top;
        insets.left = -this.layoutMargin.left;
        insets.bottom = -this.layoutMargin.bottom;
        insets.right = -this.layoutMargin.right;
        if (c instanceof JComponent) {
            Insets componentMargin = (Insets)((JComponent)c).getClientProperty(this.propertyName);
            if (componentMargin == null && this.propertyName != null) {
                componentMargin = UIManager.getInsets(this.uiManagerPropertyName);
            }
            if (componentMargin != null) {
                if (!this.isTopFixed) {
                    insets.top += componentMargin.top;
                }
                if (!this.isLeftFixed) {
                    insets.left += componentMargin.left;
                }
                if (!this.isBottomFixed) {
                    insets.bottom += componentMargin.bottom;
                }
                if (!this.isRightFixed) {
                    insets.right += componentMargin.right;
                }
            }
        }
        return insets;
    }
}

