/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.tiger;

import ch.randelshofer.quaqua.BasicQuaquaLookAndFeel;
import ch.randelshofer.quaqua.QuaquaManager;
import ch.randelshofer.quaqua.VisualMargin;
import ch.randelshofer.quaqua.util.GroupBox;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.security.AccessControlException;
import javax.swing.UIDefaults;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.InsetsUIResource;

public class Quaqua13TigerLookAndFeel
extends BasicQuaquaLookAndFeel {
    public Quaqua13TigerLookAndFeel() {
        super("com.apple.mrj.swing.MacLookAndFeel");
    }

    public String getDescription() {
        return "The Quaqua 13 Tiger Look and Feel version " + QuaquaManager.getVersion();
    }

    public String getName() {
        return "Quaqua Tiger";
    }

    protected void initSystemColorDefaults(UIDefaults table) {
        super.initSystemColorDefaults(table);
        Object[] objects = new Object[]{"control", table.get("Panel.background"), "text", new ColorUIResource(0xFFFFFF), "menu", table.get("MenuItem.background")};
        table.putDefaults(objects);
    }

    protected void initClassDefaults(UIDefaults table) {
        String basicPrefix = "javax.swing.plaf.basic.Basic";
        String quaquaPrefix = "ch.randelshofer.quaqua.Quaqua";
        String quaquaJaguarPrefix = "ch.randelshofer.quaqua.jaguar.QuaquaJaguar";
        String quaqua13JaguarPrefix = "ch.randelshofer.quaqua.jaguar.Quaqua13Jaguar";
        String quaquaPantherPrefix = "ch.randelshofer.quaqua.panther.QuaquaPanther";
        Object[] uiDefaults = new Object[]{"BrowserUI", quaquaPrefix + "BrowserUI", "ButtonUI", quaquaPrefix + "ButtonUI", "CheckBoxUI", quaquaPrefix + "CheckBoxUI", "ColorChooserUI", quaquaPrefix + "13" + "ColorChooserUI", "FileChooserUI", quaquaPantherPrefix + "FileChooserUI", "RadioButtonUI", quaquaPrefix + "RadioButtonUI", "ToggleButtonUI", quaquaPrefix + "ToggleButtonUI", "PopupMenuUI", quaquaPrefix + "13" + "PopupMenuUI", "SeparatorUI", quaquaPantherPrefix + "SeparatorUI", "MenuSeparatorUI", quaquaPantherPrefix + "SeparatorUI", "ScrollPaneUI", quaquaPrefix + "ScrollPaneUI", "SplitPaneUI", quaquaPrefix + "SplitPaneUI", "ToolBarSeparatorUI", quaquaPrefix + "ToolBarSeparatorUI", "PopupMenuSeparatorUI", quaquaPantherPrefix + "SeparatorUI", "TabbedPaneUI", quaqua13JaguarPrefix + "TabbedPaneUI", "TextAreaUI", quaquaPrefix + "TextAreaUI", "TextFieldUI", quaquaPrefix + "TextFieldUI", "PasswordFieldUI", quaquaPrefix + "PasswordFieldUI", "TextPaneUI", quaquaPrefix + "TextPaneUI", "EditorPaneUI", quaquaPrefix + "EditorPaneUI", "TreeUI", quaquaPrefix + "TreeUI", "LabelUI", quaquaPrefix + "LabelUI", "ListUI", quaquaPrefix + "13" + "ListUI", "ToolBarUI", quaquaPrefix + "ToolBarUI", "ComboBoxUI", quaquaPrefix + "ComboBoxUI", "TableUI", quaquaPrefix + "TableUI", "TableHeaderUI", quaquaPrefix + "TableHeaderUI", "OptionPaneUI", quaquaPrefix + "OptionPaneUI", "PanelUI", quaquaPrefix + "PanelUI", "ViewportUI", quaquaPrefix + "ViewportUI", "RootPaneUI", quaquaPrefix + "13RootPaneUI"};
        table.putDefaults(uiDefaults);
        if (!this.isUseScreenMenuBar()) {
            uiDefaults = new Object[]{"MenuBarUI", quaquaPrefix + "MenuBarUI", "MenuUI", quaquaPrefix + "MenuUI", "MenuItemUI", quaquaPrefix + "MenuItemUI", "CheckBoxMenuItemUI", quaquaPrefix + "MenuItemUI", "RadioButtonMenuItemUI", quaquaPrefix + "MenuItemUI"};
            table.putDefaults(uiDefaults);
        }
    }

    private boolean isUseScreenMenuBar() {
        String property;
        try {
            property = QuaquaManager.getProperty("com.apple.macos.useScreenMenuBar", "false");
        }
        catch (AccessControlException e) {
            property = "false";
        }
        return property.equals("true");
    }

    protected void initFontDefaults(UIDefaults table) {
        super.initFontDefaults(table);
        UIDefaults.ProxyLazyValue emphasizedSmallSystemFont = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{"Lucida Grande", new Integer(1), new Integer(11)});
        Object[] objects = new Object[]{"FileChooser.previewLabelFont", emphasizedSmallSystemFont};
        table.putDefaults(objects);
    }

    protected void initDesignDefaults(UIDefaults table) {
        ColorUIResource disabledForeground = new ColorUIResource(128, 128, 128);
        ColorUIResource menuSelectionForeground = new ColorUIResource(255, 255, 255);
        Object[] objects = new Object[]{"FileChooser.previewLabelForeground", new ColorUIResource(0x808080), "FileChooser.previewValueForeground", new ColorUIResource(0), "FileChooser.previewLabelInsets", new InsetsUIResource(2, 0, 0, 4), "FileChooser.previewLabelDelimiter", "", "FileChooser.cellTipOrigin", new Point(18, 0), "PopupMenu.border", new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaMenuBorder"), "Separator.foreground", new ColorUIResource(0x8B8B8B), "Separator.highlight", new ColorUIResource(243, 243, 243), "Separator.shadow", new ColorUIResource(213, 213, 213), "Separator.border", new VisualMargin(), "Sheet.displayAsSheet", Boolean.FALSE, "TitledBorder.border", new GroupBox(), "TitledBorder.titleColor", new ColorUIResource(0x303030), "ToolBar.background", table.get("Menu.background"), "ToolBar.separatorSize", new Dimension(2, 2), "ToolBarSeparator.foreground", new ColorUIResource(0x808080)};
        table.putDefaults(objects);
        objects = this.isUseScreenMenuBar() ? new Object[]{"CheckBoxMenuItem.checkIcon", Quaqua13TigerLookAndFeel.makeButtonStateIcon("/ch/randelshofer/quaqua/images/CheckBoxMenuItem.icons.png", 6), "Menu.checkIcon", Quaqua13TigerLookAndFeel.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/images/MenuItem.checkIcon.png"), "MenuItem.checkIcon", Quaqua13TigerLookAndFeel.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/images/MenuItem.checkIcon.png"), "RadioButtonMenuItem.checkIcon", Quaqua13TigerLookAndFeel.makeButtonStateIcon("/ch/randelshofer/quaqua/images/RadioButtonMenuItem.icons.png", 6)} : new Object[]{"CheckBoxMenuItem.checkIcon", Quaqua13TigerLookAndFeel.makeButtonStateIcon("/ch/randelshofer/quaqua/images/CheckBoxMenuItem.icons.png", 6), "CheckBoxMenuItem.border", new BorderUIResource.EmptyBorderUIResource(1, 1, 1, 1), "Menu.checkIcon", Quaqua13TigerLookAndFeel.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/images/MenuItem.checkIcon.png"), "Menu.margin", new InsetsUIResource(0, 8, 0, 8), "Menu.menuPopupOffsetX", new Integer(0), "Menu.menuPopupOffsetY", new Integer(0), "Menu.submenuPopupOffsetX", new Integer(0), "Menu.submenuPopupOffsetY", new Integer(-4), "Menu.useMenuBarBackgroundForTopLevel", Boolean.TRUE, "Menu.border", new BorderUIResource.EmptyBorderUIResource(1, 1, 1, 1), "MenuBar.border", this.makeImageBevelBackgroundBorder("/ch/randelshofer/quaqua/tiger/images/MenuBar.border.png", new Insets(10, 0, 11, 0), new Insets(0, 0, 0, 0), true), "MenuBar.selectedBorder", this.makeImageBevelBackgroundBorder("/ch/randelshofer/quaqua/tiger/images/MenuBar.selectedBorder.png", new Insets(1, 0, 20, 0), new Insets(0, 0, 0, 0), true), "MenuBar.margin", new InsetsUIResource(1, 8, 2, 8), "MenuBar.shadow", new ColorUIResource(0x808080), "MenuItem.acceleratorSelectionForeground", menuSelectionForeground, "MenuItem.checkIcon", Quaqua13TigerLookAndFeel.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/images/MenuItem.checkIcon.png"), "MenuItem.border", new BorderUIResource.EmptyBorderUIResource(1, 1, 1, 1), "RadioButtonMenuItem.checkIcon", Quaqua13TigerLookAndFeel.makeButtonStateIcon("/ch/randelshofer/quaqua/images/RadioButtonMenuItem.icons.png", 6), "RadioButtonMenuItem.border", new BorderUIResource.EmptyBorderUIResource(1, 1, 1, 1)};
        table.putDefaults(objects);
        objects = new Object[]{"TabbedPane.disabledForeground", disabledForeground, "TabbedPane.tabInsets", new InsetsUIResource(1, 10, 4, 9), "TabbedPane.selectedTabPadInsets", new InsetsUIResource(2, 2, 2, 1), "TabbedPane.tabAreaInsets", new InsetsUIResource(4, 16, 0, 16), "TabbedPane.contentBorderInsets", new InsetsUIResource(5, 6, 6, 6)};
        table.putDefaults(objects);
    }
}

