/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.util;

import ch.randelshofer.quaqua.QuaquaIconFactory;
import ch.randelshofer.quaqua.util.Images;
import ch.randelshofer.quaqua.util.PaintableColor;
import java.awt.Component;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;

public class TextureColor
extends PaintableColor {
    protected Image texture;

    public TextureColor(int rgb) {
        super(rgb);
    }

    public TextureColor(int r, int g, int b) {
        super(r, g, b);
    }

    public TextureColor(int r, int g, int b, int a) {
        super(r, g, b, a);
    }

    public TextureColor(int r, int g, int b, Image texture) {
        super(r, g, b);
        this.texture = texture;
    }

    public TextureColor(int r, int g, int b, int a, Image texture) {
        super(r, g, b, a);
        this.texture = texture;
    }

    public TextureColor(int rgb, String location) {
        super(rgb);
        this.texture = QuaquaIconFactory.createImage(location);
    }

    public BufferedImage getTexture() {
        this.texture = Images.toBufferedImage(this.texture);
        return (BufferedImage)this.texture;
    }

    public Paint getPaint(Component c, int xOffset, int yOffset) {
        BufferedImage txtr = this.getTexture();
        if (txtr != null) {
            Point p = TextureColor.getRootPaneOffset(c);
            return new TexturePaint(txtr, new Rectangle(p.x + xOffset, p.y + yOffset, txtr.getWidth(), txtr.getHeight()));
        }
        return this;
    }

    public static class UIResource
    extends TextureColor
    implements javax.swing.plaf.UIResource {
        public UIResource(int rgb) {
            super(rgb);
        }

        public UIResource(int r, int g, int b) {
            super(r, g, b);
        }

        public UIResource(int r, int g, int b, int a) {
            super(r, g, b, a);
        }

        public UIResource(int r, int g, int b, BufferedImage texture) {
            super(r, g, b, texture);
        }

        public UIResource(int r, int g, int b, int a, BufferedImage texture) {
            super(r, g, b, a, texture);
        }

        public UIResource(int rgb, String location) {
            super(rgb, location);
        }
    }
}

