/*
 * Decompiled with CFR 0.152.
 */
package com.infocom.print;

import com.infocom.print.PFInchUnit;
import com.infocom.print.PFPoint;
import com.infocom.print.PFSize;
import com.infocom.print.PFUnit;
import java.awt.print.PageFormat;
import java.awt.print.Paper;

public class PFPageFormat
implements Cloneable {
    public static final int PORTRAIT = 0;
    public static final int LANDSCAPE = 1;
    public static final int PAGE_LETTER = 0;
    public static final int PAGE_LEGAL = 1;
    public static final int PAGE_A4 = 2;
    public static final int PAGE_CUSTOM = 3;
    private PFUnit leftMargin = new PFInchUnit(1.0);
    private PFUnit rightMargin = new PFInchUnit(1.0);
    private PFUnit topMargin = new PFInchUnit(1.0);
    private PFUnit bottomMargin = new PFInchUnit(1.0);
    private PFUnit gutter = new PFInchUnit(0.0);
    private PFSize pageSize = new PFSize(new PFInchUnit(8.5), new PFInchUnit(11.0));
    private int pageSizeIndex = 0;
    private int pageOrientation = 0;

    public PageFormat getPageFormat() {
        PageFormat pageFormat = new PageFormat();
        Paper paper = new Paper();
        switch (this.pageOrientation) {
            case 0: {
                pageFormat.setOrientation(1);
                paper.setSize(this.pageSize.getWidth().getPoints(), this.pageSize.getHeight().getPoints());
                paper.setImageableArea(this.leftMargin.add(this.gutter).getPoints(), this.topMargin.getPoints(), this.pageSize.getWidth().substract(this.leftMargin.add(this.rightMargin).add(this.gutter)).getPoints(), this.pageSize.getHeight().substract(this.topMargin.add(this.bottomMargin)).getPoints());
                break;
            }
            case 1: {
                pageFormat.setOrientation(0);
                paper.setSize(this.pageSize.getHeight().getPoints(), this.pageSize.getWidth().getPoints());
                paper.setImageableArea(this.topMargin.getPoints(), this.leftMargin.add(this.gutter).getPoints(), this.pageSize.getHeight().substract(this.topMargin.add(this.bottomMargin)).getPoints(), this.pageSize.getWidth().substract(this.leftMargin.add(this.rightMargin).add(this.gutter)).getPoints());
            }
        }
        pageFormat.setPaper(paper);
        return pageFormat;
    }

    public void setLeftMargin(PFUnit pFUnit) {
        this.leftMargin = pFUnit;
    }

    public PFUnit getLeftMargin() {
        return this.leftMargin;
    }

    public void setRightMargin(PFUnit pFUnit) {
        this.rightMargin = pFUnit;
    }

    public PFUnit getRightMargin() {
        return this.rightMargin;
    }

    public void setTopMargin(PFUnit pFUnit) {
        this.topMargin = pFUnit;
    }

    public PFUnit getTopMargin() {
        return this.topMargin;
    }

    public void setBottomMargin(PFUnit pFUnit) {
        this.bottomMargin = pFUnit;
    }

    public PFUnit getBottomMargin() {
        return this.bottomMargin;
    }

    public PFPoint getPageAreaOrigin() {
        return new PFPoint(this.leftMargin.add(this.gutter), this.topMargin);
    }

    public PFSize getPageAreaSize() {
        return new PFSize(this.pageSize.getWidth().substract(this.leftMargin.add(this.gutter)).substract(this.rightMargin), this.pageSize.getHeight().substract(this.topMargin).substract(this.bottomMargin));
    }

    public void setGutter(PFUnit pFUnit) {
        this.gutter = pFUnit;
    }

    public PFUnit getGutter() {
        return this.gutter;
    }

    public void setPageSize(int n) {
        this.pageSizeIndex = n;
        switch (this.pageSizeIndex) {
            case 0: {
                this.setPageSize(new PFSize(new PFInchUnit(8.5), new PFInchUnit(11.0)));
                break;
            }
            case 1: {
                this.setPageSize(new PFSize(new PFInchUnit(8.5), new PFInchUnit(14.0)));
                break;
            }
        }
    }

    public int getPageSizeIndex() {
        return this.pageSizeIndex;
    }

    public void setPageSize(PFSize pFSize) {
        this.pageSize = pFSize;
    }

    public PFSize getPageSize() {
        return this.pageSize;
    }

    public void setPageOrientation(int n) {
        if (this.pageOrientation != n) {
            this.pageOrientation = n;
            PFUnit pFUnit = this.pageSize.getWidth();
            this.pageSize.setWidth(this.pageSize.getHeight());
            this.pageSize.setHeight(pFUnit);
        }
    }

    public int getPageOrientation() {
        return this.pageOrientation;
    }

    public String[] getPageSizeDefinition() {
        String[] stringArray = new String[]{"Letter", "Legal", "A4", "Custom"};
        return stringArray;
    }

    public String[] getPageOrientationDefinition() {
        String[] stringArray = new String[]{"Portrait", "Landscape"};
        return stringArray;
    }

    public Object clone() {
        try {
            return (PFPageFormat)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            return null;
        }
    }
}

