/*
 * Decompiled with CFR 0.152.
 */
package com.informagen.giv;

import com.informagen.giv.Corner;
import com.informagen.giv.MapGlyph;
import com.informagen.giv.MapRuler;
import com.informagen.giv.MapTile;
import com.informagen.giv.MapView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;

public class GIVPanel
extends JPanel {
    private MapView mMapView = null;
    private final Vector tiles = new Vector();
    private final Vector glyphs = new Vector();
    private MapRuler ruler;
    private Corner corner;
    private JPanel toolsPanel;
    private JToolBar buttonBar;
    private JButton zoomMinBtn;
    private JButton zoomInBtn;
    private JButton zoomOutBtn;
    private final JScrollPane scrollPane = new JScrollPane();
    private final boolean zoomable;
    private final boolean hasRuler;
    private boolean hasScrollbars;
    int currentZoom = Short.MIN_VALUE;
    private final int ZOOM_OUT = -1;
    private final int ZOOM_IN = 1;
    private final int RESET_ZOOM = 0;
    int mark = Integer.MIN_VALUE;
    private int fitToWidthZoom = Short.MIN_VALUE;

    public GIVPanel() {
        this(true, false, false);
    }

    public GIVPanel(boolean bl) {
        this(bl, false, false);
    }

    public GIVPanel(boolean bl, boolean bl2) {
        this(bl, bl2, true);
    }

    public GIVPanel(boolean bl, boolean bl2, boolean bl3) {
        this.hasRuler = bl;
        this.zoomable = bl2;
        this.hasScrollbars = bl3;
        if (!bl3 && bl2) {
            this.hasScrollbars = true;
        }
        if (bl2) {
            this.toolsPanel = new JPanel();
            this.buttonBar = new JToolBar();
            this.zoomMinBtn = new JButton("Fit to width");
            this.zoomInBtn = new JButton("Zoom in");
            this.zoomOutBtn = new JButton("Zoom out");
        }
        if (bl) {
            this.ruler = new MapRuler();
            this.corner = new Corner();
        }
        this.buildUI();
        this.wireUI();
    }

    public void initialZoom() {
        if (this.hasRuler) {
            this.ruler.setPreferredWidth(this.scrollPane.getViewport().getWidth());
        }
        this.doZooming(0, false);
    }

    void buildUI() {
        if (this.hasRuler) {
            this.scrollPane.setColumnHeaderView(this.ruler);
            this.scrollPane.setCorner("UPPER_RIGHT_CORNER", this.corner);
        }
        this.scrollPane.setVerticalScrollBarPolicy(this.hasScrollbars ? 22 : 20);
        this.scrollPane.setHorizontalScrollBarPolicy(this.hasScrollbars ? 32 : 31);
        this.setLayout(new BorderLayout());
        this.setLayout(new BorderLayout());
        if (this.zoomable) {
            this.add((Component)this.buildZoomPanel(), "North");
        }
        this.add((Component)this.scrollPane, "Center");
        if (this.hasRuler) {
            this.ruler.setPreferredWidth(this.scrollPane.getViewport().getWidth());
        }
    }

    void wireUI() {
        if (this.hasScrollbars) {
            this.scrollPane.getHorizontalScrollBar().setUnitIncrement(10);
        }
        if (!this.hasScrollbars) {
            this.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent componentEvent) {
                    GIVPanel.this.doZooming(0, false);
                }
            });
        }
        if (this.hasRuler) {
            this.wireRuler();
        }
        if (this.zoomable) {
            this.wireZoomBtns();
        }
    }

    private void wireRuler() {
        this.ruler.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                GIVPanel.this.mark = mouseEvent.getX();
                int n = GIVPanel.this.scrollPane.getHorizontalScrollBar().getValue();
                GIVPanel.this.ruler.showValueAt(GIVPanel.this.mark);
                GIVPanel.this.mark -= n;
                GIVPanel.this.repaint();
                GIVPanel.this.ruler.requestFocus();
            }
        });
        this.ruler.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                if (GIVPanel.this.mark > Integer.MIN_VALUE && (n == 37 || n == 39)) {
                    int n2 = GIVPanel.this.scrollPane.getHorizontalScrollBar().getValue();
                    GIVPanel.this.mark += n2;
                    boolean bl = keyEvent.isShiftDown();
                    GIVPanel.this.mark = GIVPanel.this.mark + (n == 39 ? 1 : -1) * (bl ? 10 : 1);
                    GIVPanel.this.ruler.showValueAt(GIVPanel.this.mark);
                    GIVPanel.this.mark -= n2;
                    GIVPanel.this.ruler.repaint();
                    GIVPanel.this.repaint();
                }
            }
        });
        this.corner.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                GIVPanel.this.clearMark();
            }
        });
    }

    private void wireZoomBtns() {
        this.zoomInBtn.setEnabled(true);
        this.zoomOutBtn.setEnabled(false);
        this.zoomMinBtn.setEnabled(false);
        this.zoomInBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = (actionEvent.getModifiers() & 1) != 0;
                GIVPanel.this.currentZoom = GIVPanel.this.doZooming(1, bl);
            }
        });
        this.zoomOutBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GIVPanel.this.currentZoom = GIVPanel.this.doZooming(-1, (actionEvent.getModifiers() & 1) != 0);
            }
        });
        this.zoomMinBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GIVPanel.this.currentZoom = GIVPanel.this.doZooming(0, false);
            }
        });
    }

    void adjustZoomButtons() {
        this.zoomInBtn.setEnabled(true);
        this.zoomOutBtn.setEnabled(false);
        this.zoomMinBtn.setEnabled(false);
        int n = this.getViewWidth();
        if (this.currentZoom == n) {
            this.zoomMinBtn.setEnabled(false);
            this.zoomInBtn.setEnabled(true);
            this.zoomOutBtn.setEnabled(false);
        } else if (this.currentZoom == Short.MAX_VALUE) {
            this.zoomMinBtn.setEnabled(true);
            this.zoomOutBtn.setEnabled(true);
            this.zoomInBtn.setEnabled(false);
        } else {
            this.zoomOutBtn.setEnabled(true);
            this.zoomMinBtn.setEnabled(true);
            this.zoomInBtn.setEnabled(true);
        }
    }

    private JPanel buildZoomPanel() {
        this.toolsPanel.setLayout(new BoxLayout(this.toolsPanel, 1));
        this.buttonBar.add(this.zoomMinBtn);
        this.buttonBar.add(this.zoomInBtn);
        this.buttonBar.add(this.zoomOutBtn);
        this.buttonBar.setFloatable(false);
        this.buttonBar.setAlignmentX(0.0f);
        this.toolsPanel.add(this.buttonBar);
        return this.toolsPanel;
    }

    void setVisibleOnTiles(String string, boolean bl) {
    }

    public void installMapView(MapView mapView) {
        if (mapView == null) {
            return;
        }
        this.mMapView = mapView;
        this.scrollPane.setViewportView(this.mMapView);
        if (this.hasRuler) {
            this.ruler.setExtent(this.mMapView.getMinExtent(), this.mMapView.getMaxExtent());
        }
        GIVPanel.addGlyphsFrom(this.mMapView, this.glyphs, this.tiles);
    }

    public int getViewWidth() {
        return this.fitToWidthZoom;
    }

    public Vector getGlyphs() {
        return this.glyphs;
    }

    public Vector getTiles() {
        return this.tiles;
    }

    private static void addGlyphsFrom(Container container, Vector vector, Vector vector2) {
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponent(i);
            if (component instanceof MapGlyph) {
                vector.addElement(component);
                continue;
            }
            if (component instanceof MapTile) {
                vector2.addElement(component);
                GIVPanel.addGlyphsFrom((Container)component, vector, vector2);
                continue;
            }
            if (!(component instanceof Container)) continue;
            GIVPanel.addGlyphsFrom((Container)component, vector, vector2);
        }
    }

    public int doZooming(int n, boolean bl) {
        this.clearMark();
        if (this.mMapView == null) {
            return this.fitToWidthZoom;
        }
        this.fitToWidthZoom = this.scrollPane.getViewport().getWidth();
        int n2 = this.mMapView.getSize().width;
        int n3 = this.scrollPane.getHorizontalScrollBar().getValue();
        int n4 = this.scrollPane.getVerticalScrollBar().getValue();
        int n5 = this.fitToWidthZoom;
        switch (n) {
            case 0: {
                n5 = this.fitToWidthZoom;
                break;
            }
            case 1: {
                n5 = (int)((double)n2 * 1.7);
                n5 = n5 > Short.MAX_VALUE ? Short.MAX_VALUE : n5;
                break;
            }
            case -1: {
                n5 = (int)((double)n2 / 1.7);
                n5 = n5 < this.fitToWidthZoom ? this.fitToWidthZoom : n5;
            }
        }
        this.mMapView.zoom(n5);
        if (this.zoomable) {
            this.adjustZoomButtons();
        }
        if (n != 0) {
            Container container = this.mMapView.getSelectedGlyph();
            if (container == null) {
                container = this.mMapView.getSelectedTile();
            }
            if (container != null && bl) {
                int n6 = container.getLocationOnScreen().x - this.mMapView.getLocationOnScreen().x;
                n6 += container.getSize().width >> 1;
                n3 = n6 -= this.scrollPane.getViewport().getSize().width >> 1;
            } else {
                int n7 = this.fitToWidthZoom / 2;
                int n8 = (n3 + n7) * n5 / n2;
                n3 = n8 - n7;
            }
            int n9 = n3 = n3 < 0 ? 0 : n3;
            if (n5 - n3 < this.fitToWidthZoom) {
                n3 = n5 - this.fitToWidthZoom;
            }
        } else {
            n3 = 0;
        }
        this.scrollPane.invalidate();
        this.scrollPane.validate();
        this.scrollPane.getHorizontalScrollBar().setValue(n3);
        this.scrollPane.getVerticalScrollBar().setValue(n4);
        this.scrollPane.getHorizontalScrollBar().setBlockIncrement(this.fitToWidthZoom / 2);
        if (this.hasRuler) {
            this.ruler.setPreferredWidth(n5);
        }
        return n5;
    }

    private void clearMark() {
        this.mark = Integer.MIN_VALUE;
        if (this.hasRuler) {
            this.ruler.showValueAt(this.mark);
            this.ruler.repaint();
            this.repaint();
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.hasRuler && this.mark != Integer.MIN_VALUE) {
            int n = this.ruler.getSize().height - this.ruler.getMajorTickHeight();
            graphics.drawLine(this.mark, this.scrollPane.getLocation().y + n, this.mark, this.getSize().height);
        }
    }
}

